/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.common.service.impl;

import com.ejianc.business.profinance.common.bean.BillHandleResultEntity;
import com.ejianc.business.profinance.common.mapper.BillHandleResultMapper;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billHandleService")
public class BillHandleServiceImpl
extends BaseServiceImpl<BillHandleResultMapper, BillHandleResultEntity>
implements IBillHandleResultService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public boolean sendHandleResult(String handleDataJson, String handleBillIdStr, String handleBillType, String handleCode, String handleMsg) {
        return this.sendHandleResult(handleDataJson, handleBillIdStr, handleBillType, handleCode, handleMsg, true);
    }

    @Override
    public boolean sendHandleResult(String handleDataJson, String handleBillIdStr, String handleBillType, String handleCode, String handleMsg, boolean handleWithSubService) {
        try {
            BillHandleResultVO record = new BillHandleResultVO();
            record.setBillDataJson(handleDataJson);
            record.setHandleBillType(handleBillType);
            record.setHandleBillIdStr(handleBillIdStr);
            record.setHandleResultCode(handleCode);
            record.setHandleResultMsg(handleMsg);
            record.setHandleWithSubService(Boolean.valueOf(handleWithSubService));
            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody((Object)record);
            this.logger.info("\u63a5\u6536\u5355\u636e\u5904\u7406\u7ed3\u679c\u4fe1\u606f\uff1a{}\uff0c\u653e\u5165\u5f85\u5904\u7406\u961f\u5217", (Object)handleDataJson);
            this.rabbitTemplate.convertAndSend("billHandleResult", (Object)mqMessage);
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u5c06\u5355\u636e\u5904\u7406\u7ed3\u679c-[{}],\u5f85\u5904\u7406\u5355\u636e\u7c7b\u578b-{}, \u5904\u7406\u7ed3\u679c\u72b6\u6001\u7801-{},\u5904\u7406\u7ed3\u679c\u4fe1\u606f-{}\u53d1\u9001\u5f85\u5904\u7406\u961f\u5217\u5931\u8d25\uff01", new Object[]{handleDataJson, handleBillType, handleCode, handleMsg});
            return false;
        }
    }
}

