/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.person.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.person.bean.PersonRepayDetailEntity;
import com.ejianc.business.profinance.person.bean.PersonRepayEntity;
import com.ejianc.business.profinance.person.service.IPersonLoanService;
import com.ejianc.business.profinance.person.service.IPersonRepayService;
import com.ejianc.business.profinance.person.vo.PersonRepayDetailVO;
import com.ejianc.business.profinance.person.vo.PersonRepayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"personRepay"})
public class PersonRepayController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPersonLoanService loanService;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPersonRepayService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersonRepayVO> saveOrUpdate(@RequestBody PersonRepayVO saveOrUpdateVO) {
        PersonRepayEntity entity = (PersonRepayEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PersonRepayEntity.class));
        if (entity.getId() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getDetailList();
        ArrayList<Long> delIds = new ArrayList<Long>();
        ArrayList<Long> addIds = new ArrayList<Long>();
        for (PersonRepayDetailVO vo : detailList) {
            if (vo.getRowState() != null && vo.getRowState().equals("del")) {
                Long sourceLoanId = vo.getSourceLoanId();
                delIds.add(sourceLoanId);
            }
            if (vo.getRowState() == null || !vo.getRowState().equals("add")) continue;
            addIds.add(vo.getSourceLoanId());
        }
        if (!delIds.isEmpty()) {
            this.loanService.updateColumnValue(delIds, "ref_status", "\u672a\u5f15\u7528");
        }
        if (!addIds.isEmpty()) {
            this.loanService.updateColumnValue(addIds, "ref_status", "\u5f15\u7528");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PersonRepayVO vo = (PersonRepayVO)BeanMapper.map((Object)((Object)entity), PersonRepayVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PersonRepayVO> queryDetail(Long id) {
        PersonRepayEntity entity = (PersonRepayEntity)((Object)this.service.selectById(id));
        PersonRepayVO vo = (PersonRepayVO)BeanMapper.map((Object)((Object)entity), PersonRepayVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonRepayVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PersonRepayVO vo : vos) {
                PersonRepayEntity repayEntity = (PersonRepayEntity)((Object)this.service.selectById(vo.getId()));
                List<PersonRepayDetailEntity> detailList = repayEntity.getDetailList();
                List<Long> sourceLoanIds = detailList.stream().map(PersonRepayDetailEntity::getSourceLoanId).collect(Collectors.toList());
                this.loanService.updateColumnValue(sourceLoanIds, "ref_status", "\u672a\u5f15\u7528");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("repayProjectName");
        fuzzyFields.add("repayPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map<String, BigDecimal> map = this.service.fetchTotalMny(param);
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        List personRepayVOS = BeanMapper.mapList((Iterable)page.getRecords(), PersonRepayVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)personRepayVOS);
        resp.put("totalCurTotalRepayMny", (Object)map.get("totalCurTotalRepayMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> jsonObjectCommonResponse = this.queryList(param);
        List list = new ArrayList();
        if (null != jsonObjectCommonResponse.getData()) {
            list = (List)((JSONObject)jsonObjectCommonResponse.getData()).get((Object)"records");
            list.forEach(c -> c.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonRepay-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPersonRepayData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PersonRepayVO>> refPersonRepayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonRepayVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

