/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.warn.WarnEntity;
import com.ejianc.business.warn.WarnMapper;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/profinanceWarn/"})
public class ProfinanceWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-promaterial-frontend/#/check/card?id=";
    private static final String PC_A_URL = "/ejc-profinance-frontend/#/receiptList/receiptCard?id=";
    private static final String PC_B_URL = "/ejc-promaterial-frontend/#/concreteCheck";
    private static final String PC_URL_SALARY_PAY = "/ejc-profinance-frontend/#/salaryPayApplyList/multiCards?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private WarnMapper warnMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static String PRO_AGENTID = "1000036";
    static String PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("contractCode").toString());
            vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", m.get("contractName").toString()).replaceAll("#signDate#", m.get("signDate").toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    @PostMapping(value={"outputValueWarnExecute"})
    public CommonResponse<String> outputValueWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<WarnEntity> warnEntities = this.warnMapper.selectOutputValueList();
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u5355\u636e\u6570\u91cf{}\u6761", (Object)warnEntities.size());
            ArrayList<WarnEntity> resultList = new ArrayList<WarnEntity>();
            for (WarnEntity warnEntity : warnEntities) {
                if (warnEntity.getSumReceivedMny() == null || warnEntity.getReplyMny() == null || warnEntity.getSumReceivedMny().compareTo(warnEntity.getReplyMny().multiply(new BigDecimal("0.5"))) >= 0) continue;
                resultList.add(warnEntity);
            }
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6 \uff08\u6536\u6b3e\u91d1\u989d\u5c0f\u4e8e\u4ea7\u503c\u7edf\u8ba1\u91d1\u989d\u768470%\uff09\u7684\u9879\u76ee{}\u4e2a", (Object)resultList.size());
            if (!ListUtil.isNotEmpty(resultList)) continue;
            for (WarnEntity pvo : resultList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || set.getString("parameterValue") == null) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("-\u5408\u540c-" + pvo.getContractName());
                vo.setPcTitle("\u6536\u6b3e\u767b\u8bb0");
                vo.setPcUrl(PC_A_URL + pvo.getId());
                vo.setOrgId(pvo.getOrgId());
                vo.setSendOrgId(pvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"quoteWarnExecute"})
    public CommonResponse<String> quoteWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<WarnEntity> warnEntities = this.warnMapper.selectCheckList();
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u5355\u636e\u6570\u91cf{}\u6761", (Object)warnEntities.size());
            ArrayList<WarnEntity> resultList = new ArrayList<WarnEntity>();
            for (WarnEntity warnEntity : warnEntities) {
                if (warnEntity.getSumReceivedMny() == null || warnEntity.getReplyMny() == null || warnEntity.getSumReceivedMny().compareTo(warnEntity.getReplyMny().multiply(new BigDecimal("0.7"))) >= 0) continue;
                resultList.add(warnEntity);
            }
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6 \uff08\u6536\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5bf9\u7532\u62a5\u91cf\u91d1\u989d\u768470%\uff09\u7684\u5408\u540c{}\u4e2a", (Object)resultList.size());
            if (!ListUtil.isNotEmpty(resultList)) continue;
            for (WarnEntity pvo : resultList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || set.getString("parameterValue") == null) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("-\u5408\u540c-" + pvo.getContractName());
                vo.setPcTitle("\u6536\u6b3e\u767b\u8bb0");
                vo.setPcUrl(PC_A_URL + pvo.getId());
                vo.setOrgId(pvo.getOrgId());
                vo.setSendOrgId(pvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getContractName()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @PostMapping(value={"salaryPayFailWarnExecute"})
    public CommonResponse<String> salaryPayFailWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("salaryPayFailWarnExecute\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<SalaryPayApplyEntity> warnEntities = this.warnMapper.salaryPayFailWarnExecute();
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u5355\u636e\u6570\u91cf{}\u6761", (Object)warnEntities.size());
            if (!ListUtil.isNotEmpty(warnEntities)) continue;
            for (SalaryPayApplyEntity pvo : warnEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                        continue;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("-\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7-" + pvo.getBillCode());
                vo.setPcTitle("\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u5931\u8d25");
                vo.setPcUrl(PC_URL_SALARY_PAY + pvo.getId());
                vo.setOrgId(pvo.getOrgId());
                vo.setSendOrgId(pvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"salaryPayFailNoRepeatWarnExecute"})
    public CommonResponse<String> salaryPayFailNoRepeatWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("salaryPayFailNoRepeatWarnExecute\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<SalaryPayApplyEntity> warnEntities = this.warnMapper.salaryPayFailNoRepeatWarnExecute();
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u5355\u636e\u6570\u91cf{}\u6761", (Object)warnEntities.size());
            if (!ListUtil.isNotEmpty(warnEntities)) continue;
            for (SalaryPayApplyEntity pvo : warnEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                        continue;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                        continue;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("-\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u672a\u91cd\u53d1-" + pvo.getBillCode());
                vo.setPcTitle("\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u5931\u8d25\u672a\u91cd\u53d1");
                vo.setPcUrl(PC_URL_SALARY_PAY + pvo.getId());
                vo.setOrgId(pvo.getOrgId());
                vo.setSendOrgId(pvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#billCode#", pvo.getBillCode()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    public boolean sendSys(SalaryPayApplyEntity entity) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("weixinee");
        channel.add("sys");
        Object[] receivers = new String[]{entity.getApplyId() + ""};
        parameter.setReceivers((String[])receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("earlywarning");
        parameter.setSubject("\u5355\u636e\u7f16\u53f7\u4e3a" + entity.getBillCode() + "\u7684\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u5355\u5b58\u5728\u652f\u4ed8\u5931\u8d25\u6570\u636e\uff0c\u8bf7\u53ca\u65f6\u6838\u67e5\u5904\u7406!");
        parameter.setContent("\u5185\u5bb9");
        parameter.setPcUrl(PC_URL_SALARY_PAY);
        parameter.setMobileUrl(PC_URL_SALARY_PAY);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid", (Object)PRO_AGENTID);
        weixineeParams.put("secret", (Object)PRO_SECRET);
        weixineeParams.put("msgtype", (Object)"textcard");
        weixineeParams.put("title", (Object)"\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u5931\u8d25");
        weixineeParams.put("description", (Object)("\u5355\u636e\u7f16\u53f7\u4e3a" + entity.getBillCode() + "\u7684\u5de5\u4eba\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u5355\u5b58\u5728\u652f\u4ed8\u5931\u8d25\u6570\u636e\uff0c\u8bf7\u53ca\u65f6\u6838\u67e5\u5904\u7406!"));
        weixineeParams.put("url", (Object)("https://pms.zzyjjt.com/portal/sso/index?&userid=" + entity.getApplyId() + "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-profinance-frontend%2f%23%2fsalaryPayApplyList%2fmultiCards%3fid%3d" + entity.getId()));
        weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
        parameter.setWeixineeParams(weixineeParams);
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->,\u63a5\u6536\u4eba:{}", (Object)Arrays.toString(receivers));
            return true;
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
        return false;
    }
}

