package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 费用项清单
 * 
 * @author generator
 * 
 */
public class BudgetCostVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private String detailIndex; // 序号
    private Long parentId; // 父ID
    private String costCode; // 编码
    private String costName; // 名称
    private String costUnit; // 单位
    private java.math.BigDecimal costNum; // 工程量
    private java.math.BigDecimal costTaxRate; // 税率
    private java.math.BigDecimal costPrice; // 综合单价(无税)
    private java.math.BigDecimal costTaxPrice; // 综合单价(含税)
    private java.math.BigDecimal costMny; // 合价(无税)
    private java.math.BigDecimal costTaxMny; // 合价(含税)
    private java.math.BigDecimal costTax; // 税额
    private String costMemo; // 备注
    private Boolean leafFlag; // 是否末级

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private Long costSubjectId; // 成本科目id
    private String costSubjectName; // 成本科目名称

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getCostSubjectId() {
        return costSubjectId;
    }
    @ReferDeserialTransfer
    public void setCostSubjectId(Long costSubjectId) {
        this.costSubjectId = costSubjectId;
    }

    public String getCostSubjectName() {
        return costSubjectName;
    }

    public void setCostSubjectName(String costSubjectName) {
        this.costSubjectName = costSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getCostCode() {
        return costCode;
    }

    /**
     * 编码
     */
    public void setCostCode(String costCode) {
        this.costCode = costCode;
    }
    /**
     * 名称
     */
    public String getCostName() {
        return costName;
    }

    /**
     * 名称
     */
    public void setCostName(String costName) {
        this.costName = costName;
    }
    /**
     * 单位
     */
    public String getCostUnit() {
        return costUnit;
    }

    /**
     * 单位
     */
    public void setCostUnit(String costUnit) {
        this.costUnit = costUnit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getCostNum() {
        return costNum;
    }

    /**
     * 工程量
     */
    public void setCostNum(java.math.BigDecimal costNum) {
        this.costNum = costNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getCostTaxRate() {
        return costTaxRate;
    }

    /**
     * 税率
     */
    public void setCostTaxRate(java.math.BigDecimal costTaxRate) {
        this.costTaxRate = costTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public java.math.BigDecimal getCostPrice() {
        return costPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setCostPrice(java.math.BigDecimal costPrice) {
        this.costPrice = costPrice;
    }
    /**
     * 综合单价(含税)
     */
    public java.math.BigDecimal getCostTaxPrice() {
        return costTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setCostTaxPrice(java.math.BigDecimal costTaxPrice) {
        this.costTaxPrice = costTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getCostMny() {
        return costMny;
    }

    /**
     * 合价(无税)
     */
    public void setCostMny(java.math.BigDecimal costMny) {
        this.costMny = costMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setCostTaxMny(java.math.BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    /**
     * 备注
     */
    public String getCostMemo() {
        return costMemo;
    }

    /**
     * 备注
     */
    public void setCostMemo(String costMemo) {
        this.costMemo = costMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"costPrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"costTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"costNum"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"costMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"costTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"costTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"costTax"};
    }
}
