package com.ejianc.business.pro.income.vo;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 分部分项清单
 * 
 * @author generator
 * 
 */
public class BudgetSubVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private Long parentId; // 父ID
    private String detailIndex; // 序号
    private String subCode; // 编码
    private String subName; // 名称
    private String subFeature; // 特征
    private String subUnit; // 单位
    private java.math.BigDecimal subNum; // 工程量
    private java.math.BigDecimal subTaxRate; // 税率
    private java.math.BigDecimal subPrice; // 综合单价(无税)
    private java.math.BigDecimal subTaxPrice; // 综合单价(含税)
    private java.math.BigDecimal subMny; // 合价(无税)
    private java.math.BigDecimal subTaxMny; // 合价(含税)
    private java.math.BigDecimal subTax; // 税额
    private String subMemo; // 备注
    private Boolean leafFlag; // 是否末级
    private List<BudgetDetailVO> detailVos = new ArrayList<>(); // 清单明细

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;

    private Long subSubjectId; // 成本科目id
    private String subSubjectName; // 成本科目名称
    private List<ITreeNodeB> children;

    private String subCompositiveCoefficientName; //综合系数名称
    private Long subCompositiveCoefficientId; //综合系数id
    private BigDecimal subCompositiveCoefficient; //综合系数

    private String subItemType; //清单类型  用于导入数据区分
    private Integer subPriceType; //价税计算类型：0-无税优先， 1-含税优先

    public Integer getSubPriceType() {
        return subPriceType;
    }

    public void setSubPriceType(Integer subPriceType) {
        this.subPriceType = subPriceType;
    }

    public String getSubItemType() {
        return subItemType;
    }

    public void setSubItemType(String subItemType) {
        this.subItemType = subItemType;
    }

    public String getSubCompositiveCoefficientName() {
        return subCompositiveCoefficientName;
    }

    public void setSubCompositiveCoefficientName(String subCompositiveCoefficientName) {
        this.subCompositiveCoefficientName = subCompositiveCoefficientName;
    }

    @ReferSerialTransfer(referCode = "pro-income-coefficient")
    public Long getSubCompositiveCoefficientId() {
        return subCompositiveCoefficientId;
    }

    @ReferDeserialTransfer
    public void setSubCompositiveCoefficientId(Long subCompositiveCoefficientId) {
        this.subCompositiveCoefficientId = subCompositiveCoefficientId;
    }

    public BigDecimal getSubCompositiveCoefficient() {
        return subCompositiveCoefficient;
    }

    public void setSubCompositiveCoefficient(BigDecimal subCompositiveCoefficient) {
        this.subCompositiveCoefficient = subCompositiveCoefficient;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getSubSubjectId() {
        return subSubjectId;
    }
    @ReferDeserialTransfer
    public void setSubSubjectId(Long subSubjectId) {
        this.subSubjectId = subSubjectId;
    }

    public String getSubSubjectName() {
        return subSubjectName;
    }

    public void setSubSubjectName(String subSubjectName) {
        this.subSubjectName = subSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getSubTax() {
        return subTax;
    }

    public void setSubTax(BigDecimal subTax) {
        this.subTax = subTax;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public List<BudgetDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<BudgetDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 编码
     */
    public String getSubCode() {
        return subCode;
    }

    /**
     * 编码
     */
    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }
    /**
     * 名称
     */
    public String getSubName() {
        return subName;
    }

    /**
     * 名称
     */
    public void setSubName(String subName) {
        this.subName = subName;
    }
    /**
     * 特征
     */
    public String getSubFeature() {
        return subFeature;
    }

    /**
     * 特征
     */
    public void setSubFeature(String subFeature) {
        this.subFeature = subFeature;
    }
    /**
     * 单位
     */
    public String getSubUnit() {
        return subUnit;
    }

    /**
     * 单位
     */
    public void setSubUnit(String subUnit) {
        this.subUnit = subUnit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getSubNum() {
        return subNum;
    }

    /**
     * 工程量
     */
    public void setSubNum(java.math.BigDecimal subNum) {
        this.subNum = subNum;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getSubTaxRate() {
        return subTaxRate;
    }

    /**
     * 税率
     */
    public void setSubTaxRate(java.math.BigDecimal subTaxRate) {
        this.subTaxRate = subTaxRate;
    }
    /**
     * 综合单价(无税)
     */
    public java.math.BigDecimal getSubPrice() {
        return subPrice;
    }

    /**
     * 综合单价(无税)
     */
    public void setSubPrice(java.math.BigDecimal subPrice) {
        this.subPrice = subPrice;
    }
    /**
     * 综合单价(含税)
     */
    public java.math.BigDecimal getSubTaxPrice() {
        return subTaxPrice;
    }

    /**
     * 综合单价(含税)
     */
    public void setSubTaxPrice(java.math.BigDecimal subTaxPrice) {
        this.subTaxPrice = subTaxPrice;
    }
    /**
     * 合价(无税)
     */
    public java.math.BigDecimal getSubMny() {
        return subMny;
    }

    /**
     * 合价(无税)
     */
    public void setSubMny(java.math.BigDecimal subMny) {
        this.subMny = subMny;
    }
    /**
     * 合价(含税)
     */
    public java.math.BigDecimal getSubTaxMny() {
        return subTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setSubTaxMny(java.math.BigDecimal subTaxMny) {
        this.subTaxMny = subTaxMny;
    }
    /**
     * 备注
     */
    public String getSubMemo() {
        return subMemo;
    }

    /**
     * 备注
     */
    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"subPrice"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"subTaxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"subNum"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"subMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"subTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"subTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"subTax"};
    }
}
