package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工合同交底
 * 
 * @author generator
 * 
 */
public class ContractConfessVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long contractId; // 合同主键
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long employeeId; // 交底人
    private String employeeName; // 交底人名称
    private Long deptId; // 交底部门
    private String deptName; // 交底部门名称
    private Long passiveEmployeeId;//被交底人
    private String passiveEmployeeName;//被交底人名称
    private Long passiveDeptId;//被交底部门
    private String passiveDeptName;//被交底部门名称
    private Long customerId; // 合同甲方
    private String customerName; // 合同甲方名称
    private Long architectId; // 建造师
    private String architectName; // 建造师名称
    private Long managerId; // 项目责任人
    private String managerName; // 项目责任人名称
    private Long engineeringTypeId; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date confessDate; // 交底日期
    private String contractScope; // 承包范围
    private String fundsSource; // 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    private Integer schedule; // 工期
    private String qualityRequirement; // 质量要求
    private String safetyGoal; // 安全目标
    private String civilizationConstructionGoal; // 文明施工目标
    private Integer advancePayment; // 预付款：0-无，1-有
    private Integer progressPayment; // 工程进度款支付：0-按节点支付，1-按月支付
    private String nodePayment; // 按节点支付
    private String monthPayment; // 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
    private String qualityDeposit; // 质量保证金：0-3%，1-5%
    private String priceAdjustment; // 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
    private String priceAdjustmentDesc; //价格调整描述
    private String breach; // 违约
    private Integer billType; // 单据类型
    private String otherTerms; // 其它条款
    private java.lang.String advancePaymentInfo; // 预付款信息
    private java.lang.String priceAdjustmentSecond; // 价格调整2：0-采用造价信息进行价格调整，1-采用价格指数进行价格调整，2-专用合同条款约定的其他方式
    private java.lang.String priceAdjustmentThird; // 价格调整3：0-人工费调整，1-材料、工程设备价格变化的价款调整:涨跌幅度+-5%，2-施工机械台班单价或施工机械使用费
    private java.lang.String priceAdjustmentInfo; // 法律变化引起的调整信息
    private java.lang.String priceAdjustmentThirdTwo; // 采用价格指数进行价格调整信息
    private java.lang.String priceAdjustmentThirdThree; // 专用合同条款约定的其他方式信息
    private java.lang.String priceAdjustmentThirdOne; // 采用价格信息进行价格调整信息
    private String precautions; //履约注意事项
    private String paymentTerm; //支付条款描述
    private BigDecimal fixedPaymentRate; //固定付款比例

    private List<ContractConfessDetailVO> clauseList = new ArrayList<>(); // 合同交底明细


    private String date; // 交底日期字符串
    private String billStateName; // 单据状态名称
    private Long fundsSourceId; // 资金来源(自定义档案)

    public String getPriceAdjustmentDesc() {
        return priceAdjustmentDesc;
    }

    public void setPriceAdjustmentDesc(String priceAdjustmentDesc) {
        this.priceAdjustmentDesc = priceAdjustmentDesc;
    }

    public String getPriceAdjustmentThirdOne() {
        return priceAdjustmentThirdOne;
    }

    public void setPriceAdjustmentThirdOne(String priceAdjustmentThirdOne) {
        this.priceAdjustmentThirdOne = priceAdjustmentThirdOne;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public BigDecimal getFixedPaymentRate() {
        return fixedPaymentRate;
    }

    public void setFixedPaymentRate(BigDecimal fixedPaymentRate) {
        this.fixedPaymentRate = fixedPaymentRate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode="pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 交底人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 交底人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 交底人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 交底人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 交底部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 交底部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 交底部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 交底部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 合同甲方
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 合同甲方
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 合同甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 合同甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 建造师
     */
    @ReferSerialTransfer(referCode="income-arch")
    public Long getArchitectId() {
        return architectId;
    }

    /**
     * 建造师
     */
    @ReferDeserialTransfer
    public void setArchitectId(Long architectId) {
        this.architectId = architectId;
    }
    /**
     * 建造师名称
     */
    public String getArchitectName() {
        return architectName;
    }

    /**
     * 建造师名称
     */
    public void setArchitectName(String architectName) {
        this.architectName = architectName;
    }
    /**
     * 项目责任人
     */
    @ReferSerialTransfer(referCode="income-arch")
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 项目责任人
     */
    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    /**
     * 项目责任人名称
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 项目责任人名称
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    /**
     * 工程类型
     */
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类型
     */
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 交底日期
     */
    public java.util.Date getConfessDate() {
        return confessDate;
    }

    /**
     * 交底日期
     */
    public void setConfessDate(java.util.Date confessDate) {
        this.confessDate = confessDate;
    }
    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }
    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 合同开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 工期
     */
    public Integer getSchedule() {
        return schedule;
    }

    /**
     * 工期
     */
    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }
    /**
     * 质量要求
     */
    public String getQualityRequirement() {
        return qualityRequirement;
    }

    /**
     * 质量要求
     */
    public void setQualityRequirement(String qualityRequirement) {
        this.qualityRequirement = qualityRequirement;
    }
    /**
     * 安全目标
     */
    public String getSafetyGoal() {
        return safetyGoal;
    }

    /**
     * 安全目标
     */
    public void setSafetyGoal(String safetyGoal) {
        this.safetyGoal = safetyGoal;
    }
    /**
     * 文明施工目标
     */
    public String getCivilizationConstructionGoal() {
        return civilizationConstructionGoal;
    }

    /**
     * 文明施工目标
     */
    public void setCivilizationConstructionGoal(String civilizationConstructionGoal) {
        this.civilizationConstructionGoal = civilizationConstructionGoal;
    }
    /**
     * 预付款：0-无，1-有
     */
    public Integer getAdvancePayment() {
        return advancePayment;
    }

    /**
     * 预付款：0-无，1-有
     */
    public void setAdvancePayment(Integer advancePayment) {
        this.advancePayment = advancePayment;
    }
    /**
     * 工程进度款支付：0-按节点支付，1-按月支付
     */
    public Integer getProgressPayment() {
        return progressPayment;
    }

    /**
     * 工程进度款支付：0-按节点支付，1-按月支付
     */
    public void setProgressPayment(Integer progressPayment) {
        this.progressPayment = progressPayment;
    }
    /**
     * 按节点支付
     */
    public String getNodePayment() {
        return nodePayment;
    }

    /**
     * 按节点支付
     */
    public void setNodePayment(String nodePayment) {
        this.nodePayment = nodePayment;
    }
    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public String getMonthPayment() {
        return monthPayment;
    }

    /**
     * 按月支付比例：0-70%，1-75%，2-80%，3-85%，4-90%
     */
    public void setMonthPayment(String monthPayment) {
        this.monthPayment = monthPayment;
    }
    /**
     * 质量保证金：0-3%，1-5%
     */
    public String getQualityDeposit() {
        return qualityDeposit;
    }

    /**
     * 质量保证金：0-3%，1-5%
     */
    public void setQualityDeposit(String qualityDeposit) {
        this.qualityDeposit = qualityDeposit;
    }
    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public String getPriceAdjustment() {
        return priceAdjustment;
    }

    /**
     * 价格调整：0-采用价格指数进行价格调整，1-采用造价信息进行价格调整，2-专用合同条款约定的其他方式
     */
    public void setPriceAdjustment(String priceAdjustment) {
        this.priceAdjustment = priceAdjustment;
    }

    /**
     * 违约
     */
    public String getBreach() {
        return breach;
    }

    /**
     * 违约
     */
    public void setBreach(String breach) {
        this.breach = breach;
    }

    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getOtherTerms() {
        return otherTerms;
    }

    public void setOtherTerms(String otherTerms) {
        this.otherTerms = otherTerms;
    }

    public String getAdvancePaymentInfo() {
        return advancePaymentInfo;
    }

    public void setAdvancePaymentInfo(String advancePaymentInfo) {
        this.advancePaymentInfo = advancePaymentInfo;
    }

    public String getPriceAdjustmentSecond() {
        return priceAdjustmentSecond;
    }

    public void setPriceAdjustmentSecond(String priceAdjustmentSecond) {
        this.priceAdjustmentSecond = priceAdjustmentSecond;
    }

    public String getPriceAdjustmentThird() {
        return priceAdjustmentThird;
    }

    public void setPriceAdjustmentThird(String priceAdjustmentThird) {
        this.priceAdjustmentThird = priceAdjustmentThird;
    }

    public String getPriceAdjustmentInfo() {
        return priceAdjustmentInfo;
    }

    public void setPriceAdjustmentInfo(String priceAdjustmentInfo) {
        this.priceAdjustmentInfo = priceAdjustmentInfo;
    }

    public String getPriceAdjustmentThirdTwo() {
        return priceAdjustmentThirdTwo;
    }

    public void setPriceAdjustmentThirdTwo(String priceAdjustmentThirdTwo) {
        this.priceAdjustmentThirdTwo = priceAdjustmentThirdTwo;
    }

    public String getPriceAdjustmentThirdThree() {
        return priceAdjustmentThirdThree;
    }

    public void setPriceAdjustmentThirdThree(String priceAdjustmentThirdThree) {
        this.priceAdjustmentThirdThree = priceAdjustmentThirdThree;
    }

    public List<ContractConfessDetailVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractConfessDetailVO> clauseList) {
        this.clauseList = clauseList;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    @ReferDeserialTransfer
    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    public String getPrecautions() {
        return precautions;
    }

    public Long getPassiveEmployeeId() {
        return passiveEmployeeId;
    }

    public void setPassiveEmployeeId(Long passiveEmployeeId) {
        this.passiveEmployeeId = passiveEmployeeId;
    }

    public String getPassiveEmployeeName() {
        return passiveEmployeeName;
    }

    public void setPassiveEmployeeName(String passiveEmployeeName) {
        this.passiveEmployeeName = passiveEmployeeName;
    }

    public Long getPassiveDeptId() {
        return passiveDeptId;
    }

    public void setPassiveDeptId(Long passiveDeptId) {
        this.passiveDeptId = passiveDeptId;
    }

    public String getPassiveDeptName() {
        return passiveDeptName;
    }

    public void setPassiveDeptName(String passiveDeptName) {
        this.passiveDeptName = passiveDeptName;
    }

    public void setPrecautions(String precautions) {
        this.precautions = precautions;
    }
}
