package com.ejianc.business.pro.income.vo;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 建设项目年度结算计划与完成对比表
 * 
 * @author generator
 * 
 */
public class PlancompletionListVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 基层单位id
    private String orgCode; // 基层单位编码
    private String orgName; // 基层单位名称
    private String year; //  计划年份
    private BigDecimal yearApproveMny; // 年度计划审定金额
    private BigDecimal yearSubmitMny; // 其中已送审金额
    private BigDecimal groupInnerMny; // 集团内定案返回确认金额
    private BigDecimal groupOutMny; // 集团外定案返回确认金额
    private BigDecimal groupMny; // 定案返回确认金额
    private BigDecimal completionRate; // 总完成率
    private BigDecimal unYearCompletionRate; // 未进入年度目标完成率
    private BigDecimal yearCompletionRate; // 年度目标完成率
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String memo; // 备注

    private Long completionId; // 主表主键id
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long parentProjectId; // 所属父级项目id
    private String parentProjectCode; // 所属父级项目编码
    private String parentProjectName; // 所属父级项目名称
    private String projectUnits; // 建设单位
    private Integer groupType; // 集团内/外 0-内 1-外
    private String groupTypeName; // 集团内/外 0-内 1-外
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDate; // 竣工日期
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date approveDate; // 上报计划审定日期
    private String projectManager; // 项目经理
    private Long settleEmployeeId; // 结算负责人id
    private String settleEmployeeName; // 结算负责人名称
    private BigDecimal contractMny; // 合同金额
    private BigDecimal sumCompleteMny; // 累计实际完成产值
    private BigDecimal detailSubmitMny; // 送审金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailSubmitDate; // 送审日期
    private BigDecimal ydApproveMny; // 预计审定金额
    private Integer completedFlag; // 是否取得竣工备案表 0-是 1-否
    private Integer finalizeType; // 计划定案阶段 1-一审、2-二审、3-三审、4-终审
    private Integer yearPlanFlag; // 是否进入年度计划 0-是 1-否
    private String yearPlanFlagName; // 是否进入年度计划 0-是 1-否
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planApproveDate; // 批复计划审定日期
    private Integer finalizeFlag; // 定案返回状态 0-已返回 1-未返回
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finalizeDate; // 定案表返回日期
    private BigDecimal finalizeMny; // 定案表返回金额
    private Integer indexGrade; // 指标等级 1一类、2二类

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return completionId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Integer getIndexGrade() {
        return indexGrade;
    }

    public void setIndexGrade(Integer indexGrade) {
        this.indexGrade = indexGrade;
    }

    public String getGroupTypeName() {
        return groupTypeName;
    }

    public void setGroupTypeName(String groupTypeName) {
        this.groupTypeName = groupTypeName;
    }

    public String getYearPlanFlagName() {
        return yearPlanFlagName;
    }

    public void setYearPlanFlagName(String yearPlanFlagName) {
        this.yearPlanFlagName = yearPlanFlagName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public BigDecimal getYearApproveMny() {
        return yearApproveMny;
    }

    public void setYearApproveMny(BigDecimal yearApproveMny) {
        this.yearApproveMny = yearApproveMny;
    }
    public BigDecimal getYearSubmitMny() {
        return yearSubmitMny;
    }

    public void setYearSubmitMny(BigDecimal yearSubmitMny) {
        this.yearSubmitMny = yearSubmitMny;
    }
    public BigDecimal getGroupInnerMny() {
        return groupInnerMny;
    }

    public void setGroupInnerMny(BigDecimal groupInnerMny) {
        this.groupInnerMny = groupInnerMny;
    }
    public BigDecimal getGroupOutMny() {
        return groupOutMny;
    }

    public void setGroupOutMny(BigDecimal groupOutMny) {
        this.groupOutMny = groupOutMny;
    }
    public BigDecimal getGroupMny() {
        return groupMny;
    }

    public void setGroupMny(BigDecimal groupMny) {
        this.groupMny = groupMny;
    }
    public BigDecimal getCompletionRate() {
        return completionRate;
    }

    public void setCompletionRate(BigDecimal completionRate) {
        this.completionRate = completionRate;
    }
    public BigDecimal getUnYearCompletionRate() {
        return unYearCompletionRate;
    }

    public void setUnYearCompletionRate(BigDecimal unYearCompletionRate) {
        this.unYearCompletionRate = unYearCompletionRate;
    }
    public BigDecimal getYearCompletionRate() {
        return yearCompletionRate;
    }

    public void setYearCompletionRate(BigDecimal yearCompletionRate) {
        this.yearCompletionRate = yearCompletionRate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getCompletionId() {
        return completionId;
    }

    public void setCompletionId(Long completionId) {
        this.completionId = completionId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getParentProjectId() {
        return parentProjectId;
    }

    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }

    public String getParentProjectCode() {
        return parentProjectCode;
    }

    public void setParentProjectCode(String parentProjectCode) {
        this.parentProjectCode = parentProjectCode;
    }

    public String getParentProjectName() {
        return parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }

    public String getProjectUnits() {
        return projectUnits;
    }

    public void setProjectUnits(String projectUnits) {
        this.projectUnits = projectUnits;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }

    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }

    public Long getSettleEmployeeId() {
        return settleEmployeeId;
    }

    public void setSettleEmployeeId(Long settleEmployeeId) {
        this.settleEmployeeId = settleEmployeeId;
    }

    public String getSettleEmployeeName() {
        return settleEmployeeName;
    }

    public void setSettleEmployeeName(String settleEmployeeName) {
        this.settleEmployeeName = settleEmployeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumCompleteMny() {
        return sumCompleteMny;
    }

    public void setSumCompleteMny(BigDecimal sumCompleteMny) {
        this.sumCompleteMny = sumCompleteMny;
    }

    public BigDecimal getDetailSubmitMny() {
        return detailSubmitMny;
    }

    public void setDetailSubmitMny(BigDecimal detailSubmitMny) {
        this.detailSubmitMny = detailSubmitMny;
    }

    public Date getDetailSubmitDate() {
        return detailSubmitDate;
    }

    public void setDetailSubmitDate(Date detailSubmitDate) {
        this.detailSubmitDate = detailSubmitDate;
    }

    public BigDecimal getYdApproveMny() {
        return ydApproveMny;
    }

    public void setYdApproveMny(BigDecimal ydApproveMny) {
        this.ydApproveMny = ydApproveMny;
    }

    public Integer getCompletedFlag() {
        return completedFlag;
    }

    public void setCompletedFlag(Integer completedFlag) {
        this.completedFlag = completedFlag;
    }

    public Integer getFinalizeType() {
        return finalizeType;
    }

    public void setFinalizeType(Integer finalizeType) {
        this.finalizeType = finalizeType;
    }

    public Integer getYearPlanFlag() {
        return yearPlanFlag;
    }

    public void setYearPlanFlag(Integer yearPlanFlag) {
        this.yearPlanFlag = yearPlanFlag;
    }

    public Date getPlanApproveDate() {
        return planApproveDate;
    }

    public void setPlanApproveDate(Date planApproveDate) {
        this.planApproveDate = planApproveDate;
    }

    public Integer getFinalizeFlag() {
        return finalizeFlag;
    }

    public void setFinalizeFlag(Integer finalizeFlag) {
        this.finalizeFlag = finalizeFlag;
    }

    public Date getFinalizeDate() {
        return finalizeDate;
    }

    public void setFinalizeDate(Date finalizeDate) {
        this.finalizeDate = finalizeDate;
    }

    public BigDecimal getFinalizeMny() {
        return finalizeMny;
    }

    public void setFinalizeMny(BigDecimal finalizeMny) {
        this.finalizeMny = finalizeMny;
    }
}
