package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 争议事项推进
 * 
 * @author generator
 * 
 */
public class UnsettleDisputedVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long unsettleId; // 主表主键id
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String approveFlag; // 结算送审情况 1-未送审 2-已送审
    private BigDecimal resolvedDisputedMny; // 已解决争议金额（万元）
    private BigDecimal unDisputedMny; // 未解决争议金额（万元）
    private BigDecimal allDisputedMny; // 争议金额
    private String disputedFlag; // 争议核销 1-未核销 2-已核销
    private Long disputedLevelId; // 争议解决层面id
    private String disputedLevelName; // 争议解决层面名称
    private Long writeoffEmployeeId; // 核销人id
    private String writeoffEmployeeName; // 核销人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date writeoffDate; // 核销日期
    private String memo; // 备注

    private String disputedMemo; // 争议事项活结算推进记录


    public String getDisputedMemo() {
        return disputedMemo;
    }

    public void setDisputedMemo(String disputedMemo) {
        this.disputedMemo = disputedMemo;
    }

    public Long getUnsettleId() {
        return unsettleId;
    }

    public void setUnsettleId(Long unsettleId) {
        this.unsettleId = unsettleId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getApproveFlag() {
        return approveFlag;
    }

    public void setApproveFlag(String approveFlag) {
        this.approveFlag = approveFlag;
    }
    public BigDecimal getResolvedDisputedMny() {
        return resolvedDisputedMny;
    }

    public void setResolvedDisputedMny(BigDecimal resolvedDisputedMny) {
        this.resolvedDisputedMny = resolvedDisputedMny;
    }
    public BigDecimal getUnDisputedMny() {
        return unDisputedMny;
    }

    public void setUnDisputedMny(BigDecimal unDisputedMny) {
        this.unDisputedMny = unDisputedMny;
    }
    public BigDecimal getAllDisputedMny() {
        return allDisputedMny;
    }

    public void setAllDisputedMny(BigDecimal allDisputedMny) {
        this.allDisputedMny = allDisputedMny;
    }
    public String getDisputedFlag() {
        return disputedFlag;
    }

    public void setDisputedFlag(String disputedFlag) {
        this.disputedFlag = disputedFlag;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDisputedLevelId() {
        return disputedLevelId;
    }
    @ReferDeserialTransfer
    public void setDisputedLevelId(Long disputedLevelId) {
        this.disputedLevelId = disputedLevelId;
    }
    public String getDisputedLevelName() {
        return disputedLevelName;
    }

    public void setDisputedLevelName(String disputedLevelName) {
        this.disputedLevelName = disputedLevelName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getWriteoffEmployeeId() {
        return writeoffEmployeeId;
    }
    @ReferDeserialTransfer
    public void setWriteoffEmployeeId(Long writeoffEmployeeId) {
        this.writeoffEmployeeId = writeoffEmployeeId;
    }
    public String getWriteoffEmployeeName() {
        return writeoffEmployeeName;
    }

    public void setWriteoffEmployeeName(String writeoffEmployeeName) {
        this.writeoffEmployeeName = writeoffEmployeeName;
    }
    public Date getWriteoffDate() {
        return writeoffDate;
    }

    public void setWriteoffDate(Date writeoffDate) {
        this.writeoffDate = writeoffDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
