package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 建设项目年度结算计划与完成对比表
 * 
 * @author generator
 * 
 */
public class PlancompletionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 基层单位id
    private String orgCode; // 基层单位编码
    private String orgName; // 基层单位名称
    private String year; //  计划年份
    private BigDecimal yearApproveMny; // 年度计划审定金额
    private BigDecimal yearSubmitMny; // 其中已送审金额
    private BigDecimal groupInnerMny; // 集团内定案返回确认金额
    private BigDecimal groupOutMny; // 集团外定案返回确认金额
    private BigDecimal groupMny; // 定案返回确认金额
    private BigDecimal completionRate; // 总完成率
    private BigDecimal unYearCompletionRate; // 未进入年度目标完成率
    private BigDecimal yearCompletionRate; // 年度目标完成率
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String memo; // 备注

    private List<PlancompletionDetailVO> plancompletionDetailList = new ArrayList<>();

    public List<PlancompletionDetailVO> getPlancompletionDetailList() {
        return plancompletionDetailList;
    }

    public void setPlancompletionDetailList(List<PlancompletionDetailVO> plancompletionDetailList) {
        this.plancompletionDetailList = plancompletionDetailList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public BigDecimal getYearApproveMny() {
        return yearApproveMny;
    }

    public void setYearApproveMny(BigDecimal yearApproveMny) {
        this.yearApproveMny = yearApproveMny;
    }
    public BigDecimal getYearSubmitMny() {
        return yearSubmitMny;
    }

    public void setYearSubmitMny(BigDecimal yearSubmitMny) {
        this.yearSubmitMny = yearSubmitMny;
    }
    public BigDecimal getGroupInnerMny() {
        return groupInnerMny;
    }

    public void setGroupInnerMny(BigDecimal groupInnerMny) {
        this.groupInnerMny = groupInnerMny;
    }
    public BigDecimal getGroupOutMny() {
        return groupOutMny;
    }

    public void setGroupOutMny(BigDecimal groupOutMny) {
        this.groupOutMny = groupOutMny;
    }
    public BigDecimal getGroupMny() {
        return groupMny;
    }

    public void setGroupMny(BigDecimal groupMny) {
        this.groupMny = groupMny;
    }
    public BigDecimal getCompletionRate() {
        return completionRate;
    }

    public void setCompletionRate(BigDecimal completionRate) {
        this.completionRate = completionRate;
    }
    public BigDecimal getUnYearCompletionRate() {
        return unYearCompletionRate;
    }

    public void setUnYearCompletionRate(BigDecimal unYearCompletionRate) {
        this.unYearCompletionRate = unYearCompletionRate;
    }
    public BigDecimal getYearCompletionRate() {
        return yearCompletionRate;
    }

    public void setYearCompletionRate(BigDecimal yearCompletionRate) {
        this.yearCompletionRate = yearCompletionRate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
