package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.income.vo.UnsettleDetailVO;

/**
 * 项目竣工未结推进表
 * 
 * @author generator
 * 
 */
public class UnsettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 基层单位id
    private String orgCode; // 基层单位编码
    private String orgName; // 基层单位名称
    private BigDecimal unsettleMny; // 截至目前竣工未结金额
    private BigDecimal finalizeBackMny; // 定案返回金额
    private BigDecimal disputedMny; // 争议金额
    private BigDecimal monthDisputedMny; // 本月已解决争议金额
    private Integer monthDisputedNum; // 本月核销争议个数
    private BigDecimal sumDisputedMny; // 累计已解决争议金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String memo; // 备注
    
    private List<UnsettleDetailVO> unsettleDetailList = new ArrayList<>(); // 竣工未结明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getUnsettleMny() {
        return unsettleMny;
    }

    public void setUnsettleMny(BigDecimal unsettleMny) {
        this.unsettleMny = unsettleMny;
    }

    public BigDecimal getFinalizeBackMny() {
        return finalizeBackMny;
    }

    public void setFinalizeBackMny(BigDecimal finalizeBackMny) {
        this.finalizeBackMny = finalizeBackMny;
    }

    public BigDecimal getDisputedMny() {
        return disputedMny;
    }

    public void setDisputedMny(BigDecimal disputedMny) {
        this.disputedMny = disputedMny;
    }
    public BigDecimal getMonthDisputedMny() {
        return monthDisputedMny;
    }

    public void setMonthDisputedMny(BigDecimal monthDisputedMny) {
        this.monthDisputedMny = monthDisputedMny;
    }
    public Integer getMonthDisputedNum() {
        return monthDisputedNum;
    }

    public void setMonthDisputedNum(Integer monthDisputedNum) {
        this.monthDisputedNum = monthDisputedNum;
    }
    public BigDecimal getSumDisputedMny() {
        return sumDisputedMny;
    }

    public void setSumDisputedMny(BigDecimal sumDisputedMny) {
        this.sumDisputedMny = sumDisputedMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<UnsettleDetailVO> getUnsettleDetailList() {
        return unsettleDetailList;
     }

     public void setUnsettleDetailList(List<UnsettleDetailVO> unsettleDetailList) {
        this.unsettleDetailList = unsettleDetailList;
     }
}
