package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import javax.swing.tree.TreeNode;


/**
 * 工程结算定案表返回确认单子实体
 * 
 * @author generator
 * 
 */
public class SettlementFinalizationDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private Long finalizationId; // 工程结算定案表主键
    private Long basicUnitId; // 基层单位id
    private String basicUnitCode; // 基层单位编码
    private String basicUnitName; // 基层单位名称
    private BigDecimal finalizationBackMny; // 定案表返还金额
    private BigDecimal finalizationOutMny; // 定案表外金额
    private BigDecimal materialSupplyMny; // 其中甲供材金额
    private BigDecimal qualityDepositMny; // 其中质量保证金
    private BigDecimal waterproofWarrantyMny; // 其中防水质保金
    private Long settleChargeId; // 结算负责人id
    private String settleChargeName; // 结算负责人名称
    private Long chiefEconomistId; // 主任经济师id
    private String chiefEconomistName; // 主任经济师名称
    private Long unitChargeId; // 基层单位负责人id
    private String unitChargeName; // 基层单位负责人名称
    private String detailMemo; // 备注
    private BigDecimal childSumCostMny; // 累计成本
    private BigDecimal childSumCostTaxMny; // 累计成本(含税)
    private Long childProjectId; // 子项目id
    private String childProjectName; // 子项目名称
    private java.math.BigDecimal childSumProductionMny; // 累计产值金额(无税)
    private java.math.BigDecimal childSumProductionTaxMny; // 累计产值金额
    private String childCheckUnitId; // 审核单位id
    private String childCheckUnit; // 审核单位
    private java.math.BigDecimal childReportSettleTaxMny; // 报审结算金额
    private java.math.BigDecimal childReportSettleMny; // 报审结算金额(无税)
    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="tree_index")
    private String treeIndex; // 序号
    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    private List<ITreeNodeB> children = new ArrayList<>();

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }


    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public BigDecimal getChildReportSettleTaxMny() {
        return childReportSettleTaxMny;
    }

    public void setChildReportSettleTaxMny(BigDecimal childReportSettleTaxMny) {
        this.childReportSettleTaxMny = childReportSettleTaxMny;
    }

    public BigDecimal getChildReportSettleMny() {
        return childReportSettleMny;
    }

    public void setChildReportSettleMny(BigDecimal childReportSettleMny) {
        this.childReportSettleMny = childReportSettleMny;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getChildProjectId() {
        return childProjectId;
    }
    @ReferDeserialTransfer
    public void setChildProjectId(Long childProjectId) {
        this.childProjectId = childProjectId;
    }

    public String getChildProjectName() {
        return childProjectName;
    }

    public void setChildProjectName(String childProjectName) {
        this.childProjectName = childProjectName;
    }

    public BigDecimal getChildSumProductionMny() {
        return childSumProductionMny;
    }

    public void setChildSumProductionMny(BigDecimal childSumProductionMny) {
        this.childSumProductionMny = childSumProductionMny;
    }

    public BigDecimal getChildSumProductionTaxMny() {
        return childSumProductionTaxMny;
    }

    public void setChildSumProductionTaxMny(BigDecimal childSumProductionTaxMny) {
        this.childSumProductionTaxMny = childSumProductionTaxMny;
    }

    public String getChildCheckUnitId() {
        return childCheckUnitId;
    }

    public void setChildCheckUnitId(String childCheckUnitId) {
        this.childCheckUnitId = childCheckUnitId;
    }

    public String getChildCheckUnit() {
        return childCheckUnit;
    }

    public void setChildCheckUnit(String childCheckUnit) {
        this.childCheckUnit = childCheckUnit;
    }

    public BigDecimal getChildSumCostMny() {
        return childSumCostMny;
    }

    public void setChildSumCostMny(BigDecimal childSumCostMny) {
        this.childSumCostMny = childSumCostMny;
    }

    public BigDecimal getChildSumCostTaxMny() {
        return childSumCostTaxMny;
    }

    public void setChildSumCostTaxMny(BigDecimal childSumCostTaxMny) {
        this.childSumCostTaxMny = childSumCostTaxMny;
    }

    public Long getFinalizationId() {
        return finalizationId;
    }

    public void setFinalizationId(Long finalizationId) {
        this.finalizationId = finalizationId;
    }


    @ReferSerialTransfer(referCode="idm-org")
    public Long getBasicUnitId() {
        return basicUnitId;
    }
    @ReferDeserialTransfer
    public void setBasicUnitId(Long basicUnitId) {
        this.basicUnitId = basicUnitId;
    }
    public String getBasicUnitCode() {
        return basicUnitCode;
    }

    public void setBasicUnitCode(String basicUnitCode) {
        this.basicUnitCode = basicUnitCode;
    }
    public String getBasicUnitName() {
        return basicUnitName;
    }

    public void setBasicUnitName(String basicUnitName) {
        this.basicUnitName = basicUnitName;
    }
    public BigDecimal getFinalizationBackMny() {
        return finalizationBackMny;
    }

    public void setFinalizationBackMny(BigDecimal finalizationBackMny) {
        this.finalizationBackMny = finalizationBackMny;
    }
    public BigDecimal getFinalizationOutMny() {
        return finalizationOutMny;
    }

    public void setFinalizationOutMny(BigDecimal finalizationOutMny) {
        this.finalizationOutMny = finalizationOutMny;
    }
    public BigDecimal getMaterialSupplyMny() {
        return materialSupplyMny;
    }

    public void setMaterialSupplyMny(BigDecimal materialSupplyMny) {
        this.materialSupplyMny = materialSupplyMny;
    }
    public BigDecimal getQualityDepositMny() {
        return qualityDepositMny;
    }

    public void setQualityDepositMny(BigDecimal qualityDepositMny) {
        this.qualityDepositMny = qualityDepositMny;
    }
    public BigDecimal getWaterproofWarrantyMny() {
        return waterproofWarrantyMny;
    }

    public void setWaterproofWarrantyMny(BigDecimal waterproofWarrantyMny) {
        this.waterproofWarrantyMny = waterproofWarrantyMny;
    }
    public Long getSettleChargeId() {
        return settleChargeId;
    }
    @ReferDeserialTransfer
    public void setSettleChargeId(Long settleChargeId) {
        this.settleChargeId = settleChargeId;
    }
    public String getSettleChargeName() {
        return settleChargeName;
    }

    public void setSettleChargeName(String settleChargeName) {
        this.settleChargeName = settleChargeName;
    }
    public Long getChiefEconomistId() {
        return chiefEconomistId;
    }
    @ReferDeserialTransfer
    public void setChiefEconomistId(Long chiefEconomistId) {
        this.chiefEconomistId = chiefEconomistId;
    }
    public String getChiefEconomistName() {
        return chiefEconomistName;
    }

    public void setChiefEconomistName(String chiefEconomistName) {
        this.chiefEconomistName = chiefEconomistName;
    }
    public Long getUnitChargeId() {
        return unitChargeId;
    }
    @ReferDeserialTransfer
    public void setUnitChargeId(Long unitChargeId) {
        this.unitChargeId = unitChargeId;
    }
    public String getUnitChargeName() {
        return unitChargeName;
    }

    public void setUnitChargeName(String unitChargeName) {
        this.unitChargeName = unitChargeName;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }
}
