package com.ejianc.business.pro.income.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 对甲报量
 *
 * @author generator
 *
 */
public class QuoteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编号
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "orgId")
    private Long orgId; // 组织
    @ConvertField(targetField = "orgName")
    private String orgName; // 组织名称
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 组织编码
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 父级组织
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 所属组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 父级组织名称
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同主键
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编号
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    private BigDecimal taxRate; // 合同税率
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date quoteDate; // 报量时间
    @ConvertField(targetField = "quoteMny")
    private BigDecimal quoteMny; // 本次上报金额(无税)
    @ConvertField(targetField = "quoteTaxMny")
    private BigDecimal quoteTaxMny; // 本次上报金额
    @ConvertField(targetField = "quoteTax")
    private BigDecimal taxMny; // 税额
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long deptId; // 部门id
    @ConvertField(targetField = "departmentName")
    private String deptName; // 部门名称
    @ConvertField(targetField = "settleDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date replyDate; // 批复时间
    private Integer replyStatus; // 甲方批复状态(0-未批复，1-已批复，2-未通过)
    @ConvertField(targetField = "curMny")
    private BigDecimal replyMny; // 本次批复金额(无税)
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal replyTaxMny; // 本次批复金额
    @ConvertField
    private String memo; // 备注                          ---形象进度
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态
    private BigDecimal appliedTaxMny; //已申请金额(不含本次)
    private BigDecimal appliedMny; //已申请金额(不含本次)(无税)
    private BigDecimal residueTaxMny;//剩余可申请金额

    private List<QuoteDetailVO> detailList = new ArrayList<>(); // 对甲报量子表

    private Integer contractVersion;// 合同版本

    private String billStateName; //单据状态名称

    private Long financialOrgId; //财务组织Id
    private String financialOrgName; //财务组织名称
    private String financialOrgCode; //财务组织编码

    private String financialNumber; //凭证号
    private String financialCrossFlag; //是否传会计平台 1：是； 0：否
    private Long badDebtProvisionTypeId; //坏账计提方式Id
    private String badDebtProvisionTypeName; //坏账计提方式名称

    private Long customerId; // 发包单位
    private String customerName; // 发包单位名称
    private String meterType; // 计量方式：1-按月计量，2-按节点计量
    private String quotePeriod; // 计量区间
    private BigDecimal budgetMny; // 施工图预算金额(无税)
    private BigDecimal budgetTaxMny; // 施工图预算金额(含税)
    private BigDecimal lastFinishMny; // 截止上期累计完成金额(无税)
    private BigDecimal lastFinishTaxMny; // 截止上期累计完成金额(含税)
    private BigDecimal sumFinishMny; // 累计完成金额(无税)
    private BigDecimal sumFinishTaxMny; // 累计完成金额(含税)
    private BigDecimal lastQuoteMny; // 截止上期累计上报金额(无税)
    private BigDecimal lastQuoteTaxMny; // 截止上期累计上报金额(含税)
    private BigDecimal sumQuoteMny; // 累计上报金额(无税)
    private BigDecimal sumQuoteTaxMny; // 累计上报金额(含税)
    private BigDecimal finishMny; // 本次完成金额(无税)
    private BigDecimal finishTaxMny; // 本次完成金额
    private BigDecimal productionMny; // 本次产值金额(无税)
    private BigDecimal productionTaxMny; // 本次产值金额
    private BigDecimal claimMny; // 本期签证索赔金额(无税)
    private BigDecimal claimTaxMny; // 本期签证索赔金额
    private BigDecimal otherMny; // 本期其他费用金额(无税)
    private BigDecimal otherTaxMny; // 本期其他费用金额(含税)
    private String replyStatusName; // 甲方批复状态名称
    private String replyMemo; // 甲方批复说明

    private List<QuoteProductionVO> productionList = new ArrayList<>(); // 对甲报量-产值报量
    private List<QuoteClaimVO> claimList = new ArrayList<>(); // 对甲报量-签证索赔
    private List<QuoteFeeVO> quoteFeeList = new ArrayList<>(); // 对甲报量-其他费用


    @ReferSerialTransfer(referCode="idm-org")
    public Long getFinancialOrgId() {
        return financialOrgId;
    }

    @ReferDeserialTransfer
    public void setFinancialOrgId(Long financialOrgId) {
        this.financialOrgId = financialOrgId;
    }

    public String getFinancialOrgName() {
        return financialOrgName;
    }

    public void setFinancialOrgName(String financialOrgName) {
        this.financialOrgName = financialOrgName;
    }

    public String getFinancialOrgCode() {
        return financialOrgCode;
    }

    public void setFinancialOrgCode(String financialOrgCode) {
        this.financialOrgCode = financialOrgCode;
    }

    public String getFinancialNumber() {
        return financialNumber;
    }

    public void setFinancialNumber(String financialNumber) {
        this.financialNumber = financialNumber;
    }

    public String getFinancialCrossFlag() {
        return financialCrossFlag;
    }

    public void setFinancialCrossFlag(String financialCrossFlag) {
        this.financialCrossFlag = financialCrossFlag;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getBadDebtProvisionTypeId() {
        return badDebtProvisionTypeId;
    }

    @ReferDeserialTransfer
    public void setBadDebtProvisionTypeId(Long badDebtProvisionTypeId) {
        this.badDebtProvisionTypeId = badDebtProvisionTypeId;
    }

    public String getBadDebtProvisionTypeName() {
        return badDebtProvisionTypeName;
    }

    public void setBadDebtProvisionTypeName(String badDebtProvisionTypeName) {
        this.badDebtProvisionTypeName = badDebtProvisionTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(无税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(无税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额(含税)
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额(含税)
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 报量时间
     */
    public java.util.Date getQuoteDate() {
        return quoteDate;
    }

    /**
     * 报量时间
     */
    public void setQuoteDate(java.util.Date quoteDate) {
        this.quoteDate = quoteDate;
    }
    /**
     * 本次上报金额(无税)
     */
    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    /**
     * 本次上报金额(无税)
     */
    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }
    /**
     * 本次上报金额
     */
    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    /**
     * 本次上报金额
     */
    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 部门id
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 部门id
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 批复时间
     */
    public java.util.Date getReplyDate() {
        return replyDate;
    }

    /**
     * 批复时间
     */
    public void setReplyDate(java.util.Date replyDate) {
        this.replyDate = replyDate;
    }
    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public Integer getReplyStatus() {
        return replyStatus;
    }

    /**
     * 甲方批复状态(0-未批复，1-已批复，2-未通过)
     */
    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }
    /**
     * 本次批复金额(无税)
     */
    public BigDecimal getReplyMny() {
        return replyMny;
    }

    /**
     * 本次批复金额(无税)
     */
    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    /**
     * 本次批复金额
     */
    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    /**
     * 本次批复金额
     */
    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 对甲报量子表
     */
    public List<QuoteDetailVO> getDetailList() {
        return detailList;
    }

    /**
     * 对甲报量子表
     */
    public void setDetailList(List<QuoteDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAppliedTaxMny() {
        return appliedTaxMny;
    }

    public void setAppliedTaxMny(BigDecimal appliedTaxMny) {
        this.appliedTaxMny = appliedTaxMny;
    }

    public BigDecimal getAppliedMny() {
        return appliedMny;
    }

    public void setAppliedMny(BigDecimal appliedMny) {
        this.appliedMny = appliedMny;
    }

    public BigDecimal getResidueTaxMny() {
        return residueTaxMny;
    }

    public void setResidueTaxMny(BigDecimal residueTaxMny) {
        this.residueTaxMny = residueTaxMny;
    }

    @ReferSerialTransfer(referCode="support-customer,support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getMeterType() {
        return meterType;
    }

    public void setMeterType(String meterType) {
        this.meterType = meterType;
    }

    public String getQuotePeriod() {
        return quotePeriod;
    }

    public void setQuotePeriod(String quotePeriod) {
        this.quotePeriod = quotePeriod;
    }

    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }

    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }

    public BigDecimal getLastFinishMny() {
        return lastFinishMny;
    }

    public void setLastFinishMny(BigDecimal lastFinishMny) {
        this.lastFinishMny = lastFinishMny;
    }

    public BigDecimal getLastFinishTaxMny() {
        return lastFinishTaxMny;
    }

    public void setLastFinishTaxMny(BigDecimal lastFinishTaxMny) {
        this.lastFinishTaxMny = lastFinishTaxMny;
    }

    public BigDecimal getSumFinishMny() {
        return sumFinishMny;
    }

    public void setSumFinishMny(BigDecimal sumFinishMny) {
        this.sumFinishMny = sumFinishMny;
    }

    public BigDecimal getSumFinishTaxMny() {
        return sumFinishTaxMny;
    }

    public void setSumFinishTaxMny(BigDecimal sumFinishTaxMny) {
        this.sumFinishTaxMny = sumFinishTaxMny;
    }

    public BigDecimal getLastQuoteMny() {
        return lastQuoteMny;
    }

    public void setLastQuoteMny(BigDecimal lastQuoteMny) {
        this.lastQuoteMny = lastQuoteMny;
    }

    public BigDecimal getLastQuoteTaxMny() {
        return lastQuoteTaxMny;
    }

    public void setLastQuoteTaxMny(BigDecimal lastQuoteTaxMny) {
        this.lastQuoteTaxMny = lastQuoteTaxMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }

    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }

    public BigDecimal getProductionMny() {
        return productionMny;
    }

    public void setProductionMny(BigDecimal productionMny) {
        this.productionMny = productionMny;
    }

    public BigDecimal getProductionTaxMny() {
        return productionTaxMny;
    }

    public void setProductionTaxMny(BigDecimal productionTaxMny) {
        this.productionTaxMny = productionTaxMny;
    }

    public BigDecimal getClaimMny() {
        return claimMny;
    }

    public void setClaimMny(BigDecimal claimMny) {
        this.claimMny = claimMny;
    }

    public BigDecimal getClaimTaxMny() {
        return claimTaxMny;
    }

    public void setClaimTaxMny(BigDecimal claimTaxMny) {
        this.claimTaxMny = claimTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public String getReplyStatusName() {
        return replyStatusName;
    }

    public void setReplyStatusName(String replyStatusName) {
        this.replyStatusName = replyStatusName;
    }

    public String getReplyMemo() {
        return replyMemo;
    }

    public void setReplyMemo(String replyMemo) {
        this.replyMemo = replyMemo;
    }

    public List<QuoteProductionVO> getProductionList() {
        return productionList;
    }

    public void setProductionList(List<QuoteProductionVO> productionList) {
        this.productionList = productionList;
    }

    public List<QuoteClaimVO> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<QuoteClaimVO> claimList) {
        this.claimList = claimList;
    }

    public List<QuoteFeeVO> getQuoteFeeList() {
        return quoteFeeList;
    }

    public void setQuoteFeeList(List<QuoteFeeVO> quoteFeeList) {
        this.quoteFeeList = quoteFeeList;
    }
}
