package com.ejianc.business.pro.income.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author nfy
 * @date 2025/4/23
 */
public class ImportContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同类型：主合同
     */
    public static final Integer CONTRACT_TYPE_MAIN_CONTRACT = 0;
    /**
     * 合同类型：补充协议
     */
    public static final Integer CONTRACT_TYPE_SUPPLEMENT = 1;

    @ConvertField(targetField = "contractCode")
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long reviewId; // 合同评审
    private String reviewName; // 合同评审名称
    @ConvertField
    private Long projectId; // 项目
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private String projectCode; // 项目编号
    @ConvertField
    private Long orgId; // 组织
    @ConvertField
    private String orgCode; // 组织编码
    @ConvertField
    private String orgName; // 组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    private Long bearType; // 承揽方式
    private String bearTypeName; // 承揽方式name
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField(targetField = "categoryId")
    private Long contractType; // 合同类型
    private String contractTypeName; // 合同类型名称
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @ConvertField(targetField = "partyaId")
    private Long customerId; // 合同甲方
    @ConvertField(targetField = "partyaName")
    private String customerName; // 合同甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 合同乙方
    @ConvertField(targetField = "partybName")
    private String supplierName; // 合同乙方名称
    @ConvertField(targetField = "joinPartyName")
    private String constructionPartner; // 施工联合方
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "contractTax")
    private BigDecimal taxMny; // 税额
    @ConvertField
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @ConvertField
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @ConvertField(targetField = "contractStartDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 合同开工日期
    @ConvertField(targetField = "contractFinishDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 合同竣工日期
    @ConvertField(targetField = "contractDaysLimit")
    private Integer schedule; // 工期
    private Long contractValuationType; // 合同计价形式，档案
    private String contractValuationTypeName; // 合同计价形式名称
    private String contractStatus; // 合同状态：1-履约中, 2-已封账，3-已解除
    @ConvertField(targetField = "partycName")
    private String contractPartyc; // 合同丙方
    private BigDecimal conjoinedContractTotalMny; // 联体合同总金额
    private BigDecimal costChangeTotalMny; // 工程造价及变动合计总金额(无税)
    private BigDecimal costChangeTotalTaxMny; // 工程造价及变动合计总金额
    @ConvertField
    private BigDecimal provisionalMny; // 暂列金额
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @ConvertField
    private Long employeeId; // 经办人
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField
    private Long deptId; // 经办部门
    @ConvertField
    private String deptName; // 经办部门名称
    private String memo; // 备注
    @ConvertField(targetField = "baseTaxMny")
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    @ConvertField(targetField = "baseMny")
    private BigDecimal baseMoney; // 初始版本金额
    @ConvertField(targetField = "baseTax")
    private BigDecimal baseTax; // 初始版本税额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private Integer changeVersion; // 变更版本

    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private String changeReason; // 变更原因
    @ConvertField
    private String mainContractName; // 主合同名称
    @ConvertField
    private Long mainContractId; // 主合同ID
    @ConvertField
    private String mainContractCode; // 主合同编码
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    private BigDecimal sumProductionMny; // 累计产值报量
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    private BigDecimal sumQuoteMny; // 累计甲方报量
    private BigDecimal sumCollectMny; // 累计收款
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private BigDecimal sumInvoicingMny; // 累计开票
    private BigDecimal sumNegotiateMny; // 变更洽商总金额(无税)
    private BigDecimal sumNegotiateTaxMny; // 变更洽商总金额
    private BigDecimal sumVisaMny; // 经济签证总金额(无税)
    private BigDecimal sumVisaTaxMny; // 经济签证总金额
    private BigDecimal sumClaimMny; // 索赔总金额(无税)
    private BigDecimal sumClaimTaxMny; // 索赔总金额
    private BigDecimal sumOperateMny; // 累计变更洽商金额(无税)
    private BigDecimal sumOperateTaxMny; // 累计变更洽商金额
    private BigDecimal sumMaterialSettleMny; // 累计甲供材结算金额(无税)
    private BigDecimal sumMaterialSettleTaxMny; // 累计甲供材结算金额
    @ConvertField
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    private Integer isRelieve; // 是否已解除：0-否，1-是
    private String supplierPhone; // 乙方电话
    private String customerPhone; // 甲方电话
    private String customerEntrustedAgent; // 甲方委托代理人
    private String supplierEntrustedAgent; // 乙方委托代理人
    private Long disputeResolution; // 争议解决方式
    private String disputeResolutionAgency; // 争议解决机构

    private Integer reviewVersion; // 施工合同评审版本号
    private String contractStatusName; // 合同状态名称
    private String billStateName; // 单据状态名称
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private String supplementContent; // 协议内容
    private Long contractualModel; // 承包模式
    private String contractualModelName; // 承包模式名称
    private Integer isSuspend; // 是否中止：0-否，1-是
    private Long constructId;//建设单位
    private String constructName;//建设单位
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;
    @ConvertField
    private BigDecimal notIncludeProvisionalMny; // 施工合同金额(不含暂列金额)

    @ConvertField
    private Integer isEstimation; // 是否暂估合同：0-否，1-是
    @ConvertField
    private BigDecimal totalCostAdjustTaxMny; // 工程造价调整金额合计
    @ConvertField
    private BigDecimal totalCostAdjustMny; // 工程造价调整金额合计(无税)
    @ConvertField
    private BigDecimal totalCostAdjustTax; // 工程造价调整税额
    private BigDecimal totalAfterCostAdjustTaxMny; // 工程造价调整后总金额
    private BigDecimal totalAfterCostAdjustMny; // 工程造价调整后总金额(无税)
    private BigDecimal totalAfterCostAdjustTax; // 工程造价调整后税额
    private BigDecimal nicContractMny; // 工程造价调整后总金额(不含暂列金额)

    private String progressPaymentClause; // 工程进度款支付条款

    private BigDecimal overReducedMny; // 超报审减费(无税)
    private BigDecimal overReducedTaxMny; // 超报审减费
    private String meterType; // 计量方式：1-按月计量，2-按节点计量
    private String errorMessage;

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getContractValuationTypeName() {
        return contractValuationTypeName;
    }

    public void setContractValuationTypeName(String contractValuationTypeName) {
        this.contractValuationTypeName = contractValuationTypeName;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getReviewId() {
        return reviewId;
    }

    public void setReviewId(Long reviewId) {
        this.reviewId = reviewId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getBearType() {
        return bearType;
    }

    public void setBearType(Long bearType) {
        this.bearType = bearType;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getConstructionPartner() {
        return constructionPartner;
    }

    public void setConstructionPartner(String constructionPartner) {
        this.constructionPartner = constructionPartner;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getSchedule() {
        return schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getContractPartyc() {
        return contractPartyc;
    }

    public void setContractPartyc(String contractPartyc) {
        this.contractPartyc = contractPartyc;
    }

    public BigDecimal getConjoinedContractTotalMny() {
        return conjoinedContractTotalMny;
    }

    public void setConjoinedContractTotalMny(BigDecimal conjoinedContractTotalMny) {
        this.conjoinedContractTotalMny = conjoinedContractTotalMny;
    }

    public BigDecimal getCostChangeTotalMny() {
        return costChangeTotalMny;
    }

    public void setCostChangeTotalMny(BigDecimal costChangeTotalMny) {
        this.costChangeTotalMny = costChangeTotalMny;
    }

    public BigDecimal getCostChangeTotalTaxMny() {
        return costChangeTotalTaxMny;
    }

    public void setCostChangeTotalTaxMny(BigDecimal costChangeTotalTaxMny) {
        this.costChangeTotalTaxMny = costChangeTotalTaxMny;
    }

    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }

    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseTax() {
        return baseTax;
    }

    public void setBaseTax(BigDecimal baseTax) {
        this.baseTax = baseTax;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public BigDecimal getSumNegotiateMny() {
        return sumNegotiateMny;
    }

    public void setSumNegotiateMny(BigDecimal sumNegotiateMny) {
        this.sumNegotiateMny = sumNegotiateMny;
    }

    public BigDecimal getSumNegotiateTaxMny() {
        return sumNegotiateTaxMny;
    }

    public void setSumNegotiateTaxMny(BigDecimal sumNegotiateTaxMny) {
        this.sumNegotiateTaxMny = sumNegotiateTaxMny;
    }

    public BigDecimal getSumVisaMny() {
        return sumVisaMny;
    }

    public void setSumVisaMny(BigDecimal sumVisaMny) {
        this.sumVisaMny = sumVisaMny;
    }

    public BigDecimal getSumVisaTaxMny() {
        return sumVisaTaxMny;
    }

    public void setSumVisaTaxMny(BigDecimal sumVisaTaxMny) {
        this.sumVisaTaxMny = sumVisaTaxMny;
    }

    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    public BigDecimal getSumOperateMny() {
        return sumOperateMny;
    }

    public void setSumOperateMny(BigDecimal sumOperateMny) {
        this.sumOperateMny = sumOperateMny;
    }

    public BigDecimal getSumOperateTaxMny() {
        return sumOperateTaxMny;
    }

    public void setSumOperateTaxMny(BigDecimal sumOperateTaxMny) {
        this.sumOperateTaxMny = sumOperateTaxMny;
    }

    public BigDecimal getSumMaterialSettleMny() {
        return sumMaterialSettleMny;
    }

    public void setSumMaterialSettleMny(BigDecimal sumMaterialSettleMny) {
        this.sumMaterialSettleMny = sumMaterialSettleMny;
    }

    public BigDecimal getSumMaterialSettleTaxMny() {
        return sumMaterialSettleTaxMny;
    }

    public void setSumMaterialSettleTaxMny(BigDecimal sumMaterialSettleTaxMny) {
        this.sumMaterialSettleTaxMny = sumMaterialSettleTaxMny;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getCustomerPhone() {
        return customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getCustomerEntrustedAgent() {
        return customerEntrustedAgent;
    }

    public void setCustomerEntrustedAgent(String customerEntrustedAgent) {
        this.customerEntrustedAgent = customerEntrustedAgent;
    }

    public String getSupplierEntrustedAgent() {
        return supplierEntrustedAgent;
    }

    public void setSupplierEntrustedAgent(String supplierEntrustedAgent) {
        this.supplierEntrustedAgent = supplierEntrustedAgent;
    }

    public Long getDisputeResolution() {
        return disputeResolution;
    }

    public void setDisputeResolution(Long disputeResolution) {
        this.disputeResolution = disputeResolution;
    }

    public String getDisputeResolutionAgency() {
        return disputeResolutionAgency;
    }

    public void setDisputeResolutionAgency(String disputeResolutionAgency) {
        this.disputeResolutionAgency = disputeResolutionAgency;
    }

    public Integer getReviewVersion() {
        return reviewVersion;
    }

    public void setReviewVersion(Integer reviewVersion) {
        this.reviewVersion = reviewVersion;
    }

    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public String getSupplementContent() {
        return supplementContent;
    }

    public void setSupplementContent(String supplementContent) {
        this.supplementContent = supplementContent;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Integer getIsSuspend() {
        return isSuspend;
    }

    public void setIsSuspend(Integer isSuspend) {
        this.isSuspend = isSuspend;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public BigDecimal getNotIncludeProvisionalMny() {
        return notIncludeProvisionalMny;
    }

    public void setNotIncludeProvisionalMny(BigDecimal notIncludeProvisionalMny) {
        this.notIncludeProvisionalMny = notIncludeProvisionalMny;
    }

    public Integer getIsEstimation() {
        return isEstimation;
    }

    public void setIsEstimation(Integer isEstimation) {
        this.isEstimation = isEstimation;
    }

    public BigDecimal getTotalCostAdjustTaxMny() {
        return totalCostAdjustTaxMny;
    }

    public void setTotalCostAdjustTaxMny(BigDecimal totalCostAdjustTaxMny) {
        this.totalCostAdjustTaxMny = totalCostAdjustTaxMny;
    }

    public BigDecimal getTotalCostAdjustMny() {
        return totalCostAdjustMny;
    }

    public void setTotalCostAdjustMny(BigDecimal totalCostAdjustMny) {
        this.totalCostAdjustMny = totalCostAdjustMny;
    }

    public BigDecimal getTotalCostAdjustTax() {
        return totalCostAdjustTax;
    }

    public void setTotalCostAdjustTax(BigDecimal totalCostAdjustTax) {
        this.totalCostAdjustTax = totalCostAdjustTax;
    }

    public BigDecimal getTotalAfterCostAdjustTaxMny() {
        return totalAfterCostAdjustTaxMny;
    }

    public void setTotalAfterCostAdjustTaxMny(BigDecimal totalAfterCostAdjustTaxMny) {
        this.totalAfterCostAdjustTaxMny = totalAfterCostAdjustTaxMny;
    }

    public BigDecimal getTotalAfterCostAdjustMny() {
        return totalAfterCostAdjustMny;
    }

    public void setTotalAfterCostAdjustMny(BigDecimal totalAfterCostAdjustMny) {
        this.totalAfterCostAdjustMny = totalAfterCostAdjustMny;
    }

    public BigDecimal getTotalAfterCostAdjustTax() {
        return totalAfterCostAdjustTax;
    }

    public void setTotalAfterCostAdjustTax(BigDecimal totalAfterCostAdjustTax) {
        this.totalAfterCostAdjustTax = totalAfterCostAdjustTax;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public String getProgressPaymentClause() {
        return progressPaymentClause;
    }

    public void setProgressPaymentClause(String progressPaymentClause) {
        this.progressPaymentClause = progressPaymentClause;
    }

    public BigDecimal getOverReducedMny() {
        return overReducedMny;
    }

    public void setOverReducedMny(BigDecimal overReducedMny) {
        this.overReducedMny = overReducedMny;
    }

    public BigDecimal getOverReducedTaxMny() {
        return overReducedTaxMny;
    }

    public void setOverReducedTaxMny(BigDecimal overReducedTaxMny) {
        this.overReducedTaxMny = overReducedTaxMny;
    }

    public String getMeterType() {
        return meterType;
    }

    public void setMeterType(String meterType) {
        this.meterType = meterType;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getReviewName() {
        return reviewName;
    }

    public void setReviewName(String reviewName) {
        this.reviewName = reviewName;
    }

    public String getBearTypeName() {
        return bearTypeName;
    }

    public void setBearTypeName(String bearTypeName) {
        this.bearTypeName = bearTypeName;
    }
}
