package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 费税清单
 * 
 * @author generator
 * 
 */
public class BudgetFeeVO extends BaseVO implements ITreeNodeB,ITaxCalculate {
    private static final long serialVersionUID = 1L;
    
    private Long budgetId; // 预算书主键
    private String detailIndex; // 序号
    private Long parentId; // 父ID
    private String feeCode; // 编码
    private String feeName; // 名称
    private String feeFeature; // 特征
    private BigDecimal feeTaxRate; // 税率
    private BigDecimal feeMny; // 合价(无税)
    private BigDecimal feeTaxMny; // 合价(含税)
    private BigDecimal feeTax; // 税额
    private String feeMemo; // 备注
    private Boolean leafFlag; // 是否末级
    private List<BudgetDetailVO> detailVos = new ArrayList<>(); // 清单明细

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;
    private Long feeSubjectId; // 成本科目id
    private String feeSubjectName; // 成本科目名称

    private String feeCompositiveCoefficientName; //综合系数名称
    private Long feeCompositiveCoefficientId; //综合系数id
    private BigDecimal feeCompositiveCoefficient; //综合系数

    private String feeItemType; //清单类型  用于导入数据区分

    private Integer feePriceType; //价税计算类型：0-无税优先， 1-含税优先

    public Integer getFeePriceType() {
        return feePriceType;
    }

    public void setFeePriceType(Integer feePriceType) {
        this.feePriceType = feePriceType;
    }

    public String getFeeItemType() {
        return feeItemType;
    }

    public void setFeeItemType(String feeItemType) {
        this.feeItemType = feeItemType;
    }

    private List<ITreeNodeB> children;

    public String getFeeCompositiveCoefficientName() {
        return feeCompositiveCoefficientName;
    }

    public void setFeeCompositiveCoefficientName(String feeCompositiveCoefficientName) {
        this.feeCompositiveCoefficientName = feeCompositiveCoefficientName;
    }

    @ReferSerialTransfer(referCode = "pro-income-coefficient")
    public Long getFeeCompositiveCoefficientId() {
        return feeCompositiveCoefficientId;
    }

    @ReferDeserialTransfer
    public void setFeeCompositiveCoefficientId(Long feeCompositiveCoefficientId) {
        this.feeCompositiveCoefficientId = feeCompositiveCoefficientId;
    }

    public BigDecimal getFeeCompositiveCoefficient() {
        return feeCompositiveCoefficient;
    }

    public void setFeeCompositiveCoefficient(BigDecimal feeCompositiveCoefficient) {
        this.feeCompositiveCoefficient = feeCompositiveCoefficient;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    @ReferSerialTransfer(referCode="subject-project-org-ref")
    public Long getFeeSubjectId() {
        return feeSubjectId;
    }
    @ReferDeserialTransfer
    public void setFeeSubjectId(Long feeSubjectId) {
        this.feeSubjectId = feeSubjectId;
    }

    public String getFeeSubjectName() {
        return feeSubjectName;
    }

    public void setFeeSubjectName(String feeSubjectName) {
        this.feeSubjectName = feeSubjectName;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public List<BudgetDetailVO> getDetailVos() {
        return detailVos;
    }

    public void setDetailVos(List<BudgetDetailVO> detailVos) {
        this.detailVos = detailVos;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
    /**
     * 预算书主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算书主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getFeeCode() {
        return feeCode;
    }

    /**
     * 编码
     */
    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }
    /**
     * 名称
     */
    public String getFeeName() {
        return feeName;
    }

    /**
     * 名称
     */
    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    /**
     * 特征
     */
    public String getFeeFeature() {
        return feeFeature;
    }

    /**
     * 特征
     */
    public void setFeeFeature(String feeFeature) {
        this.feeFeature = feeFeature;
    }
    /**
     * 税率
     */
    public BigDecimal getFeeTaxRate() {
        return feeTaxRate;
    }

    /**
     * 税率
     */
    public void setFeeTaxRate(BigDecimal feeTaxRate) {
        this.feeTaxRate = feeTaxRate;
    }
    /**
     * 合价(无税)
     */
    public BigDecimal getFeeMny() {
        return feeMny;
    }

    /**
     * 合价(无税)
     */
    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }
    /**
     * 合价(含税)
     */
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    /**
     * 合价(含税)
     */
    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    /**
     * 备注
     */
    public String getFeeMemo() {
        return feeMemo;
    }

    /**
     * 备注
     */
    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{null};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{null};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{null};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"feeMny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"feeTaxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"feeTaxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"feeTax"};
    }

    @Override
    public String[] getCalculateType() {
        return new String[]{"ONLYMONEY"};
    }
}
