package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 甲供材对账单 
 * 
 * @author generator
 * 
 */
public class AccountVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long projectId; // 项目
    private String projectCode; // 项目编号
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编号
    private String orgName; // 组织名称
    private BigDecimal sumMaterialSettleMny; // 累计甲供材结算金额
    private BigDecimal materialSettleMny; // 本次甲供材结算金额
    private BigDecimal materialDeductMny; // 本次甲供材已扣金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reportedDate; // 对账日期
    private Integer billState; // 单据状态（审批必须字段）
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private Long parentOrgId; // 父级组织
    private String  parentOrgCode; // 父级组织编号
    private String parentOrgName; // 父级组织名称
    private String billStateName; // 单据状态名称（审批必须字段）
    private Integer contractVersion; //施工合同版本
    private BigDecimal appliedTaxMny; //已申请金额(不含本次)
    private BigDecimal appliedMny; //已申请金额(不含本次)(无税)
    private BigDecimal residueTaxMny;//剩余可申请金额

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同ID
     */
    @ReferSerialTransfer(referCode = "pro-income-contract")
    public Long getContractId() {
        return contractId;
    }
    /**
     * 合同ID
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 累计甲供材结算金额
     */
    public BigDecimal getSumMaterialSettleMny() {
        return sumMaterialSettleMny;
    }

    /**
     * 累计甲供材结算金额
     */
    public void setSumMaterialSettleMny(BigDecimal sumMaterialSettleMny) {
        this.sumMaterialSettleMny = sumMaterialSettleMny;
    }
    /**
     * 本次甲供材结算金额
     */
    public BigDecimal getMaterialSettleMny() {
        return materialSettleMny;
    }

    /**
     * 本次甲供材结算金额
     */
    public void setMaterialSettleMny(BigDecimal materialSettleMny) {
        this.materialSettleMny = materialSettleMny;
    }
    /**
     * 本次甲供材已扣金额
     */
    public BigDecimal getMaterialDeductMny() {
        return materialDeductMny;
    }

    /**
     * 本次甲供材已扣金额
     */
    public void setMaterialDeductMny(BigDecimal materialDeductMny) {
        this.materialDeductMny = materialDeductMny;
    }
    /**
     * 上报日期
     */
    public java.util.Date getReportedDate() {
        return reportedDate;
    }

    /**
     * 上报日期
     */
    public void setReportedDate(java.util.Date reportedDate) {
        this.reportedDate = reportedDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 父级组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public BigDecimal getAppliedTaxMny() {
        return appliedTaxMny;
    }

    public void setAppliedTaxMny(BigDecimal appliedTaxMny) {
        this.appliedTaxMny = appliedTaxMny;
    }

    public BigDecimal getAppliedMny() {
        return appliedMny;
    }

    public void setAppliedMny(BigDecimal appliedMny) {
        this.appliedMny = appliedMny;
    }

    public BigDecimal getResidueTaxMny() {
        return residueTaxMny;
    }

    public void setResidueTaxMny(BigDecimal residueTaxMny) {
        this.residueTaxMny = residueTaxMny;
    }
}
