package com.ejianc.business.pro.income.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class ValidateUtil {

    private final static Logger logger = LoggerFactory.getLogger(ValidateUtil.class);

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private ICommenQueryFieldsService queryFieldsService;

    private final static String REQUEST_ID = "saveOrUpdate";

    /**
     * 保存时校验version是否一致
     * @param billId
     * @param billTypeCode
     * @param version
     * @return
     */
    public Boolean validateUpStreamVersion(String billId, String billTypeCode, Integer version) {
        Boolean flag = true;
        if(version != null && version != 0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, billId, REQUEST_ID, 1000);
                logger.info("判断单据单据锁结果------" + locked);
                if(locked){
                    JSONObject json = queryFieldsService.queryBillDetail(billId, billTypeCode);
                    logger.info("===="+json.toJSONString());
                    Object obj = json.getJSONObject("data").get("version");
                    String str = obj != null ? obj.toString() : "0";
                    str = str.indexOf(".") > 0 ? str.substring(0, str.indexOf(".")) : str;
                    Integer dataVersion = Integer.parseInt(str);
                    if(version.intValue() != dataVersion.intValue()){
                        flag = false;
                    }
                }
            }catch (Exception e) {
                logger.error(e.getMessage());
                throw new BusinessException("网络异常，请刷新重试！");
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, billId, REQUEST_ID);
                }
                jedis.close();
            }
        }
        return flag;
    }
}
