package com.ejianc.business.pro.recipetApply.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 收款申请单
 * 
 * @author generator
 * 
 */
public class RecipetApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long createUserId; // 创建者账号
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long contractCategoryId; // 合同类别id
    private String contractCategoryCode; // 合同类别编码
    private String contractCategoryName; // 合同类别名称
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long customerId; // 甲方id
    private String customerName; // 甲方名称
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办（申请人）部门id
    private String departmentName; // 经办（申请人）部门名称
    private String memo; // 收款内容  非必填，0-500字
    private Long clausePropertyId; // 款项属性id
    private String clausePropertyName; // 款项属性名称
    private String sourceCategoryType; // 合同大类id
    private String sourceCategoryTypeName; // 合同大类名称
    private Integer sourceFlag; // 来源标识
    private String receiptApplyId; // 收款申请单号id
    private String receiptApplyName; // 收款申请单号名称
    private BigDecimal actualReceivedMny; // 实际收款金额
    private BigDecimal totalApplyTaxMny; // 本期申请金额合计
    private BigDecimal totalApplyMny; // 本期申请金额合计(无税)
    private BigDecimal totalQuoteTaxMny; // 本期工程进度款
    private BigDecimal totalQuoteMny; // 本期工程进度款(无税)
    private BigDecimal totalAwardPunishTaxMny; // 本期甲方奖罚款
    private BigDecimal totalAwardPunishMny; // 本期甲方奖罚款(无税)
    private BigDecimal totalAccountTaxMny; // 本期材料扣款
    private BigDecimal totalAccountMny; // 本期材料扣款(无税)
    private BigDecimal totalOtherTaxMny; // 本期其他费用
    private BigDecimal totalOtherMny; // 本期其他费用(无税)
    private BigDecimal uncollectedMny;//未收款金额
    private String billStateName;
    
    private List<RecipetApplyQuoteVO> recipetApplyQuoteList = new ArrayList<>(); // 工程进度款
    private List<RecipetApplyAccountVO> recipetApplyAccountList = new ArrayList<>(); // 材料扣款
    private List<RecipetApplyAwardPunishVO> recipetApplyAwardPunishList = new ArrayList<>(); // 甲方奖罚款
    private List<RecipetApplyOtherVO> recipetApplyOtherList = new ArrayList<>(); // 其他费用

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "contractPool")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getClausePropertyId() {
        return clausePropertyId;
    }
    @ReferDeserialTransfer
    public void setClausePropertyId(Long clausePropertyId) {
        this.clausePropertyId = clausePropertyId;
    }
    public String getClausePropertyName() {
        return clausePropertyName;
    }

    public void setClausePropertyName(String clausePropertyName) {
        this.clausePropertyName = clausePropertyName;
    }
    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }
    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }
    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public String getReceiptApplyId() {
        return receiptApplyId;
    }

    public void setReceiptApplyId(String receiptApplyId) {
        this.receiptApplyId = receiptApplyId;
    }
    public String getReceiptApplyName() {
        return receiptApplyName;
    }

    public void setReceiptApplyName(String receiptApplyName) {
        this.receiptApplyName = receiptApplyName;
    }
    public BigDecimal getActualReceivedMny() {
        return actualReceivedMny;
    }

    public void setActualReceivedMny(BigDecimal actualReceivedMny) {
        this.actualReceivedMny = actualReceivedMny;
    }
    public BigDecimal getTotalApplyTaxMny() {
        return totalApplyTaxMny;
    }

    public void setTotalApplyTaxMny(BigDecimal totalApplyTaxMny) {
        this.totalApplyTaxMny = totalApplyTaxMny;
    }
    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }
    public BigDecimal getTotalQuoteTaxMny() {
        return totalQuoteTaxMny;
    }

    public void setTotalQuoteTaxMny(BigDecimal totalQuoteTaxMny) {
        this.totalQuoteTaxMny = totalQuoteTaxMny;
    }
    public BigDecimal getTotalQuoteMny() {
        return totalQuoteMny;
    }

    public void setTotalQuoteMny(BigDecimal totalQuoteMny) {
        this.totalQuoteMny = totalQuoteMny;
    }
    public BigDecimal getTotalAwardPunishTaxMny() {
        return totalAwardPunishTaxMny;
    }

    public void setTotalAwardPunishTaxMny(BigDecimal totalAwardPunishTaxMny) {
        this.totalAwardPunishTaxMny = totalAwardPunishTaxMny;
    }
    public BigDecimal getTotalAwardPunishMny() {
        return totalAwardPunishMny;
    }

    public void setTotalAwardPunishMny(BigDecimal totalAwardPunishMny) {
        this.totalAwardPunishMny = totalAwardPunishMny;
    }
    public BigDecimal getTotalAccountTaxMny() {
        return totalAccountTaxMny;
    }

    public void setTotalAccountTaxMny(BigDecimal totalAccountTaxMny) {
        this.totalAccountTaxMny = totalAccountTaxMny;
    }
    public BigDecimal getTotalAccountMny() {
        return totalAccountMny;
    }

    public void setTotalAccountMny(BigDecimal totalAccountMny) {
        this.totalAccountMny = totalAccountMny;
    }
    public BigDecimal getTotalOtherTaxMny() {
        return totalOtherTaxMny;
    }

    public void setTotalOtherTaxMny(BigDecimal totalOtherTaxMny) {
        this.totalOtherTaxMny = totalOtherTaxMny;
    }
    public BigDecimal getTotalOtherMny() {
        return totalOtherMny;
    }

    public void setTotalOtherMny(BigDecimal totalOtherMny) {
        this.totalOtherMny = totalOtherMny;
    }
    
     public List<RecipetApplyQuoteVO> getRecipetApplyQuoteList() {
        return recipetApplyQuoteList;
     }

     public void setRecipetApplyQuoteList(List<RecipetApplyQuoteVO> recipetApplyQuoteList) {
        this.recipetApplyQuoteList = recipetApplyQuoteList;
     }
     public List<RecipetApplyAccountVO> getRecipetApplyAccountList() {
        return recipetApplyAccountList;
     }

     public void setRecipetApplyAccountList(List<RecipetApplyAccountVO> recipetApplyAccountList) {
        this.recipetApplyAccountList = recipetApplyAccountList;
     }
     public List<RecipetApplyAwardPunishVO> getRecipetApplyAwardPunishList() {
        return recipetApplyAwardPunishList;
     }

     public void setRecipetApplyAwardPunishList(List<RecipetApplyAwardPunishVO> recipetApplyAwardPunishList) {
        this.recipetApplyAwardPunishList = recipetApplyAwardPunishList;
     }
     public List<RecipetApplyOtherVO> getRecipetApplyOtherList() {
        return recipetApplyOtherList;
     }

     public void setRecipetApplyOtherList(List<RecipetApplyOtherVO> recipetApplyOtherList) {
        this.recipetApplyOtherList = recipetApplyOtherList;
     }

    public BigDecimal getUncollectedMny() {
        return uncollectedMny;
    }

    public void setUncollectedMny(BigDecimal uncollectedMny) {
        this.uncollectedMny = uncollectedMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
