package com.ejianc.business.pro.income.vo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 收入材料汇总明细表
 *
 * @author CJ
 * @Description:
 * @date 2023/2/23 10:28
 */
public class RevenueMaterialsVO implements Serializable {

    private static final long serialVersionUID = 4372524159582181163L;

    /**
     * 明细编码
     */
    private String itemCode;
    /**
     * 明细名称
     */
    private String itemName;
    /**
     * 明细规格类型
     */
    private String itemSpec;
    /**
     * 明细单位
     */
    private String itemUnit;
    /**
     * 明细工程量
     */
    private BigDecimal itemNum;
    /**
     * 合价（无税）
     */
    private BigDecimal itemMny;
    /**
     * 明细合价
     */
    private BigDecimal itemTaxMny;
    /**
     * 明细含量
     */
    private BigDecimal itemContent;
    /**
     * 明细单价（无税）
     */
    private BigDecimal itemPrice;
    /**
     * 明细单价
     */
    private BigDecimal itemTaxPrice;
    /**
     * 明细产值金额（不含税）
     */
    private BigDecimal totalPMny;
    /**
     * 明细产值金额
     */
    private BigDecimal totalPTaxMny;
    /**
     * 明细产值
     */
    private BigDecimal totalPNum;

    /**
     * 预算金额（无税）占比：清单预算金额（无税）占预算总金额（无税）比例
     */
    private BigDecimal itemMnyRatio;

    /**
     * 预算金额占比：清单预算金额占预算总金额比例
     */
    private BigDecimal itemTaxMnyRatio;

    /**
     * 清单产值（无税）占比：清单产值（无税）金额占总产值（无税）金额比例
     */
    private BigDecimal totalPMnyRatio;

    /**
     * 清单产值占比：清单产值金额占总产值金额比例
     */
    private BigDecimal totalPTaxMnyRatio;

    public BigDecimal getItemMnyRatio() {
        return itemMnyRatio;
    }

    public void setItemMnyRatio(BigDecimal itemMnyRatio) {
        this.itemMnyRatio = itemMnyRatio;
    }

    public BigDecimal getItemTaxMnyRatio() {
        return itemTaxMnyRatio;
    }

    public void setItemTaxMnyRatio(BigDecimal itemTaxMnyRatio) {
        this.itemTaxMnyRatio = itemTaxMnyRatio;
    }

    public BigDecimal getTotalPMnyRatio() {
        return totalPMnyRatio;
    }

    public void setTotalPMnyRatio(BigDecimal totalPMnyRatio) {
        this.totalPMnyRatio = totalPMnyRatio;
    }

    public BigDecimal getTotalPTaxMnyRatio() {
        return totalPTaxMnyRatio;
    }

    public void setTotalPTaxMnyRatio(BigDecimal totalPTaxMnyRatio) {
        this.totalPTaxMnyRatio = totalPTaxMnyRatio;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    public String getItemUnit() {
        return itemUnit;
    }

    public void setItemUnit(String itemUnit) {
        this.itemUnit = itemUnit;
    }

    public BigDecimal getItemNum() {
        return itemNum;
    }

    public void setItemNum(BigDecimal itemNum) {
        this.itemNum = itemNum;
    }

    public BigDecimal getItemMny() {
        return itemMny;
    }

    public void setItemMny(BigDecimal itemMny) {
        this.itemMny = itemMny;
    }

    public BigDecimal getItemTaxMny() {
        return itemTaxMny;
    }

    public void setItemTaxMny(BigDecimal itemTaxMny) {
        this.itemTaxMny = itemTaxMny;
    }

    public BigDecimal getItemContent() {
        return itemContent;
    }

    public void setItemContent(BigDecimal itemContent) {
        this.itemContent = itemContent;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public BigDecimal getItemTaxPrice() {
        return itemTaxPrice;
    }

    public void setItemTaxPrice(BigDecimal itemTaxPrice) {
        this.itemTaxPrice = itemTaxPrice;
    }

    public BigDecimal getTotalPMny() {
        return totalPMny;
    }

    public void setTotalPMny(BigDecimal totalPMny) {
        this.totalPMny = totalPMny;
    }

    public BigDecimal getTotalPTaxMny() {
        return totalPTaxMny;
    }

    public void setTotalPTaxMny(BigDecimal totalPTaxMny) {
        this.totalPTaxMny = totalPTaxMny;
    }

    public BigDecimal getTotalPNum() {
        return totalPNum;
    }

    public void setTotalPNum(BigDecimal totalPNum) {
        this.totalPNum = totalPNum;
    }
}
