package com.ejianc.business.pro.g9.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 结算报审跟踪-G9
 * 
 * @author generator
 * 
 */
public class SettleReportFollowG9VO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 
    private String checkUnit; // 审核单位
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long contractId; // 合同
    private String contractName; // 合同名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date followDate; // 跟踪日期
    private String followRemark; // 跟踪进展描述
    private Long followPerson; // 跟踪人
    private String followPersonName; // 跟踪人名称
    private Long projectLeaderId; // 项目负责人
    private String projectLeaderName; // 项目负责人
    private Long businessManager; // 经营对接人
    private String businessManagerName; // 经营对接人
    private Long settleId;//报审id
    private String sourceType;
    private String reportProgress;

    private List<SettleReportFollowZiG9VO> settleReportFollowZiG9List = new ArrayList<>(); // 结算报审跟踪子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "ejc-share-zzyj-project-ex001")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "nbzz-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Date getFollowDate() {
        return followDate;
    }

    public void setFollowDate(Date followDate) {
        this.followDate = followDate;
    }
    public String getFollowRemark() {
        return followRemark;
    }

    public void setFollowRemark(String followRemark) {
        this.followRemark = followRemark;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getFollowPerson() {
        return followPerson;
    }
    @ReferDeserialTransfer
    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }
    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProjectLeaderId() {
        return projectLeaderId;
    }
    @ReferDeserialTransfer
    public void setProjectLeaderId(Long projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }
    public String getProjectLeaderName() {
        return projectLeaderName;
    }

    public void setProjectLeaderName(String projectLeaderName) {
        this.projectLeaderName = projectLeaderName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getBusinessManager() {
        return businessManager;
    }
    @ReferDeserialTransfer
    public void setBusinessManager(Long businessManager) {
        this.businessManager = businessManager;
    }
    public String getBusinessManagerName() {
        return businessManagerName;
    }

    public void setBusinessManagerName(String businessManagerName) {
        this.businessManagerName = businessManagerName;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public List<SettleReportFollowZiG9VO> getSettleReportFollowZiG9List() {
        return settleReportFollowZiG9List;
    }

    public void setSettleReportFollowZiG9List(List<SettleReportFollowZiG9VO> settleReportFollowZiG9List) {
        this.settleReportFollowZiG9List = settleReportFollowZiG9List;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getReportProgress() {
        return reportProgress;
    }

    public void setReportProgress(String reportProgress) {
        this.reportProgress = reportProgress;
    }
}
