package com.ejianc.business.pro.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 施工合同归档登记表
 * 
 * @author generator
 * 
 */
public class FilingVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filingDate; // 归档日期
    private String contractName; // 
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private Long supplierId; // 供应商Id（乙方id）
    private String supplierName; // 
    private Long projectId; // 项目Id
    private String projectName; // 
    private String projectCode; // 项目编号
    private String filingExplain; // 归档说明
    private String employeeName; // 经办人 名称
    private Long employeeId; // 经办人
    private String employeeCode; // 经办人 编码
    private String departmentName; // 经办部门 名称
    private Long departmentId; // 经办部门
    private String departmentCode; // 经办部门 编码
    private Long firstPartyId; // 甲方Id
    private String firstPartyName; // 
    private Long orgId; // 项目部ID
    private String orgName; // 
    private String orgCode; // 项目部编码
    private String parentOrgCode; // 项目部上级编码
    private String parentOrgName; // 
    private Long parentOrgId; // 项目部上级id
    private String memo; // 备注
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 编码
    private Long sourceId; // 来源 id
    private Date effectiveDate; // 生效日期
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private String updateBillType; // 单据类型
    private Long filingTypeId; // 归档类型 id
    private String filingTypeName; // 归档类型 参照名称
    private String filingTypeCode; // 归档类型编码
    private String filingTypeInnerCode; // 归档类型内码
    private Long fileId; // 文件Id
    private String fileName; // 文件名称

    private Integer cancelFlag; // 作废状态（0：未作废，1：已作废）


    public Integer getCancelFlag() {
        return cancelFlag;
    }

    public void setCancelFlag(Integer cancelFlag) {
        this.cancelFlag = cancelFlag;
    }
    //proincome-contract-review

    public Date getFilingDate() {
        return filingDate;
    }

    public void setFilingDate(Date filingDate) {
        this.filingDate = filingDate;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="proincome-contract-review")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getFilingExplain() {
        return filingExplain;
    }

    public void setFilingExplain(String filingExplain) {
        this.filingExplain = filingExplain;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getUpdateBillType() {
        return updateBillType;
    }

    public void setUpdateBillType(String updateBillType) {
        this.updateBillType = updateBillType;
    }
    public Long getFilingTypeId() {
        return filingTypeId;
    }

    public void setFilingTypeId(Long filingTypeId) {
        this.filingTypeId = filingTypeId;
    }
    public String getFilingTypeName() {
        return filingTypeName;
    }

    public void setFilingTypeName(String filingTypeName) {
        this.filingTypeName = filingTypeName;
    }
    public String getFilingTypeCode() {
        return filingTypeCode;
    }

    public void setFilingTypeCode(String filingTypeCode) {
        this.filingTypeCode = filingTypeCode;
    }
    public String getFilingTypeInnerCode() {
        return filingTypeInnerCode;
    }

    public void setFilingTypeInnerCode(String filingTypeInnerCode) {
        this.filingTypeInnerCode = filingTypeInnerCode;
    }
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    
}
