package com.ejianc.business.pro.income.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RegisterSupplementHistoryVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 补充协议合同总金额(含税)
     */
    private BigDecimal supplementToalTaxMny;

    /**
     * 补充协议合同总金额(无税)
     */
    private BigDecimal supplementToalMny;
    
    /**
     * 原合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 原合同金额(无税)
     */
    private BigDecimal contractMny;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private String changeStatus;

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    private Integer isFinish;

    /**
     * 是否已解除：0-否，1-是
     */
    private Integer isRelieve;
    
    private List<ContractRegisterVO> detailList = new ArrayList<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getSupplementToalTaxMny() {
        return supplementToalTaxMny;
    }

    public void setSupplementToalTaxMny(BigDecimal supplementToalTaxMny) {
        this.supplementToalTaxMny = supplementToalTaxMny;
    }

    public BigDecimal getSupplementToalMny() {
        return supplementToalMny;
    }

    public void setSupplementToalMny(BigDecimal supplementToalMny) {
        this.supplementToalMny = supplementToalMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsRelieve() {
        return isRelieve;
    }

    public void setIsRelieve(Integer isRelieve) {
        this.isRelieve = isRelieve;
    }

    public List<ContractRegisterVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractRegisterVO> detailList) {
        this.detailList = detailList;
    }
}
