package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.cons.DetailLengthCons;
import com.ejianc.business.pro.income.enums.ExcelDetailTypeEnum;
import com.ejianc.business.pro.income.mapper.BudgetMapper;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.*;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 项目预算书
 *
 * @author generator
 */
@Service("budgetService")
public class BudgetServiceImpl extends BaseServiceImpl<BudgetMapper, BudgetEntity> implements IBudgetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "INCOME_BUDGET";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetSubService budgetSubService;
    @Autowired
    private IBudgetMeasureService budgetMeasureService;
    @Autowired
    private IBudgetOtherService budgetOtherService;
    @Autowired
    private IBudgetFeeService budgetFeeService;
    @Autowired
    private IBudgetCostService budgetCostService;
    @Autowired
    private IBudgetDetailService budgetDetailService;
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private IAttachmentApi fileApi;
    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private IProductionDetailSubService productionDetailSubService;
    @Autowired
    private IProductionDetailMeasureService productionDetailMeasureService;
    @Autowired
    private IProductionDetailOtherService productionDetailOtherService;
    @Autowired
    private IProductionDetailFeeService productionDetailFeeService;
    @Autowired
    private IProductionDetailCostService productionDetailCostService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    private final String BUDGET_COMPOSITIVE_COEFFICIENT = "budget_compositive_coefficient";

    @Autowired
    private BudgetMapper budgetMapper;


    // 编辑保存，小于100条
    @Override
    public BudgetVO saveOrUpdate(BudgetVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, BudgetEntity.class);
            operateType = "edit";
            if(saveorUpdateVO.getBillState()==1||saveorUpdateVO.getBillState()==3){
                BudgetEntity budgetEntity = baseMapper.selectById(saveorUpdateVO.getId());
                BigDecimal oldbudgetTaxMny = budgetEntity.getBudgetTaxMny()==null?BigDecimal.ZERO:budgetEntity.getBudgetTaxMny();
                BigDecimal newbudgetTaxMny = saveorUpdateVO.getBudgetTaxMny()==null?BigDecimal.ZERO:saveorUpdateVO.getBudgetTaxMny();
                if(oldbudgetTaxMny.compareTo(newbudgetTaxMny)!=0){
                    //sendMsg(entity);
                }
            }

        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantId, saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, BudgetEntity.class);
            operateType = "add";
        }
        super.saveOrUpdate(entity);

        if (entity.getBudgetModel() == 0 || entity.getBudgetModel() == 2) {
            detailInfo(saveorUpdateVO, entity.getId());
        } else {
            detailCost(saveorUpdateVO, entity.getId());
        }

        return queryDetail(entity.getId());
    }

    @Override
    public BudgetVO queryDetail(Long id) {
        BudgetEntity entity = super.selectById(id);
        BudgetVO vo = BeanMapper.map(entity, BudgetVO.class);
        Integer detailLength = 0;
        if (vo.getBudgetModel() == 0 || entity.getBudgetModel() == 2) {
            List<BudgetSubVO> subVos = vo.getSubVos();
            List<BudgetMeasureVO> measureVos = vo.getMeasureVos();
            List<BudgetOtherVO> otherVos = vo.getOtherVos();
            List<BudgetFeeVO> feeVos = vo.getFeeVos();
            Integer a = subVos.size() > measureVos.size() ? subVos.size() : measureVos.size();
            Integer b = otherVos.size() > feeVos.size() ? otherVos.size() : feeVos.size();
            detailLength = a > b ? a : b;
            vo.setDetailLength(detailLength);
            Map<Long, List<BudgetDetailVO>> bdMap = new HashMap<>();
            boolean lengthFlag = false;
            if (DetailLengthCons.DETAIL_LENGTH == null || detailLength <= DetailLengthCons.DETAIL_LENGTH) {
                lengthFlag = true;
                LambdaQueryWrapper<BudgetDetailEntity> lambda = new LambdaQueryWrapper<>();
                lambda.eq(BudgetDetailEntity::getDr, 0);
                lambda.eq(BudgetDetailEntity::getBudgetId, id);
                List<BudgetDetailEntity> budgetDetailEntities = budgetDetailService.list(lambda);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    BudgetDetailVO bdevo = BeanMapper.map(bde, BudgetDetailVO.class);
                    bdevo.setRowState("edit");
                    bdevo.setTid(bdevo.getId().toString());
                    bdevo.setTpid(bdevo.getParentId() != null && bdevo.getParentId() > 0 ? bdevo.getParentId().toString() : "");
                    if (bdMap.containsKey(bdevo.getBudgetBid())) {
                        List<BudgetDetailVO> entities = bdMap.get(bdevo.getBudgetBid());
                        entities.add(bdevo);
                        bdMap.put(bdevo.getBudgetBid(), entities);
                    } else {
                        List<BudgetDetailVO> entities = new ArrayList<>();
                        entities.add(bdevo);
                        bdMap.put(bdevo.getBudgetBid(), entities);
                    }
                }
            }
            if (subVos != null && subVos.size() > 0) {
                for (BudgetSubVO cdVo : subVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0 ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (lengthFlag && cdVo.getLeafFlag()) {
                        List<BudgetDetailVO> detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList<>() : bdMap.get(cdVo.getId());
                        new SortUtil<BudgetDetailVO>().entryListToSort(detailList);
                        cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                    }
                }
                new SortUtil<BudgetSubVO>().entryListToSort(subVos);
                vo.setSubVos(TreeNodeBUtil.buildTree(subVos));
            }
            if (measureVos != null && measureVos.size() > 0) {
                for (BudgetMeasureVO cdVo : measureVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0 ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (lengthFlag && cdVo.getLeafFlag()) {
                        List<BudgetDetailVO> detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList<>() : bdMap.get(cdVo.getId());
                        new SortUtil<BudgetDetailVO>().entryListToSort(detailList);
                        cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                    }
                }
                new SortUtil<BudgetMeasureVO>().entryListToSort(measureVos);
                vo.setMeasureVos(TreeNodeBUtil.buildTree(measureVos));
            }
            if (otherVos != null && otherVos.size() > 0) {
                for (BudgetOtherVO cdVo : otherVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0 ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (lengthFlag && cdVo.getLeafFlag()) {
                        List<BudgetDetailVO> detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList<>() : bdMap.get(cdVo.getId());
                        new SortUtil<BudgetDetailVO>().entryListToSort(detailList);
                        cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                    }
                }
                new SortUtil<BudgetOtherVO>().entryListToSort(otherVos);
                vo.setOtherVos(TreeNodeBUtil.buildTree(otherVos));
            }
            if (feeVos != null && feeVos.size() > 0) {
                for (BudgetFeeVO cdVo : feeVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0 ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                    if (lengthFlag && cdVo.getLeafFlag()) {
                        List<BudgetDetailVO> detailList = bdMap.get(cdVo.getId()) == null ? new ArrayList<>() : bdMap.get(cdVo.getId());
                        new SortUtil<BudgetDetailVO>().entryListToSort(detailList);
                        cdVo.setDetailVos(TreeNodeBUtil.buildTree(detailList));
                    }
                }
                new SortUtil<BudgetFeeVO>().entryListToSort(feeVos);
                vo.setFeeVos(TreeNodeBUtil.buildTree(feeVos));
            }
        } else {
            List<BudgetCostVO> costVos = vo.getCostVos();
            detailLength = costVos.size();
            vo.setDetailLength(detailLength);
            if (costVos != null && costVos.size() > 0) {
                for (BudgetCostVO cdVo : costVos) {
                    cdVo.setTid(cdVo.getId().toString());
                    cdVo.setTpid(cdVo.getParentId() != null && cdVo.getParentId() > 0 ? cdVo.getParentId().toString() : "");
                    cdVo.setRowState("edit");
                }
                new SortUtil<BudgetCostVO>().entryListToSort(costVos);
                vo.setCostVos(TreeNodeBUtil.buildTree(costVos));
            }
        }
        return vo;
    }

    @Override
    public BudgetVO queryBudgetDetail(Long id) {
        BudgetEntity entity = baseMapper.selectById(id);
        BudgetVO vo = BeanMapper.map(entity, BudgetVO.class);
        return vo;
    }

    @Override
    public BudgetVO saveBudget(BudgetVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            operateType = "edit";
        } else {
            operateType = "add";
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        BudgetEntity entity = BeanMapper.map(saveorUpdateVO, BudgetEntity.class);
        super.saveOrUpdate(entity);
        if (("add").equals(operateType)) {
            List<Long> attachIds = saveorUpdateVO.getAttachIds();
            if (attachIds != null && attachIds.size() > 0) {
                fileApi.updateAttachRef(entity.getId(), attachIds);
            }
        }
        return BeanMapper.map(entity, BudgetVO.class);
    }

    @Override
    public void delete(List<BudgetVO> vos) {
        List<Long> ids = vos.stream().map(BudgetVO::getId).collect(Collectors.toList());

        LambdaQueryWrapper<BudgetEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BudgetEntity::getId, ids);
        List<BudgetEntity> list = this.list(wrapper);
        for (BudgetEntity entity : list) {
            if (entity.getUseId() != null) {
                throw new BusinessException("单据编号为" + entity.getBillCode() + "的预算书已经被引用，不能删除！");
            }
        }

        budgetSubService.delSubBatchByBudgetId(ids);
        budgetMeasureService.delMeasureBatchByBudgetId(ids);
        budgetOtherService.delOtherBatchByBudgetId(ids);
        budgetFeeService.delFeeBatchByBudgetId(ids);
        budgetCostService.delCostBatchByBudgetId(ids);
        budgetDetailService.delDetailBatchByBudgetId(ids);
        super.removeByIds(ids, true);
    }

    @Override
    public CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (StringUtils.isNotEmpty(request.getParameter("budgetId"))) {
            budgetId = Long.valueOf(request.getParameter("budgetId"));
        } else {
            return CommonResponse.error("预算书主键为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result != null && result.size() > 0) {
                List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
                Map<String, Long> parentMap = new HashMap<>();
                List<BudgetCostVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    if (datas.size() < 12) {
                        return CommonResponse.error("文件数据不完整，请下载最新模板！");
                    }
                    BudgetCostVO vo = new BudgetCostVO();
                    boolean flag = false;
                    String warnType = "";

                    String indexCode = datas.get(0);
                    String costCode = datas.get(1);
                    String costName = datas.get(2);
                    String costUnit = datas.get(3);
                    String costNum = datas.get(4);
                    String costTaxRate = datas.get(5);
                    String costPrice = datas.get(6);
                    String costTaxPrice = datas.get(7);
                    String costMny = datas.get(8);
                    String costTaxMny = datas.get(9);
                    String costTax = datas.get(10);
                    String costMemo = datas.get(11);

                    Long id = IdWorker.getId();
                    vo.setId(id);
                    vo.setBudgetId(budgetId);

                    if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                        indexCode = indexCode.trim();// 去除导入时树形编码空格
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                        String[] split = indexCode.split("[-/.]");
                        if (split.length > 1) {
                            vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
                        vo.setDetailIndex(i + "");
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }
                    } else {
                        vo.setIndexCode(null);
                        warnType = warnType + "[序号为空]";
                        flag = true;
                    }

                    if (StringUtils.isEmpty(costCode)) {// 编码为空
                        vo.setCostCode(null);
                        warnType = warnType + "[编码为空]";
                        flag = true;
                    } else {
                        vo.setCostCode(costCode);
                    }

                    if (StringUtils.isEmpty(costName)) {//名称为空
                        vo.setCostName(null);
                        warnType = warnType + "[费用项名称为空]";
                        flag = true;
                    } else {
                        vo.setCostName(costName);
                    }

                    vo.setCostUnit(costUnit);//计量单位

                    if (StringUtils.isEmpty(costNum)) {
                        vo.setCostNum(null);
                    } else {
                        try {
                            vo.setCostNum(new BigDecimal(costNum));
                        } catch (Exception e) {
                            vo.setCostNum(null);
                            warnType = warnType + "[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTaxRate)) {
                        vo.setCostTaxRate(null);
                    } else {
                        try {
                            vo.setCostTaxRate(new BigDecimal(costTaxRate));
                        } catch (Exception e) {
                            vo.setCostTaxRate(null);
                            warnType = warnType + "[税率(%)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costPrice)) {
                        vo.setCostPrice(null);
                    } else {
                        try {
                            vo.setCostPrice(new BigDecimal(costPrice));
                        } catch (Exception e) {
                            vo.setCostPrice(null);
                            warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTaxPrice)) {
                        vo.setCostTaxPrice(null);
                    } else {
                        try {
                            vo.setCostTaxPrice(new BigDecimal(costTaxPrice));
                        } catch (Exception e) {
                            vo.setCostTaxPrice(null);
                            warnType = warnType + "[综合单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costMny)) {
                        vo.setCostMny(null);
                    } else {
                        try {
                            vo.setCostMny(new BigDecimal(costMny));
                        } catch (Exception e) {
                            vo.setCostMny(null);
                            warnType = warnType + "[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setCostTaxMny(null);
                    } else {
                        try {
                            vo.setCostTaxMny(new BigDecimal(costTaxMny));
                        } catch (Exception e) {
                            vo.setCostTaxMny(null);
                            warnType = warnType + "[合价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTax)) {
                        vo.setCostTax(null);
                    } else {
                        try {
                            vo.setCostTax(new BigDecimal(costTax));
                        } catch (Exception e) {
                            vo.setCostTax(null);
                            warnType = warnType + "[税额只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setCostMemo(costMemo);

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                List<BudgetCostVO> successList = new ArrayList<>();
                List<ImportErrorVo> errorList = new ArrayList<>();
                for (BudgetCostVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            String indexCode = vo.getIndexCode();
                            Boolean leafFlag = true;
                            for (String code : detailIndexList) {
                                if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                    String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                    if ("-/.".indexOf(sub) != -1) {
                                        leafFlag = false;
                                        break;
                                    }
                                }
                            }
                            vo.setLeafFlag(leafFlag);
                            vo.setParentId(parentMap.get(vo.getTpid()));
                            if (!leafFlag) {
                                vo.setCostNum(null);
                                vo.setCostTaxRate(null);
                                vo.setCostPrice(null);
                                vo.setCostTaxPrice(null);
                                vo.setCostMny(null);
                                vo.setCostTaxMny(null);
                                vo.setCostTax(null);
                            }
                            successList.add(vo);
                        }
                    } else {
                        ImportErrorVo errorVo = new ImportErrorVo();
                        errorVo.setPageName("费用项清单");
                        errorVo.setId(vo.getId());
                        errorVo.setIndexCode(vo.getIndexCode());
                        errorVo.setCode(vo.getCostCode());
                        errorVo.setName(vo.getCostName());
                        errorVo.setUnit(vo.getCostUnit());
                        errorVo.setWarnType(vo.getWarnType());
                        errorList.add(errorVo);
                    }
                }
                if (errorList.size() == 0) {
                    // 价税分离
                    new TaxCalculateUtil<BudgetCostVO>().calculate(successList);
                    // list转树
                    List<BudgetCostVO> budgetCostVOS = TreeNodeBUtil.buildTree(successList);
                    // 向上汇总金额
                    new UpSumUtil<BudgetCostVO>().upSum(budgetCostVOS, "costMny", "costTaxMny", "costTax");
                    BigDecimal budgetMny = BigDecimal.ZERO;
                    BigDecimal budgetTaxMny = BigDecimal.ZERO;
                    for (BudgetCostVO bv : budgetCostVOS) {
                        budgetMny = MathUtil.safeAdd(budgetMny, bv.getCostMny());
                        budgetTaxMny = MathUtil.safeAdd(budgetTaxMny, bv.getCostTaxMny());
                    }
                    // 树转list
                    List<BudgetCostVO> budgetCostVOS1 = new UpSumUtil<BudgetCostVO>().treeToList(budgetCostVOS);

                    resp.put("successList", null);
                    resp.put("errorList", null);
                    resp.put("successNum", budgetCostVOS1.size());
                    resp.put("errorNum", 0);

                    budgetCostService.delCostByBudgetId(budgetId);
                    List<BudgetCostEntity> budgetCostEntities = BeanMapper.mapList(budgetCostVOS1, BudgetCostEntity.class);
                    budgetCostService.saveOrUpdateBatch(budgetCostEntities, budgetCostEntities.size(), false);
                    LambdaUpdateWrapper<BudgetEntity> lambd = new LambdaUpdateWrapper<>();
                    lambd.set(BudgetEntity::getBudgetMny, budgetMny);
                    lambd.set(BudgetEntity::getBudgetTaxMny, budgetTaxMny);
                    lambd.eq(BudgetEntity::getId, budgetId);
                    super.update(lambd);
                } else {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (StringUtils.isNotEmpty(request.getParameter("budgetId"))) {
            budgetId = Long.valueOf(request.getParameter("budgetId"));
        } else {
            return CommonResponse.error("预算书主键为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size == null || size != 4) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
            if (result0.size() > 0 && result0.get(0).size() < 13) {
                return CommonResponse.error("[分部分项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result1 = resList.get(1);
            if (result1.size() > 0 && result1.get(0).size() < 13) {
                return CommonResponse.error("[措施项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(2);
            if (result2.size() > 0 && result2.get(0).size() < 13) {
                return CommonResponse.error("[其它项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(3);
            if (result3.size() > 0 && result3.get(0).size() < 9) {
                return CommonResponse.error("[费税项清单]数据不完整，请下载最新模板！");
            }
            ImportVo importVo0 = excelImportSub(result0, budgetId);
            ImportVo importVo1 = excelImportMeasure(result1, budgetId);
            ImportVo importVo2 = excelImportOther(result2, budgetId);
            ImportVo importVo3 = excelImportFee(result3, budgetId);

            List<ImportErrorVo> errorList = new ArrayList<>();
            errorList.addAll(importVo0.getErrorList());
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());

            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<BudgetSubVO> subList = importVo0.getSubList();
                // 价税分离
                new TaxCalculateUtil<BudgetSubVO>().calculate(subList);
                // list转树
                List<BudgetSubVO> subVOS = TreeNodeBUtil.buildTree(subList);
                // 向上汇总金额
                new UpSumUtil<BudgetSubVO>().upSum(subVOS, "subMny", "subTaxMny", "subTax");
                // 计算合计
                BigDecimal subTotalMny = BigDecimal.ZERO;
                BigDecimal subTotalTaxMny = BigDecimal.ZERO;
                for (BudgetSubVO bv : subVOS) {
                    subTotalMny = MathUtil.safeAdd(subTotalMny, bv.getSubMny());
                    subTotalTaxMny = MathUtil.safeAdd(subTotalTaxMny, bv.getSubTaxMny());
                }
                // 树转list
                List<BudgetSubVO> budgetSubVOS = new UpSumUtil<BudgetSubVO>().treeToList(subVOS);

                List<BudgetMeasureVO> measureList = importVo1.getMeasureList();
                // 价税分离
                new TaxCalculateUtil<BudgetMeasureVO>().calculate(measureList);
                // list转树
                List<BudgetMeasureVO> measureVOS = TreeNodeBUtil.buildTree(measureList);
                // 向上汇总金额
                new UpSumUtil<BudgetMeasureVO>().upSum(measureVOS, "measureMny", "measureTaxMny", "measureTax");
                // 计算合计
                BigDecimal measureTotalMny = BigDecimal.ZERO;
                BigDecimal measureTotalTaxMny = BigDecimal.ZERO;
                for (BudgetMeasureVO bv : measureVOS) {
                    measureTotalMny = MathUtil.safeAdd(measureTotalMny, bv.getMeasureMny());
                    measureTotalTaxMny = MathUtil.safeAdd(measureTotalTaxMny, bv.getMeasureTaxMny());
                }
                // 树转list
                List<BudgetMeasureVO> budgetMeasureVOS = new UpSumUtil<BudgetMeasureVO>().treeToList(measureVOS);

                List<BudgetOtherVO> otherList = importVo2.getOtherList();
                // 价税分离
                new TaxCalculateUtil<BudgetOtherVO>().calculate(otherList);
                // list转树
                List<BudgetOtherVO> otherVOS = TreeNodeBUtil.buildTree(otherList);
                // 向上汇总金额
                new UpSumUtil<BudgetOtherVO>().upSum(otherVOS, "otherMny", "otherTaxMny", "otherTax");
                // 计算合计
                BigDecimal otherTotalMny = BigDecimal.ZERO;
                BigDecimal otherTotalTaxMny = BigDecimal.ZERO;
                for (BudgetOtherVO bv : otherVOS) {
                    otherTotalMny = MathUtil.safeAdd(otherTotalMny, bv.getOtherMny());
                    otherTotalTaxMny = MathUtil.safeAdd(otherTotalTaxMny, bv.getOtherTaxMny());
                }
                // 树转list
                List<BudgetOtherVO> budgetOtherVOS = new UpSumUtil<BudgetOtherVO>().treeToList(otherVOS);

                List<BudgetFeeVO> feeList = importVo3.getFeeList();
                // 价税分离
                new TaxCalculateUtil<BudgetFeeVO>().calculate(feeList);
                // list转树
                List<BudgetFeeVO> feeVOS = TreeNodeBUtil.buildTree(feeList);
                // 向上汇总金额
                new UpSumUtil<BudgetFeeVO>().upSum(feeVOS, "feeMny", "feeTaxMny", "feeTax");
                // 计算合计
                BigDecimal feeTotalMny = BigDecimal.ZERO;
                BigDecimal feeTotalTaxMny = BigDecimal.ZERO;
                for (BudgetFeeVO bv : feeVOS) {
                    feeTotalMny = MathUtil.safeAdd(feeTotalMny, bv.getFeeMny());
                    feeTotalTaxMny = MathUtil.safeAdd(feeTotalTaxMny, bv.getFeeTaxMny());
                }
                // 树转list
                List<BudgetFeeVO> budgetFeeVOS = new UpSumUtil<BudgetFeeVO>().treeToList(feeVOS);

                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", budgetSubVOS.size() + budgetMeasureVOS.size() + budgetOtherVOS.size() + budgetFeeVOS.size());
                resp.put("errorNum", 0);

                budgetDetailService.delDetailByBudgetId(budgetId);

                budgetSubService.delSubByBudgetId(budgetId);
                if (budgetSubVOS.size() > 0) {
                    List<BudgetSubEntity> budgetSubEntities = BeanMapper.mapList(budgetSubVOS, BudgetSubEntity.class);
                    budgetSubService.saveOrUpdateBatch(budgetSubEntities, budgetSubEntities.size(), false);
                }
                budgetMeasureService.delMeasureByBudgetId(budgetId);
                if (budgetMeasureVOS.size() > 0) {
                    List<BudgetMeasureEntity> budgetMeasureEntities = BeanMapper.mapList(budgetMeasureVOS, BudgetMeasureEntity.class);
                    budgetMeasureService.saveOrUpdateBatch(budgetMeasureEntities, budgetMeasureEntities.size(), false);
                }
                budgetOtherService.delOtherByBudgetId(budgetId);
                if (budgetOtherVOS.size() > 0) {
                    List<BudgetOtherEntity> budgetOtherEntities = BeanMapper.mapList(budgetOtherVOS, BudgetOtherEntity.class);
                    budgetOtherService.saveOrUpdateBatch(budgetOtherEntities, budgetOtherEntities.size(), false);
                }
                budgetFeeService.delFeeByBudgetId(budgetId);
                if (budgetFeeVOS.size() > 0) {
                    List<BudgetFeeEntity> budgetFeeEntities = BeanMapper.mapList(budgetFeeVOS, BudgetFeeEntity.class);
                    budgetFeeService.saveOrUpdateBatch(budgetFeeEntities, budgetFeeEntities.size(), false);
                }

                BigDecimal budgetMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalMny, measureTotalMny), MathUtil.safeAdd(otherTotalMny, feeTotalMny));
                BigDecimal budgetTaxMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTaxMny, measureTotalTaxMny), MathUtil.safeAdd(otherTotalTaxMny, feeTotalTaxMny));
                LambdaUpdateWrapper<BudgetEntity> lambd = new LambdaUpdateWrapper<>();
                lambd.set(BudgetEntity::getSubTotalMny, subTotalMny);
                lambd.set(BudgetEntity::getSubTotalTaxMny, subTotalTaxMny);
                lambd.set(BudgetEntity::getMeasureTotalMny, measureTotalMny);
                lambd.set(BudgetEntity::getMeasureTotalTaxMny, measureTotalTaxMny);
                lambd.set(BudgetEntity::getOtherTotalMny, otherTotalMny);
                lambd.set(BudgetEntity::getOtherTotalTaxMny, otherTotalTaxMny);
                lambd.set(BudgetEntity::getFeeTotalMny, feeTotalMny);
                lambd.set(BudgetEntity::getFeeTotalTaxMny, feeTotalTaxMny);
                lambd.set(BudgetEntity::getBudgetMny, budgetMny);
                lambd.set(BudgetEntity::getBudgetTaxMny, budgetTaxMny);
                lambd.eq(BudgetEntity::getId, budgetId);
                super.update(lambd);

            }
            return CommonResponse.success(resp);
        }
    }

    private ImportVo excelImportSub(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetSubVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetSubVO vo = new BudgetSubVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String costMemo = datas.get(12);

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setSubCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    vo.setSubCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setSubName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setSubName(costName);
                }
                vo.setSubFeature(feeFeature);
                vo.setSubUnit(costUnit);//计量单位

                if (StringUtils.isEmpty(costNum)) {
                    vo.setSubNum(null);
                } else {
                    try {
                        vo.setSubNum(new BigDecimal(costNum));
                    } catch (Exception e) {
                        vo.setSubNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxRate)) {
                    vo.setSubTaxRate(null);
                } else {
                    try {
                        vo.setSubTaxRate(new BigDecimal(costTaxRate));
                    } catch (Exception e) {
                        vo.setSubTaxRate(null);
                        warnType = warnType + "[税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costPrice)) {
                    vo.setSubPrice(null);
                } else {
                    try {
                        vo.setSubPrice(new BigDecimal(costPrice));
                    } catch (Exception e) {
                        vo.setSubPrice(null);
                        warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxPrice)) {
                    vo.setSubTaxPrice(null);
                } else {
                    try {
                        vo.setSubTaxPrice(new BigDecimal(costTaxPrice));
                    } catch (Exception e) {
                        vo.setSubTaxPrice(null);
                        warnType = warnType + "[综合单价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costMny)) {
                    vo.setSubMny(null);
                } else {
                    try {
                        vo.setSubMny(new BigDecimal(costMny));
                    } catch (Exception e) {
                        vo.setSubMny(null);
                        warnType = warnType + "[合价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxMny)) {
                    vo.setSubTaxMny(null);
                } else {
                    try {
                        vo.setSubTaxMny(new BigDecimal(costTaxMny));
                    } catch (Exception e) {
                        vo.setSubTaxMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTax)) {
                    vo.setSubTax(null);
                } else {
                    try {
                        vo.setSubTax(new BigDecimal(costTax));
                    } catch (Exception e) {
                        vo.setSubTax(null);
                        warnType = warnType + "[税额只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setSubMemo(costMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BudgetSubVO> successList = new ArrayList<>();
            for (BudgetSubVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        if (!leafFlag) {
                            vo.setSubNum(null);
                            vo.setSubTaxRate(null);
                            vo.setSubPrice(null);
                            vo.setSubTaxPrice(null);
                            vo.setSubMny(null);
                            vo.setSubTaxMny(null);
                            vo.setSubTax(null);
                        }
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("分部分项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getSubCode());
                    errorVo.setName(vo.getSubName());
                    errorVo.setUnit(vo.getSubUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setSubList(successList);
        }
        return res;
    }

    private ImportVo excelImportMeasure(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetMeasureVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetMeasureVO vo = new BudgetMeasureVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String costMemo = datas.get(12);

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setMeasureCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    vo.setMeasureCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setMeasureName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setMeasureName(costName);
                }
                vo.setMeasureFeature(feeFeature);
                vo.setMeasureUnit(costUnit);//计量单位

                if (StringUtils.isEmpty(costNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(costNum));
                    } catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxRate)) {
                    vo.setMeasureTaxRate(null);
                } else {
                    try {
                        vo.setMeasureTaxRate(new BigDecimal(costTaxRate));
                    } catch (Exception e) {
                        vo.setMeasureTaxRate(null);
                        warnType = warnType + "[税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costPrice)) {
                    vo.setMeasurePrice(null);
                } else {
                    try {
                        vo.setMeasurePrice(new BigDecimal(costPrice));
                    } catch (Exception e) {
                        vo.setMeasurePrice(null);
                        warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxPrice)) {
                    vo.setMeasureTaxPrice(null);
                } else {
                    try {
                        vo.setMeasureTaxPrice(new BigDecimal(costTaxPrice));
                    } catch (Exception e) {
                        vo.setMeasureTaxPrice(null);
                        warnType = warnType + "[综合单价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costMny)) {
                    vo.setMeasureMny(null);
                } else {
                    try {
                        vo.setMeasureMny(new BigDecimal(costMny));
                    } catch (Exception e) {
                        vo.setMeasureMny(null);
                        warnType = warnType + "[合价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxMny)) {
                    vo.setMeasureTaxMny(null);
                } else {
                    try {
                        vo.setMeasureTaxMny(new BigDecimal(costTaxMny));
                    } catch (Exception e) {
                        vo.setMeasureTaxMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTax)) {
                    vo.setMeasureTax(null);
                } else {
                    try {
                        vo.setMeasureTax(new BigDecimal(costTax));
                    } catch (Exception e) {
                        vo.setMeasureTax(null);
                        warnType = warnType + "[税额只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setMeasureMemo(costMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BudgetMeasureVO> successList = new ArrayList<>();
            for (BudgetMeasureVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        if (!leafFlag) {
                            vo.setMeasureNum(null);
                            vo.setMeasureTaxRate(null);
                            vo.setMeasurePrice(null);
                            vo.setMeasureTaxPrice(null);
                            vo.setMeasureMny(null);
                            vo.setMeasureTaxMny(null);
                            vo.setMeasureTax(null);
                        }
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("措施项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMeasureCode());
                    errorVo.setName(vo.getMeasureName());
                    errorVo.setUnit(vo.getMeasureUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setMeasureList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetOtherVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetOtherVO vo = new BudgetOtherVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costUnit = datas.get(4);
                String costNum = datas.get(5);
                String costTaxRate = datas.get(6);
                String costPrice = datas.get(7);
                String costTaxPrice = datas.get(8);
                String costMny = datas.get(9);
                String costTaxMny = datas.get(10);
                String costTax = datas.get(11);
                String costMemo = datas.get(12);

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setOtherCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    vo.setOtherCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setOtherName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setOtherName(costName);
                }
                vo.setOtherFeature(feeFeature);
                vo.setOtherUnit(costUnit);//计量单位

                if (StringUtils.isEmpty(costNum)) {
                    vo.setOtherNum(null);
                } else {
                    try {
                        vo.setOtherNum(new BigDecimal(costNum));
                    } catch (Exception e) {
                        vo.setOtherNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxRate)) {
                    vo.setOtherTaxRate(null);
                } else {
                    try {
                        vo.setOtherTaxRate(new BigDecimal(costTaxRate));
                    } catch (Exception e) {
                        vo.setOtherTaxRate(null);
                        warnType = warnType + "[税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costPrice)) {
                    vo.setOtherPrice(null);
                } else {
                    try {
                        vo.setOtherPrice(new BigDecimal(costPrice));
                    } catch (Exception e) {
                        vo.setOtherPrice(null);
                        warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxPrice)) {
                    vo.setOtherTaxPrice(null);
                } else {
                    try {
                        vo.setOtherTaxPrice(new BigDecimal(costTaxPrice));
                    } catch (Exception e) {
                        vo.setOtherTaxPrice(null);
                        warnType = warnType + "[综合单价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costMny)) {
                    vo.setOtherMny(null);
                } else {
                    try {
                        vo.setOtherMny(new BigDecimal(costMny));
                    } catch (Exception e) {
                        vo.setOtherMny(null);
                        warnType = warnType + "[合价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxMny)) {
                    vo.setOtherTaxMny(null);
                } else {
                    try {
                        vo.setOtherTaxMny(new BigDecimal(costTaxMny));
                    } catch (Exception e) {
                        vo.setOtherTaxMny(null);
                        warnType = warnType + "[合价只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTax)) {
                    vo.setOtherTax(null);
                } else {
                    try {
                        vo.setOtherTax(new BigDecimal(costTax));
                    } catch (Exception e) {
                        vo.setOtherTax(null);
                        warnType = warnType + "[税额只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setOtherMemo(costMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BudgetOtherVO> successList = new ArrayList<>();
            for (BudgetOtherVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        if (!leafFlag) {
                            vo.setOtherNum(null);
                            vo.setOtherTaxRate(null);
                            vo.setOtherPrice(null);
                            vo.setOtherTaxPrice(null);
                            vo.setOtherMny(null);
                            vo.setOtherTaxMny(null);
                            vo.setOtherTax(null);
                        }
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("其它清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getOtherCode());
                    errorVo.setName(vo.getOtherName());
                    errorVo.setUnit(vo.getOtherUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportFee(List<List<String>> result, Long budgetId) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetFeeVO> detailVoList = new ArrayList<>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetFeeVO vo = new BudgetFeeVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                String costCode = datas.get(1);
                String costName = datas.get(2);
                String feeFeature = datas.get(3);
                String costTaxRate = datas.get(4);
                String costMny = datas.get(5);
                String costTaxMny = datas.get(6);
                String costTax = datas.get(7);
                String costMemo = datas.get(8);

                Long id = IdWorker.getId();
                vo.setId(id);
                vo.setBudgetId(budgetId);

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    vo.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    if (split.length > 1) {
                        vo.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    vo.setDetailIndex(i + "");
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setFeeCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    vo.setFeeCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setFeeName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setFeeName(costName);
                }

                vo.setFeeFeature(feeFeature);

                if (StringUtils.isEmpty(costTaxRate)) {
                    vo.setFeeTaxRate(null);
                } else {
                    try {
                        vo.setFeeTaxRate(new BigDecimal(costTaxRate));
                    } catch (Exception e) {
                        vo.setFeeTaxRate(null);
                        warnType = warnType + "[税率(%)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costMny)) {
                    vo.setFeeMny(null);
                } else {
                    try {
                        vo.setFeeMny(new BigDecimal(costMny));
                    } catch (Exception e) {
                        vo.setFeeMny(null);
                        warnType = warnType + "[金额(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTaxMny)) {
                    vo.setFeeTaxMny(null);
                } else {
                    try {
                        vo.setFeeTaxMny(new BigDecimal(costTaxMny));
                    } catch (Exception e) {
                        vo.setFeeTaxMny(null);
                        warnType = warnType + "[金额只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(costTax)) {
                    vo.setFeeTax(null);
                } else {
                    try {
                        vo.setFeeTax(new BigDecimal(costTax));
                    } catch (Exception e) {
                        vo.setFeeTax(null);
                        warnType = warnType + "[税额只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setFeeMemo(costMemo);
                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            List<BudgetFeeVO> successList = new ArrayList<>();
            for (BudgetFeeVO vo : detailVoList) {
                if (vo.getImportFlag()) {
                    if (importFlag) {
                        String indexCode = vo.getIndexCode();
                        Boolean leafFlag = true;
                        for (String code : detailIndexList) {
                            if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                                String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                                if ("-/.".indexOf(sub) != -1) {
                                    leafFlag = false;
                                    break;
                                }
                            }
                        }
                        vo.setLeafFlag(leafFlag);
                        vo.setParentId(parentMap.get(vo.getTpid()));
                        if (!leafFlag) {
                            vo.setFeeTaxRate(null);
                            vo.setFeeMny(null);
                            vo.setFeeTaxMny(null);
                            vo.setFeeTax(null);
                        }
                        successList.add(vo);
                    }
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("费税项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getFeeCode());
                    errorVo.setName(vo.getFeeName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setFeeList(successList);
        }
        return res;
    }

    //处理子表(清单模式)
    private void detailInfo(BudgetVO saveorUpdateVO, Long budgetId) {
        List<BudgetDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        //维护父子级关系
        Map<String, Long> idMap = new HashMap<>();
        //维护父子级关系
        Map<String, Long> detailIdMap = new HashMap<>();

        // 分部分项
        List<BudgetSubVO> detailsVos = saveorUpdateVO.getSubVos();
        List<BudgetSubEntity> saveOrUpldates1 = new ArrayList<>();
        List<Long> deleteIds1 = new ArrayList<>();
        for (BudgetSubVO detailsVo : detailsVos) {
            if ("add".equals(detailsVo.getRowState())) {
                BudgetSubEntity details = BeanMapper.map(detailsVo, BudgetSubEntity.class);
                //Long id = IdWorker.getId();
                details.setBudgetId(budgetId);
                //details.setId(id);
                saveOrUpldates1.add(details);
                List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    bde.setBudgetId(budgetId);
                    //bde.setBudgetBid(id);
                    bde.setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetSubEntity details = BeanMapper.map(detailsVo, BudgetSubEntity.class);
                saveOrUpldates1.add(details);
                List<BudgetDetailVO> detailVOList = detailsVo.getDetailVos();
                if (detailVOList != null && detailVOList.size() > 0) {
                    List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                    for (BudgetDetailEntity bde : budgetDetailEntities) {
                        if ("del".equals(bde.getRowState())) {
                            deleteIds.add(bde.getId());
                        } else {
                            bde.setBudgetId(budgetId);
                            bde.setBudgetBid(details.getId());
                            bde.setTbid(details.getTid());
                            saveOrUpldates.add(bde);
                        }
                    }
                }
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds1.add(detailsVo.getId());
                List<BudgetDetailVO> budgetDetailVos = detailsVo.getDetailVos();
                for (BudgetDetailVO bdv : budgetDetailVos) {
                    if (bdv.getId() != null && bdv.getId() > 0) {
                        deleteIds.add(bdv.getId());
                    }
                }
            }
        }
        if (saveOrUpldates1.size() > 0) {
            budgetSubService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
            //维护父子级关系
            //Map<String, Long> idMap = new HashMap<>();
            for (BudgetSubEntity cdEntity : saveOrUpldates1) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetSubEntity cdEntity : saveOrUpldates1) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetSubService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
        }
        if (deleteIds1.size() > 0) {
            budgetSubService.removeByIds(deleteIds1, false);
        }
        // 措施项
        List<BudgetMeasureVO> measureVos = saveorUpdateVO.getMeasureVos();
        List<BudgetMeasureEntity> saveOrUpldates2 = new ArrayList<>();
        List<Long> deleteIds2 = new ArrayList<>();
        for (BudgetMeasureVO detailsVo : measureVos) {
            if ("add".equals(detailsVo.getRowState())) {
                BudgetMeasureEntity details = BeanMapper.map(detailsVo, BudgetMeasureEntity.class);
                //Long id = IdWorker.getId();
                details.setBudgetId(budgetId);
                //details.setId(id);
                saveOrUpldates2.add(details);
                List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    bde.setBudgetId(budgetId);
                    //bde.setBudgetBid(id);
                    bde.setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetMeasureEntity details = BeanMapper.map(detailsVo, BudgetMeasureEntity.class);
                saveOrUpldates2.add(details);
                List<BudgetDetailVO> detailVOList = detailsVo.getDetailVos();
                if (detailVOList != null && detailVOList.size() > 0) {
                    List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                    for (BudgetDetailEntity bde : budgetDetailEntities) {
                        if ("del".equals(bde.getRowState())) {
                            deleteIds.add(bde.getId());
                        } else {
                            bde.setBudgetId(budgetId);
                            bde.setBudgetBid(details.getId());
                            bde.setTbid(details.getTid());
                            saveOrUpldates.add(bde);
                        }
                    }
                }
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds2.add(detailsVo.getId());
                List<BudgetDetailVO> budgetDetailVos = detailsVo.getDetailVos();
                for (BudgetDetailVO bdv : budgetDetailVos) {
                    if (bdv.getId() != null && bdv.getId() > 0) {
                        deleteIds.add(bdv.getId());
                    }
                }
            }
        }
        if (saveOrUpldates2.size() > 0) {
            budgetMeasureService.saveOrUpdateBatch(saveOrUpldates2, saveOrUpldates2.size(), false);
            //维护父子级关系
            //Map<String, Long> idMap = new HashMap<>();
            for (BudgetMeasureEntity cdEntity : saveOrUpldates2) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetMeasureEntity cdEntity : saveOrUpldates2) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetMeasureService.saveOrUpdateBatch(saveOrUpldates2, saveOrUpldates2.size(), false);
        }
        if (deleteIds2.size() > 0) {
            budgetMeasureService.removeByIds(deleteIds2, false);
        }
        // 其它
        List<BudgetOtherVO> otherVos = saveorUpdateVO.getOtherVos();
        List<BudgetOtherEntity> saveOrUpldates3 = new ArrayList<>();
        List<Long> deleteIds3 = new ArrayList<>();
        for (BudgetOtherVO detailsVo : otherVos) {
            if ("add".equals(detailsVo.getRowState())) {
                BudgetOtherEntity details = BeanMapper.map(detailsVo, BudgetOtherEntity.class);
                //Long id = IdWorker.getId();
                details.setBudgetId(budgetId);
                //details.setId(id);
                saveOrUpldates3.add(details);
                List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    bde.setBudgetId(budgetId);
                    //bde.setBudgetBid(id);
                    bde.setTbid(details.getTid());
                    saveOrUpldates.add(bde);
                }
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetOtherEntity details = BeanMapper.map(detailsVo, BudgetOtherEntity.class);
                saveOrUpldates3.add(details);
                List<BudgetDetailVO> detailVOList = detailsVo.getDetailVos();
                if (detailVOList != null && detailVOList.size() > 0) {
                    List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                    for (BudgetDetailEntity bde : budgetDetailEntities) {
                        if ("del".equals(bde.getRowState())) {
                            deleteIds.add(bde.getId());
                        } else {
                            bde.setBudgetId(budgetId);
                            bde.setBudgetBid(details.getId());
                            bde.setTbid(details.getTid());
                            saveOrUpldates.add(bde);
                        }
                    }
                }
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds3.add(detailsVo.getId());
                List<BudgetDetailVO> budgetDetailVos = detailsVo.getDetailVos();
                for (BudgetDetailVO bdv : budgetDetailVos) {
                    if (bdv.getId() != null && bdv.getId() > 0) {
                        deleteIds.add(bdv.getId());
                    }
                }
            }
        }
        if (saveOrUpldates3.size() > 0) {
            budgetOtherService.saveOrUpdateBatch(saveOrUpldates3, saveOrUpldates3.size(), false);
            //维护父子级关系
            //Map<String, Long> idMap = new HashMap<>();
            for (BudgetOtherEntity cdEntity : saveOrUpldates3) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetOtherEntity cdEntity : saveOrUpldates3) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetOtherService.saveOrUpdateBatch(saveOrUpldates3, saveOrUpldates3.size(), false);
        }
        if (deleteIds3.size() > 0) {
            budgetOtherService.removeByIds(deleteIds3, false);
        }
        // 费税
        List<BudgetFeeVO> feeVos = saveorUpdateVO.getFeeVos();
        List<BudgetFeeEntity> saveOrUpldates4 = new ArrayList<>();
        List<Long> deleteIds4 = new ArrayList<>();
        for (BudgetFeeVO detailsVo : feeVos) {
            if ("add".equals(detailsVo.getRowState())) {
                BudgetFeeEntity details = BeanMapper.map(detailsVo, BudgetFeeEntity.class);
                //Long id = IdWorker.getId();
                details.setBudgetId(budgetId);
                //details.setId(id);
                saveOrUpldates4.add(details);
                List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailsVo.getDetailVos(), BudgetDetailEntity.class);
                for (BudgetDetailEntity bde : budgetDetailEntities) {
                    bde.setBudgetId(budgetId);
                    //bde.setBudgetBid(id);
                    saveOrUpldates.add(bde);
                }
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetFeeEntity details = BeanMapper.map(detailsVo, BudgetFeeEntity.class);
                saveOrUpldates4.add(details);
                List<BudgetDetailVO> detailVOList = detailsVo.getDetailVos();
                if (detailVOList != null && detailVOList.size() > 0) {
                    List<BudgetDetailEntity> budgetDetailEntities = BeanMapper.mapList(detailVOList, BudgetDetailEntity.class);
                    for (BudgetDetailEntity bde : budgetDetailEntities) {
                        if ("del".equals(bde.getRowState())) {
                            deleteIds.add(bde.getId());
                        } else {
                            bde.setBudgetId(budgetId);
                            bde.setBudgetBid(details.getId());
                            bde.setTbid(details.getTid());
                            saveOrUpldates.add(bde);
                        }
                    }
                }
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds4.add(detailsVo.getId());
                List<BudgetDetailVO> budgetDetailVos = detailsVo.getDetailVos();
                for (BudgetDetailVO bdv : budgetDetailVos) {
                    if (bdv.getId() != null && bdv.getId() > 0) {
                        deleteIds.add(bdv.getId());
                    }
                }
            }
        }
        if (saveOrUpldates4.size() > 0) {
            budgetFeeService.saveOrUpdateBatch(saveOrUpldates4, saveOrUpldates4.size(), false);
            for (BudgetFeeEntity cdEntity : saveOrUpldates4) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetFeeEntity cdEntity : saveOrUpldates4) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetFeeService.saveOrUpdateBatch(saveOrUpldates4, saveOrUpldates4.size(), false);
        }
        if (deleteIds4.size() > 0) {
            budgetFeeService.removeByIds(deleteIds4, false);
        }

        // 清单详情
        if (saveOrUpldates.size() > 0) {
            for (BudgetDetailEntity bdv : saveOrUpldates) {
                bdv.setBudgetBid(idMap.get(bdv.getTbid()));
            }
            budgetDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            for (BudgetDetailEntity cdEntity : saveOrUpldates) {
                detailIdMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(detailIdMap.get(cdEntity.getTpid()));
                }
            }
            budgetDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            budgetDetailService.removeByIds(deleteIds, false);
        }
    }

    //处理子表(费用项模式)
    private void detailCost(BudgetVO saveorUpdateVO, Long budgetId) {
        // 分部分项
        List<BudgetCostVO> costVos = saveorUpdateVO.getCostVos();
        List<BudgetCostEntity> saveOrUpldates1 = new ArrayList<>();
        List<Long> deleteIds1 = new ArrayList<>();
        for (BudgetCostVO detailsVo : costVos) {
            if ("add".equals(detailsVo.getRowState())) {
                BudgetCostEntity details = BeanMapper.map(detailsVo, BudgetCostEntity.class);
                //Long id = IdWorker.getId();
                details.setBudgetId(budgetId);
                //details.setId(id);
                saveOrUpldates1.add(details);
            } else if ("edit".equals(detailsVo.getRowState())) {
                BudgetCostEntity details = BeanMapper.map(detailsVo, BudgetCostEntity.class);
                saveOrUpldates1.add(details);
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds1.add(detailsVo.getId());
            }
        }
        if (saveOrUpldates1.size() > 0) {
            budgetCostService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetCostEntity cdEntity : saveOrUpldates1) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetCostEntity cdEntity : saveOrUpldates1) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            budgetCostService.saveOrUpdateBatch(saveOrUpldates1, saveOrUpldates1.size(), false);
        }
        if (deleteIds1.size() > 0) {
            budgetCostService.removeByIds(deleteIds1, false);
        }
    }

    private ImportVo excelImportZzyj(List<List<String>> result, BudgetEntity entity) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetDetailVO> detailVoList = new ArrayList<>();
            List<String> subjectList = new ArrayList<>();
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetDetailVO detailVO = new BudgetDetailVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                Pattern pattern = Pattern.compile("(-?\\d+\\.?\\d*)[Ee]{1}[\\+-]?[0-9]*");
                boolean isMache = pattern.matcher(indexCode.trim()).matches();
                if(isMache) {
                    indexCode = new BigDecimal(indexCode).toPlainString();
                }
                String code = datas.get(1);
                String name = datas.get(2);
                String feature = datas.get(3);
                String unit = datas.get(4);
                String content = datas.get(5);
                String num = datas.get(6);
                String price = datas.get(7);
                String mny = datas.get(8);
                String str = datas.get(9);

                if (StringUtils.isNotEmpty(str)) {
                    int index = 0;
                    for (int j = 0; j < str.length(); j++) {
                        if (!Character.isDigit(str.charAt(j))) {
                            index = j;
                            break;
                        }
                    }
                    String subject = str.substring(index).trim();
                    if (StringUtils.isNotEmpty(subject)) {
                        detailVO.setDetailSubjectName(subject);
                    }
                }
                Long id = IdWorker.getId();
                detailVO.setId(id);
                detailVO.setBudgetId(entity.getId());

                //detailVO.setDetailSubjectName(subject);
                if (StringUtils.isEmpty(code)) {// 编码为空
                    detailVO.setDetailCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    if (SubjectEnum.增值税.getSubjectCode().equals(code)) {
                        continue;
                    } else {
                        if (SubjectEnum.getCodeList().contains(code)) {
                            detailVO.setDetailSubjectName(SubjectEnum.getNameByCode(code));
                        }
                    }
                    detailVO.setDetailCode(code);
                }

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    detailVO.setIndexCode(indexCode);
                    parentMap.put(indexCode, id);
                    String[] split = indexCode.split("[-/.]");
                    detailVO.setNodeLevel(split.length);
                    if (split.length > 1) {
                        detailVO.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                    }
                    detailVO.setDetailIndex(i + "");
                    if (split.length > 3) {
                        warnType = warnType + "[序号只支持三级结构]";
                        flag = true;
                    }
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                } else {
                    detailVO.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                    detailVO.setNodeLevel(0);
                }

                if (StringUtils.isEmpty(name)) {//名称为空
                    detailVO.setDetailName(null);
                    warnType = warnType + "[名称为空]";
                    flag = true;
                } else {
                    detailVO.setDetailName(name);
                }
                detailVO.setDetailSpec(feature);
                detailVO.setDetailUnit(unit);//计量单位
                if (StringUtils.isEmpty(content)) {
                    if(detailVO.getNodeLevel()==3){
                        detailVO.setContent(BigDecimal.ZERO);
                    }else{
                        detailVO.setContent(BigDecimal.ONE);
                    }
                } else {
                    try {
                        detailVO.setContent(new BigDecimal(content));
                    } catch (Exception e) {
                        detailVO.setContent(null);
                        warnType = warnType + "[含量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(num)) {
                    detailVO.setDetailNum(null);
                    if (detailVO.getNodeLevel() == 1) {
                        warnType = warnType + "[一级工程量不能为空]";
                        flag = true;
                    }
                } else {
                    try {
                        detailVO.setDetailNum(new BigDecimal(num));
                    } catch (Exception e) {
                        detailVO.setDetailNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(price)) {
                    detailVO.setDetailPrice(BigDecimal.ZERO);
                } else {
                    try {
                        detailVO.setDetailPrice(new BigDecimal(price));
                    } catch (Exception e) {
                        detailVO.setDetailPrice(null);
                        warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty(mny)) {
                    detailVO.setDetailMny(BigDecimal.ZERO);
                } else {
                    try {
                        detailVO.setDetailMny(new BigDecimal(mny));
                    } catch (Exception e) {
                        detailVO.setDetailMny(null);
                        warnType = warnType + "[合价(无税)只能为数字或小数]";
                        flag = true;
                    }
                }
                detailVO.setImportFlag(!flag);// true=可以导入，false=不可导入
                detailVO.setWarnType(warnType);
                detailVoList.add(detailVO);
                if (StringUtils.isNotEmpty(detailVO.getDetailSubjectName())) {
                    subjectList.add(detailVO.getDetailSubjectName());
                }
            }
            Map<String, Long> subjectMap = new HashMap<>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter(QueryParam.IN, subjectList));
                CommonResponse<List<SubjectOrgVO>> commonResponse = subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List<SubjectOrgVO> data = commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("成本科目查询失败!");
                }
            }
            List<BudgetDetailVO> successList = new ArrayList<>();
            for (BudgetDetailVO vo : detailVoList) {
                String indexCode = vo.getIndexCode();
                Boolean leafFlag = true;
                if (vo.getNodeLevel() != 1 && indexCode != null) {
                    for (String code : detailIndexList) {
                        if (code.startsWith(indexCode) && !code.equals(indexCode)) {
                            String sub = code.substring(indexCode.length(), indexCode.length() + 1);
                            if ("-/.".indexOf(sub) != -1) {
                                leafFlag = false;
                                break;
                            }
                        }
                    }
                }
                vo.setLeafFlag(leafFlag);
                if (!parentMap.containsKey(vo.getTpid()) && vo.getNodeLevel() != 1) {
                    if (vo.getTpid() != null) {
                        vo.setWarnType(vo.getWarnType() + "[缺少序号'" + vo.getTpid() + "'无法形成三级结构]");
                    }
                    vo.setImportFlag(false);// true=可以导入，false=不可导入
                }
                if (leafFlag && vo.getNodeLevel() != 1) {
                    // 孙表末级
                    if (vo.getDetailPrice() == null) {
                        vo.setWarnType(vo.getWarnType() + "[清单明细末级综合单价(无税)不能为空]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                    }
                    if (vo.getDetailMny() == null) {
                        vo.setWarnType(vo.getWarnType() + "[清单明细末级合价(无税)不能为空]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                    }
                }
                if (StringUtils.isNotEmpty(vo.getDetailSubjectName())) {
                    if (subjectMap.containsKey(vo.getDetailSubjectName())) {
                        vo.setDetailSubjectId(subjectMap.get(vo.getDetailSubjectName()));
                    } else {
                        vo.setDetailSubjectId(null);
                        vo.setDetailSubjectName(null);
                        //vo.setWarnType(vo.getWarnType() + "[该成本科目不存在]");
                        //vo.setImportFlag(false);// true=可以导入，false=不可导入
                    }
                }
                if (!vo.getImportFlag()) {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("分部分项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getDetailCode());
                    errorVo.setName(vo.getDetailName());
                    errorVo.setUnit(vo.getDetailUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                } else {
                    vo.setParentId(parentMap.get(vo.getTpid()));
                    if (!leafFlag) {
                        vo.setContent(null);
                        vo.setDetailNum(null);
                        vo.setDetailPrice(null);
                        vo.setDetailMny(null);
                    } else {
                        vo.setDetailTaxRate(entity.getTaxRate());
                    }
                    successList.add(vo);
                }
            }
            res.setErrorList(errorList);
            if (errorList.size() <= 0) {
                res.setDetailList(dealContent(successList));
            }

        }
        return res;
    }

    private ImportVo excelImportMeasure(List<List<String>> result, BudgetEntity entity) {
        return excelImportMeasure(result, entity, 0);
    }

    private ImportVo excelImportMeasure(List<List<String>> result, BudgetEntity entity, Integer priceType) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        Set<String> compositiveCoefficientNames = new HashSet<>();
        Set<String> parentIndex = new HashSet<>();
        Integer rootItemIndex = 0; //树根节点序号
        BigDecimal hundred = new BigDecimal("100");
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetMeasureVO> detailVoList = new ArrayList<>();
            List<String> subjectList = new ArrayList<>();
            boolean importFlag = true;
            String indexCode = null;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetMeasureVO vo = new BudgetMeasureVO();
                boolean flag = false;
                String warnType = "";

                String code = datas.get(0); //序号
                String costCode = datas.get(1); //编码
                String costName = datas.get(2); //名称
                String feeFeature = null;//datas.get(3); //特征
                String costUnit = datas.get(3); //单位
                String costNum = datas.get(4); //工程量
                String costTaxPrice = datas.get(5); //综合单价（含税）
                String costTaxMny = datas.get(6); //合价（含税）
                BigDecimal costTaxRate = entity.getTaxRate();
                String subjectName = datas.get(7); //成本科目
                String compositiveCoefficient = datas.get(8); //综合系数

                //设置成本科目名称
                if (StringUtils.isNotEmpty(subjectName)) {
                    int index = 0;
                    for (int j = 0; j < subjectName.length(); j++) {
                        if (!Character.isDigit(subjectName.charAt(j))) {
                            index = j;
                            break;
                        }
                    }
                    String subject = subjectName.substring(index).trim();
                    if (StringUtils.isNotEmpty(subject)) {
                        vo.setMeasureSubjectName(subject);
                    }
                }
                //设置综合系数名称
                if(StringUtils.isBlank(compositiveCoefficient)) {
                    compositiveCoefficient = "默认系数";
                }
                vo.setMeasureCompositiveCoefficientName(compositiveCoefficient);
                compositiveCoefficientNames.add(vo.getMeasureCompositiveCoefficientName());
                vo.setMeasurePriceType(priceType);

                Long id = IdWorker.getId();
                //设置行Id
                vo.setId(id);
                //设置所属预算书Id
                vo.setBudgetId(entity.getId());

                indexCode = code;
                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格

                    if(indexCode.indexOf(".") < 0) {
                        if(StringUtils.isBlank(costUnit) && StringUtils.isBlank(costNum)) {
                            continue;
                        }
                        detailIndexList.clear();
                        indexCode = (++rootItemIndex).toString();
                        parentMap.put(indexCode, id);
                    } else {
                        indexCode = rootItemIndex + indexCode.substring(indexCode.indexOf("."));
                    }

                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }


                if(!flag) {
                    vo.setIndexCode(indexCode);

                    if(indexCode.indexOf(".") > 0) {
                        vo.setTpid(indexCode.substring(0, indexCode.lastIndexOf(".")));
                        if(!parentMap.containsKey(vo.getTpid())) {
                            warnType = warnType + "[序号对应上级不存在]";
                            vo.setTpid(code.substring(0, code.lastIndexOf(".")-1));
                            flag = true;
                        } else {
                            parentMap.put(indexCode, id);
                            parentIndex.add(vo.getTpid());
                        }
                    }

                    //序号重复校验
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        vo.setIndexCode(code);
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                    vo.setDetailIndex(i + "");
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setMeasureCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
//                    if (SubjectEnum.增值税.getSubjectCode().equals(costCode)) {
//                        continue;
//                    } else {
//                        if (SubjectEnum.getCodeList().contains(costCode)) {
//                            vo.setMeasureSubjectName(SubjectEnum.getNameByCode(costCode));
//                        }
//                    }
                    vo.setMeasureCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setMeasureName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setMeasureName(costName);
                }
                vo.setMeasureFeature(feeFeature);
                vo.setMeasureUnit(costUnit);//计量单位

                if (StringUtils.isEmpty(costNum)) {
                    vo.setMeasureNum(null);
                } else {
                    try {
                        vo.setMeasureNum(new BigDecimal(costNum));
                    } catch (Exception e) {
                        vo.setMeasureNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setMeasureTaxRate(costTaxRate);

                if(vo.getMeasurePriceType() == 1) { //含税优先
                    if (StringUtils.isEmpty(costTaxPrice)) {
                        vo.setMeasureTaxPrice(null);
                    } else {
                        try {
                            vo.setMeasureTaxPrice(new BigDecimal(costTaxPrice));
                        } catch (Exception e) {
                            vo.setMeasureTaxPrice(null);
                            warnType = warnType + "[综合单价(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setMeasureTaxMny(null);
                    } else {
                        try {
                            vo.setMeasureTaxMny(new BigDecimal(costTaxMny));
                        } catch (Exception e) {
                            vo.setMeasureTaxMny(null);
                            warnType = warnType + "[合价(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else { //无税优先
                    if (StringUtils.isEmpty(costTaxPrice)) {
                        vo.setMeasurePrice(null);
                    } else {
                        try {
                            vo.setMeasurePrice(new BigDecimal(costTaxPrice));
                        } catch (Exception e) {
                            vo.setMeasurePrice(null);
                            warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setMeasureMny(null);
                    } else {
                        try {
                            vo.setMeasureMny(new BigDecimal(costTaxMny));
                        } catch (Exception e) {
                            vo.setMeasureMny(null);
                            warnType = warnType + "[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
                if (StringUtils.isNotEmpty(vo.getMeasureSubjectName())) {
                    subjectList.add(vo.getMeasureSubjectName());
                }
            }

            //成本科目档案查询
            Map<String, Long> subjectMap = new HashMap<>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter(QueryParam.IN, subjectList));
                CommonResponse<List<SubjectOrgVO>> commonResponse = subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List<SubjectOrgVO> data = commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("成本科目查询失败!");
                }
            }

            //查询综合系数信息
            Map<String, DefdocDetailVO> compositiveCoefficientMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(compositiveCoefficientNames)) {
                CommonResponse<List<DefdocDetailVO>> detailListResp = defdocApi.detailListByDetailNamesAndDocCode(
                        compositiveCoefficientNames.toArray(new String[compositiveCoefficientNames.size()]), BUDGET_COMPOSITIVE_COEFFICIENT);
                if(!detailListResp.isSuccess()) {
                    logger.error("综合系数：根据名称列表-{}，档案分类编码-{}查询匹配的档案项列表信息失败！", JSONObject.toJSONString(compositiveCoefficientNames), BUDGET_COMPOSITIVE_COEFFICIENT);
                    throw new BusinessException("综合系数自定义档案信息查询失败！");
                }
                compositiveCoefficientMap = detailListResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
            }

            List<BudgetMeasureVO> successList = new ArrayList<>();
            DefdocDetailVO compositiveCoefficient = null;
            Boolean leafFlag = true;
            for (BudgetMeasureVO vo : detailVoList) {
                leafFlag = !parentIndex.contains(vo.getIndexCode());
                vo.setLeafFlag(leafFlag);
                vo.setParentId(parentMap.get(vo.getTpid()));

                //设置综合系数
                if(StringUtils.isNotBlank(vo.getMeasureCompositiveCoefficientName())) {
                    if(compositiveCoefficientMap.containsKey(vo.getMeasureCompositiveCoefficientName())) {
                        compositiveCoefficient = compositiveCoefficientMap.get(vo.getMeasureCompositiveCoefficientName());
                        vo.setMeasureCompositiveCoefficientName(compositiveCoefficient.getName());
                        vo.setMeasureCompositiveCoefficientId(compositiveCoefficient.getId());
                        vo.setMeasureCompositiveCoefficient(new BigDecimal(compositiveCoefficient.getAttrCode()));
                        vo.setMeasureTaxRate(ComputeUtil.safeSub(hundred, vo.getMeasureCompositiveCoefficient())); //用综合系数算出税率：税率 = 100 - 综合系数
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[综合系数项不存在或未启用]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                        vo.setMeasureCompositiveCoefficient(null);
                    }
                }

                if (leafFlag) {
                    vo.setMeasureNum(vo.getMeasureNum() == null ? BigDecimal.ZERO : vo.getMeasureNum());
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getMeasureTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);
                    if(vo.getMeasurePriceType() == 1) { //含税优先
                        if (vo.getMeasureTaxPrice() == null) {
                            vo.setMeasureTaxPrice(BigDecimal.ZERO);
                        } else {
                            vo.setMeasurePrice(MathUtil.safeSub(vo.getMeasureTaxPrice(), MathUtil.safeMultiply(taxRate, vo.getMeasureTaxPrice())));
                        }
                        if (vo.getMeasureTaxMny() == null) {
                            vo.setMeasureTaxMny(BigDecimal.ZERO);
                        } else {
                            vo.setMeasureTax(MathUtil.safeMultiply(taxRate, vo.getMeasureTaxMny()));
                            vo.setMeasureMny(MathUtil.safeSub(vo.getMeasureTaxMny(), vo.getMeasureTax()));
                        }
                    } else {//无税优先
                        if (vo.getMeasurePrice() == null) {
                            vo.setMeasurePrice(BigDecimal.ZERO);
                        } else {
                            vo.setMeasureTaxPrice(MathUtil.safeMultiply(rate, vo.getMeasurePrice()));
                        }

                        if (vo.getMeasureMny() == null) {
                            vo.setMeasureTaxMny(BigDecimal.ZERO);
                        } else {
                            vo.setMeasureTaxMny(MathUtil.safeMultiply(rate, vo.getMeasureMny()));
                            vo.setMeasureTax(MathUtil.safeSub(vo.getMeasureTaxMny(), vo.getMeasureMny()));
                        }
                    }
                    vo.setMeasureItemType(ExcelDetailTypeEnum.其他_明细项.getCode());
                } else {
                    vo.setMeasureNum(null);
                    vo.setMeasureTaxRate(null);
                    vo.setMeasurePrice(null);
                    vo.setMeasureTaxPrice(null);
                    vo.setMeasureMny(null);
                    vo.setMeasureTaxMny(null);
                    vo.setMeasureTax(null);
                    vo.setMeasureItemType(ExcelDetailTypeEnum.其他_类别.getCode());
                }
                //设置成本科目
                if (StringUtils.isNotEmpty(vo.getMeasureSubjectName())) {
                    if (subjectMap.containsKey(vo.getMeasureSubjectName())) {
                        vo.setMeasureSubjectId(subjectMap.get(vo.getMeasureSubjectName()));
                    } else {
                        vo.setMeasureSubjectId(null);
                        vo.setMeasureSubjectName(null);
                        //vo.setWarnType(vo.getWarnType() + "[该成本科目不存在]");
                        //vo.setImportFlag(false);// true=可以导入，false=不可导入
                    }
                }

                if (vo.getImportFlag()) {
                    successList.add(vo);
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("措施项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getMeasureCode());
                    errorVo.setName(vo.getMeasureName());
                    errorVo.setUnit(vo.getMeasureUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setMeasureList(successList);
        }
        return res;
    }

    private ImportVo excelImportOther(List<List<String>> result, BudgetEntity entity) {
        return excelImportOther(result, entity, 0);
    }

    private ImportVo excelImportOther(List<List<String>> result, BudgetEntity entity, Integer priceType) {
        ImportVo res = new ImportVo();
        Set<String> compositiveCoefficientNames = new HashSet<>();
        List<ImportErrorVo> errorList = new ArrayList<>();
        Set<String> parentIndex = new HashSet<>();
        Integer rootIndex = 0;
        BigDecimal hundred = new BigDecimal("100");
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetOtherVO> detailVoList = new ArrayList<>();
            List<String> subjectList = new ArrayList<>();
            boolean importFlag = true;
            String indexCode = null;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetOtherVO vo = new BudgetOtherVO();
                boolean flag = false;
                String warnType = "";

                String code = datas.get(0); //序号
                String costCode = datas.get(1); //编码
                String costName = datas.get(2); //名称
                String feeFeature = "";//datas.get(3); //特征
                String costUnit = datas.get(3); //单位
                String costNum = datas.get(4); //工程量
                String costTaxPrice = datas.get(5); //综合单价（含税）
                String costTaxMny = datas.get(6); //合价（含税）
                String costSubjectName = datas.get(7); //成本科目
                String costPositiveCoefficientName = datas.get(8); //综合系数
                BigDecimal costTaxRate = entity.getTaxRate();

                //成本科目
                if (StringUtils.isNotEmpty(costSubjectName)) {
                    int index = 0;
                    for (int j = 0; j < costSubjectName.length(); j++) {
                        if (!Character.isDigit(costSubjectName.charAt(j))) {
                            index = j;
                            break;
                        }
                    }
                    costSubjectName = costSubjectName.substring(index).trim();
                    if (StringUtils.isNotEmpty(costSubjectName)) {
                        vo.setOtherSubjectName(costSubjectName);
                    }
                }

                //hangId
                Long id = IdWorker.getId();
                vo.setId(id);
                //所属预算书
                vo.setBudgetId(entity.getId());
                //综合系数
                if(StringUtils.isBlank(costPositiveCoefficientName)) {
                    costPositiveCoefficientName = "默认系数";
                }
                vo.setOtherCompositiveCoefficientName(costPositiveCoefficientName);
                compositiveCoefficientNames.add(costPositiveCoefficientName);
                vo.setOtherPriceType(priceType);

                indexCode = code;
                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格

                    if(indexCode.indexOf(".") < 0) {
                        if(StringUtils.isBlank(costUnit) && StringUtils.isBlank(costNum)) {
                            continue;
                        }
                        detailIndexList.clear();
                        indexCode = (++rootIndex).toString();
                        vo.setIndexCode(indexCode);
                        parentMap.put(indexCode, id);
                    } else {
                        indexCode = rootIndex + indexCode.substring(indexCode.indexOf("."));
                        vo.setIndexCode(indexCode);

                        vo.setTpid(indexCode.substring(0, indexCode.lastIndexOf(".")));
                        if(!parentMap.containsKey(vo.getTpid())) {
                            warnType = warnType + "[序号对应上级不存在]";
                            vo.setTpid(code.substring(0, code.lastIndexOf(".")));
                            flag = true;
                        } else {
                            parentMap.put(indexCode, id);
                            parentIndex.add(vo.getTpid());
                        }

                        //序号重复校验
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            vo.setIndexCode(code);
                            flag = true;
                        } else {
                            detailIndexList.add(indexCode);
                        }

                    }
                    vo.setDetailIndex(i + "");
                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setOtherCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
//                    if (SubjectEnum.增值税.getSubjectCode().equals(costCode)) {
//                        continue;
//                    } else {
//                        if (SubjectEnum.getCodeList().contains(costCode)) {
//                            vo.setOtherSubjectName(SubjectEnum.getNameByCode(costCode));
//                        }
//                    }
                    vo.setOtherCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setOtherName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setOtherName(costName);
                }
                vo.setOtherFeature(feeFeature);
                vo.setOtherUnit(costUnit);//计量单位

                //工程量
                if (StringUtils.isEmpty(costNum)) {
                    vo.setOtherNum(null);
                } else {
                    if(SX2JExcelImportHandlerUtil.validateDecimal(costNum)) {
                        vo.setOtherNum(new BigDecimal(costNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                    } else {
                        vo.setOtherNum(null);
                        warnType = warnType + "[工程量只能为数字或小数]";
                        flag = true;
                    }
                }
                vo.setOtherTaxRate(costTaxRate);
                if(vo.getOtherPriceType() == 1) { //含税优先
                    //综合单价（含税）
                    if (StringUtils.isEmpty(costTaxPrice)) {
                        vo.setOtherTaxPrice(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxPrice)) {
                            vo.setOtherTaxPrice(new BigDecimal(costTaxPrice).setScale(4, BigDecimal.ROUND_HALF_UP));
                        } else {
                            vo.setOtherTaxPrice(null);
                            warnType = warnType + "[综合单价(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    //合价（含税）
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setOtherTaxMny(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxMny)) {
                            vo.setOtherTaxMny(new BigDecimal(costTaxMny));
                        } else {
                            vo.setOtherTaxMny(null);
                            warnType = warnType + "[合价(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else { //无税优先
                    //综合单价（含税）
                    if (StringUtils.isEmpty(costTaxPrice)) {
                        vo.setOtherPrice(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxPrice)) {
                            vo.setOtherPrice(new BigDecimal(costTaxPrice).setScale(4, BigDecimal.ROUND_HALF_UP));
                        } else {
                            vo.setOtherPrice(null);
                            warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    //合价（含税）
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setOtherMny(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxMny)) {
                            vo.setOtherMny(new BigDecimal(costTaxMny));
                        } else {
                            vo.setOtherMny(null);
                            warnType = warnType + "[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
                if (StringUtils.isNotEmpty(vo.getOtherSubjectName())) {
                    subjectList.add(vo.getOtherSubjectName());
                }
            }
            Map<String, Long> subjectMap = new HashMap<>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter(QueryParam.IN, subjectList));
                CommonResponse<List<SubjectOrgVO>> commonResponse = subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List<SubjectOrgVO> data = commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("成本科目查询失败!");
                }
            }

            //查询综合系数信息
            Map<String, DefdocDetailVO> compositiveCoefficientMap = null;
            if(CollectionUtils.isNotEmpty(compositiveCoefficientNames)) {
                CommonResponse<List<DefdocDetailVO>> detailListResp = defdocApi.detailListByDetailNamesAndDocCode(
                        compositiveCoefficientNames.toArray(new String[compositiveCoefficientNames.size()]), BUDGET_COMPOSITIVE_COEFFICIENT);
                if(!detailListResp.isSuccess()) {
                    logger.error("综合系数：根据名称列表-{}，档案分类编码-{}查询匹配的档案项列表信息失败！", JSONObject.toJSONString(compositiveCoefficientNames), BUDGET_COMPOSITIVE_COEFFICIENT);
                    throw new BusinessException("综合系数自定义档案信息查询失败！");
                }
                compositiveCoefficientMap = detailListResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
            }

            List<BudgetOtherVO> successList = new ArrayList<>();
            DefdocDetailVO compositiveCoefficient = null;
            Boolean leafFlag = true;
            for (BudgetOtherVO vo : detailVoList) {
                leafFlag = !parentIndex.contains(vo.getIndexCode());
                vo.setLeafFlag(leafFlag);
                vo.setParentId(parentMap.get(vo.getTpid()));

                if(StringUtils.isNotBlank(vo.getOtherCompositiveCoefficientName())) {
                    if(compositiveCoefficientMap.containsKey(vo.getOtherCompositiveCoefficientName())) {
                        compositiveCoefficient = compositiveCoefficientMap.get(vo.getOtherCompositiveCoefficientName());
                        vo.setOtherCompositiveCoefficientName(compositiveCoefficient.getName());
                        vo.setOtherCompositiveCoefficientId(compositiveCoefficient.getId());
                        vo.setOtherCompositiveCoefficient(new BigDecimal(compositiveCoefficient.getAttrCode()));
                        vo.setOtherTaxRate(ComputeUtil.safeSub(hundred,new BigDecimal(compositiveCoefficient.getAttrCode()))); //用综合系数算出税率：税率 = 100 - 综合系数
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[综合系数项不存在或未启用]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                        vo.setOtherCompositiveCoefficient(null);
                    }
                }

                if (leafFlag) {
                    vo.setOtherNum(vo.getOtherNum() == null ? BigDecimal.ZERO : vo.getOtherNum());
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getOtherTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);

                    if(vo.getOtherPriceType() == 1) { //含税优先
                        if(vo.getOtherTaxPrice() == null) {
                            vo.setOtherTaxPrice(BigDecimal.ZERO);
                        } else {
                            vo.setOtherPrice(MathUtil.safeSub(vo.getOtherTaxPrice(), MathUtil.safeMultiply(taxRate, vo.getOtherTaxPrice())));
                        }

                        if(vo.getOtherTaxMny() == null) {
                            vo.setOtherTaxMny(BigDecimal.ZERO);
                        } else {
                            vo.setOtherTax(MathUtil.safeMultiply(taxRate, vo.getOtherTaxMny()));
                            vo.setOtherMny(MathUtil.safeSub(vo.getOtherTaxMny(), vo.getOtherTax()));
                        }
                    } else { //无税优先
                        if(vo.getOtherPrice() == null) {
                            vo.setOtherPrice(BigDecimal.ZERO);
                        } else {
                            vo.setOtherTaxPrice(MathUtil.safeMultiply(rate, vo.getOtherPrice()));
                        }

                        if(vo.getOtherMny() == null) {
                            vo.setOtherMny(BigDecimal.ZERO);
                        } else {
                            vo.setOtherTaxMny(MathUtil.safeMultiply(rate, vo.getOtherMny()));
                            vo.setOtherTax(MathUtil.safeSub(vo.getOtherTaxMny(), vo.getOtherMny()));
                        }
                    }
                    vo.setOtherItemType(ExcelDetailTypeEnum.其他_明细项.getCode());
                } else {
                    vo.setOtherNum(null);
                    vo.setOtherTaxRate(null);
                    vo.setOtherPrice(null);
                    vo.setOtherTaxPrice(null);
                    vo.setOtherMny(null);
                    vo.setOtherTaxMny(null);
                    vo.setOtherTax(null);
                    vo.setOtherItemType(ExcelDetailTypeEnum.其他_类别.getCode());
                }
                if (StringUtils.isNotEmpty(vo.getOtherSubjectName())) {
                    if (subjectMap.containsKey(vo.getOtherSubjectName())) {
                        vo.setOtherSubjectId(subjectMap.get(vo.getOtherSubjectName()));
                    } else {
                        vo.setOtherSubjectId(null);
                        vo.setOtherSubjectName(null);
                    }
                }

                if (vo.getImportFlag()) {
                    successList.add(vo);
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("其它清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getOtherCode());
                    errorVo.setName(vo.getOtherName());
                    errorVo.setUnit(vo.getOtherUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setOtherList(successList);
        }
        return res;
    }

    private ImportVo excelImportFee(List<List<String>> result, BudgetEntity entity) {
        return excelImportFee(result, entity, 0);
    }

    private ImportVo excelImportFee(List<List<String>> result, BudgetEntity entity, Integer priceType) {
        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        Set<String> compositiveCoefficientNames = new HashSet<>();
        Set<String> parentIndex = new HashSet<>();
        Integer rootIndex = 0;
        BigDecimal hundred = new BigDecimal("100");
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetFeeVO> detailVoList = new ArrayList<>();
            List<String> subjectList = new ArrayList<>();
            boolean importFlag = true;
            String indexCode = null;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetFeeVO vo = new BudgetFeeVO();
                boolean flag = false;
                String warnType = "";

                String code = datas.get(0); //序号
                String costCode = datas.get(1); //编码
                String costName = datas.get(2); //名称
                String feeFeature = "";  //特征
                String costTaxMny = datas.get(3); //金额
                BigDecimal costTaxRate = entity.getTaxRate();
                String subjectName = datas.get(4);
                String compositiveCoefficient = datas.get(5);

                if (StringUtils.isNotEmpty(subjectName)) {
                    int index = 0;
                    for (int j = 0; j < subjectName.length(); j++) {
                        if (!Character.isDigit(subjectName.charAt(j))) {
                            index = j;
                            break;
                        }
                    }
                    subjectName = subjectName.substring(index).trim();
                    if (StringUtils.isNotEmpty(subjectName)) {
                        vo.setFeeSubjectName(subjectName);
                    }
                }

                if(StringUtils.isBlank(compositiveCoefficient)) {
                    compositiveCoefficient = "默认系数";
                }
                vo.setFeeCompositiveCoefficientName(compositiveCoefficient);
                compositiveCoefficientNames.add(compositiveCoefficient);
                vo.setFeePriceType(priceType);

                //行Id
                Long id = IdWorker.getId();
                vo.setId(id);
                //所属预算书
                vo.setBudgetId(entity.getId());

                indexCode = code;
                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空

                    if(indexCode.indexOf(".") < 0) {
                        detailIndexList.clear();
                        indexCode = (++rootIndex).toString();
                        parentMap.put(indexCode, id);
                    } else {
                        indexCode = rootIndex + indexCode.substring(indexCode.indexOf("."));
                    }

                } else {
                    vo.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                }

                if(!flag) {
                    vo.setDetailIndex(i + "");
                    vo.setIndexCode(indexCode);
                    if(indexCode.indexOf(".") > 0) {
                        vo.setTpid(indexCode.substring(0, indexCode.lastIndexOf(".")));
                        if(!parentMap.containsKey(vo.getTpid())) {
                            warnType = warnType + "[序号对应上级不存在]";
                            vo.setTpid(code.substring(0, code.lastIndexOf(".")-1));
                            flag = true;
                        } else {
                            parentMap.put(indexCode, id);
                            parentIndex.add(vo.getTpid());
                        }
                    }

                    //序号重复校验
                    if (detailIndexList.contains(indexCode)) {
                        warnType = warnType + "[序号重复]";
                        vo.setIndexCode(code);
                        flag = true;
                    } else {
                        detailIndexList.add(indexCode);
                    }
                }

                if (StringUtils.isEmpty(costCode)) {// 编码为空
                    vo.setFeeCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
//                    if (SubjectEnum.增值税.getSubjectCode().equals(costCode)) {
//                        continue;
//                    } else {
//                        if (SubjectEnum.getCodeList().contains(costCode)) {
//                            vo.setFeeSubjectName(SubjectEnum.getNameByCode(costCode));
//                        }
//                    }
                    vo.setFeeCode(costCode);
                }

                if (StringUtils.isEmpty(costName)) {//名称为空
                    vo.setFeeName(null);
                    warnType = warnType + "[费用项名称为空]";
                    flag = true;
                } else {
                    vo.setFeeName(costName);
                }

                vo.setFeeFeature(feeFeature);
                vo.setFeeTaxRate(costTaxRate);

                if(vo.getFeePriceType() == 1) { //含税优先
                    //金额（含税）
                    if (StringUtils.isEmpty(costTaxMny)) {
                        vo.setFeeTaxMny(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxMny)) {
                            vo.setFeeTaxMny(new BigDecimal(costTaxMny).setScale(4, BigDecimal.ROUND_HALF_UP));
                        } else {
                            vo.setFeeTaxMny(null);
                            warnType = warnType + "[金额(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else {//无税优先
                    if(StringUtils.isEmpty(costTaxMny)) {
                        vo.setFeeMny(null);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(costTaxMny)) {
                            vo.setFeeMny(new BigDecimal(costTaxMny).setScale(4, BigDecimal.ROUND_HALF_UP));
                        } else {
                            vo.setFeeMny(null);
                            warnType = warnType + "[金额(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                }

                vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                if (importFlag) {// 如果能导入
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
                if (StringUtils.isNotEmpty(vo.getFeeSubjectName())) {
                    subjectList.add(vo.getFeeSubjectName());
                }
            }
            Map<String, Long> subjectMap = new HashMap<>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter(QueryParam.IN, subjectList));
                CommonResponse<List<SubjectOrgVO>> commonResponse = subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List<SubjectOrgVO> data = commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("成本科目查询失败!");
                }
            }

            //查询综合系数信息
            Map<String, DefdocDetailVO> compositiveCoefficientMap = null;
            if(CollectionUtils.isNotEmpty(compositiveCoefficientNames)) {
                CommonResponse<List<DefdocDetailVO>> detailListResp = defdocApi.detailListByDetailNamesAndDocCode(
                        compositiveCoefficientNames.toArray(new String[compositiveCoefficientNames.size()]), BUDGET_COMPOSITIVE_COEFFICIENT);
                if(!detailListResp.isSuccess()) {
                    logger.error("综合系数：根据名称列表-{}，档案分类编码-{}查询匹配的档案项列表信息失败！", JSONObject.toJSONString(compositiveCoefficientNames), BUDGET_COMPOSITIVE_COEFFICIENT);
                    throw new BusinessException("综合系数自定义档案信息查询失败！");
                }
                compositiveCoefficientMap = detailListResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
            }

            List<BudgetFeeVO> successList = new ArrayList<>();
            DefdocDetailVO compositiveCoefficient = null;
            Boolean leafFlag = true;
            for (BudgetFeeVO vo : detailVoList) {
                leafFlag = !parentIndex.contains(vo.getIndexCode());
                vo.setLeafFlag(leafFlag);
                vo.setParentId(parentMap.get(vo.getTpid()));

                //综合系数
                if(StringUtils.isNotBlank(vo.getFeeCompositiveCoefficientName())) {
                    if(compositiveCoefficientMap.containsKey(vo.getFeeCompositiveCoefficientName())) {
                        compositiveCoefficient = compositiveCoefficientMap.get(vo.getFeeCompositiveCoefficientName());
                        vo.setFeeCompositiveCoefficientName(compositiveCoefficient.getName());
                        vo.setFeeCompositiveCoefficientId(compositiveCoefficient.getId());
                        vo.setFeeCompositiveCoefficient(new BigDecimal(compositiveCoefficient.getAttrCode()));
                        vo.setFeeTaxRate(ComputeUtil.safeSub(hundred, vo.getFeeCompositiveCoefficient())); //用综合系数算出税率：税率 = 100 - 综合系数
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[综合系数项不存在或未启用]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                        vo.setFeeCompositiveCoefficientName(null);
                    }
                }

                if (leafFlag) {
                    BigDecimal taxRate = MathUtil.safeDiv(vo.getFeeTaxRate(), new BigDecimal("100"));
                    BigDecimal rate = MathUtil.safeAdd(taxRate, BigDecimal.ONE);

                    if(vo.getFeePriceType() == 1) {//含税优先
                        if (vo.getFeeTaxMny() == null) { //含税优先
                            vo.setFeeTaxMny(BigDecimal.ZERO);
                        } else { //无税优先
                            vo.setFeeTax(MathUtil.safeMultiply(taxRate, vo.getFeeTaxMny()));
                            vo.setFeeMny(MathUtil.safeSub(vo.getFeeTaxMny(), vo.getFeeTax()));
                        }
                    } else {//无税优先
                        if (vo.getFeeMny() == null) { //含税优先
                            vo.setFeeMny(BigDecimal.ZERO);
                        } else { //无税优先
                            vo.setFeeTaxMny(MathUtil.safeMultiply(rate, vo.getFeeMny()));
                            vo.setFeeTax(MathUtil.safeSub(vo.getFeeTaxMny(), vo.getFeeMny()));
                        }
                    }
                    vo.setFeeItemType(ExcelDetailTypeEnum.其他_明细项.getCode());
                } else {
                    vo.setFeeTaxRate(null);
                    vo.setFeeMny(null);
                    vo.setFeeTaxMny(null);
                    vo.setFeeTax(null);
                    vo.setFeeItemType(ExcelDetailTypeEnum.其他_类别.getCode());
                }
                //成本科目
                if (StringUtils.isNotEmpty(vo.getFeeSubjectName())) {
                    if (subjectMap.containsKey(vo.getFeeSubjectName())) {
                        vo.setFeeSubjectId(subjectMap.get(vo.getFeeSubjectName()));
                    } else {
                        vo.setFeeSubjectId(null);
                        vo.setFeeSubjectName(null);
                    }
                }

                if (vo.getImportFlag()) {
                    successList.add(vo);
                } else {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("费税项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getFeeCode());
                    errorVo.setName(vo.getFeeName());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                }
            }
            res.setErrorList(errorList);
            res.setFeeList(successList);
        }
        return res;
    }

    private List<BudgetDetailVO> dealContent(List<BudgetDetailVO> list) {
        Map<String, BudgetDetailVO> map = new HashMap<>();
        for (BudgetDetailVO vo : list) {
            map.put(vo.getIndexCode(), vo);
        }
        BudgetDetailVO parent = null;
        for (BudgetDetailVO vo : list) {
            String[] split = vo.getIndexCode().split("[-/.]");
            BudgetDetailVO detailVO = map.get(split[0]);
            parent = map.get(vo.getTpid());
            if(split.length > 2) {
                detailVO = map.get(split[0]+"."+split[1]);
                vo.setBudgetBid(detailVO.getId());

                if(null == vo.getContent()) {

                }

//            }
//            if (vo.getNodeLevel() > 2) {
                BigDecimal pnum = parent.getDetailNum();
                if(pnum == null) {
                    pnum = BigDecimal.ZERO;
                }
                BigDecimal num = MathUtil.safeMultiply(pnum, vo.getContent());
                BigDecimal taxRate = MathUtil.safeDiv(vo.getDetailTaxRate(), new BigDecimal("100"));
                BigDecimal rate = MathUtil.safeSub(BigDecimal.ONE, taxRate);

                if(1 == vo.getDetailPriceType()) { //含税优先
                    if(null == vo.getDetailTaxPrice()) {
                        vo.setDetailTaxPrice(BigDecimal.ZERO);
                    } else {
                        vo.setDetailPrice(MathUtil.safeSub(vo.getDetailTaxPrice(), MathUtil.safeMultiply(taxRate, vo.getDetailTaxPrice())));
                    }
                    if(null == vo.getDetailTaxMny()) {
                        vo.setDetailTaxMny(BigDecimal.ZERO);
                    } else {
                        vo.setDetailTax(MathUtil.safeMultiply(taxRate, vo.getDetailTaxMny()));
                        vo.setDetailMny(MathUtil.safeSub(vo.getDetailTaxMny(), vo.getDetailTax()));
                    }
                } else { //无税优先
                    if(null == vo.getDetailPrice()) {
                        vo.setDetailPrice(BigDecimal.ZERO);
                    } else {
                        vo.setDetailTaxPrice(MathUtil.safeMultiply(rate, vo.getDetailPrice()));
                    }
                    if(null == vo.getDetailMny()) {
                        vo.setDetailMny(BigDecimal.ZERO);
                    } else {
                        vo.setDetailTaxMny(MathUtil.safeMultiply(rate, vo.getDetailMny()));
                        vo.setDetailTax(MathUtil.safeSub(vo.getDetailTaxMny(), vo.getDetailMny()));
                    }
                }
                vo.setDetailNum(num);
            }
        }
        // list转树
        List<BudgetDetailVO> subVOS = TreeNodeBUtil.buildTree(list);
        // 向上汇总金额
        new UpSumUtil<BudgetDetailVO>().upSum(subVOS, "detailMny", "detailTaxMny", "detailTax");
        // 树转list
        List<BudgetDetailVO> budgetVOS = new UpSumUtil<BudgetDetailVO>().treeToList(subVOS);

        return budgetVOS;
    }


    @Override
    public CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (StringUtils.isNotEmpty(request.getParameter("budgetId"))) {
            budgetId = Long.valueOf(request.getParameter("budgetId"));
        } else {
            return CommonResponse.error("预算书主键为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size == null) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
            if (result0.size() > 0 && result0.get(0).size() < 10) {
                return CommonResponse.error("[分部分项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result1 = resList.get(1);
            if (result1.size() > 0 && result1.get(0).size() < 9) {
                return CommonResponse.error("[措施项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(2);
            if (result2.size() > 0 && result2.get(0).size() < 9) {
                return CommonResponse.error("[其它项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(3);
            if (result3.size() > 0 && result3.get(0).size() < 6) {
                return CommonResponse.error("[费税项清单]数据不完整，请下载最新模板！");
            }

            BudgetEntity entity = baseMapper.selectById(budgetId);
            ImportVo importVo = excelImportZzyj(result0, entity);
            ImportVo importVo1 = excelImportMeasure(result1, entity);
            ImportVo importVo2 = excelImportOther(result2, entity);
            ImportVo importVo3 = excelImportFee(result3, entity);

            List<ImportErrorVo> errorList = new ArrayList<>();
            errorList.addAll(importVo.getErrorList());
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());

            //List<ImportErrorVo> errorList = importVo.getErrorList();
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", 0);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<BudgetDetailVO> successList = importVo.getDetailList();
                // 计算合计
                BigDecimal subTotalMny = BigDecimal.ZERO;
                BigDecimal subTotalTaxMny = BigDecimal.ZERO;
                BigDecimal subTotalTax = BigDecimal.ZERO;
                List<BudgetSubEntity> subList = new ArrayList<>();
                List<BudgetDetailVO> detailList = new ArrayList<>();
                for (BudgetDetailVO bv : successList) {
                    if (bv.getNodeLevel() == 1) {
                        BudgetSubEntity subVo = new BudgetSubEntity();
                        subVo.setId(bv.getId());
                        subVo.setBudgetId(bv.getBudgetId());
                        subVo.setParentId(bv.getParentId());
                        subVo.setDetailIndex(bv.getDetailIndex());
                        subVo.setSubCode(bv.getDetailCode());
                        subVo.setSubName(bv.getDetailName());
                        subVo.setSubFeature(bv.getDetailSpec());
                        subVo.setSubUnit(bv.getDetailUnit());
                        subVo.setSubNum(bv.getDetailNum());
                        subVo.setSubTaxRate(bv.getDetailTaxRate());
                        subVo.setSubPrice(MathUtil.safeDiv(bv.getDetailMny(), bv.getDetailNum()));
                        subVo.setSubTaxPrice(MathUtil.safeDiv(bv.getDetailTaxMny(), bv.getDetailNum()));
                        subVo.setSubMny(bv.getDetailMny());
                        subVo.setSubTaxMny(bv.getDetailTaxMny());
                        subVo.setSubTax(bv.getDetailTax());
                        subVo.setSubMemo(bv.getDetailMemo());
                        subVo.setLeafFlag(bv.getLeafFlag());
                        subVo.setTid(bv.getTid());
                        subVo.setTpid(bv.getTpid());
                        subVo.setSubSubjectId(bv.getDetailSubjectId());
                        subVo.setSubSubjectName(bv.getDetailSubjectName());
                        subList.add(subVo);
                        subTotalMny = MathUtil.safeAdd(subTotalMny, subVo.getSubMny());
                        subTotalTaxMny = MathUtil.safeAdd(subTotalTaxMny, subVo.getSubTaxMny());
                        subTotalTax = MathUtil.safeAdd(subTotalTax, subVo.getSubTax());
                    } else {
                        if (bv.getNodeLevel() == 2) {
                            bv.setParentId(null);
                        }
                        detailList.add(bv);
                    }
                }

                List<BudgetMeasureVO> measureList = importVo1.getMeasureList();
                // 价税分离
                //new TaxCalculateUtil<BudgetMeasureVO>().calculate(measureList);
                // list转树
                List<BudgetMeasureVO> measureVOS = TreeNodeBUtil.buildTree(measureList);
                // 向上汇总金额
                new UpSumUtil<BudgetMeasureVO>().upSum(measureVOS, "measureMny", "measureTaxMny", "measureTax");
                // 计算合计
                BigDecimal measureTotalMny = BigDecimal.ZERO;
                BigDecimal measureTotalTaxMny = BigDecimal.ZERO;
                BigDecimal measureTotalTax = BigDecimal.ZERO;
                for (BudgetMeasureVO bv : measureVOS) {
                    measureTotalMny = MathUtil.safeAdd(measureTotalMny, bv.getMeasureMny());
                    measureTotalTaxMny = MathUtil.safeAdd(measureTotalTaxMny, bv.getMeasureTaxMny());
                    measureTotalTax = MathUtil.safeAdd(measureTotalTax, bv.getMeasureTax());
                }
                // 树转list
                List<BudgetMeasureVO> budgetMeasureVOS = new UpSumUtil<BudgetMeasureVO>().treeToList(measureVOS);

                List<BudgetOtherVO> otherList = importVo2.getOtherList();
                // 价税分离
                //new TaxCalculateUtil<BudgetOtherVO>().calculate(otherList);
                // list转树
                List<BudgetOtherVO> otherVOS = TreeNodeBUtil.buildTree(otherList);
                // 向上汇总金额
                new UpSumUtil<BudgetOtherVO>().upSum(otherVOS, "otherMny", "otherTaxMny", "otherTax");
                // 计算合计
                BigDecimal otherTotalMny = BigDecimal.ZERO;
                BigDecimal otherTotalTaxMny = BigDecimal.ZERO;
                BigDecimal otherTotalTax = BigDecimal.ZERO;
                for (BudgetOtherVO bv : otherVOS) {
                    otherTotalMny = MathUtil.safeAdd(otherTotalMny, bv.getOtherMny());
                    otherTotalTaxMny = MathUtil.safeAdd(otherTotalTaxMny, bv.getOtherTaxMny());
                    otherTotalTax = MathUtil.safeAdd(otherTotalTax, bv.getOtherTax());
                }
                // 树转list
                List<BudgetOtherVO> budgetOtherVOS = new UpSumUtil<BudgetOtherVO>().treeToList(otherVOS);

                List<BudgetFeeVO> feeList = importVo3.getFeeList();
                // 价税分离
                //new TaxCalculateUtil<BudgetFeeVO>().calculate(feeList);
                // list转树
                List<BudgetFeeVO> feeVOS = TreeNodeBUtil.buildTree(feeList);
                // 向上汇总金额
                new UpSumUtil<BudgetFeeVO>().upSum(feeVOS, "feeMny", "feeTaxMny", "feeTax");
                // 计算合计
                BigDecimal feeTotalMny = BigDecimal.ZERO;
                BigDecimal feeTotalTaxMny = BigDecimal.ZERO;
                BigDecimal feeTotalTax = BigDecimal.ZERO;
                for (BudgetFeeVO bv : feeVOS) {
                    feeTotalMny = MathUtil.safeAdd(feeTotalMny, bv.getFeeMny());
                    feeTotalTaxMny = MathUtil.safeAdd(feeTotalTaxMny, bv.getFeeTaxMny());
                    feeTotalTax = MathUtil.safeAdd(feeTotalTax, bv.getFeeTax());
                }
                // 树转list
                List<BudgetFeeVO> budgetFeeVOS = new UpSumUtil<BudgetFeeVO>().treeToList(feeVOS);

                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", successList.size() + budgetMeasureVOS.size() + budgetOtherVOS.size() + budgetFeeVOS.size());
                resp.put("errorNum", 0);

                budgetDetailService.delDetailByBudgetId(budgetId);
                if (detailList.size() > 0) {
                    List<BudgetDetailEntity> detailEntities = BeanMapper.mapList(detailList, BudgetDetailEntity.class);
                    budgetDetailService.saveOrUpdateBatch(detailEntities, detailEntities.size(), false);
                }

                budgetSubService.delSubByBudgetId(budgetId);
                if (subList.size() > 0) {
                    budgetSubService.saveOrUpdateBatch(subList, subList.size(), false);
                }

                budgetMeasureService.delMeasureByBudgetId(budgetId);
                if (budgetMeasureVOS.size() > 0) {
                    List<BudgetMeasureEntity> budgetMeasureEntities = BeanMapper.mapList(budgetMeasureVOS, BudgetMeasureEntity.class);
                    budgetMeasureService.saveOrUpdateBatch(budgetMeasureEntities, budgetMeasureEntities.size(), false);
                }
                budgetOtherService.delOtherByBudgetId(budgetId);
                if (budgetOtherVOS.size() > 0) {
                    List<BudgetOtherEntity> budgetOtherEntities = BeanMapper.mapList(budgetOtherVOS, BudgetOtherEntity.class);
                    budgetOtherService.saveOrUpdateBatch(budgetOtherEntities, budgetOtherEntities.size(), false);
                }
                budgetFeeService.delFeeByBudgetId(budgetId);
                if (budgetFeeVOS.size() > 0) {
                    List<BudgetFeeEntity> budgetFeeEntities = BeanMapper.mapList(budgetFeeVOS, BudgetFeeEntity.class);
                    budgetFeeService.saveOrUpdateBatch(budgetFeeEntities, budgetFeeEntities.size(), false);
                }

                BigDecimal budgetMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalMny, measureTotalMny), MathUtil.safeAdd(otherTotalMny, feeTotalMny));
                BigDecimal budgetTaxMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTaxMny, measureTotalTaxMny), MathUtil.safeAdd(otherTotalTaxMny, feeTotalTaxMny));
                BigDecimal budgetTax = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTax, measureTotalTax), MathUtil.safeAdd(otherTotalTax, feeTotalTax));
                LambdaUpdateWrapper<BudgetEntity> lambd = new LambdaUpdateWrapper<>();
                lambd.set(BudgetEntity::getSubTotalMny, subTotalMny);
                lambd.set(BudgetEntity::getSubTotalTaxMny, subTotalTaxMny);
                lambd.set(BudgetEntity::getSubTotalTax, subTotalTax);
                lambd.set(BudgetEntity::getMeasureTotalMny, measureTotalMny);
                lambd.set(BudgetEntity::getMeasureTotalTaxMny, measureTotalTaxMny);
                lambd.set(BudgetEntity::getMeasureTotalTax, measureTotalTax);
                lambd.set(BudgetEntity::getOtherTotalMny, otherTotalMny);
                lambd.set(BudgetEntity::getOtherTotalTaxMny, otherTotalTaxMny);
                lambd.set(BudgetEntity::getOtherTotalTax, otherTotalTax);
                lambd.set(BudgetEntity::getFeeTotalMny, feeTotalMny);
                lambd.set(BudgetEntity::getFeeTotalTaxMny, feeTotalTaxMny);
                lambd.set(BudgetEntity::getFeeTotalTax, feeTotalTax);
                lambd.set(BudgetEntity::getBudgetMny, budgetMny);
                lambd.set(BudgetEntity::getBudgetTaxMny, budgetTaxMny);
                lambd.set(BudgetEntity::getBudgetTax, budgetTax);
                lambd.eq(BudgetEntity::getId, budgetId);
                super.update(lambd);

            }
            return CommonResponse.success(resp);
        }
    }

    @Override
    public List<BudgetReportVO> querySumBudgetMny(Long projectId,String beginPeriod,String endDate) {
        LambdaQueryWrapper<BudgetEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetEntity::getDr, 0);
        wrapper.eq(BudgetEntity::getProjectId, projectId);
        wrapper.in(BudgetEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetEntity> entityList = super.list(wrapper);
        if (CollectionUtils.isEmpty(entityList)) {
            return new ArrayList<>();
        }
        List<Long> budegtIds = entityList.stream().map(BudgetEntity::getId).collect(Collectors.toList());

        List<BudgetSubEntity> subList = budgetSubService.querySubByBudgetIds(budegtIds);
        List<BudgetMeasureEntity> measureList = budgetMeasureService.queryMeasureByBudgetIds(budegtIds);
        List<BudgetOtherEntity> otherList = budgetOtherService.queryOtherByBudgetIds(budegtIds);
        List<BudgetFeeEntity> feeList = budgetFeeService.queryFeeByBudgetIds(budegtIds);
        List<BudgetCostEntity> costList = budgetCostService.queryCostByBudgetIds(budegtIds);
        List<BudgetDetailEntity> detailList = budgetDetailService.queryDetailByBudgetIds(budegtIds);
        Map<Long, BudgetReportVO> resMap = new HashMap<>();

        Map<Long, BudgetSubEntity> subMap = new HashMap<>();
        for (BudgetSubEntity entity : subList) {
            Long subjectId = entity.getSubSubjectId();
            if (subjectId != null && subjectId > 0) {
                subMap.put(entity.getId(), entity);
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getSubMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getSubTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getSubNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getSubSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getSubMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getSubTaxMny());
                    reportVO.setYsNumAll(entity.getSubNum());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        Map<Long, BudgetMeasureEntity> measureMap = new HashMap<>();
        for (BudgetMeasureEntity entity : measureList) {
            Long subjectId = entity.getMeasureSubjectId();
            if (subjectId != null && subjectId > 0) {
                measureMap.put(entity.getId(), entity);
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getMeasureMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getMeasureTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getMeasureNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getMeasureSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getMeasureMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getMeasureTaxMny());
                    reportVO.setYsNumAll(entity.getMeasureNum());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        Map<Long, BudgetOtherEntity> otherMap = new HashMap<>();
        for (BudgetOtherEntity entity : otherList) {
            Long subjectId = entity.getOtherSubjectId();
            if (subjectId != null && subjectId > 0) {
                otherMap.put(entity.getId(), entity);
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getOtherMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getOtherTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getOtherNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getOtherSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getOtherMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getOtherTaxMny());
                    reportVO.setYsNumAll(entity.getOtherNum());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        Map<Long, BudgetFeeEntity> feeMap = new HashMap<>();
        for (BudgetFeeEntity entity : feeList) {
            Long subjectId = entity.getFeeSubjectId();
            if (subjectId != null && subjectId > 0) {
                feeMap.put(entity.getId(), entity);
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getFeeMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getFeeTaxMny());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getFeeSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getFeeMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getFeeTaxMny());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        Map<Long, BudgetCostEntity> costMap = new HashMap<>();
        for (BudgetCostEntity entity : costList) {
            Long subjectId = entity.getCostSubjectId();
            if (subjectId != null && subjectId > 0) {
                costMap.put(entity.getId(), entity);
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getCostMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getCostTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getCostNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getCostSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getCostMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getCostTaxMny());
                    reportVO.setYsNumAll(entity.getCostNum());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        for (BudgetDetailEntity entity : detailList) {
            Long subjectId = entity.getDetailSubjectId();
            if (subjectId != null && subjectId > 0) {
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getDetailMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getDetailTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getDetailNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    resMap.put(subjectId, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getDetailSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getDetailMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getDetailTaxMny());
                    reportVO.setYsNumAll(entity.getDetailNum());
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        // 日期
        LambdaQueryWrapper<ProductionEntity> peoductionLambd = new LambdaQueryWrapper<>();
        peoductionLambd.eq(ProductionEntity::getDr, 0);
        peoductionLambd.eq(ProductionEntity::getProjectId, projectId);
        peoductionLambd.in(ProductionEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        if (StringUtils.isNotEmpty(endDate)) {
            beginPeriod = beginPeriod + "-1";
            endDate = endDate + "-31";
            peoductionLambd.ge(ProductionEntity::getProductionDate, beginPeriod);
            peoductionLambd.le(ProductionEntity::getProductionDate, endDate);
        }
        List<ProductionEntity> productionEntities = productionService.list(peoductionLambd);
        if (CollectionUtils.isEmpty(productionEntities)) {
            return new ArrayList<>(resMap.values());
        }
        List<Long> productionIds = productionEntities.stream().map(ProductionEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ProductionDetailEntity> peoduDetailLambd = new LambdaQueryWrapper<>();
        peoduDetailLambd.eq(ProductionDetailEntity::getDr, 0);
        peoduDetailLambd.in(ProductionDetailEntity::getProductionId, productionIds);
        List<ProductionDetailEntity> productionDetails = productionDetailService.list(peoduDetailLambd);
        if (CollectionUtils.isEmpty(productionDetails)) {
            return new ArrayList<>(resMap.values());
        }
        List<Long> proDetailIds = productionDetails.stream().map(ProductionDetailEntity::getId).collect(Collectors.toList());

        LambdaQueryWrapper<ProductionDetailSubEntity> proSubLambd = new LambdaQueryWrapper<>();
        proSubLambd.eq(ProductionDetailSubEntity::getDr, 0);
        proSubLambd.in(ProductionDetailSubEntity::getDetailId, proDetailIds);
        List<ProductionDetailSubEntity> subDetails = productionDetailSubService.list(proSubLambd);

        LambdaQueryWrapper<ProductionDetailMeasureEntity> proMeasureLambd = new LambdaQueryWrapper<>();
        proMeasureLambd.eq(ProductionDetailMeasureEntity::getDr, 0);
        proMeasureLambd.in(ProductionDetailMeasureEntity::getDetailId, proDetailIds);
        List<ProductionDetailMeasureEntity> measureDetails = productionDetailMeasureService.list(proMeasureLambd);

        LambdaQueryWrapper<ProductionDetailOtherEntity> proOtherLambd = new LambdaQueryWrapper<>();
        proOtherLambd.eq(ProductionDetailOtherEntity::getDr, 0);
        proOtherLambd.in(ProductionDetailOtherEntity::getDetailId, proDetailIds);
        List<ProductionDetailOtherEntity> otherDetails = productionDetailOtherService.list(proOtherLambd);

        LambdaQueryWrapper<ProductionDetailFeeEntity> proFeeLambd = new LambdaQueryWrapper<>();
        proFeeLambd.eq(ProductionDetailFeeEntity::getDr, 0);
        proFeeLambd.in(ProductionDetailFeeEntity::getDetailId, proDetailIds);
        List<ProductionDetailFeeEntity> feeDetails = productionDetailFeeService.list(proFeeLambd);

        LambdaQueryWrapper<ProductionDetailCostEntity> proCostLambd = new LambdaQueryWrapper<>();
        proCostLambd.eq(ProductionDetailCostEntity::getDr, 0);
        proCostLambd.in(ProductionDetailCostEntity::getDetailId, proDetailIds);
        List<ProductionDetailCostEntity> costDetails = productionDetailCostService.list(proCostLambd);

        Map<Long, List<ProductionDetailSubEntity>> proSubMap = new HashMap<>();
        for (ProductionDetailSubEntity entity : subDetails) {
            if (subMap.containsKey(entity.getBudgetDetailId())) {
                BudgetSubEntity bentity = subMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getSubSubjectId();
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(subjectId, reportVO);
                }
            }
            Long budgetDetailId = entity.getBudgetDetailId();
            if (proSubMap.containsKey(budgetDetailId)) {
                List<ProductionDetailSubEntity> plist = proSubMap.get(budgetDetailId);
                plist.add(entity);
                proSubMap.put(budgetDetailId, plist);
            } else {
                List<ProductionDetailSubEntity> plist = new ArrayList<>();
                plist.add(entity);
                proSubMap.put(budgetDetailId, plist);
            }
        }
        Map<Long, List<ProductionDetailMeasureEntity>> proMeasureMap = new HashMap<>();
        for (ProductionDetailMeasureEntity entity : measureDetails) {
            if (measureMap.containsKey(entity.getBudgetDetailId())) {
                BudgetMeasureEntity bentity = measureMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getMeasureSubjectId();
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(subjectId, reportVO);
                }
            }
            Long budgetDetailId = entity.getBudgetDetailId();
            if (proMeasureMap.containsKey(budgetDetailId)) {
                List<ProductionDetailMeasureEntity> plist = proMeasureMap.get(budgetDetailId);
                plist.add(entity);
                proMeasureMap.put(budgetDetailId, plist);
            } else {
                List<ProductionDetailMeasureEntity> plist = new ArrayList<>();
                plist.add(entity);
                proMeasureMap.put(budgetDetailId, plist);
            }
        }
        for (ProductionDetailOtherEntity entity : otherDetails) {
            if (otherMap.containsKey(entity.getBudgetDetailId())) {
                BudgetOtherEntity bentity = otherMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getOtherSubjectId();
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        for (ProductionDetailFeeEntity entity : feeDetails) {
            if (feeMap.containsKey(entity.getBudgetDetailId())) {
                BudgetFeeEntity bentity = feeMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getFeeSubjectId();
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        for (ProductionDetailCostEntity entity : costDetails) {
            if (costMap.containsKey(entity.getBudgetDetailId())) {
                BudgetCostEntity bentity = costMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getCostSubjectId();
                if (resMap.containsKey(subjectId)) {
                    BudgetReportVO reportVO = resMap.get(subjectId);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(subjectId, reportVO);
                }
            }
        }
        //proSubMap
        for (BudgetDetailEntity entity : detailList) {
            Long subjectId = entity.getDetailSubjectId();
            if (subjectId != null && subjectId > 0) {
                BigDecimal content = entity.getContent();
                BigDecimal detailPrice = entity.getDetailPrice();
                BigDecimal detailTaxPrice = entity.getDetailTaxPrice();

                Long budgetBid = entity.getBudgetBid();
                if (proSubMap.containsKey(budgetBid)) {
                    List<ProductionDetailSubEntity> pdList = proSubMap.get(budgetBid);
                    for (ProductionDetailSubEntity pdd : pdList) {
                        if (resMap.containsKey(subjectId)) {
                            BudgetReportVO reportVO = resMap.get(subjectId);
                            BigDecimal useNum = pdd.getProductionNum();
                            BigDecimal dnum = MathUtil.safeMultiply(useNum, content);
                            BigDecimal dmny = MathUtil.safeMultiply(dnum, detailPrice);
                            BigDecimal dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                            BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), dmny);
                            BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), dtaxMny);
                            BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), dnum);
                            reportVO.setYsHappenMny(mny);
                            reportVO.setYsHappenTaxMny(taxMny);
                            reportVO.setYsNum(num);
                            resMap.put(subjectId, reportVO);
                        }
                    }
                }
                if (proMeasureMap.containsKey(budgetBid)) {
                    List<ProductionDetailMeasureEntity> pdList = proMeasureMap.get(budgetBid);
                    for (ProductionDetailMeasureEntity pdd : pdList) {
                        if (resMap.containsKey(subjectId)) {
                            BudgetReportVO reportVO = resMap.get(subjectId);
                            BigDecimal useNum = pdd.getProductionNum();
                            BigDecimal dnum = MathUtil.safeMultiply(useNum, content);
                            BigDecimal dmny = MathUtil.safeMultiply(dnum, detailPrice);
                            BigDecimal dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                            BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), dmny);
                            BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), dtaxMny);
                            BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), dnum);
                            reportVO.setYsHappenMny(mny);
                            reportVO.setYsHappenTaxMny(taxMny);
                            reportVO.setYsNum(num);
                            resMap.put(subjectId, reportVO);
                        }
                    }
                }
            }
        }
        return new ArrayList<>(resMap.values());
    }
    @Override
    public List<BudgetReportVO> querySumBudgetMnyNew(Long projectId, String beginPeriod,String endDate) {
        LambdaQueryWrapper<BudgetEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetEntity::getDr, 0);
        wrapper.eq(BudgetEntity::getProjectId, projectId);
        wrapper.in(BudgetEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetEntity> entityList = super.list(wrapper);
        if (CollectionUtils.isEmpty(entityList)) {
            return new ArrayList<>();
        }
        List<Long> budegtIds = entityList.stream().map(BudgetEntity::getId).collect(Collectors.toList());
        List<BudgetSubEntity> subList = budgetSubService.querySubByBudgetIds(budegtIds);
        List<BudgetMeasureEntity> measureList = budgetMeasureService.queryMeasureByBudgetIds(budegtIds);
        List<BudgetOtherEntity> otherList = budgetOtherService.queryOtherByBudgetIds(budegtIds);
        List<BudgetFeeEntity> feeList = budgetFeeService.queryFeeByBudgetIds(budegtIds);
        List<BudgetCostEntity> costList = budgetCostService.queryCostByBudgetIds(budegtIds);
        List<BudgetDetailEntity> detailList = budgetDetailService.queryDetailByBudgetIds(budegtIds);
        Map<String, BudgetReportVO> resMap = new HashMap<>();
        Map<Long, BudgetSubEntity> subMap = new HashMap<>();
        for (BudgetSubEntity entity : subList) {
            Long subjectId = entity.getSubSubjectId();
            String unitName = entity.getSubUnit()==null?"":entity.getSubUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                subMap.put(entity.getId(), entity);
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getSubMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getSubTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getSubNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getSubSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getSubMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getSubTaxMny());
                    reportVO.setYsNumAll(entity.getSubNum());
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        Map<Long, BudgetMeasureEntity> measureMap = new HashMap<>();
        for (BudgetMeasureEntity entity : measureList) {
            Long subjectId = entity.getMeasureSubjectId();
            String unitName = entity.getMeasureUnit()==null?"":entity.getMeasureUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                measureMap.put(entity.getId(), entity);
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getMeasureMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getMeasureTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getMeasureNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getMeasureSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getMeasureMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getMeasureTaxMny());
                    reportVO.setYsNumAll(entity.getMeasureNum());
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        Map<Long, BudgetOtherEntity> otherMap = new HashMap<>();
        for (BudgetOtherEntity entity : otherList) {
            Long subjectId = entity.getOtherSubjectId();
            String unitName = entity.getOtherUnit()==null?"":entity.getOtherUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                otherMap.put(entity.getId(), entity);
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getOtherMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getOtherTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getOtherNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getOtherSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getOtherMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getOtherTaxMny());
                    reportVO.setYsNumAll(entity.getOtherNum());
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        Map<Long, BudgetFeeEntity> feeMap = new HashMap<>();
        for (BudgetFeeEntity entity : feeList) {
            Long subjectId = entity.getFeeSubjectId();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+"";
                feeMap.put(entity.getId(), entity);
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getFeeMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getFeeTaxMny());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getFeeSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getFeeMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getFeeTaxMny());
                    resMap.put(key, reportVO);
                }
            }
        }
        Map<Long, BudgetCostEntity> costMap = new HashMap<>();
        for (BudgetCostEntity entity : costList) {
            Long subjectId = entity.getCostSubjectId();
            String unitName = entity.getCostUnit()==null?"":entity.getCostUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                costMap.put(entity.getId(), entity);
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getCostMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getCostTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getCostNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getCostSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getCostMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getCostTaxMny());
                    reportVO.setYsNumAll(entity.getCostNum());
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        for (BudgetDetailEntity entity : detailList) {
            Long subjectId = entity.getDetailSubjectId();
            String unitName = entity.getDetailUnit()==null?"":entity.getDetailUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMnyAll(), entity.getDetailMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMnyAll(), entity.getDetailTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNumAll(), entity.getDetailNum());
                    reportVO.setYsHappenMnyAll(mny);
                    reportVO.setYsHappenTaxMnyAll(taxMny);
                    reportVO.setYsNumAll(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                } else {
                    BudgetReportVO reportVO = new BudgetReportVO();
                    reportVO.setSubjectId(subjectId);
                    reportVO.setSubjectName(entity.getDetailSubjectName());
                    reportVO.setYsHappenMnyAll(entity.getDetailMny());
                    reportVO.setYsHappenTaxMnyAll(entity.getDetailTaxMny());
                    reportVO.setYsNumAll(entity.getDetailNum());
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        LambdaQueryWrapper<ProductionEntity> peoductionLambd = new LambdaQueryWrapper<>();
        peoductionLambd.eq(ProductionEntity::getDr, 0);
        peoductionLambd.eq(ProductionEntity::getProjectId, projectId);
        peoductionLambd.in(ProductionEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        if (StringUtils.isNotEmpty(endDate)) {
            beginPeriod = beginPeriod + "-1";
            endDate = endDate + "-31";
            peoductionLambd.ge(ProductionEntity::getProductionDate, beginPeriod);
            peoductionLambd.le(ProductionEntity::getProductionDate, endDate);
        }
        List<ProductionEntity> productionEntities = productionService.list(peoductionLambd);
        if (CollectionUtils.isEmpty(productionEntities)) {
            return new ArrayList<>(resMap.values());
        }
        List<Long> productionIds = productionEntities.stream().map(ProductionEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ProductionDetailEntity> peoduDetailLambd = new LambdaQueryWrapper<>();
        peoduDetailLambd.eq(ProductionDetailEntity::getDr, 0);
        peoduDetailLambd.in(ProductionDetailEntity::getProductionId, productionIds);
        List<ProductionDetailEntity> productionDetails = productionDetailService.list(peoduDetailLambd);
        if (CollectionUtils.isEmpty(productionDetails)) {
            return new ArrayList<>(resMap.values());
        }
        List<Long> proDetailIds = productionDetails.stream().map(ProductionDetailEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<ProductionDetailSubEntity> proSubLambd = new LambdaQueryWrapper<>();
        proSubLambd.eq(ProductionDetailSubEntity::getDr, 0);
        proSubLambd.in(ProductionDetailSubEntity::getDetailId, proDetailIds);
        List<ProductionDetailSubEntity> subDetails = productionDetailSubService.list(proSubLambd);
        LambdaQueryWrapper<ProductionDetailMeasureEntity> proMeasureLambd = new LambdaQueryWrapper<>();
        proMeasureLambd.eq(ProductionDetailMeasureEntity::getDr, 0);
        proMeasureLambd.in(ProductionDetailMeasureEntity::getDetailId, proDetailIds);
        List<ProductionDetailMeasureEntity> measureDetails = productionDetailMeasureService.list(proMeasureLambd);
        LambdaQueryWrapper<ProductionDetailOtherEntity> proOtherLambd = new LambdaQueryWrapper<>();
        proOtherLambd.eq(ProductionDetailOtherEntity::getDr, 0);
        proOtherLambd.in(ProductionDetailOtherEntity::getDetailId, proDetailIds);
        List<ProductionDetailOtherEntity> otherDetails = productionDetailOtherService.list(proOtherLambd);
        LambdaQueryWrapper<ProductionDetailFeeEntity> proFeeLambd = new LambdaQueryWrapper<>();
        proFeeLambd.eq(ProductionDetailFeeEntity::getDr, 0);
        proFeeLambd.in(ProductionDetailFeeEntity::getDetailId, proDetailIds);
        List<ProductionDetailFeeEntity> feeDetails = productionDetailFeeService.list(proFeeLambd);
        LambdaQueryWrapper<ProductionDetailCostEntity> proCostLambd = new LambdaQueryWrapper<>();
        proCostLambd.eq(ProductionDetailCostEntity::getDr, 0);
        proCostLambd.in(ProductionDetailCostEntity::getDetailId, proDetailIds);
        List<ProductionDetailCostEntity> costDetails = productionDetailCostService.list(proCostLambd);
        Map<Long, List<ProductionDetailSubEntity>> proSubMap = new HashMap<>();
        for (ProductionDetailSubEntity entity : subDetails) {
            if (subMap.containsKey(entity.getBudgetDetailId())) {
                BudgetSubEntity bentity = subMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getSubSubjectId();
                String unitName = bentity.getSubUnit()==null?"":bentity.getSubUnit();
                String key = subjectId.toString()+","+unitName;
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
            Long budgetDetailId = entity.getBudgetDetailId();
            if (proSubMap.containsKey(budgetDetailId)) {
                List<ProductionDetailSubEntity> plist = proSubMap.get(budgetDetailId);
                plist.add(entity);
                proSubMap.put(budgetDetailId, plist);
            } else {
                List<ProductionDetailSubEntity> plist = new ArrayList<>();
                plist.add(entity);
                proSubMap.put(budgetDetailId, plist);
            }
        }
        Map<Long, List<ProductionDetailMeasureEntity>> proMeasureMap = new HashMap<>();
        for (ProductionDetailMeasureEntity entity : measureDetails) {
            if (measureMap.containsKey(entity.getBudgetDetailId())) {
                BudgetMeasureEntity bentity = measureMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getMeasureSubjectId();
                String unitName = bentity.getMeasureUnit()==null?"":bentity.getMeasureUnit();
                String key = subjectId.toString()+","+unitName;
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
            Long budgetDetailId = entity.getBudgetDetailId();
            if (proMeasureMap.containsKey(budgetDetailId)) {
                List<ProductionDetailMeasureEntity> plist = proMeasureMap.get(budgetDetailId);
                plist.add(entity);
                proMeasureMap.put(budgetDetailId, plist);
            } else {
                List<ProductionDetailMeasureEntity> plist = new ArrayList<>();
                plist.add(entity);
                proMeasureMap.put(budgetDetailId, plist);
            }
        }
        for (ProductionDetailOtherEntity entity : otherDetails) {
            if (otherMap.containsKey(entity.getBudgetDetailId())) {
                BudgetOtherEntity bentity = otherMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getOtherSubjectId();
                String unitName = bentity.getOtherUnit()==null?"":bentity.getOtherUnit();
                String key = subjectId.toString()+","+unitName;
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        for (ProductionDetailFeeEntity entity : feeDetails) {
            if (feeMap.containsKey(entity.getBudgetDetailId())) {
                BudgetFeeEntity bentity = feeMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getFeeSubjectId();
                String key = subjectId.toString()+","+"";
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    resMap.put(key, reportVO);
                }
            }
        }
        for (ProductionDetailCostEntity entity : costDetails) {
            if (costMap.containsKey(entity.getBudgetDetailId())) {
                BudgetCostEntity bentity = costMap.get(entity.getBudgetDetailId());
                Long subjectId = bentity.getCostSubjectId();
                String unitName = bentity.getCostUnit()==null?"":bentity.getCostUnit();
                String key = subjectId.toString()+","+unitName;
                if (resMap.containsKey(key)) {
                    BudgetReportVO reportVO = resMap.get(key);
                    BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), entity.getProductionMny());
                    BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), entity.getProductionTaxMny());
                    BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), entity.getProductionNum());
                    reportVO.setYsHappenMny(mny);
                    reportVO.setYsHappenTaxMny(taxMny);
                    reportVO.setYsNum(num);
                    reportVO.setYsUnitName(unitName);
                    resMap.put(key, reportVO);
                }
            }
        }
        for (BudgetDetailEntity entity : detailList) {
            Long subjectId = entity.getDetailSubjectId();
            String unitName = entity.getDetailUnit()==null?"":entity.getDetailUnit();
            if (subjectId != null && subjectId > 0) {
                String key = subjectId.toString()+","+unitName;
                BigDecimal content = entity.getContent();
                BigDecimal detailPrice = entity.getDetailPrice();
                BigDecimal detailTaxPrice = entity.getDetailTaxPrice();

                Long budgetBid = entity.getBudgetBid();
                if (proSubMap.containsKey(budgetBid)) {
                    List<ProductionDetailSubEntity> pdList = proSubMap.get(budgetBid);
                    for (ProductionDetailSubEntity pdd : pdList) {
                        if (resMap.containsKey(key)) {
                            BudgetReportVO reportVO = resMap.get(key);
                            BigDecimal useNum = pdd.getProductionNum();
                            BigDecimal dnum = MathUtil.safeMultiply(useNum, content);
                            BigDecimal dmny = MathUtil.safeMultiply(dnum, detailPrice);
                            BigDecimal dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                            BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), dmny);
                            BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), dtaxMny);
                            BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), dnum);
                            reportVO.setYsHappenMny(mny);
                            reportVO.setYsHappenTaxMny(taxMny);
                            reportVO.setYsNum(num);
                            reportVO.setYsUnitName(unitName);
                            resMap.put(key, reportVO);
                        }
                    }
                }
                if (proMeasureMap.containsKey(budgetBid)) {
                    List<ProductionDetailMeasureEntity> pdList = proMeasureMap.get(budgetBid);
                    for (ProductionDetailMeasureEntity pdd : pdList) {
                        if (resMap.containsKey(key)) {
                            BudgetReportVO reportVO = resMap.get(key);
                            BigDecimal useNum = pdd.getProductionNum();
                            BigDecimal dnum = MathUtil.safeMultiply(useNum, content);
                            BigDecimal dmny = MathUtil.safeMultiply(dnum, detailPrice);
                            BigDecimal dtaxMny = MathUtil.safeMultiply(dnum, detailTaxPrice);
                            BigDecimal mny = MathUtil.safeAdd(reportVO.getYsHappenMny(), dmny);
                            BigDecimal taxMny = MathUtil.safeAdd(reportVO.getYsHappenTaxMny(), dtaxMny);
                            BigDecimal num = MathUtil.safeAdd(reportVO.getYsNum(), dnum);
                            reportVO.setYsHappenMny(mny);
                            reportVO.setYsHappenTaxMny(taxMny);
                            reportVO.setYsNum(num);
                            reportVO.setYsUnitName(unitName);
                            resMap.put(key, reportVO);
                        }
                    }
                }
            }
        }
        return new ArrayList<>(resMap.values());
    }

    @Override
    public BigDecimal queryAllBudgetMny(Long projectId) {
        BigDecimal sumMny = null;
        LambdaQueryWrapper<BudgetEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BudgetEntity::getProjectId, projectId);
        wrapper.in(BudgetEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetEntity> entityList = super.list(wrapper);
        if (CollectionUtils.isNotEmpty(entityList)) {
            sumMny = entityList.stream().map(item -> item.getBudgetTaxMny() == null ? BigDecimal.ZERO : item.getBudgetTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return sumMny;
    }

    @Override
    public void updateUseId(Long useId, String useType, List<Long> budgetIds) {
        LambdaUpdateWrapper<BudgetEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BudgetEntity::getUseId, useId);
        wrapper.set(BudgetEntity::getUseType, null);
        wrapper.set(BudgetEntity::getUseId, null);
        this.update(wrapper);
        if (CollectionUtils.isNotEmpty(budgetIds)) {
            budgetIds.forEach(e -> {
                LambdaUpdateWrapper<BudgetEntity> lambda = new LambdaUpdateWrapper();
                lambda.eq(BudgetEntity::getId, e);
                lambda.set(BudgetEntity::getUseType, useType);
                lambda.set(BudgetEntity::getUseId, useId);
                this.update(lambda);
            });
        }
    }

    @Override
    public List<BudgetVO> selectByUseId(Long useId) {
        LambdaUpdateWrapper<BudgetEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BudgetEntity::getUseId, useId);
        wrapper.eq(BudgetEntity::getDr, 0);
        wrapper.eq(BudgetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BudgetEntity> list = this.list(wrapper);
        List<BudgetVO> budgetVOS = BeanMapper.mapList(list, BudgetVO.class);
        return budgetVOS;
    }

    @Override
    public void deleteUseId(List<Long> useId) {
        useId.forEach(e -> {
            LambdaUpdateWrapper<BudgetEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BudgetEntity::getUseId, e);
            wrapper.set(BudgetEntity::getUseType, null);
            wrapper.set(BudgetEntity::getUseId, null);
            this.update(wrapper);
        });
    }

    //查询合同下预算分类节点【是否收入】字段为“是"的已生效的预算书
    @Override
    public BudgetHistoryVO queryBudgetHistory(Long id, Long accountingId) {
        ContractRegisterEntity entity = contractService.selectById(id);
        BudgetHistoryVO historyVO = new BudgetHistoryVO();
        historyVO.setId(entity.getId());
        historyVO.setRegisterId(entity.getId());
        historyVO.setChangeStatus(entity.getChangeStatus());
        historyVO.setIsFinish(entity.getIsFinish());
        historyVO.setIsRelieve(entity.getIsRelieve());
        historyVO.setProjectId(entity.getProjectId());
        historyVO.setIsSuspend(entity.getIsSuspend());

        LambdaQueryWrapper<BudgetEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(BudgetEntity::getDr, 0);
        lambd.eq(BudgetEntity::getContractId, id);
        lambd.in(BudgetEntity::getBillState, 1, 3);
//        lambd.eq(BudgetEntity::getIncomeFlag, 1);

        List<BudgetEntity> allList = super.list(lambd);

        BigDecimal allTaxMny = BigDecimal.ZERO;
        BigDecimal allMny = BigDecimal.ZERO;
        BigDecimal allTax = BigDecimal.ZERO;

        if (allList != null && allList.size() > 0) {
            for (BudgetEntity be : allList) {
                allTaxMny = MathUtil.safeAdd(allTaxMny, be.getBudgetTaxMny());
                allMny = MathUtil.safeAdd(allMny, be.getBudgetMny());
                allTax = MathUtil.safeAdd(allTax, be.getBudgetTax());
            }
            // 【预算占比】=【预算金额】➗整个项目【预算金额】
        }
        historyVO.setAllTaxMny(allTaxMny);
        historyVO.setAllMny(allMny);
        historyVO.setAllTax(allTax);
        return historyVO;
    }

    /**
     * 关联预算书
     *
     * @param useId
     * @param ids
     * @param useType
     */
    @Override
    public void relevanceBudget(Long useId, List<Long> ids, String useType) {
        LambdaUpdateWrapper<BudgetEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.in(BudgetEntity::getId, ids);
        wrapper.set(BudgetEntity::getUseId, useId);
        wrapper.set(BudgetEntity::getUseType, useType);
        this.update(wrapper);
    }

    /**
     * 取消关联预算书
     *
     * @param ids
     */
    @Override
    public void deleteRelevanceBudget(List<Long> ids) {
        LambdaUpdateWrapper<BudgetEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.in(BudgetEntity::getId, ids);
        wrapper.set(BudgetEntity::getUseId, null);
        wrapper.set(BudgetEntity::getUseType, null);
        this.update(wrapper);
    }
    private void sendMsg(BudgetEntity entity){
        String CODE = "WARNBUDGET001";
        CommonResponse<WarningDTO> response =
                warnCenterApi.getWarnSet(CODE,entity.getParentOrgId());
        logger.info("查询预警中心设置：{} ",JSONObject.toJSONString(response));
        if(response.isSuccess()){
            WarningDTO orgSet = response.getData();
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(orgSet.getModuleName() + "-" + entity.getBillCode());
            vo.setPcTitle("项目预算书修订");
            vo.setOrgId(entity.getParentOrgId());
            OrgVO orgVO = iOrgApi.getOneById(entity.getParentOrgId()).getData();
            vo.setOrgName(orgVO==null?"":orgVO.getName());
            vo.setSendOrgId(entity.getParentOrgId()+"");
            vo.setSourceId(entity.getId().toString());
            vo.setTenantId(InvocationInfoProxy.getTenantid());
            vo.setWarnSetId(orgSet.getId());
            vo.setEarlywarnName(orgSet.getName());
            vo.setWarnType(orgSet.getWarnType()+"");
            vo.setWarnLevel(orgSet.getWarningSetings().get(0).getWarningLevel());
            vo.setWarnSetParamId(orgSet.getWarningSetings().get(0).getId());
            vo.setEarlywarnContent(
                    orgSet.getWarningContentTemplate().replaceAll("#projectName#",
                            entity.getProjectName())
                            .replaceAll("#budgetName#", entity.getBudgetName())
            );
            List<EarlyWarnTransVO> earlyWarnTransVOS = new ArrayList<>();
            earlyWarnTransVOS.add(vo);
            logger.info("预警中心：{} ",JSONObject.toJSONString(earlyWarnTransVOS));
            CommonResponse<String> warnCenterByCode =
                    warnCenterApi.sendToWarnCenterByCode(earlyWarnTransVOS,CODE);
            logger.info("预警中心响应：{}",JSONObject.toJSONString(warnCenterByCode));
        } }


    @Override
    public CommonResponse<JSONObject> excelImportSX2JInProvinceInfo(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = null;
        if (StringUtils.isNotEmpty(request.getParameter("budgetId"))) {
            budgetId = Long.valueOf(request.getParameter("budgetId"));
        } else {
            return CommonResponse.error("预算书主键为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size == null) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
            if (result0.size() > 0 && result0.get(0).size() < 10) {
                return CommonResponse.error("[分部分项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result1 = resList.get(1);
            if (result1.size() > 0 && result1.get(0).size() < 9) {
                return CommonResponse.error("[措施项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result2 = resList.get(2);
            if (result2.size() > 0 && result2.get(0).size() < 9) {
                return CommonResponse.error("[其它项清单]数据不完整，请下载最新模板！");
            }
            List<List<String>> result3 = resList.get(3);
            if (result3.size() > 0 && result3.get(0).size() < 6) {
                return CommonResponse.error("[费税项清单]数据不完整，请下载最新模板！");
            }

            BudgetEntity entity = baseMapper.selectById(budgetId);
            ImportVo importVo = excelImportSX2JInProvince(result0, entity, 1);
            ImportVo importVo1 = excelImportMeasure(result1, entity, 1);
            ImportVo importVo2 = excelImportOther(result2, entity, 1);
            ImportVo importVo3 = excelImportFee(result3, entity, 1);

            List<ImportErrorVo> errorList = new ArrayList<>();
            errorList.addAll(importVo.getErrorList());
            errorList.addAll(importVo1.getErrorList());
            errorList.addAll(importVo2.getErrorList());
            errorList.addAll(importVo3.getErrorList());

            Integer sucNum = 0;
            sucNum += importVo.getDetailList().size();
            sucNum += importVo1.getMeasureList().size();
            sucNum += importVo2.getOtherList().size();
            sucNum += importVo3.getFeeList().size();

            //List<ImportErrorVo> errorList = importVo.getErrorList();
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", sucNum);
                resp.put("errorNum", errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                List<BudgetDetailVO> successList = importVo.getDetailList();
                // 计算合计
                BigDecimal subTotalMny = BigDecimal.ZERO;
                BigDecimal subTotalTaxMny = BigDecimal.ZERO;
                BigDecimal subTotalTax = BigDecimal.ZERO;
                List<BudgetSubEntity> subList = new ArrayList<>();
                List<BudgetDetailVO> detailList = new ArrayList<>();
                for (BudgetDetailVO bv : successList) {
                    if (bv.getNodeLevel() <= 2) {
                        BudgetSubEntity subVo = new BudgetSubEntity();
                        subVo.setId(bv.getId());
                        subVo.setBudgetId(bv.getBudgetId());
                        subVo.setParentId(bv.getParentId());
                        subVo.setDetailIndex(bv.getDetailIndex());
                        subVo.setSubCode(bv.getDetailCode());
                        subVo.setSubName(bv.getDetailName());
                        subVo.setSubFeature(bv.getDetailSpec());
                        subVo.setSubUnit(bv.getDetailUnit());
                        subVo.setSubNum(bv.getDetailNum());
                        subVo.setSubTaxRate(bv.getDetailTaxRate());
                        subVo.setSubPrice(MathUtil.safeDiv(bv.getDetailMny(), bv.getDetailNum()));
                        subVo.setSubTaxPrice(MathUtil.safeDiv(bv.getDetailTaxMny(), bv.getDetailNum()));
                        subVo.setSubMny(bv.getDetailMny());
                        subVo.setSubTaxMny(bv.getDetailTaxMny());
                        subVo.setSubTax(bv.getDetailTax());
                        subVo.setSubMemo(bv.getDetailMemo());
                        subVo.setLeafFlag(bv.getLeafFlag());
                        subVo.setTid(bv.getTid());
                        subVo.setTpid(bv.getTpid());
                        subVo.setSubSubjectId(bv.getDetailSubjectId());
                        subVo.setSubSubjectName(bv.getDetailSubjectName());
                        subVo.setSubCompositiveCoefficient(bv.getDetailCompositiveCoefficient());
                        subVo.setSubCompositiveCoefficientId(bv.getDetailCompositiveCoefficientId());
                        subVo.setSubCompositiveCoefficientName(bv.getDetailCompositiveCoefficientName());
                        subVo.setSubItemType(bv.getDetailItemType());
                        subList.add(subVo);
                        if(ExcelDetailTypeEnum.分部分项清单_分部分项.getCode().equals(subVo.getSubItemType())) {
                            subTotalMny = MathUtil.safeAdd(subTotalMny, subVo.getSubMny());
                            subTotalTaxMny = MathUtil.safeAdd(subTotalTaxMny, subVo.getSubTaxMny());
                            subTotalTax = MathUtil.safeAdd(subTotalTax, subVo.getSubTax());
                        }
                    } else {
//                        if (bv.getNodeLevel() == 2) {
//                            bv.setParentId(null);
//                        }
                        detailList.add(bv);
                    }
                }

                List<BudgetMeasureVO> measureList = importVo1.getMeasureList();
                // 价税分离
                //new TaxCalculateUtil<BudgetMeasureVO>().calculate(measureList);
                // list转树
                List<BudgetMeasureVO> measureVOS = TreeNodeBUtil.buildTree(measureList);
                // 向上汇总金额
                new UpSumUtil<BudgetMeasureVO>().upSum(measureVOS, "measureMny", "measureTaxMny", "measureTax");
                // 计算合计
                BigDecimal measureTotalMny = BigDecimal.ZERO;
                BigDecimal measureTotalTaxMny = BigDecimal.ZERO;
                BigDecimal measureTotalTax = BigDecimal.ZERO;
                for (BudgetMeasureVO bv : measureVOS) {
                    measureTotalMny = MathUtil.safeAdd(measureTotalMny, bv.getMeasureMny());
                    measureTotalTaxMny = MathUtil.safeAdd(measureTotalTaxMny, bv.getMeasureTaxMny());
                    measureTotalTax = MathUtil.safeAdd(measureTotalTax, bv.getMeasureTax());
                }
                // 树转list
                List<BudgetMeasureVO> budgetMeasureVOS = new UpSumUtil<BudgetMeasureVO>().treeToList(measureVOS);

                List<BudgetOtherVO> otherList = importVo2.getOtherList();
                // 价税分离
                //new TaxCalculateUtil<BudgetOtherVO>().calculate(otherList);
                // list转树
                List<BudgetOtherVO> otherVOS = TreeNodeBUtil.buildTree(otherList);
                // 向上汇总金额
                new UpSumUtil<BudgetOtherVO>().upSum(otherVOS, "otherMny", "otherTaxMny", "otherTax");
                // 计算合计
                BigDecimal otherTotalMny = BigDecimal.ZERO;
                BigDecimal otherTotalTaxMny = BigDecimal.ZERO;
                BigDecimal otherTotalTax = BigDecimal.ZERO;
                for (BudgetOtherVO bv : otherVOS) {
                    otherTotalMny = MathUtil.safeAdd(otherTotalMny, bv.getOtherMny());
                    otherTotalTaxMny = MathUtil.safeAdd(otherTotalTaxMny, bv.getOtherTaxMny());
                    otherTotalTax = MathUtil.safeAdd(otherTotalTax, bv.getOtherTax());
                }
                // 树转list
                List<BudgetOtherVO> budgetOtherVOS = new UpSumUtil<BudgetOtherVO>().treeToList(otherVOS);

                List<BudgetFeeVO> feeList = importVo3.getFeeList();
                // 价税分离
                //new TaxCalculateUtil<BudgetFeeVO>().calculate(feeList);
                // list转树
                List<BudgetFeeVO> feeVOS = TreeNodeBUtil.buildTree(feeList);
                // 向上汇总金额
                new UpSumUtil<BudgetFeeVO>().upSum(feeVOS, "feeMny", "feeTaxMny", "feeTax");
                // 计算合计
                BigDecimal feeTotalMny = BigDecimal.ZERO;
                BigDecimal feeTotalTaxMny = BigDecimal.ZERO;
                BigDecimal feeTotalTax = BigDecimal.ZERO;
                for (BudgetFeeVO bv : feeVOS) {
                    feeTotalMny = MathUtil.safeAdd(feeTotalMny, bv.getFeeMny());
                    feeTotalTaxMny = MathUtil.safeAdd(feeTotalTaxMny, bv.getFeeTaxMny());
                    feeTotalTax = MathUtil.safeAdd(feeTotalTax, bv.getFeeTax());
                }
                // 树转list
                List<BudgetFeeVO> budgetFeeVOS = new UpSumUtil<BudgetFeeVO>().treeToList(feeVOS);

                resp.put("successList", null);
                resp.put("errorList", null);
                resp.put("successNum", successList.size() + budgetMeasureVOS.size() + budgetOtherVOS.size() + budgetFeeVOS.size());
                resp.put("errorNum", 0);

                budgetDetailService.delDetailByBudgetId(budgetId);
                if (detailList.size() > 0) {
                    List<BudgetDetailEntity> detailEntities = BeanMapper.mapList(detailList, BudgetDetailEntity.class);
                    budgetDetailService.saveOrUpdateBatch(detailEntities, detailEntities.size(), false);
                }

                budgetSubService.delSubByBudgetId(budgetId);
                if (subList.size() > 0) {
                    budgetSubService.saveOrUpdateBatch(subList, subList.size(), false);
                }

                budgetMeasureService.delMeasureByBudgetId(budgetId);
                if (budgetMeasureVOS.size() > 0) {
                    List<BudgetMeasureEntity> budgetMeasureEntities = BeanMapper.mapList(budgetMeasureVOS, BudgetMeasureEntity.class);
                    budgetMeasureService.saveOrUpdateBatch(budgetMeasureEntities, budgetMeasureEntities.size(), false);
                }
                budgetOtherService.delOtherByBudgetId(budgetId);
                if (budgetOtherVOS.size() > 0) {
                    List<BudgetOtherEntity> budgetOtherEntities = BeanMapper.mapList(budgetOtherVOS, BudgetOtherEntity.class);
                    budgetOtherService.saveOrUpdateBatch(budgetOtherEntities, budgetOtherEntities.size(), false);
                }
                budgetFeeService.delFeeByBudgetId(budgetId);
                if (budgetFeeVOS.size() > 0) {
                    List<BudgetFeeEntity> budgetFeeEntities = BeanMapper.mapList(budgetFeeVOS, BudgetFeeEntity.class);
                    budgetFeeService.saveOrUpdateBatch(budgetFeeEntities, budgetFeeEntities.size(), false);
                }

                BigDecimal budgetMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalMny, measureTotalMny), MathUtil.safeAdd(otherTotalMny, feeTotalMny));
                BigDecimal budgetTaxMny = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTaxMny, measureTotalTaxMny), MathUtil.safeAdd(otherTotalTaxMny, feeTotalTaxMny));
                BigDecimal budgetTax = MathUtil.safeAdd(MathUtil.safeAdd(subTotalTax, measureTotalTax), MathUtil.safeAdd(otherTotalTax, feeTotalTax));
                LambdaUpdateWrapper<BudgetEntity> lambd = new LambdaUpdateWrapper<>();
                lambd.set(BudgetEntity::getSubTotalMny, subTotalMny);
                lambd.set(BudgetEntity::getSubTotalTaxMny, subTotalTaxMny);
                lambd.set(BudgetEntity::getSubTotalTax, subTotalTax);
                lambd.set(BudgetEntity::getMeasureTotalMny, measureTotalMny);
                lambd.set(BudgetEntity::getMeasureTotalTaxMny, measureTotalTaxMny);
                lambd.set(BudgetEntity::getMeasureTotalTax, measureTotalTax);
                lambd.set(BudgetEntity::getOtherTotalMny, otherTotalMny);
                lambd.set(BudgetEntity::getOtherTotalTaxMny, otherTotalTaxMny);
                lambd.set(BudgetEntity::getOtherTotalTax, otherTotalTax);
                lambd.set(BudgetEntity::getFeeTotalMny, feeTotalMny);
                lambd.set(BudgetEntity::getFeeTotalTaxMny, feeTotalTaxMny);
                lambd.set(BudgetEntity::getFeeTotalTax, feeTotalTax);
                lambd.set(BudgetEntity::getBudgetMny, budgetMny);
                lambd.set(BudgetEntity::getBudgetTaxMny, budgetTaxMny);
                lambd.set(BudgetEntity::getBudgetTax, budgetTax);
                lambd.eq(BudgetEntity::getId, budgetId);
                super.update(lambd);

            }
            return CommonResponse.success(resp);
        }
    }

    @Override
    public String checkQuote(List<Long> compositiveCoefficientIds) {
        Long countNum = budgetMapper.checkQuote(compositiveCoefficientIds);
        if(countNum > 0) {
            return "综合系数项被引用";
        }
        return null;
    }

    private ImportVo excelImportSX2JInProvince(List<List<String>> result, BudgetEntity entity, Integer priceType) {

        ImportVo res = new ImportVo();
        List<ImportErrorVo> errorList = new ArrayList<>();
        Integer rootDetailNums = 0;
        Set<String> parentIndexList = new HashSet<>();// 父级节点编码
        Set<String> compositiveCoefficientNames = new HashSet<>();
        BigDecimal hundred = new BigDecimal("100");
        if (result != null && result.size() > 0) {
            List<String> detailIndexList = new ArrayList<>();// 树形编码不能重复
            String curRootDetailIndex = ""; //分布序号
            Integer detailItemIndex = 0; //明细项序号
            Map<String, Long> parentMap = new HashMap<>();
            List<BudgetDetailVO> detailVoList = new ArrayList<>();
            List<String> subjectList = new ArrayList<>();
            String originalIndex = null;
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                BudgetDetailVO detailVO = new BudgetDetailVO();
                boolean flag = false;
                String warnType = "";

                String indexCode = datas.get(0);
                originalIndex = indexCode;
                Pattern pattern = Pattern.compile("(-?\\d+\\.?\\d*)[Ee]{1}[\\+-]?[0-9]*");
                boolean isMache = pattern.matcher(indexCode.trim()).matches();
                if(isMache) {
                    indexCode = new BigDecimal(indexCode).toPlainString();
                }
                String code = datas.get(1);  //编码
                String name = datas.get(2);  //名称
                String feature = ""; //datas.get(3);
                String unit = datas.get(3);     //单位
                String content = datas.get(4);  //含量
                String num = datas.get(5);  //工程量
                String taxPrice = datas.get(6); //综合单价（含税）
                String taxMny = datas.get(7); //合价（含税）
                String subjectName = datas.get(8); //成本科目
                String compositiveCoefficient = datas.get(9); //综合系数
                if(StringUtils.equals(name, "综合工日")) {
                    //名称为 综合工日的项 跳过
                    continue;
                }

                if(StringUtils.isBlank(compositiveCoefficient)) {
                    compositiveCoefficient = "默认系数";
                }
                detailVO.setDetailCompositiveCoefficientName(compositiveCoefficient);
                compositiveCoefficientNames.add(compositiveCoefficient);
                detailVO.setDetailPriceType(priceType);

                if (StringUtils.isNotEmpty(subjectName)) {
                    int index = 0;
                    for (int j = 0; j < subjectName.length(); j++) {
                        if (!Character.isDigit(subjectName.charAt(j))) {
                            index = j;
                            break;
                        }
                    }
                    String subject = subjectName.substring(index).trim();
                    if (StringUtils.isNotEmpty(subject)) {
                        detailVO.setDetailSubjectName(subject);
                    }
                }
                //设置单据Id
                Long id = IdWorker.getId();
                detailVO.setId(id);
                //设置所属预算书Id
                detailVO.setBudgetId(entity.getId());
                //设置成本科目名称
                detailVO.setDetailSubjectName(subjectName);

                //编码设置
                if (StringUtils.isEmpty(code)) {// 编码为空
                    detailVO.setDetailCode(null);
                    warnType = warnType + "[编码为空]";
                    flag = true;
                } else {
                    detailVO.setDetailCode(code);
                }

                if (StringUtils.isNotEmpty(indexCode)) {//序号不为空
                    indexCode = indexCode.trim();// 去除导入时树形编码空格
                    if(indexCode.indexOf(".") < 0) { //序号长度：1-明细数据，2-定项数据，3-费用项，4-费用项构成
                        detailItemIndex++; //明细序号+1
                        indexCode = rootDetailNums.toString() + "." + detailItemIndex.toString(); //重置序号
                        detailIndexList.clear();
                    } else {
                        //改写序号,替换序号首位数值
                        indexCode = rootDetailNums.toString() + "." + detailItemIndex.toString() + indexCode.substring(indexCode.indexOf("."));
                        //校验编码重复
                        if (detailIndexList.contains(indexCode)) {
                            warnType = warnType + "[序号重复]";
                            flag = true;
                            detailVO.setIndexCode(originalIndex);
                        }
                    }
                } else if(StringUtils.isNotBlank(code) && code.indexOf(".") >= 0) {
                    //序号为空则认为是分部数据
                    rootDetailNums++;
                    //清空层级序号缓存
                    detailIndexList.clear();
                    indexCode = rootDetailNums.toString();
                    //重置明细项序号
                    detailItemIndex = 0;
                    detailVO.setIndexCode(indexCode);
                    parentMap.put(detailVO.getIndexCode(), id);
                } else {
                    detailVO.setIndexCode(null);
                    warnType = warnType + "[序号为空]";
                    flag = true;
                    detailVO.setNodeLevel(0);
                }

                if(!flag) {
                    if(indexCode.indexOf(".") > 0) {
                        String[] split = indexCode.split("[-/.]");
                        if (split.length > 5) {
                            warnType = warnType + "[序号只支持五级结构]";
                            flag = true;
                        } else {
                            detailVO.setTpid(indexCode.substring(0, indexCode.length() - split[split.length - 1].length() - 1));
                        }
                        //设置层级
                        detailVO.setNodeLevel(split.length);
                    } else {
                        //设置层级
                        detailVO.setNodeLevel(1);
                    }
                    detailVO.setDetailIndex(i + "");
                    detailVO.setIndexCode(indexCode);

                    //父级校验
                    if(StringUtils.isNotBlank(detailVO.getTpid())) {
                        if(!parentMap.containsKey(detailVO.getTpid())) {
                            warnType = warnType + "[序号对应上级数据不存在或上级数据校验未通过]";
                            flag = true;
                            detailVO.setIndexCode(indexCode);
                        } else {
                            parentIndexList.add(detailVO.getTpid());
                        }
                    }
                }

                if(!flag) {
                    parentMap.put(indexCode, id);
                    detailIndexList.add(indexCode);
                    switch (detailVO.getNodeLevel()) {
                        case 1:
                            detailVO.setDetailItemType(ExcelDetailTypeEnum.分部分项清单_分部.getCode());
                            break;
                        case 2:
                            detailVO.setDetailItemType(ExcelDetailTypeEnum.分部分项清单_分部分项.getCode());
                            break;
                        case 3:
                            detailVO.setDetailItemType(ExcelDetailTypeEnum.分部分项清单_定额.getCode());
                            break;
                        case 4:
                            detailVO.setDetailItemType(ExcelDetailTypeEnum.分部分项清单_单价构成.getCode());
                            break;
                        case 5:
                            detailVO.setDetailItemType(ExcelDetailTypeEnum.分部分项清单_单价构成下人材机明细.getCode());
                            break;
                        default:
                            break;
                    }
                }

                if (StringUtils.isEmpty(name)) {//名称为空
                    detailVO.setDetailName(null);
                    warnType = warnType + "[名称为空]";
                    flag = true;
                } else {
                    detailVO.setDetailName(name);
                }

                detailVO.setDetailSpec(feature);  //特征
                detailVO.setDetailUnit(unit);//计量单位
                if (StringUtils.isEmpty(content)) { //含量
                    //定项 以及 费用构成项 含量可编辑，若未填写，则初始值为1
//                    if(detailVO.getNodeLevel()==5 || detailVO.getNodeLevel() ==3){
//                        detailVO.setContent(BigDecimal.ZERO);
//                    }else{
//
//                    }
                    detailVO.setContent(BigDecimal.ONE);
                } else {
                    try {
                        detailVO.setContent(new BigDecimal(content).setScale(4, BigDecimal.ROUND_HALF_UP)); //控制小数位数4位
                    } catch (Exception e) {
                        detailVO.setContent(null);
                        warnType = warnType + "[含量只能为数字或小数]";
                        flag = true;
                    }
                }
                //工程量
                if(detailVO.getNodeLevel() != 1 && detailVO.getNodeLevel() != 4) { //除了分部、费用项数据，都可以维护
                    if(StringUtils.isNotBlank(num)) {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(num)) {
                            detailVO.setDetailNum(new BigDecimal(num).setScale(4, BigDecimal.ROUND_HALF_UP));
                        } else {
                            detailVO.setDetailNum(null);
                            if (detailVO.getNodeLevel() == 1) {
                                warnType = warnType + "[工程量不能为空]";
                                flag = true;
                            }
                        }
                    } else {
                        detailVO.setDetailNum(BigDecimal.ZERO);
                    }
                }

                if(detailVO.getDetailPriceType() == 1) { //含税优先
                    //综合单价（含税）
                    if (StringUtils.isEmpty(taxPrice)) {
                        detailVO.setDetailTaxPrice(BigDecimal.ZERO);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(taxPrice)) {
                            detailVO.setDetailTaxPrice(new BigDecimal(taxPrice).setScale(4, BigDecimal.ROUND_HALF_UP)); //保留4位小数
                        } else {
                            warnType = warnType + "[综合单价(含税)只能为数字或小数]";
                            flag = true;
                            detailVO.setDetailTaxPrice(null);
                        }
                    }

                    //合价（含税）
                    if (StringUtils.isEmpty(taxMny)) {
                        detailVO.setDetailTaxMny(BigDecimal.ZERO);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(taxMny)) {
                            detailVO.setDetailTaxMny(new BigDecimal(taxMny).setScale(4, BigDecimal.ROUND_HALF_UP)); //保留4位小数
                        } else {
                            detailVO.setDetailTaxMny(null);
                            warnType = warnType + "[合价(含税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                } else { //无税优先
                    //综合单价（含税）
                    if (StringUtils.isEmpty(taxPrice)) {
                        detailVO.setDetailPrice(BigDecimal.ZERO);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(taxPrice)) {
                            detailVO.setDetailPrice(new BigDecimal(taxPrice).setScale(4, BigDecimal.ROUND_HALF_UP)); //保留4位小数
                        } else {
                            warnType = warnType + "[综合单价(无税)只能为数字或小数]";
                            flag = true;
                            detailVO.setDetailPrice(null);
                        }
                    }

                    //合价（含税）
                    if (StringUtils.isEmpty(taxMny)) {
                        detailVO.setDetailMny(BigDecimal.ZERO);
                    } else {
                        if(SX2JExcelImportHandlerUtil.validateDecimal(taxMny)) {
                            detailVO.setDetailMny(new BigDecimal(taxMny).setScale(4, BigDecimal.ROUND_HALF_UP)); //保留4位小数
                        } else {
                            detailVO.setDetailMny(null);
                            warnType = warnType + "[合价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                }

                detailVO.setImportFlag(!flag);// true=可以导入，false=不可导入
                detailVO.setWarnType(warnType);
                detailVoList.add(detailVO);
                if (StringUtils.isNotEmpty(detailVO.getDetailSubjectName())) {
                    subjectList.add(detailVO.getDetailSubjectName());
                }
            }
            //查询成本科目信息
            Map<String, Long> subjectMap = new HashMap<>();
            if (subjectList.size() > 0) {
                QueryParam param = new QueryParam();
                param.getParams().put("subjectName", new Parameter(QueryParam.IN, subjectList));
                CommonResponse<List<SubjectOrgVO>> commonResponse = subjectOrgApi.querySubjectOrg(param);
                if (commonResponse.isSuccess()) {
                    List<SubjectOrgVO> data = commonResponse.getData();
                    for (SubjectOrgVO subjectOrgVO : data) {
                        subjectMap.put(subjectOrgVO.getSubjectName(), subjectOrgVO.getId());
                    }
                } else {
                    throw new BusinessException("成本科目查询失败!");
                }
            }

            //查询综合系数信息
            Map<String, DefdocDetailVO> compositiveCoefficientMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(compositiveCoefficientNames)) {
                CommonResponse<List<DefdocDetailVO>> detailListResp = defdocApi.detailListByDetailNamesAndDocCode(
                        compositiveCoefficientNames.toArray(new String[compositiveCoefficientNames.size()]), BUDGET_COMPOSITIVE_COEFFICIENT);
                if(!detailListResp.isSuccess()) {
                    logger.error("综合系数：根据名称列表-{}，档案分类编码-{}查询匹配的档案项列表信息失败！", JSONObject.toJSONString(compositiveCoefficientNames), BUDGET_COMPOSITIVE_COEFFICIENT);
                    throw new BusinessException("综合系数自定义档案信息查询失败！");
                }
                compositiveCoefficientMap = detailListResp.getData().stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
            }

            List<BudgetDetailVO> successList = new ArrayList<>();
            DefdocDetailVO compositiveCoefficient = null;
            for (BudgetDetailVO vo : detailVoList) {
                vo.setLeafFlag(ExcelDetailTypeEnum.分部分项清单_分部分项.getCode().equals(vo.getDetailItemType()) || ExcelDetailTypeEnum.分部分项清单_单价构成下人材机明细.getCode().equals(vo.getDetailItemType())
                || ExcelDetailTypeEnum.分部分项清单_定额.getCode().equals(vo.getDetailItemType()) || !parentIndexList.contains(vo.getIndexCode()));
                if (StringUtils.isNotEmpty(vo.getDetailSubjectName())) {
                    if (subjectMap.containsKey(vo.getDetailSubjectName())) {
                        vo.setDetailSubjectId(subjectMap.get(vo.getDetailSubjectName()));
                    } else {
                        vo.setDetailSubjectId(null);
                        vo.setDetailSubjectName(null);
                    }
                }
                if(StringUtils.isNotBlank(vo.getDetailCompositiveCoefficientName())) {
                    if(compositiveCoefficientMap.containsKey(vo.getDetailCompositiveCoefficientName())) {
                        compositiveCoefficient = compositiveCoefficientMap.get(vo.getDetailCompositiveCoefficientName());
                        vo.setDetailCompositiveCoefficientName(compositiveCoefficient.getName());
                        vo.setDetailCompositiveCoefficientId(compositiveCoefficient.getId());
                        vo.setDetailCompositiveCoefficient(new BigDecimal(compositiveCoefficient.getAttrCode()));
                        vo.setDetailTaxRate(ComputeUtil.safeSub(hundred, new BigDecimal(compositiveCoefficient.getAttrCode())));
                    } else {
                        vo.setWarnType(vo.getWarnType() + "[综合系数项不存在或未启用]");
                        vo.setImportFlag(false);// true=可以导入，false=不可导入
                        vo.setDetailCompositiveCoefficientName(null);
                    }
                }
                if (!vo.getImportFlag()) {
                    ImportErrorVo errorVo = new ImportErrorVo();
                    errorVo.setPageName("分部分项清单");
                    errorVo.setId(vo.getId());
                    errorVo.setIndexCode(vo.getIndexCode());
                    errorVo.setCode(vo.getDetailCode());
                    errorVo.setName(vo.getDetailName());
                    errorVo.setUnit(vo.getDetailUnit());
                    errorVo.setWarnType(vo.getWarnType());
                    errorList.add(errorVo);
                } else {
                    vo.setParentId(parentMap.get(vo.getTpid()));
//                    if (!vo.getLeafFlag()) {
//                        vo.setContent(null);
//                        vo.setDetailNum(null);
//                        vo.setDetailPrice(null);
//                        vo.setDetailMny(null);
//                    }
//                    else {
//                        vo.setDetailTaxRate(entity.getTaxRate());
//                    }
                    successList.add(vo);
                }
            }
            res.setErrorList(errorList);
            if (errorList.size() <= 0) {
                res.setDetailList(dealContent(successList));
            }

        }
        return res;
    }


}
