package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.mapper.FinalizedMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 工程定案
 * 
 * @author generator
 * 
 */
@Service("finalizedService")
public class FinalizedServiceImpl extends BaseServiceImpl<FinalizedMapper, FinalizedEntity> implements IFinalizedService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    private static final String FINALIZED_CODE = "FINALIZED";//此处需要根据实际修改

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private ISettleReportService reportService;

    @Autowired
    private ValidateUtil validateUtil;

    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IContractRegisterService contractService;

    @Autowired
    private ISettlePoolApi settlePoolApi;
    
    @Override
    public FinalizedVO saveOrUpdate(FinalizedVO saveOrUpdateVO) {

        // 保存时校验合同version是否一致
        if (!Objects.equals(null, saveOrUpdateVO.getContractId())) {
            if(!validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()),
                    BillTypeCodeEnum.施工合同.getCode(), saveOrUpdateVO.getContractVersion())){
                throw new BusinessException("该合同已被更新，请刷新后重做！");
            }
        }
        
        // 查询校验结算报审单
        querySettleReport(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getContractId());
                
        FinalizedVO finalizedVO = null;
        
        FinalizedEntity entity = BeanMapper.map(saveOrUpdateVO, FinalizedEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(FINALIZED_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            
            // 查询校验工程定案
            finalizedVO = queryFinalizedList(entity.getProjectId(), entity.getContractId(), null);
            // 查询校验定案阶段
            validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), null);
        }else {
            // 编辑
            // 查询校验工程定案
            finalizedVO = queryFinalizedList(entity.getProjectId(), entity.getContractId(), entity.getId());
            // 查询校验定案阶段
            validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), entity.getId());
            
            // 如果编辑时切换了合同并且修改前单据数据是终审的话，查询老数据并恢复对应合同 定案状态和合同状态
            FinalizedEntity oldEneity = this.selectById(entity.getId());
            if (!Objects.equals(oldEneity.getContractId(), entity.getContractId()) 
                    && Objects.equals(oldEneity.getFinalStage(), FinalStageEnum.终审.getCode())) {
                
                LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(ContractRegisterEntity::getIsFinish, 0);
                wrapper.set(ContractRegisterEntity::getContractStatus, "1");
                wrapper.eq(ContractRegisterEntity::getId, oldEneity.getContractId());
                registerService.update(wrapper);
            }


        }
        
        // 保存的时候修改是否终审状态(其实可以在新增的时候写)
        if (Objects.equals(entity.getFinalStage(), FinalStageEnum.终审.getCode())) {
            LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ContractRegisterEntity::getIsFinish, 1);
            wrapper.eq(BaseEntity::getId, entity.getContractId());
            registerService.update(wrapper);
        }
        
        // 审减金额、审减率
//        if (Objects.equals(entity.getFinalStage(), FinalStageEnum.一审.getCode()) 
//                || (Objects.equals(entity.getFinalStage(), FinalStageEnum.终审.getCode()) && Objects.equals(finalizedVO.getId(), null))) {
//            entity.setReviewSubtractMny(ComputeUtil.safeSub(entity.getCheckMny(), entity.getReportSettleMny()));
//            entity.setReviewSubtractRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(entity.getReviewSubtractMny(), entity.getReportSettleMny()), new BigDecimal("100")));
//        }else {
//            entity.setReviewSubtractMny(ComputeUtil.safeSub(entity.getCheckMny(), finalizedVO.getCheckMny()));
//            entity.setReviewSubtractRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(entity.getReviewSubtractMny(), finalizedVO.getCheckMny()), new BigDecimal("100")));
//        }
        
        // 总经济效益率
//        BigDecimal leftMny = ComputeUtil.safeSub(entity.getCheckMny(), ComputeUtil.safeSub(entity.getContractTaxMny(), saveOrUpdateVO.getProvisionalMny()));
//        BigDecimal rightMny = ComputeUtil.safeSub(entity.getContractTaxMny(), saveOrUpdateVO.getProvisionalMny());
//        entity.setTotalEconomicBenefitRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(leftMny, rightMny), new BigDecimal("100")));

        super.saveOrUpdate(entity, false);
        FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        
        return vo;
    }

    @Override
    public SettleReportVO querySettleReport(Long projectId, Long contractId) {

        LambdaQueryWrapper<SettleReportEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(SettleReportEntity::getProjectId, projectId);
        }
        wrapper.eq(SettleReportEntity::getContractId, contractId);
        wrapper.orderByDesc(SettleReportEntity::getCreateTime);
        List<SettleReportEntity> list = reportService.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            throw new BusinessException("请先做结算报审！");
        }

        // 是否存在已生效的结算报审单
        boolean billStateFlag = list.stream().anyMatch(entity -> entity.getBillState() == 1 || entity.getBillState() == 3);
        if (!billStateFlag) {
            throw new BusinessException("请先做结算报审！");
        }

        SettleReportVO vo = new SettleReportVO();
        for (SettleReportEntity entity : list) {
            if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                vo = BeanMapper.map(entity, SettleReportVO.class);
                break;
            }
        }
        
        return vo;
    }

    @Override
    public FinalizedVO queryFinalizedList(Long projectId, Long contractId, Long id) {
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(FinalizedEntity::getId, id);
        }
        wrapper.eq(FinalizedEntity::getContractId, contractId);
        wrapper.orderByDesc(FinalizedEntity::getCreateTime);
        List<FinalizedEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new FinalizedVO();
        }

        long count = list.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
        if (count > 0) {
            throw new BusinessException("当前合同存在非审批通过的工程定案，不允许新增！");
        }
        
        return BeanMapper.map(list.get(0), FinalizedVO.class);
    }

    @Override
    public Boolean validateFinalStage(Long projectId, Long contractId, String finalStage, Long id) {
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(FinalizedEntity::getId, id);
        }
        wrapper.eq(FinalizedEntity::getContractId, contractId);
        wrapper.orderByDesc(FinalizedEntity::getCreateTime);
        List<FinalizedEntity> list = this.list(wrapper);
        
        if (ListUtil.isEmpty(list)) {
            if (Objects.equals(finalStage, FinalStageEnum.终审.getCode())) {
                return true;
            }
            if (!Objects.equals(finalStage, FinalStageEnum.一审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
        }
        
        boolean flag = list.stream().anyMatch(entity -> entity.getFinalStage().equals(finalStage));
        if (flag) {
            throw new BusinessException("已存在该定案阶段，请重新选择！");
        }

        List<String> finalStageList = list.stream().map(FinalizedEntity::getFinalStage).collect(Collectors.toList());
        if (Objects.equals(finalStage, FinalStageEnum.二审.getCode())) {
            if (!finalStageList.contains(FinalStageEnum.一审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
        }

        if (Objects.equals(finalStage, FinalStageEnum.三审.getCode())) {
            if (!finalStageList.contains(FinalStageEnum.一审.getCode()) && !finalStageList.contains(FinalStageEnum.二审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
            if (finalStageList.contains(FinalStageEnum.一审.getCode()) && !finalStageList.contains(FinalStageEnum.二审.getCode())) {
                throw new BusinessException("请先完成二审！");
            }
        }

        if (Objects.equals(finalStage, FinalStageEnum.终审.getCode())) {
            LambdaQueryWrapper<SettleReportEntity> reportWrapper = new LambdaQueryWrapper<>();
            if (!Objects.equals(null, projectId)) {
                reportWrapper.eq(SettleReportEntity::getProjectId, projectId);
            }
            reportWrapper.eq(SettleReportEntity::getContractId, contractId);
            reportWrapper.orderByDesc(SettleReportEntity::getCreateTime);
            List<SettleReportEntity> reportEntityList = reportService.list(reportWrapper);

            long count = reportEntityList.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
            if (count > 0) {
                throw new BusinessException("该合同下存未生效的结算报审单据，不允许新增终审定案！");
            }
        }
        
        return true;
    }

    @Override
    public FinalizedHistoryVO queryFinalizedRecord(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);
        FinalizedHistoryVO vo = new FinalizedHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());

        // 查询历史记录
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(FinalizedEntity::getContractId, id);
        wrapper.in(FinalizedEntity::getBillState, billStateList);
        wrapper.orderByDesc(FinalizedEntity::getCheckDate);
        List<FinalizedEntity> list = super.list(wrapper);
        
        // 审定总金额、审减总金额
        BigDecimal sumCheckTaxMny = list.stream().filter(e -> e.getCheckTaxMny() != null).map(FinalizedEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReviewSubtractMny = list.stream().filter(e -> e.getReviewSubtractMny() != null).map(FinalizedEntity::getReviewSubtractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        
        vo.setSumCheckMny(sumCheckTaxMny);
        vo.setSumReviewSubtractMny(sumReviewSubtractMny);
        vo.setDetailList(BeanMapper.mapList(list, FinalizedVO.class));
        
        return vo;
    }

    @Override
    public boolean pushSettleToPool(FinalizedVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+ JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",id, res.getMsg());
            }
        }catch (Exception e){
            logger.error("结算单弃审推送合同池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送合同池异常!");
        }
        return flag;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, String performanceStatus) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            registerService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert(vo, data);
            data.setPerformanceStatus(performanceStatus);
            data.setChangeStatus(Integer.parseInt(vo.getChangeStatus()));
            data.setContractProperty(1);
            data.setSourceType(ContractTypeEnum.施工合同.getTypeCode());
            String url = null;
            if (vo.getSupplementFlag() == 0) {
                url = "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId();
            }else {
                url = "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            }
            data.setPcCardUrl(url);
            data.setCategoryId(1524001989040545793L);// 施工合同类别是自定义档案，合同池写死
            //data.setMobileCardUrl(baseHost+"ejc-proincome-mobile/#/contractRegister/card");
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}", vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        return false;
    }

    // 将FinalizedVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(FinalizedVO vo, SettlePoolVO spv) {
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        spv.setSourceType("project_decide");//结算类型
        spv.setSourceId(vo.getId());//结算单id
        spv.setId(vo.getId());// id
        spv.setSettleProperty(1);
        spv.setUltimateFlag(0);//是否最终结算=否
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setBillCodeUrl("/ejc-proincome-frontend/#/finalized/card?id=" + vo.getId());// 穿透地址
        if(vo.getContractId()!=null){//有合同需要推送的字段
            //查询合同
            ContractRegisterEntity contractEntity = contractService.selectById(vo.getContractId());
            spv.setContractType("contraction");
            spv.setContractFlag(1);//合同标识
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getCustomerId());//甲方id
            spv.setPartyaName(contractEntity.getCustomerName());//甲方name
            spv.setPartybId(contractEntity.getSupplierId());//乙方id
            spv.setPartybName(contractEntity.getSupplierName());//乙方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            BigDecimal lastTaxMny = BigDecimal.ZERO; // 截止本期累计结算金额
            BigDecimal lastMny = BigDecimal.ZERO; // 截止本期累计结算金额（无税）
            BigDecimal lastTax = BigDecimal.ZERO; // 截止本期累计结算税额
            /*获取除本次累计结算金额*/
            LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.orderByDesc(FinalizedEntity::getCreateTime);
            wrapper.in(FinalizedEntity::getBillState, 1,3);
            wrapper.eq(FinalizedEntity::getDr, 0);
            wrapper.eq(FinalizedEntity::getContractId, vo.getContractId());
            wrapper.ne(FinalizedEntity::getId,vo.getId());
            wrapper.eq(FinalizedEntity::getFinalStage,"4");
            List<FinalizedEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                for (FinalizedEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getCheckTaxMny()==null?BigDecimal.ZERO:settlementEntity.getCheckTaxMny();
                    BigDecimal settMny = settlementEntity.getCheckMny()==null?BigDecimal.ZERO:settlementEntity.getCheckMny();
                    BigDecimal settTax = settlementEntity.getTax()==null?BigDecimal.ZERO:settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(lastMny);//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(lastTax);//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成");
    }

}
