/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.arch.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.arch.bean.ArchitectEntity;
import com.ejianc.business.pro.arch.mapper.ArchitectMapper;
import com.ejianc.business.pro.arch.service.IArchitectService;
import com.ejianc.business.pro.arch.utils.DetailIndexExcelReader2;
import com.ejianc.business.pro.arch.vo.ArchitectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="architectService")
public class ArchitectServiceImpl
extends BaseServiceImpl<ArchitectMapper, ArchitectEntity>
implements IArchitectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ARC_N_C";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
        List<List<String>> result = resList.get(1);
        if (result != null && result.size() > 0) {
            ArrayList<ArchitectEntity> arcList = new ArrayList<ArchitectEntity>();
            for (int i = 0; i < result.size(); ++i) {
                String sex;
                List<String> datas = result.get(i);
                this.logger.error("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(datas));
                ArchitectVO architectVO = new ArchitectVO();
                boolean flag = false;
                String warnType = "";
                if (StringUtils.isEmpty((CharSequence)datas.get(0))) {
                    String name = datas.get(0);
                    architectVO.setName(name);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(1))) {
                    String idCard = datas.get(1);
                    architectVO.setIdCard(idCard);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(2))) {
                    sex = datas.get(2);
                    architectVO.setSex("\u7537".equals(sex) ? "1" : "2");
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(3))) {
                    sex = datas.get(3);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(4))) {
                    String registrationNumber = datas.get(4);
                    architectVO.setRegistrationNumber(registrationNumber);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(5))) {
                    String validity = datas.get(5);
                    architectVO.setValidity(new Date(validity));
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(6))) {
                    String certificateNumber = datas.get(6);
                    architectVO.setCertificateNumber(certificateNumber);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(7))) {
                    String certificateValidity = datas.get(7);
                    architectVO.setCertificateValidity(new Date(certificateValidity));
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(8))) {
                    String titleLevel;
                    switch (titleLevel = datas.get(8)) {
                        case "\u6b63\u9ad8\u7ea7": {
                            architectVO.setTitleLevel("0");
                            break;
                        }
                        case "\u526f\u9ad8\u7ea7": {
                            architectVO.setTitleLevel("1");
                            break;
                        }
                        case "\u4e2d\u7ea7": {
                            architectVO.setTitleLevel("2");
                            break;
                        }
                        case "\u521d\u7ea7": {
                            architectVO.setTitleLevel("3");
                            break;
                        }
                        case "\u5458\u7ea7": {
                            architectVO.setTitleLevel("4");
                            break;
                        }
                    }
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(9))) {
                    String addItemOne = datas.get(9);
                    architectVO.setAddItemOne(addItemOne);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(10))) {
                    String addItemTwo = datas.get(10);
                    architectVO.setAddItemTwo(addItemTwo);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(11))) {
                    String addItemThree = datas.get(11);
                    architectVO.setAddItemThree(addItemThree);
                }
                if (StringUtils.isEmpty((CharSequence)datas.get(12))) {
                    String memo = datas.get(12);
                    architectVO.setMemo(memo);
                }
                architectVO.setEmployeeId(InvocationInfoProxy.getUserid());
                architectVO.setOrgId(InvocationInfoProxy.getOrgId());
                ArchitectEntity entity = (ArchitectEntity)((Object)BeanMapper.map((Object)architectVO, ArchitectEntity.class));
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)architectVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
                arcList.add(entity);
            }
            this.logger.info("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(arcList));
        }
        return null;
    }
}

