package com.ejianc.business.pro.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.income.bean.SettlementFinalizationDetailEntity;
/**
 * 工程结算定案表返回确认单主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_settlement_finalization")
public class SettlementFinalizationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value = "construct_id")
    private Long constructId; // 建设单位id
    @TableField(value="construct_name")
    private String constructName; // 建设单位
    @TableField(value = "check_unit_id")
    private Long checkUnitId; // 审核单位id
    @TableField(value="check_unit")
    private String checkUnit; // 审核单位
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值
    @TableField(value="sum_cost_mny")
    private BigDecimal sumCostMny; // 累计成本

    @TableField(value="sum_receipt_mny")
    private BigDecimal sumReceiptMny; // 累计收款金额
    @TableField(value="censorship_settlement_mny")
    private BigDecimal censorshipSettlementMny; // 送审结算金额
    @TableField(value="censorship_date")
    private Date censorshipDate; // 送审日期
    @TableField(value="finalization_stage")
    private String finalizationStage; // 定案阶段
    @TableField(value="finalization_stage_name")
    private String finalizationStageName; // 定案阶段名称：1-一审，2-二审，3-三审，4-终审
    @TableField(value="final_Judgment")
    private Integer finalJudgment; // 是否终审 0-否 1-是
    @TableField(value="government_audit")
    private Integer governmentAudit; // 是否政府审计 0-否 1-是
    @TableField(value="authorize_mny")
    private BigDecimal authorizeMny; // 审定金额
    @TableField(value="authorize_date")
    private Date authorizeDate; // 审定日期
    @TableField(value="final_reduction_rate")
    private BigDecimal finalReductionRate; // 最终审减率
    @TableField(value="contract_reduction_rate")
    private BigDecimal contractReductionRate; // 合同约定审减率
    @TableField(value="finalization_back_date")
    private Date finalizationBackDate; // 定案表返回日期
    @TableField(value="sum_finalization_back_mny")
    private BigDecimal sumFinalizationBackMny; // 定案表返回金额
    @TableField(value="finalization_difference_mny")
    private BigDecimal finalizationDifferenceMny; // 定案表返回金额与审定金额之差
    @TableField(value="sum_finalization_out_mny")
    private BigDecimal sumFinalizationOutMny; // 定案表外金额
    @TableField(value="finalization_form_flag")
    private Integer finalizationFormFlag; // 是否取得竣工备案表 0-否 1-是
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="sum_cost_tax_mny")
    private BigDecimal sumCostTaxMny; // 累计成本

    @TableField(value = "settle_stage")
    private String settleStage; // 结算阶段  固定值【第一阶段、第二阶段、第三阶段、第四阶段、第五阶段】
    @TableField(value = "unit_property")
    private String unitProperty; // 建设单位性质 1-集团内  2-集团外
    @TableField(exist=false)
    @SubEntity(serviceName="settlementFinalizationDetailService",pidName = "finalizationId")
    private List<SettlementFinalizationDetailEntity> detailList = new ArrayList<>(); // 工程结算定案表返回确认单子实体
    @TableField(value="censorship_settlement_tax_mny")
    private BigDecimal censorshipSettlementTaxMny; // 送审结算金额(含税)

    public Integer getGovernmentAudit() {
        return governmentAudit;
    }

    public void setGovernmentAudit(Integer governmentAudit) {
        this.governmentAudit = governmentAudit;
    }

    public Integer getFinalJudgment() {
        return finalJudgment;
    }

    public void setFinalJudgment(Integer finalJudgment) {
        this.finalJudgment = finalJudgment;
    }

    public String getFinalizationStageName() {
        return finalizationStageName;
    }

    public void setFinalizationStageName(String finalizationStageName) {
        this.finalizationStageName = finalizationStageName;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getCensorshipSettlementTaxMny() {
        return censorshipSettlementTaxMny;
    }

    public void setCensorshipSettlementTaxMny(BigDecimal censorshipSettlementTaxMny) {
        this.censorshipSettlementTaxMny = censorshipSettlementTaxMny;
    }

    public String getUnitProperty() {
        return unitProperty;
    }

    public void setUnitProperty(String unitProperty) {
        this.unitProperty = unitProperty;
    }

    public String getSettleStage() {
        return settleStage;
    }

    public void setSettleStage(String settleStage) {
        this.settleStage = settleStage;
    }

    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }

    public Long getCheckUnitId() {
        return checkUnitId;
    }

    public void setCheckUnitId(Long checkUnitId) {
        this.checkUnitId = checkUnitId;
    }

    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getCensorshipSettlementMny() {
        return censorshipSettlementMny;
    }

    public void setCensorshipSettlementMny(BigDecimal censorshipSettlementMny) {
        this.censorshipSettlementMny = censorshipSettlementMny;
    }
    public Date getCensorshipDate() {
        return censorshipDate;
    }

    public void setCensorshipDate(Date censorshipDate) {
        this.censorshipDate = censorshipDate;
    }
    public String getFinalizationStage() {
        return finalizationStage;
    }

    public void setFinalizationStage(String finalizationStage) {
        this.finalizationStage = finalizationStage;
    }
    public BigDecimal getAuthorizeMny() {
        return authorizeMny;
    }

    public void setAuthorizeMny(BigDecimal authorizeMny) {
        this.authorizeMny = authorizeMny;
    }
    public Date getAuthorizeDate() {
        return authorizeDate;
    }

    public void setAuthorizeDate(Date authorizeDate) {
        this.authorizeDate = authorizeDate;
    }
    public BigDecimal getFinalReductionRate() {
        return finalReductionRate;
    }

    public void setFinalReductionRate(BigDecimal finalReductionRate) {
        this.finalReductionRate = finalReductionRate;
    }
    public BigDecimal getContractReductionRate() {
        return contractReductionRate;
    }

    public void setContractReductionRate(BigDecimal contractReductionRate) {
        this.contractReductionRate = contractReductionRate;
    }
    public Date getFinalizationBackDate() {
        return finalizationBackDate;
    }

    public void setFinalizationBackDate(Date finalizationBackDate) {
        this.finalizationBackDate = finalizationBackDate;
    }
    public BigDecimal getSumFinalizationBackMny() {
        return sumFinalizationBackMny;
    }

    public void setSumFinalizationBackMny(BigDecimal sumFinalizationBackMny) {
        this.sumFinalizationBackMny = sumFinalizationBackMny;
    }
    public BigDecimal getFinalizationDifferenceMny() {
        return finalizationDifferenceMny;
    }

    public void setFinalizationDifferenceMny(BigDecimal finalizationDifferenceMny) {
        this.finalizationDifferenceMny = finalizationDifferenceMny;
    }
    public BigDecimal getSumFinalizationOutMny() {
        return sumFinalizationOutMny;
    }

    public void setSumFinalizationOutMny(BigDecimal sumFinalizationOutMny) {
        this.sumFinalizationOutMny = sumFinalizationOutMny;
    }
    public Integer getFinalizationFormFlag() {
        return finalizationFormFlag;
    }

    public void setFinalizationFormFlag(Integer finalizationFormFlag) {
        this.finalizationFormFlag = finalizationFormFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }


    public List<SettlementFinalizationDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettlementFinalizationDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
