package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.PlancompletionDetailVO;
import com.ejianc.business.pro.income.vo.PlancompletionListVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.income.vo.PlancompletionVO;

/**
 * 建设项目年度结算计划与完成对比表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plancompletion")
public class PlancompletionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLANCOMPLETION_CODE";//此处需要根据实际修改

    @Autowired
    private IPlancompletionService service;

    @Autowired
    private IPlancompletionDetailService plancompletionDetailService;

    @Autowired
    private IContractRegisterService contractRegisterService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private ISettleReportService settleReportService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlancompletionVO> saveOrUpdate(@RequestBody PlancompletionVO saveOrUpdateVO) {

        LambdaQueryWrapper<PlancompletionEntity> lambda = Wrappers.<PlancompletionEntity>lambdaQuery();
        lambda.eq(PlancompletionEntity::getYear,saveOrUpdateVO.getYear());
        lambda.in(PlancompletionEntity::getOrgId,saveOrUpdateVO.getOrgId());
        if(null!=saveOrUpdateVO.getId()){
            lambda.ne(PlancompletionEntity::getId,saveOrUpdateVO.getId());
        }
        List<PlancompletionEntity> list = service.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("当前组织在该年份下已存在对比表，请选择其他年份！");
        }

        List<PlancompletionDetailVO> detailVOList = saveOrUpdateVO.getPlancompletionDetailList();
        if(CollectionUtils.isNotEmpty(detailVOList)){
            detailVOList.forEach(e->{
                if(null!=e.getParentProjectId()){
                    LambdaQueryWrapper<PlancompletionDetailEntity> lambda2 = Wrappers.<PlancompletionDetailEntity>lambdaQuery();
                    lambda2.eq(PlancompletionDetailEntity::getParentProjectId,e.getParentProjectId());
                    lambda2.orderByDesc(PlancompletionDetailEntity::getCreateTime);
                    List<PlancompletionDetailEntity> resList = plancompletionDetailService.list(lambda2);
                    if(CollectionUtils.isNotEmpty(resList)&&!e.getApproveDate().equals(resList.get(0).getApproveDate())){
                        throw new BusinessException("父项目名称为【"+e.getParentProjectName()+"】与已有单据中的计划审定日期【"+resList.get(0).getApproveDate()+"】不一致，请沟通后调整");
                    }
                }
            });
        }

    	PlancompletionEntity entity = BeanMapper.map(saveOrUpdateVO, PlancompletionEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PlancompletionVO vo = BeanMapper.map(entity, PlancompletionVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlancompletionVO> queryDetail(Long id) {
    	PlancompletionEntity entity = service.selectById(id);
    	PlancompletionVO vo = BeanMapper.map(entity, PlancompletionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryMny 查询详情
     * @param
     */
    @RequestMapping(value = "/queryMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlancompletionDetailVO> queryMny(Long projectId) {
        PlancompletionDetailVO vo = new PlancompletionDetailVO();
        // 合同金额  带项目的收入合同金额
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getProjectId,projectId);
        lambda.in(ContractRegisterEntity::getBillState,1,3);
        List<ContractRegisterEntity> contractRegisterList = contractRegisterService.list(lambda);
        if(CollectionUtils.isNotEmpty(contractRegisterList)){
            BigDecimal contractMny = contractRegisterList.stream().filter(item -> null != item.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setContractMny(contractMny);
        }else{
            vo.setContractMny(BigDecimal.ZERO);
        }
       // 累计实际完成产值   取项目下已生效的【产值报量】中的“产值金额”累计值
        LambdaQueryWrapper<ProductionEntity> lambda2 = Wrappers.<ProductionEntity>lambdaQuery();
        lambda2.eq(ProductionEntity::getProjectId,projectId);
        lambda2.in(ProductionEntity::getBillState,1,3);
        List<ProductionEntity> productionList = productionService.list(lambda2);
        if(CollectionUtils.isNotEmpty(productionList)){
            BigDecimal productionTaxMny = productionList.stream().filter(item -> null != item.getProductionTaxMny()).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setSumCompleteMny(productionTaxMny);
        }else{
            vo.setSumCompleteMny(BigDecimal.ZERO);
        }

        LambdaQueryWrapper<SettleReportEntity> lambda3 = Wrappers.<SettleReportEntity>lambdaQuery();
        lambda3.eq(SettleReportEntity::getProjectId,projectId);
        lambda3.in(SettleReportEntity::getBillState,1,3);
        lambda3.orderByDesc(SettleReportEntity::getCreateTime);
        List<SettleReportEntity> settleReportList = settleReportService.list(lambda3);
        if(CollectionUtils.isNotEmpty(settleReportList)){
            BigDecimal reportSettleTaxMny = settleReportList.stream().filter(item -> null != item.getReportSettleTaxMny()).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal predictCheckMny = settleReportList.stream().filter(item -> null != item.getPredictCheckMny()).map(SettleReportEntity::getPredictCheckMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setDetailSubmitMny(reportSettleTaxMny);// 送审金额   取项目下已生效【结算报审】中的“报审结算金额”累计值
            vo.setYdApproveMny(predictCheckMny);// 预计审定金额  取项目下已生效【结算报审】中“预计审定金额”累计值
            vo.setDetailSubmitDate(settleReportList.get(0).getReportDate()); // 送审日期  取项目下已生效【结算报审】中最新一期的“报审结算日期”
            String unitProperty = settleReportList.get(0).getUnitProperty()==null?"1":settleReportList.get(0).getUnitProperty();
            vo.setGroupType(Integer.parseInt(unitProperty));
        }else{
            vo.setDetailSubmitMny(BigDecimal.ZERO);// 送审金额   取项目下已生效【结算报审】中的“报审结算金额”累计值
            vo.setYdApproveMny(BigDecimal.ZERO);// 预计审定金额  取项目下已生效【结算报审】中“预计审定金额”累计值
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlancompletionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PlancompletionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlancompletionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlancompletionListVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlancompletionEntity> page = service.queryPage(param,false);
        IPage<PlancompletionListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlancompletionListVO> resDatas = new ArrayList<>();
  		if(CollectionUtils.isNotEmpty(page.getRecords())){
            resDatas = BeanMapper.mapList(page.getRecords(), PlancompletionListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long,Integer> map = new HashMap<>();
            if(CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<PlancompletionDetailEntity> lambda = Wrappers.<PlancompletionDetailEntity>lambdaQuery();
            lambda.in(PlancompletionDetailEntity::getCompletionId,ids);
            List<PlancompletionDetailEntity> resList = plancompletionDetailService.list(lambda);
            List<PlancompletionListVO> plancompletionListVOList = BeanMapper.mapList(resList, PlancompletionListVO.class);
            if(CollectionUtils.isNotEmpty(plancompletionListVOList)){
                plancompletionListVOList.forEach(e->{
                    e.setBillState(map.get(e.getCompletionId()));
                    e.setYearApproveMny(e.getYdApproveMny()==null?BigDecimal.ZERO:e.getYdApproveMny());
                    e.setYearSubmitMny(e.getDetailSubmitMny()==null?BigDecimal.ZERO:e.getDetailSubmitMny());
                    e.setGroupMny(e.getFinalizeMny()==null?BigDecimal.ZERO:e.getFinalizeMny());
                });
                resDatas.addAll(plancompletionListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else{
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlancompletionListVO.class));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlancompletionEntity> list = service.queryList(param);

        List<PlancompletionListVO> resDatas = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> ids = list.stream().map(PlancompletionEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PlancompletionDetailEntity> lambda = Wrappers.<PlancompletionDetailEntity>lambdaQuery();
            lambda.in(PlancompletionDetailEntity::getCompletionId,ids);
            List<PlancompletionDetailEntity> resList = plancompletionDetailService.list(lambda);
            for(int i=0;i<list.size();i++){
                resDatas.add(BeanMapper.map(list.get(i), PlancompletionListVO.class));
                for(int k=0;k<resList.size();k++){
                    if(list.get(i).getId().equals(resList.get(k).getCompletionId())){
                        PlancompletionListVO e = BeanMapper.map(resList.get(k), PlancompletionListVO.class);
                        e.setYearApproveMny(e.getYdApproveMny()==null?BigDecimal.ZERO:e.getYdApproveMny());
                        e.setYearSubmitMny(e.getDetailSubmitMny()==null?BigDecimal.ZERO:e.getDetailSubmitMny());
                        e.setGroupMny(e.getFinalizeMny()==null?BigDecimal.ZERO:e.getFinalizeMny());
                        resDatas.add(e);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(resDatas)){
            resDatas.forEach(e->{
                if(null!=e.getGroupType()){
                    e.setGroupTypeName(e.getGroupType()==1?"内":"外");
                }
                if(null!=e.getYearPlanFlag()){
                    e.setYearPlanFlagName(e.getYearPlanFlag()==0?"是":"否");
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plancompletion-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPlancompletionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlancompletionVO>> refPlancompletionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlancompletionEntity> page = service.queryPage(param,false);
        IPage<PlancompletionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlancompletionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
