/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.bean.UnsettleDetailEntity;
import com.ejianc.business.pro.income.bean.UnsettleEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.service.IUnsettleDetailService;
import com.ejianc.business.pro.income.service.IUnsettleService;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.MonthVO;
import com.ejianc.business.pro.income.vo.UnsettleDetailVO;
import com.ejianc.business.pro.income.vo.UnsettleListVO;
import com.ejianc.business.pro.income.vo.UnsettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"unsettle"})
public class UnsettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "UNSETTLE_CODE";
    @Autowired
    private IUnsettleService service;
    @Autowired
    private IUnsettleDetailService unsettleDetailService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private ISettleReportService settleReportService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UnsettleVO> saveOrUpdate(@RequestBody UnsettleVO saveOrUpdateVO) {
        UnsettleEntity entity = (UnsettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, UnsettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        UnsettleVO vo = (UnsettleVO)BeanMapper.map((Object)((Object)entity), UnsettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UnsettleVO> queryDetail(Long id) {
        UnsettleEntity entity = (UnsettleEntity)((Object)this.service.selectById(id));
        UnsettleVO vo = (UnsettleVO)BeanMapper.map((Object)((Object)entity), UnsettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UnsettleDetailVO> queryMny(Long projectId) {
        UnsettleDetailVO vo = new UnsettleDetailVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        lambda.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List contractRegisterList = this.contractRegisterService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterList)) {
            BigDecimal contractMny = contractRegisterList.stream().filter(item -> null != item.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setContractMny(contractMny);
            vo.setContractProgressScale(((ContractRegisterEntity)((Object)contractRegisterList.get(0))).getContractPromisePaymentRate());
            vo.setContractSettleScale(((ContractRegisterEntity)((Object)contractRegisterList.get(0))).getContractSettleRate());
        } else {
            vo.setContractMny(BigDecimal.ZERO);
            vo.setContractProgressScale(BigDecimal.ZERO);
            vo.setContractSettleScale(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(ProductionEntity::getProjectId, (Object)projectId);
        lambda2.in(ProductionEntity::getBillState, new Object[]{1, 3});
        List productionList = this.productionService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)productionList)) {
            BigDecimal productionTaxMny = productionList.stream().filter(item -> null != item.getProductionTaxMny()).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setSumCompleteMny(productionTaxMny);
        } else {
            vo.setSumCompleteMny(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(SettleReportEntity::getProjectId, (Object)projectId);
        lambda3.in(SettleReportEntity::getBillState, new Object[]{1, 3});
        lambda3.orderByDesc(BaseEntity::getCreateTime);
        List settleReportList = this.settleReportService.list((Wrapper)lambda3);
        if (CollectionUtils.isNotEmpty((Collection)settleReportList)) {
            BigDecimal reportSettleTaxMny = settleReportList.stream().filter(item -> null != item.getReportSettleTaxMny()).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setDetailSubmitMny(reportSettleTaxMny);
            vo.setDetailSubmitDate(((SettleReportEntity)((Object)settleReportList.get(0))).getPredictCheckDate());
        } else {
            vo.setDetailSubmitMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryYears"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> queryYears() {
        Calendar calendar3;
        Date signDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(signDate);
        calendar.add(1, -1);
        calendar.getTime();
        Date beforeDate = calendar.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date());
        calendar2.add(1, 1);
        Date endDate = calendar2.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        ArrayList<String> list = new ArrayList<String>();
        do {
            list.add(sdf.format(endDate));
            calendar3 = Calendar.getInstance();
            calendar3.setTime(endDate);
            calendar3.add(1, -1);
        } while (beforeDate.before(endDate = calendar3.getTime()));
        list.add(sdf.format(beforeDate));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryMonths"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MonthVO>> queryMonths(Long id, String year) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        String currentMonth = dateFormat.format(new Date());
        List<MonthVO> list = this.service.getMonths(id, year);
        HashMap map = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> map.put(e.getMonth(), e));
        }
        ArrayList<MonthVO> listMonth = new ArrayList<MonthVO>();
        for (int i = 1; i < 13; ++i) {
            MonthVO vo = new MonthVO();
            if (i < 10) {
                vo.setMonth(year + "-0" + i);
                if (map.containsKey(vo.getMonth())) {
                    vo.setNum(((MonthVO)map.get(vo.getMonth())).getNum());
                    vo.setResolvedDisputedMny(((MonthVO)map.get(vo.getMonth())).getResolvedDisputedMny());
                } else {
                    vo.setNum(Integer.valueOf(0));
                    vo.setResolvedDisputedMny(BigDecimal.ZERO);
                }
            } else {
                vo.setMonth(year + "-" + i);
                if (map.containsKey(vo.getMonth())) {
                    vo.setNum(((MonthVO)map.get(vo.getMonth())).getNum());
                    vo.setResolvedDisputedMny(((MonthVO)map.get(vo.getMonth())).getResolvedDisputedMny());
                } else {
                    vo.setNum(Integer.valueOf(0));
                    vo.setResolvedDisputedMny(BigDecimal.ZERO);
                }
            }
            if (vo.getMonth().endsWith(currentMonth)) {
                vo.setFlag(true);
            } else {
                vo.setFlag(false);
            }
            listMonth.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", listMonth);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnsettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UnsettleVO unsettleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnsettleListVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), UnsettleListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(UnsettleDetailEntity::getUnsettleId, ids);
            List resList = this.unsettleDetailService.list((Wrapper)lambda);
            List unsettleListVOList = BeanMapper.mapList((Iterable)resList, UnsettleListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)unsettleListVOList)) {
                unsettleListVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getUnsettleId()));
                    e.setFinalizeBackMny(e.getFinalizeMny() == null ? BigDecimal.ZERO : e.getFinalizeMny());
                    e.setDisputedMny(e.getDetailDisputedMny() == null ? BigDecimal.ZERO : e.getDetailDisputedMny());
                    if (e.getSubmissionFlag() != null) {
                        e.setSubmissionFlagName(e.getSubmissionFlag() == 0 ? "\u672a\u9001\u5ba1" : "\u5df2\u9001\u5ba1");
                    }
                    if (e.getSettleStage() != null) {
                        switch (e.getSettleStage()) {
                            case 1: {
                                e.setSettleStageName("\u7b2c\u4e00\u9636\u6bb5");
                                break;
                            }
                            case 2: {
                                e.setSettleStageName("\u7b2c\u4e8c\u9636\u6bb5");
                                break;
                            }
                            case 3: {
                                e.setSettleStageName("\u7b2c\u4e09\u9636\u6bb5");
                                break;
                            }
                            case 4: {
                                e.setSettleStageName("\u7b2c\u56db\u9636\u6bb5");
                                break;
                            }
                            case 5: {
                                e.setSettleStageName("\u7b2c\u4e94\u9636\u6bb5");
                            }
                        }
                    }
                });
                resDatas.addAll(unsettleListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnsettleListVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<Object> resDatas = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(UnsettleDetailEntity::getUnsettleId, ids);
            List resList = this.unsettleDetailService.list((Wrapper)lambda);
            for (int i = 0; i < list.size(); ++i) {
                resDatas.add(BeanMapper.map(list.get(i), UnsettleListVO.class));
                for (int k = 0; k < resList.size(); ++k) {
                    UnsettleListVO e2;
                    if (!((UnsettleEntity)((Object)list.get(i))).getId().equals(((UnsettleDetailEntity)((Object)resList.get(k))).getUnsettleId())) continue;
                    e2.setFinalizeBackMny((e2 = (UnsettleListVO)BeanMapper.map(resList.get(k), UnsettleListVO.class)).getFinalizeMny() == null ? BigDecimal.ZERO : e2.getFinalizeMny());
                    e2.setDisputedMny(e2.getDetailDisputedMny() == null ? BigDecimal.ZERO : e2.getDetailDisputedMny());
                    resDatas.add(e2);
                }
            }
        }
        HashMap<String, ArrayList<Object>> beans = new HashMap<String, ArrayList<Object>>();
        resDatas.forEach(e -> {
            if (e.getSubmissionFlag() != null) {
                if (e.getSubmissionFlag() == 1) {
                    e.setSubmissionFlagName("\u5df2\u9001\u5ba1");
                } else {
                    e.setSubmissionFlagName("\u672a\u9001\u5ba1");
                }
            }
            if (e.getSettleStage() != null) {
                switch (e.getSettleStage()) {
                    case 1: {
                        e.setSettleStageName("\u7b2c\u4e00\u9636\u6bb5");
                        break;
                    }
                    case 2: {
                        e.setSettleStageName("\u7b2c\u4e8c\u9636\u6bb5");
                        break;
                    }
                    case 3: {
                        e.setSettleStageName("\u7b2c\u4e09\u9636\u6bb5");
                        break;
                    }
                    case 4: {
                        e.setSettleStageName("\u7b2c\u56db\u9636\u6bb5");
                        break;
                    }
                    case 5: {
                        e.setSettleStageName("\u7b2c\u4e94\u9636\u6bb5");
                    }
                }
            }
            if (e.getIndexGrade() != null) {
                switch (e.getIndexGrade()) {
                    case 1: {
                        e.setIndexGradeName("\u4e00\u7c7b");
                        break;
                    }
                    case 2: {
                        e.setIndexGradeName("\u4e8c\u7c7b");
                    }
                }
            }
            if (e.getScheduleCompletionDate() != null) {
                switch (e.getScheduleCompletionDate()) {
                    case 1: {
                        e.setScheduleCompletionDateName("\u7b2c\u4e00\u5b63\u5ea6");
                        break;
                    }
                    case 2: {
                        e.setScheduleCompletionDateName("\u7b2c\u4e8c\u5b63\u5ea6");
                        break;
                    }
                    case 3: {
                        e.setScheduleCompletionDateName("\u7b2c\u4e09\u5b63\u5ea6");
                        break;
                    }
                    case 4: {
                        e.setScheduleCompletionDateName("\u7b2c\u56db\u5b63\u5ea6");
                    }
                }
            }
        });
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Unsettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refUnsettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UnsettleVO>> refUnsettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnsettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

