/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.utils.BillTypeCodeEnum;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRegisterService")
public class ContractRegisterServiceImpl
extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity>
implements IContractRegisterService {
    private static final String INCOME_CONTRACT_REGISTER = "INCOME_CONTRACT_REGISTER";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    public ContractRegisterMapper mapper;
    @Autowired
    private IProjectSetApi projectSetApi;

    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {
        if (!Objects.equals(null, saveorUpdateVO.getReviewId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c\u8bc4\u5ba1.getCode(), saveorUpdateVO.getReviewVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractRegisterEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List list = this.list((Wrapper)wrapper);
                    String supplementNum = "";
                    supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_REGISTER, (Long)tenantId, (BaseVO)saveorUpdateVO);
                    CommonResponse response = this.billCodeApi.generateBillCode(billCodeParam);
                    if (response.isSuccess()) {
                        billCode = (String)response.getData();
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                entity.setBillCode(billCode);
            }
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            entity.setChangeStatus("1");
        } else {
            if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }
        }
        entity.setContractTaxMny(entity.getBaseTaxMoney());
        entity.setContractMny(entity.getBaseMoney());
        entity.setTaxMny(entity.getBaseTax());
        entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTaxMoney(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
        entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseMoney(), (BigDecimal)entity.getTotalCostAdjustMny()));
        entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTax(), (BigDecimal)entity.getTotalCostAdjustTax()));
        entity.setNicContractMny(ComputeUtil.safeSub((BigDecimal)entity.getContractTaxMny(), (BigDecimal)entity.getProvisionalMny()));
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity, false);
        return (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (null == param.getParams().get("parentOrgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List entityList = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)entityList, ContractRegisterVO.class);
        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (StringUtils.isNotBlank((CharSequence)contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("\u5df2\u89e3\u9664");
                }
            } else {
                vo.setContractStatusName("");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = (ContractReviewEntity)((Object)this.reviewService.selectById(reviewId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)entity.getMainContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)list.get(0));
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }
        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(mainContractId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(id));
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, ContractRegisterVO.class));
        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)reviewId);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<ContractRegisterEntity>();
        }
        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            if ("1".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("2");
            }
            if ("2".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("3");
            }
            if ("3".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
            data.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
            data.setSourceId(vo.getId());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-proincome-frontend/#/contractRegister/contractApprove?id=" + vo.getId() : "/ejc-proincome-frontend/#/contractRegister/supplementCard?id=";
            data.setPcCardUrl(url);
            this.logger.info("\u65bd\u5de5\u5408\u540c\u767b\u8bb0\u63a8\u5408\u540c\u6c60\uff0c{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public List<Map<String, Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryCostWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public ContractRegisterVO queryRegisterByProject(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        wrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ContractRegisterVO();
        }
        return (ContractRegisterVO)BeanMapper.map(list.get(0), ContractRegisterVO.class);
    }

    @Override
    public List<Map<String, Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleReportWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.querySettleReportWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryFinalizedWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryFinalizedWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryBudgetInWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryBudgetInWarnContract(sqlParamList);
    }

    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.reviewService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ContractReviewVO();
        }
        return (ContractReviewVO)BeanMapper.map(list.get(0), ContractReviewVO.class);
    }

    @Override
    public ContractRegisterVO queryParentRateByProject(Long projectId) {
        CommonResponse projectDataRes = this.projectSetApi.getProjectId(projectId);
        if (projectDataRes.isSuccess()) {
            ProjectPoolSetVO data = (ProjectPoolSetVO)projectDataRes.getData();
            if (data.getParentProjectId() != null) {
                Long parentProjectId = data.getParentProjectId();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(ContractRegisterEntity::getProjectId, (Object)parentProjectId);
                wrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
                wrapper.orderByAsc(BaseEntity::getCreateTime);
                List list = super.list((Wrapper)wrapper);
                if (ListUtil.isEmpty((List)list)) {
                    return new ContractRegisterVO();
                }
                return (ContractRegisterVO)BeanMapper.map(list.get(0), ContractRegisterVO.class);
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u672a\u67e5\u5230\u9879\u76ee\u4fe1\u606f\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return new ContractRegisterVO();
    }
}

