/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.bean.SettlementFinalizationDetailEntity;
import com.ejianc.business.pro.income.bean.SettlementFinalizationEntity;
import com.ejianc.business.pro.income.mapper.SettlementFinalizationMapper;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.service.ISettlementFinalizationDetailService;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.SettlementFinalizationDetailVO;
import com.ejianc.business.pro.income.vo.SettlementFinalizationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementFinalizationService")
public class SettlementFinalizationServiceImpl
extends BaseServiceImpl<SettlementFinalizationMapper, SettlementFinalizationEntity>
implements ISettlementFinalizationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SETTLEMENT_FINALIZATION";
    @Autowired
    private IProductionService productionService;
    @Autowired
    private ISettleReportService settleReportService;
    @Autowired
    private ISettlementFinalizationDetailService settlementFinalizationDetailService;

    @Override
    public SettlementFinalizationVO saveOrUpdate(SettlementFinalizationVO saveOrUpdateVO) {
        List<SettlementFinalizationDetailEntity> entityDetailList;
        SettlementFinalizationEntity entity;
        if (null != saveOrUpdateVO.getContractId()) {
            List list;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)saveOrUpdateVO.getContractId()));
            queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
            if (saveOrUpdateVO.getId() != null) {
                queryParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
                throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5de5\u7a0b\u7ed3\u7b97\u5b9a\u6848\u8868\u8fd4\u56de\u786e\u8ba4\u5355\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if ((entity = (SettlementFinalizationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementFinalizationEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entityDetailList = entity.getDetailList()) && null == entity.getId()) {
            for (SettlementFinalizationDetailEntity detailEntity : entityDetailList) {
                detailEntity.setId(null);
                detailEntity.setParentId(null);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        List<SettlementFinalizationDetailEntity> entityDetailList2 = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(entityDetailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SettlementFinalizationDetailEntity detailEntity2 : entityDetailList2) {
                idMap.put(detailEntity2.getTid(), detailEntity2.getId());
            }
            for (SettlementFinalizationDetailEntity detailEntity2 : entityDetailList2) {
                if (!StringUtils.isNotEmpty((CharSequence)detailEntity2.getTpid())) continue;
                detailEntity2.setParentId((Long)idMap.get(detailEntity2.getTpid()));
            }
            this.settlementFinalizationDetailService.saveOrUpdateBatch(entityDetailList2);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public Boolean querySettleFinalization(Long projectId, Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(SettlementFinalizationEntity::getProjectId, (Object)projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.notIn(SettlementFinalizationEntity::getBillState, new Object[]{1, 3});
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u5de5\u7a0b\u7ed3\u7b97\u8fd4\u56de\u786e\u8ba4\u5355!");
        }
        return true;
    }

    @Override
    public SettlementFinalizationDetailVO getDataByProjectId(Long id, Long projectId, Long childProjectId, String settleStage) {
        LambdaQueryWrapper wrappersettlementFinalization = new LambdaQueryWrapper();
        wrappersettlementFinalization.eq(SettlementFinalizationEntity::getProjectId, (Object)projectId);
        if (id != null) {
            wrappersettlementFinalization.ne(BaseEntity::getId, (Object)id);
        }
        wrappersettlementFinalization.eq(SettlementFinalizationEntity::getSettleStage, (Object)settleStage);
        List finalizationEntityList = super.list((Wrapper)wrappersettlementFinalization);
        if (CollectionUtils.isNotEmpty((Collection)finalizationEntityList)) {
            List ids = finalizationEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrappersettlementFinalizationDetail = new LambdaQueryWrapper();
            wrappersettlementFinalizationDetail.eq(SettlementFinalizationDetailEntity::getChildProjectId, (Object)childProjectId);
            wrappersettlementFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List settlementFinalizationDetailEntities = this.settlementFinalizationDetailService.list((Wrapper)wrappersettlementFinalizationDetail);
            if (settlementFinalizationDetailEntities != null && settlementFinalizationDetailEntities.size() > 0) {
                Long finalizationId = ((SettlementFinalizationDetailEntity)((Object)settlementFinalizationDetailEntities.stream().findFirst().get())).getFinalizationId();
                List settlementFinalizationEntityList = finalizationEntityList.stream().filter(s -> s.getId().equals(finalizationId)).collect(Collectors.toList());
                String billCode = ((SettlementFinalizationEntity)((Object)settlementFinalizationEntityList.stream().findFirst().get())).getBillCode();
                throw new BusinessException("\u9009\u62e9\u5931\u8d25\uff0c\u8be5\u6267\u884c\u9879\u76ee\u5df2\u7ecf\u88ab\u3010" + billCode + "\u3011\u5f15\u7528\uff01");
            }
        }
        SettlementFinalizationDetailVO settlementFinalizationDetailVO = new SettlementFinalizationDetailVO();
        LambdaQueryWrapper wrapperProduction = new LambdaQueryWrapper();
        wrapperProduction.eq(ProductionEntity::getProjectId, (Object)childProjectId);
        wrapperProduction.in(ProductionEntity::getBillState, new Object[]{1, 3});
        List productionEntityList = this.productionService.list((Wrapper)wrapperProduction);
        if (CollectionUtils.isNotEmpty((Collection)productionEntityList)) {
            BigDecimal productionMny = productionEntityList.stream().filter(e -> e.getProductionMny() != null).map(ProductionEntity::getProductionMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal productionTaxMny = productionEntityList.stream().filter(e -> e.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settlementFinalizationDetailVO.setChildSumProductionMny(productionMny);
            settlementFinalizationDetailVO.setChildSumProductionTaxMny(productionTaxMny);
        }
        LambdaQueryWrapper wrapperSettleReport = new LambdaQueryWrapper();
        wrapperSettleReport.eq(SettleReportEntity::getProjectId, (Object)childProjectId);
        wrapperSettleReport.in(SettleReportEntity::getBillState, new Object[]{1, 3});
        wrapperSettleReport.eq(SettleReportEntity::getSettleStage, (Object)settleStage);
        List settleReportEntityList = this.settleReportService.list((Wrapper)wrapperSettleReport);
        if (CollectionUtils.isNotEmpty((Collection)settleReportEntityList)) {
            BigDecimal reportSettleTaxMny = settleReportEntityList.stream().filter(e -> e.getReportSettleTaxMny() != null).map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reportSettleMny = settleReportEntityList.stream().filter(e -> e.getReportSettleMny() != null).map(SettleReportEntity::getReportSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settlementFinalizationDetailVO.setChildReportSettleMny(reportSettleMny);
            settlementFinalizationDetailVO.setChildReportSettleTaxMny(reportSettleTaxMny);
            String checkUnit = ((SettleReportEntity)((Object)settleReportEntityList.stream().findFirst().get())).getCheckUnit();
            settlementFinalizationDetailVO.setChildCheckUnit(checkUnit);
        }
        return settlementFinalizationDetailVO;
    }

    @Override
    public SettlementFinalizationVO queryDetail(Long id) {
        SettlementFinalizationEntity settlementFinalizationEntity = (SettlementFinalizationEntity)((Object)super.selectById((Serializable)id));
        SettlementFinalizationVO vo = (SettlementFinalizationVO)BeanMapper.map((Object)((Object)settlementFinalizationEntity), SettlementFinalizationVO.class);
        List detailList = vo.getDetailList();
        detailList.forEach(val -> {
            val.setTid(this.objToString(val.getId()));
            val.setTpid(this.objToString(val.getParentId()));
            val.setRowState("edit");
        });
        List settlementFinalizationDetailVOS = TreeNodeBUtil.buildTree((List)detailList);
        vo.setDetailList(settlementFinalizationDetailVOS);
        return vo;
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }
}

