package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 *
 * @author generator
 */
@Controller
@RequestMapping("contractRegister")
public class ContractRegisterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractRegisterService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveorUpdateVO) {

        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
        ContractRegisterEntity entity = service.selectById(id);
        ContractRegisterVO vo = BeanMapper.map(entity, ContractRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        service.removeByIds(vos.stream().map(ContractRegisterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractRegisterVO> list = service.excelExport(param);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        ExcelExport.getInstance().export("contract-register-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     * @Description 参照
     */
    @RequestMapping(value = "/refContractRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag", new Parameter("eq", 0));
        param.getParams().put("isFinish", new Parameter("eq", 0));
        param.getParams().put("isRelieve", new Parameter("eq", 0));
        param.getParams().put("isSuspend", new Parameter("eq", 0));
        param.getParams().put("isEstimation", new Parameter("eq", 0)); // 过滤暂估合同，只查询正式合同

        List<String> changeStatusList = new ArrayList<>();
        changeStatusList.add("1");
        changeStatusList.add("3");
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, changeStatusList));

        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinish")) {
                boolean isFinish = Boolean.parseBoolean(conditionMap.get("isFinish").toString());
                if (!isFinish) {
                    param.getParams().remove("isFinish");
                }
            }
            if (!Objects.equals(conditionMap.get("isRelieve"), null)) {
                boolean isRelieve = Boolean.parseBoolean(conditionMap.get("isRelieve").toString());
                if (!isRelieve) {
                    param.getParams().remove("isRelieve");
                }
            }
            if (!Objects.equals(conditionMap.get("isBudget"), null)) {
                boolean isBudget = Boolean.parseBoolean(conditionMap.get("isBudget").toString());
                if (!isBudget) {
                    param.getParams().remove("changeStatus");
                }
            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractRegisterEntity> page = service.queryPage(param, false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 新增补充协议时根据评审id查询详情
     *
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/addRegisterByRevId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addRegisterByRevId(Long reviewId) {
        return CommonResponse.success("新增转换数据成功！", service.addRegisterByRevId(reviewId));
    }

    /**
     * 新增补充协议时根据合同id查询详情
     *
     * @param mainContractId
     * @return
     */
    @RequestMapping(value = "/addSupplementByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addSupplementByConId(Long mainContractId) {
        ContractRegisterVO vo = service.addSupplementByConId(mainContractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * 合同补充协议历史记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterSupplementHistoryVO> querySupplementRecord(@RequestParam Long id) {
        RegisterSupplementHistoryVO vo = service.querySupplementRecord(id);
        return CommonResponse.success(vo);
    }

    /**
     * 新增补充协议评审时校验主合同是否做过登记，并且是审批通过态
     *
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/queryRegisterByReviewId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractRegisterEntity>> queryRegisterByReviewId(@RequestParam Long reviewId) {
        return CommonResponse.success("查询数据成功", service.queryRegisterByReviewId(reviewId));
    }

    /**
     * 同步合同池
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushContract")
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value = "id") Long id) {
        ContractRegisterEntity registerEntity = service.selectById(id);
        ContractRegisterVO vo = BeanMapper.map(registerEntity, ContractRegisterVO.class);

        return CommonResponse.success("同步合同池成功！", service.pushContract(vo, false));
    }

    /**
     * 根据项目查询合同
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryRegisterByProject")
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryRegisterByProject(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("同步合同池成功！", service.queryRegisterByProject(projectId));
    }

    /**
     * 根据项目查询合同评审
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryReviewByProject")
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryReviewByProject(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("同步合同池成功！", service.queryReviewByProject(projectId));
    }

    /**
     * 根据项目查询它父项目的contractSettleRate
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryParentRateByProject")
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryParentRateByProject(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询成功！", service.queryParentRateByProject(projectId));
    }
}
