/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.SettlementFinalizationDetailEntity;
import com.ejianc.business.pro.income.bean.SettlementFinalizationEntity;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.ISettlementFinalizationDetailService;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;
import com.ejianc.business.pro.income.vo.SettlementFinalizationDetailVO;
import com.ejianc.business.pro.income.vo.SettlementFinalizationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementFinalization"})
public class SettlementFinalizationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SETTLEMENT_FINALIZATION";
    @Autowired
    private ISettlementFinalizationService service;
    @Autowired
    private ISettlementFinalizationDetailService settlementFinalizationDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> saveOrUpdate(@RequestBody SettlementFinalizationVO saveOrUpdateVO) {
        SettlementFinalizationVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySettleFinalization"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> querySettleFinalization(@RequestParam(required=false) Long projectId, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.querySettleFinalization(projectId, id));
    }

    @RequestMapping(value={"/getDataByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementFinalizationDetailVO> getDataByProjectId(@RequestParam(required=false) Long id, @RequestParam Long projectId, @RequestParam Long childProjectId, @RequestParam String settleStage) {
        SettlementFinalizationDetailVO settlementFinalizationDetailVO = this.service.getDataByProjectId(id, projectId, childProjectId, settleStage);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)settlementFinalizationDetailVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> queryDetail(Long id) {
        SettlementFinalizationVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateDateById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementFinalizationVO> updateDateById(@RequestBody SettlementFinalizationVO settlementFinalizationVO) {
        SettlementFinalizationEntity settlementFinalizationEntity = (SettlementFinalizationEntity)((Object)this.service.selectById(settlementFinalizationVO.getId()));
        settlementFinalizationEntity.setFinalizationBackDate(settlementFinalizationVO.getFinalizationBackDate());
        this.service.updateById((Object)settlementFinalizationEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementFinalizationVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementFinalizationVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("constructName");
        param.getFuzzyFields().add("checkUnit");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("createTime") ? (String)param.getOrderMap().get("createTime") : "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List settlementFinalizationVOS = BeanMapper.mapList((Iterable)page.getRecords(), SettlementFinalizationVO.class);
        if (CollectionUtils.isNotEmpty((Collection)settlementFinalizationVOS)) {
            List ids = settlementFinalizationVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaFinalizationDetail = Wrappers.lambdaQuery();
            lambdaFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List settlementFinalizationDetailEntities = this.settlementFinalizationDetailService.list((Wrapper)lambdaFinalizationDetail);
            Map<Object, Object> mapChild = new HashMap();
            Map<Long, List<SettlementFinalizationDetailEntity>> mapSun = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(score -> score.getParentId()));
            if (CollectionUtils.isNotEmpty((Collection)settlementFinalizationDetailEntities)) {
                mapChild = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() == null).collect(Collectors.groupingBy(score -> score.getFinalizationId()));
            }
            for (SettlementFinalizationVO settlementFinalizationVO : settlementFinalizationVOS) {
                this.logger.info("111");
                if (!mapChild.containsKey(settlementFinalizationVO.getId())) continue;
                this.logger.info("222");
                List childList = (List)mapChild.get(settlementFinalizationVO.getId());
                ArrayList<SettlementFinalizationVO> settleChild = new ArrayList<SettlementFinalizationVO>();
                for (SettlementFinalizationDetailEntity settlementFinalizationDetailEntity : childList) {
                    this.logger.info("333");
                    SettlementFinalizationVO settlementFinalizationChild = new SettlementFinalizationVO();
                    settlementFinalizationChild.setSumFinalizationBackMny(settlementFinalizationDetailEntity.getFinalizationBackMny());
                    settlementFinalizationChild.setSumFinalizationOutMny(settlementFinalizationDetailEntity.getFinalizationOutMny());
                    settlementFinalizationChild.setId(Long.valueOf(IdWorker.getId()));
                    settlementFinalizationChild.setProjectName(settlementFinalizationDetailEntity.getChildProjectName());
                    settlementFinalizationChild.setBasicUnitName(settlementFinalizationDetailEntity.getBasicUnitName());
                    settlementFinalizationChild.setBillState(settlementFinalizationVO.getBillState());
                    settleChild.add(settlementFinalizationChild);
                    if (mapSun.containsKey(settlementFinalizationDetailEntity.getId())) {
                        this.logger.info("444");
                        ArrayList<SettlementFinalizationVO> settleSun = new ArrayList<SettlementFinalizationVO>();
                        List<SettlementFinalizationDetailEntity> sunList = mapSun.get(settlementFinalizationDetailEntity.getId());
                        for (SettlementFinalizationDetailEntity settlementFinalizationDetailSun : sunList) {
                            SettlementFinalizationVO settlementFinalizationSun = new SettlementFinalizationVO();
                            settlementFinalizationSun.setSumFinalizationBackMny(settlementFinalizationDetailSun.getFinalizationBackMny());
                            settlementFinalizationSun.setSumFinalizationOutMny(settlementFinalizationDetailSun.getFinalizationOutMny());
                            settlementFinalizationSun.setId(Long.valueOf(IdWorker.getId()));
                            settlementFinalizationSun.setBasicUnitName(settlementFinalizationDetailSun.getBasicUnitName());
                            settleSun.add(settlementFinalizationSun);
                        }
                        settlementFinalizationChild.setChildren(settleSun);
                    }
                    settleChild.add(settlementFinalizationChild);
                }
                settlementFinalizationVO.setChildren(settleChild);
            }
        }
        pageData.setRecords(settlementFinalizationVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("constructName");
        param.getFuzzyFields().add("checkUnit");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("createTime") ? (String)param.getOrderMap().get("createTime") : "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = BeanMapper.mapList((Iterable)list, SettlementFinalizationVO.class);
        voList.forEach(e -> {
            if (e.getFinalizationFormFlag() != null) {
                if (e.getFinalizationFormFlag() == 1) {
                    e.setFinalizationFormFlagName("\u662f");
                } else {
                    e.setFinalizationFormFlagName("\u5426");
                }
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        ArrayList<SettlementFinalizationVO> finalizationVOList = new ArrayList<SettlementFinalizationVO>();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaFinalizationDetail = Wrappers.lambdaQuery();
            lambdaFinalizationDetail.in(SettlementFinalizationDetailEntity::getFinalizationId, ids);
            List settlementFinalizationDetailEntities = this.settlementFinalizationDetailService.list((Wrapper)lambdaFinalizationDetail);
            Map<Object, Object> mapChild = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)settlementFinalizationDetailEntities)) {
                mapChild = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() == null).collect(Collectors.groupingBy(score -> score.getFinalizationId()));
            }
            Map<Long, List<SettlementFinalizationDetailEntity>> mapSun = settlementFinalizationDetailEntities.stream().filter(s -> s.getParentId() != null).collect(Collectors.groupingBy(score -> score.getParentId()));
            for (SettlementFinalizationVO settlementFinalizationVO : voList) {
                finalizationVOList.add(settlementFinalizationVO);
                this.logger.info("111");
                if (!mapChild.containsKey(settlementFinalizationVO.getId())) continue;
                this.logger.info("222");
                List childList = (List)mapChild.get(settlementFinalizationVO.getId());
                ArrayList<SettlementFinalizationVO> settleChild = new ArrayList<SettlementFinalizationVO>();
                for (SettlementFinalizationDetailEntity settlementFinalizationDetailEntity : childList) {
                    this.logger.info("333");
                    SettlementFinalizationVO settlementFinalizationChild = new SettlementFinalizationVO();
                    settlementFinalizationChild.setSumFinalizationBackMny(settlementFinalizationDetailEntity.getFinalizationBackMny());
                    settlementFinalizationChild.setSumFinalizationOutMny(settlementFinalizationDetailEntity.getFinalizationOutMny());
                    settlementFinalizationChild.setId(Long.valueOf(IdWorker.getId()));
                    settlementFinalizationChild.setProjectName(settlementFinalizationDetailEntity.getChildProjectName());
                    settlementFinalizationChild.setBasicUnitName(settlementFinalizationDetailEntity.getBasicUnitName());
                    settlementFinalizationChild.setBillState(settlementFinalizationVO.getBillState());
                    settleChild.add(settlementFinalizationChild);
                    finalizationVOList.add(settlementFinalizationChild);
                    if (mapSun.containsKey(settlementFinalizationDetailEntity.getId())) {
                        ArrayList<SettlementFinalizationVO> settleSun = new ArrayList<SettlementFinalizationVO>();
                        List<SettlementFinalizationDetailEntity> sunList = mapSun.get(settlementFinalizationDetailEntity.getId());
                        for (SettlementFinalizationDetailEntity settlementFinalizationDetailSun : sunList) {
                            SettlementFinalizationVO settlementFinalizationSun = new SettlementFinalizationVO();
                            settlementFinalizationSun.setSumFinalizationBackMny(settlementFinalizationDetailSun.getFinalizationBackMny());
                            settlementFinalizationSun.setSumFinalizationOutMny(settlementFinalizationDetailSun.getFinalizationOutMny());
                            settlementFinalizationSun.setId(Long.valueOf(IdWorker.getId()));
                            settlementFinalizationSun.setBasicUnitName(settlementFinalizationDetailSun.getBasicUnitName());
                            settleSun.add(settlementFinalizationSun);
                            finalizationVOList.add(settlementFinalizationSun);
                        }
                        settlementFinalizationChild.setChildren(settleSun);
                    }
                    settleChild.add(settlementFinalizationChild);
                }
                settlementFinalizationVO.setChildren(settleChild);
            }
        }
        for (SettlementFinalizationVO vo : finalizationVOList) {
            if (vo.getBillState() != null) {
                vo.setBillStateName(com.ejianc.business.pro.income.enums.BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.\u4e00\u5ba1.getCode())) {
                vo.setFinalizationStageName("\u4e00\u5ba1");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.\u4e8c\u5ba1.getCode())) {
                vo.setFinalizationStageName("\u4e8c\u5ba1");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.\u4e09\u5ba1.getCode())) {
                vo.setFinalizationStageName("\u4e09\u5ba1");
            }
            if (Objects.equals(vo.getFinalizationStage(), FinalStageEnum.\u7ec8\u5ba1.getCode())) {
                vo.setFinalizationStageName("\u7ec8\u5ba1");
            }
            if ("1".equals(vo.getSettleStage())) {
                vo.setSettleStage("\u7b2c\u4e00\u9636\u6bb5");
            }
            if ("2".equals(vo.getSettleStage())) {
                vo.setSettleStage("\u7b2c\u4e8c\u9636\u6bb5");
            }
            if ("3".equals(vo.getSettleStage())) {
                vo.setSettleStage("\u7b2c\u4e09\u9636\u6bb5");
            }
            if ("4".equals(vo.getSettleStage())) {
                vo.setSettleStage("\u7b2c\u56db\u9636\u6bb5");
            }
            if ("5".equals(vo.getSettleStage())) {
                vo.setSettleStage("\u7b2c\u4e94\u9636\u6bb5");
            }
            if ("1".equals(vo.getUnitProperty())) {
                vo.setUnitProperty("\u96c6\u56e2\u5185");
            }
            if (!"2".equals(vo.getUnitProperty())) continue;
            vo.setUnitProperty("\u96c6\u56e2\u5916");
        }
        beans.put("records", finalizationVOList);
        ExcelExport.getInstance().export("settlementFinalization-export.xlsx", beans, response);
    }
}

