/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.home.consts.ProjectStatusEnum;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.MemorandumEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.bean.SettlementFinalizationEntity;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IMemorandumService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warnTiming"})
public class WarnTimingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IFinalizedService finalizedService;
    @Autowired
    private ISettlementFinalizationService settlementFinalizationService;
    @Autowired
    private ISettleReportService settleReportService;
    @Autowired
    private IMemorandumService memorandumService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/notFinalizedTimingWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> notFinalizedTimingWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)999999L);
        lambda.in(QuoteEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        lambda.orderByDesc(QuoteEntity::getPredictCompleteDate);
        List list = this.quoteService.list((Wrapper)lambda);
        this.logger.info("\u5bf9\u7532\u4fdd\u91cf\u6761\u6570\uff1a{}", (Object)list.size());
        HashMap<Long, QuoteEntity> quoteProjectcIdMap = new HashMap<Long, QuoteEntity>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                if (quoteProjectcIdMap.containsKey(e.getProjectId())) {
                    QuoteEntity quoteEntity = (QuoteEntity)((Object)((Object)quoteProjectcIdMap.get(e.getProjectId())));
                    if (null != quoteEntity.getPredictCompleteDate() && e.getPredictCompleteDate().after(quoteEntity.getPredictCompleteDate())) {
                        quoteProjectcIdMap.put(e.getProjectId(), (QuoteEntity)((Object)e));
                    }
                } else {
                    quoteProjectcIdMap.put(e.getProjectId(), (QuoteEntity)((Object)e));
                }
            });
        }
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(FinalizedEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda2.in(FinalizedEntity::getProjectId, quoteProjectcIdMap.keySet());
            List finalizedList = this.finalizedService.list((Wrapper)lambda2);
            Map<Long, List<FinalizedEntity>> finalizedMap = finalizedList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(FinalizedEntity::getProjectId));
            ArrayList unFinalizedList = new ArrayList();
            quoteProjectcIdMap.forEach((key, value) -> {
                if (!finalizedMap.containsKey(key)) {
                    unFinalizedList.add(value);
                }
            });
            if (null == unFinalizedList || !ListUtil.isNotEmpty(unFinalizedList)) continue;
            for (QuoteEntity quoteEntity : unFinalizedList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = quoteEntity.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date date = new Date();
                Date oneDate = quoteEntity.getPredictCompleteDate();
                Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                Integer day = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getIntValue("parameterValue");
                    this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u9879\u76ee\u7ae3\u5de5\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u5bf9\u7532\u62a5\u91cf\u4fe1\u606f\uff1a{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, JSONObject.toJSONString((Object)((Object)quoteEntity))});
                    if ("\u9ad8".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || betweenDays < day) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + quoteEntity.getProjectName());
                vo.setPcTitle("\u9879\u76ee\u7ae3\u5de5\u65e5\u671f\u540e\u672a\u5b8c\u6210\u5de5\u7a0b\u5b9a\u6848");
                vo.setOrgId(quoteEntity.getOrgId());
                vo.setSendOrgId(quoteEntity.getOrgId() + "");
                vo.setOrgName(quoteEntity.getOrgName());
                vo.setSourceId(quoteEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(day)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(day)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(day)));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/notSettleFinalizationWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> notSettleFinalizationWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)999999L);
        lambda.in(FinalizedEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        lambda.orderByDesc(FinalizedEntity::getReturnDate);
        List list = this.finalizedService.list((Wrapper)lambda);
        this.logger.info("\u5bf9\u7532\u4fdd\u91cf\u6761\u6570\uff1a{}", (Object)list.size());
        HashMap<Long, FinalizedEntity> finalizedProjectcIdMap = new HashMap<Long, FinalizedEntity>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                if (finalizedProjectcIdMap.containsKey(e.getProjectId())) {
                    FinalizedEntity finalizedEntity = (FinalizedEntity)((Object)((Object)finalizedProjectcIdMap.get(e.getProjectId())));
                    if (null != finalizedEntity.getReturnDate() && e.getReturnDate().before(finalizedEntity.getReturnDate())) {
                        finalizedProjectcIdMap.put(e.getProjectId(), (FinalizedEntity)((Object)e));
                    }
                } else {
                    finalizedProjectcIdMap.put(e.getProjectId(), (FinalizedEntity)((Object)e));
                }
            });
        }
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(SettlementFinalizationEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda2.in(SettlementFinalizationEntity::getProjectId, finalizedProjectcIdMap.keySet());
            List settlementFinalizationList = this.settlementFinalizationService.list((Wrapper)lambda2);
            Map<Long, List<SettlementFinalizationEntity>> settlementFinalizationMap = settlementFinalizationList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(SettlementFinalizationEntity::getProjectId));
            ArrayList unFinalizedList = new ArrayList();
            finalizedProjectcIdMap.forEach((key, value) -> {
                if (!settlementFinalizationMap.containsKey(key)) {
                    unFinalizedList.add(value);
                }
            });
            if (null == unFinalizedList || !ListUtil.isNotEmpty(unFinalizedList)) continue;
            for (FinalizedEntity finalizedEntity : unFinalizedList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = finalizedEntity.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date date = new Date();
                Date oneDate = finalizedEntity.getReturnDate();
                Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                Integer day = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getIntValue("parameterValue");
                    this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u9879\u76ee\u7ae3\u5de5\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u5bf9\u7532\u62a5\u91cf\u4fe1\u606f\uff1a{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, JSONObject.toJSONString((Object)((Object)finalizedEntity))});
                    if ("\u9ad8".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || betweenDays < day) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + finalizedEntity.getProjectName());
                vo.setPcTitle("\u5b9a\u6848\u8fd4\u56de\u65e5\u671f\u524d\u6ca1\u5b9a\u6848\u786e\u8ba4\u7684\u5355\u636e");
                vo.setOrgId(finalizedEntity.getOrgId());
                vo.setSendOrgId(finalizedEntity.getOrgId() + "");
                vo.setOrgName(finalizedEntity.getOrgName());
                vo.setSourceId(finalizedEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)finalizedEntity.getReturnDate())).replaceAll("#day#", String.valueOf(day)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)finalizedEntity.getReturnDate())).replaceAll("#day#", String.valueOf(day)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(finalizedEntity.getProjectName())).replaceAll("#returnDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)finalizedEntity.getReturnDate())).replaceAll("#day#", String.valueOf(day)));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/notMemorandumWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> notMemorandumWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)999999L);
        lambda.in(SettleReportEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.settleReportService.list((Wrapper)lambda);
        this.logger.info("\u7ed3\u7b97\u62a5\u5ba1\u6761\u6570\uff1a{}", (Object)list.size());
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(MemorandumEntity::getSettleReportId, ids);
            List memorandumList = this.memorandumService.list((Wrapper)lambda2);
            Map<Long, List<MemorandumEntity>> memorandumMap = memorandumList.stream().collect(Collectors.groupingBy(MemorandumEntity::getSettleReportId));
            this.logger.info("\u7ef4\u62a4\u7684\u5907\u5fd8\u5f55\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(memorandumMap));
            ArrayList unFinalizedList = new ArrayList();
            list.forEach(e -> {
                if (!memorandumMap.containsKey(e.getId())) {
                    unFinalizedList.add(e);
                }
            });
            this.logger.info("\u6ca1\u6709\u7ef4\u62a4\u7684\u5907\u5fd8\u5f55\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(unFinalizedList));
            if (null == unFinalizedList || !ListUtil.isNotEmpty(unFinalizedList)) continue;
            for (SettleReportEntity settleReportEntity : unFinalizedList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = settleReportEntity.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                JSONObject useSetHigh = null;
                Date date = new Date();
                Date oneDate = settleReportEntity.getEffectDate();
                Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                Integer day = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getIntValue("parameterValue");
                    this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u751f\u6548\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u5b9e\u4f53\u4fe1\u606f\uff1a{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, JSONObject.toJSONString((Object)((Object)settleReportEntity))});
                    if (betweenDays < day) continue;
                    high = true;
                    useSetHigh = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + settleReportEntity.getProjectName());
                vo.setPcTitle("\u7ed3\u7b97\u62a5\u5ba1\u7ef4\u62a4\u5907\u5fd8\u5f55\u63d0\u9192");
                vo.setOrgId(settleReportEntity.getOrgId());
                vo.setSendOrgId(settleReportEntity.getOrgId() + "");
                vo.setOrgName(settleReportEntity.getOrgName());
                vo.setSourceId(settleReportEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(settleReportEntity.getProjectName())).replaceAll("#billCode#", String.valueOf(settleReportEntity.getBillCode())).replaceAll("#day#", String.valueOf(day)));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/quoteNotSettleReportWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> quoteNotSettleReportWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u9879\u76ee\u7ae3\u5de5\u540e\u672a\u5b8c\u6210\u7ed3\u7b97\u62a5\u5ba1\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)999999L);
        lambda.in(QuoteEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        lambda.orderByDesc(QuoteEntity::getPredictCompleteDate);
        List list = this.quoteService.list((Wrapper)lambda);
        list.sort((t1, t2) -> t2.getPredictCompleteDate().compareTo(t1.getPredictCompleteDate()));
        this.logger.info("\u5bf9\u7532\u62a5\u91cf\u6761\u6570\uff1a{}", (Object)list.size());
        if (CollectionUtils.isEmpty((Collection)list) || list.size() == 0) {
            return CommonResponse.success((String)"\u65e0\u5bf9\u7532\u62a5\u91cf\u6570\u636e\uff01");
        }
        HashMap<Long, QuoteEntity> quoteProjectIdMap = new HashMap<Long, QuoteEntity>();
        for (QuoteEntity quoteEntity : list) {
            if (quoteProjectIdMap.containsKey(quoteEntity.getProjectId())) continue;
            quoteProjectIdMap.put(quoteEntity.getProjectId(), quoteEntity);
        }
        this.logger.info("\u5bf9\u7532\u62a5\u91cf\u6761\u6570\uff1a{}", (Object)quoteProjectIdMap.size());
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(SettleReportEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda2.in(SettleReportEntity::getProjectId, quoteProjectIdMap.keySet());
            List settleReportList = this.settleReportService.list((Wrapper)lambda2);
            List settleReportProjectIdList = settleReportList.stream().map(SettleReportEntity::getProjectId).distinct().collect(Collectors.toList());
            this.logger.info("\u5df2\u505a\u7ed3\u7b97\u62a5\u5ba1\u7684\u9879\u76eeid\uff1a{}", (Object)JSONObject.toJSONString(settleReportProjectIdList));
            ArrayList unSettleList = new ArrayList();
            quoteProjectIdMap.forEach((key, value) -> {
                if (!settleReportProjectIdList.contains(key)) {
                    unSettleList.add(quoteProjectIdMap.get(key));
                }
            });
            if (null == unSettleList || !ListUtil.isNotEmpty(unSettleList)) continue;
            for (QuoteEntity quoteEntity : unSettleList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = quoteEntity.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date date = new Date();
                Date oneDate = quoteEntity.getPredictCompleteDate();
                Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
                Integer day = null;
                Integer lowDay = null;
                Integer highDay = null;
                Integer meddleDay = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getIntValue("parameterValue");
                    this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u9884\u8ba1\u5b8c\uff08\u7ae3\uff09\u5de5\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u5bf9\u7532\u62a5\u91cf\u4fe1\u606f\uff1a{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, JSONObject.toJSONString((Object)((Object)quoteEntity))});
                    if ("\u9ad8".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        high = true;
                        useSetHigh = set;
                        highDay = day;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && betweenDays >= day) {
                        meddle = true;
                        useSetMeddle = set;
                        meddleDay = day;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || betweenDays < day) continue;
                    low = true;
                    useSetLow = set;
                    lowDay = day;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + quoteEntity.getProjectName());
                vo.setPcTitle("\u9879\u76ee\u7ae3\u5de5\u540e\u672a\u5b8c\u6210\u7ed3\u7b97\u62a5\u5ba1");
                vo.setOrgId(quoteEntity.getOrgId());
                vo.setSendOrgId(quoteEntity.getOrgId() + "");
                vo.setOrgName(quoteEntity.getOrgName());
                vo.setSourceId(quoteEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                this.logger.info("tmContent:{}", (Object)tmpContent);
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(highDay)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(meddleDay)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(quoteEntity.getProjectName())).replaceAll("#predictCompleteDate#", DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)quoteEntity.getPredictCompleteDate())).replaceAll("#day#", String.valueOf(lowDay)));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/projectNotSettleReportWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> projectNotSettleReportWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u7ae3\u5de5\u672a\u7ed3\u9879\u76ee\u672a\u5b8c\u6210\u7ed3\u7b97\u62a5\u5ba1\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        HashMap<Long, ProjectPoolSetVO> projectIdMap = new HashMap<Long, ProjectPoolSetVO>();
        CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectPoolList(ProjectStatusEnum.\u7ae3\u5de5.getCode(), null, null);
        if (jsonArrayCommonResponse.isSuccess() && null != jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)jsonArrayCommonResponse.getData()))) {
            JSONArray data = (JSONArray)jsonArrayCommonResponse.getData();
            List projectData = JSONObject.parseArray((String)data.toJSONString(), ProjectPoolSetVO.class);
            if (CollectionUtils.isNotEmpty((Collection)projectData)) {
                for (ProjectPoolSetVO project : projectData) {
                    if (null == project.getTenantId() || project.getTenantId() != 999999L || null == project.getSettleStatus() || !project.getSettleStatus().equals("1")) continue;
                    projectIdMap.put(project.getId(), project);
                }
            }
            this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectData.size());
            this.logger.info("\u9879\u76ee\u4fe1\u606fmap\u6761\u6570\uff1a{}", (Object)projectIdMap.size());
            if (null == projectIdMap) {
                return CommonResponse.success((String)"\u65e0\u5bf9\u5e94\u72b6\u6001\u9879\u76ee\u6570\u636e\uff01");
            }
        }
        this.logger.info("\u653e\u7f6e\u6570\u636e");
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            if (null != tenantId && tenantId != 999999L) continue;
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(BaseEntity::getTenantId, (Object)999999L);
            lambda2.in(SettleReportEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda2.in(SettleReportEntity::getProjectId, projectIdMap.keySet());
            List settleReportList = this.settleReportService.list((Wrapper)lambda2);
            List settleReportProjectIdList = settleReportList.stream().map(SettleReportEntity::getProjectId).distinct().collect(Collectors.toList());
            this.logger.info("\u5df2\u505a\u7ed3\u7b97\u62a5\u5ba1\u7684\u9879\u76eeid\uff1a{}", (Object)JSONObject.toJSONString(settleReportProjectIdList));
            ArrayList unSettleList = new ArrayList();
            projectIdMap.forEach((key, value) -> {
                if (!settleReportProjectIdList.contains(key)) {
                    unSettleList.add(projectIdMap.get(key));
                }
            });
            if (null == unSettleList || !ListUtil.isNotEmpty(unSettleList)) continue;
            for (ProjectPoolSetVO project : unSettleList) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = project.getOrgId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    this.logger.info("\u9879\u76ee\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)project));
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + project.getName());
                vo.setPcTitle("\u7ae3\u5de5\u672a\u7ed3\u9879\u76ee\u672a\u5b8c\u6210\u7ed3\u7b97\u62a5\u5ba1");
                vo.setOrgId(project.getOrgId());
                vo.setSendOrgId(project.getOrgId() + "");
                vo.setOrgName(project.getOrgName());
                vo.setSourceId(project.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                this.logger.info("tmContent:{}", (Object)tmpContent);
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(project.getName())));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

