package com.ejianc.business.pro.home.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.home.consts.ProjectStatusEnum;
import com.ejianc.business.pro.home.mapper.HomePortalMapper;
import com.ejianc.business.pro.home.service.IHomePortalService;
import com.ejianc.business.pro.home.util.CommonListCallable;
import com.ejianc.business.pro.home.util.DateUtil;
import com.ejianc.business.pro.home.util.JSONUtils;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.ProductionPlanEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionPlanService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;


/**
 * <p>
 * 门户首页 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@Service("homePortalService")
public class HomePortalServiceImpl extends BaseServiceImpl<HomePortalMapper, BaseEntity> implements IHomePortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractRegisterService contractService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IProductionPlanService planService;

    @Autowired
    private IQuoteService quoteService;

    @Autowired
    private IProjectPoolApi projectSetApi;

    @Override
    public JSONObject productReplyReport(QueryParam queryParam) {
        JSONObject page = new JSONObject();
        page.put("current", "1");
        page.put("size", "10");
        page.put("records", new ArrayList<>());
        page.put("total", "0");
        page.put("pages", "1");
        if(!queryParam.getParams().containsKey("month")){
            return page;
        }
        String month = String.valueOf(queryParam.getParams().get("month").getValue());
        Date monthDate = DateUtil.parseDate(month + "-01");
        queryParam.getParams().remove("month");
        LinkedHashMap<String,String> orderMap = queryParam.getOrderMap();
        if(!orderMap.containsKey("buildUnitName")){
            queryParam.getOrderMap().put("buildUnitName", QueryParam.ASC);
        }
        if(!orderMap.containsKey("projectDate")){
            queryParam.getOrderMap().put("projectDate", QueryParam.DESC);
        }
        if(queryParam.getOrderMap().containsKey("projectStatusName")){
            queryParam.getOrderMap().put("projectStatus", queryParam.getOrderMap().get("projectStatusName"));
            queryParam.getOrderMap().remove("projectStatusName");
        }
        CommonResponse<Page<ProjectPoolSetVO>> resp = projectSetApi.queryProjectIPage(queryParam);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        Page<ProjectPoolSetVO> pageData = resp.getData();
        page.put("current", "" + pageData.getCurrent());
        page.put("size", "" + pageData.getSize());
        page.put("records", new ArrayList<>());
        page.put("total", "" + pageData.getTotal());
        page.put("pages", "" + pageData.getPages());
        if(CollectionUtils.isEmpty(pageData.getRecords())){
            return page;
        }
        List<ProjectPoolSetVO> projectList = pageData.getRecords();
        List<Long> projectIds = projectList.stream().map(x->x.getId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        QueryParam param2 = Utils.deepCopy(param);// 深拷贝
        param2.getParams().put("replyDate", new Parameter(QueryParam.NE, null));
        QueryParam param3 = Utils.deepCopy(param);// 深拷贝
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, productionService);// 产值报量
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, quoteService);// 对甲报量
        Future<JSONArray> future3 = CommonListCallable.excute(threadPool, param3, contractService);// 施工合同

        List<ProductionEntity> productionList = new ArrayList<>();// 产值报量
        List<QuoteEntity> quoteList = new ArrayList<>();// 对甲报量
        List<ContractRegisterEntity> contractList = new ArrayList<>();// 施工合同
        try {
            productionList = JSONUtils.json2List(future1.get().toJSONString(), ProductionEntity.class);
            quoteList = JSONUtils.json2List(future2.get().toJSONString(), QuoteEntity.class);
            contractList = JSONUtils.json2List(future3.get().toJSONString(), ContractRegisterEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        // 产值报量-计划产值
        this.setProductionPlanList(productionList);

        Map<Long, List<ContractRegisterEntity>> contractMap = contractList.stream().collect(Collectors.groupingBy(x->x.getProjectId()));
        Map<Long, List<ProductionEntity>> productionMap = productionList.stream().collect(Collectors.groupingBy(x->x.getProjectId()));
        Map<Long, List<QuoteEntity>> quoteMap = quoteList.stream().collect(Collectors.groupingBy(x->x.getProjectId()));

        JSONArray array = new JSONArray();
        for(ProjectPoolSetVO project : projectList){
            Long projectId = project.getId();
            JSONObject obj = new JSONObject();
            obj.put("projectId", projectId);// 项目主键
            obj.put("buildUnitName", project.getBuildUnitName());// 二级单位
            obj.put("name", project.getName());// 项目名称
            obj.put("constructName", project.getConstructName());// 建设单位
            obj.put("projectScale", project.getMeasure());// 工程规模
            obj.put("projectStatus", project.getProjectStatus());// 项目状态：1、在建 2、停缓建 3、竣工验收 4、已完工 5、其他
            obj.put("projectStatusName", ProjectStatusEnum.getEnumByCode(project.getProjectStatus()).getName());// 项目状态：1、在建 2、项目中止 3、竣工 4、保修
            obj.put("projectDate", DateUtil.formatDate(project.getProjectDate()));// 立项日期

            BigDecimal contractMny = null;
            if(contractMap.containsKey(projectId)){
                contractMny = contractMap.get(projectId).stream().map(x->x.getBaseTaxMoney()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);// 合同签订金额
            }
            obj.put("contractMny", ComputeUtil.scaleTwo(contractMny));// 合同金额

            Date endOfLastYear = DateUtil.endOfLastYear(monthDate);// 上年最后一天
            Date beginOfMonth = DateUtil.beginOfMonth(monthDate);// 当月第一天
            Date endOfMonth = DateUtil.endOfMonth(monthDate);// 当月最后一天
            Date beginOfYear = DateUtil.beginOfYear(monthDate);// 当年第一天
            Date nextMonth = DateUtil.addMonths(monthDate, 1);// 下一月

            // 开工至上一年底累计(万元)
            BigDecimal lastYearProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), null, endOfLastYear);
            obj.put("lastYearProductMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(lastYearProductMny, new BigDecimal("10000"))));// 实际完成产值
            BigDecimal lastYearQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), null, endOfLastYear);
            obj.put("lastYearQuoteMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(lastYearQuoteMny, new BigDecimal("10000"))));// 业主批复金额
            // TODO 待定
            obj.put("lastYearShouldMny", null);// 按合同应收款
            obj.put("lastYearReceiveMny", null);// 实际回款
            obj.put("lastYearDebtMny", ComputeUtil.scaleTwo(ComputeUtil.safeSub(obj.getBigDecimal("lastYearShouldMny"), obj.getBigDecimal("lastYearReceiveMny"))));// 欠付金额

            // 当月情况(万元)
            BigDecimal monthProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), beginOfMonth, endOfMonth);
            obj.put("monthProductMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(monthProductMny, new BigDecimal("10000"))));// 实际完成产值
            BigDecimal monthQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), beginOfMonth, endOfMonth);
            obj.put("monthQuoteMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(monthQuoteMny, new BigDecimal("10000"))));// 业主批复金额
            // TODO 待定
            obj.put("monthShouldMny", null);// 按合同应收款
            obj.put("monthReceiveMny", null);// 实际回款
            obj.put("monthDebtMny", ComputeUtil.scaleTwo(ComputeUtil.safeSub(obj.getBigDecimal("monthShouldMny"), obj.getBigDecimal("monthReceiveMny"))));// 欠付金额

            // 本年累计(万元)
            BigDecimal yearProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), beginOfYear, endOfMonth);
            obj.put("yearProductMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(yearProductMny, new BigDecimal("10000"))));// 实际完成产值
            BigDecimal yearQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), beginOfYear, endOfMonth);
            obj.put("yearQuoteMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(yearQuoteMny, new BigDecimal("10000"))));// 业主批复金额
            // TODO 待定
            obj.put("yearShouldMny", null);// 按合同应收款
            obj.put("yearReceiveMny", null);// 实际回款
            obj.put("yearDebtMny", ComputeUtil.scaleTwo(ComputeUtil.safeSub(obj.getBigDecimal("yearShouldMny"), obj.getBigDecimal("yearReceiveMny"))));// 欠付金额

            // 项目开工至当前月累计(万元)
            BigDecimal sumProductMny = this.getProductionTaxMnyByDate(productionMap.get(projectId), null, endOfMonth);
            obj.put("sumProductMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(sumProductMny, new BigDecimal("10000"))));// 实际完成产值
            BigDecimal sumQuoteMny = this.getReplyTaxMnyByDate(quoteMap.get(projectId), null, endOfMonth);
            obj.put("sumQuoteMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(sumQuoteMny, new BigDecimal("10000"))));// 业主批复金额
            // TODO 待定
            obj.put("sumShouldMny", null);// 按合同应收款
            obj.put("sumReceiveMny", null);// 实际回款
            obj.put("sumDebtMny", ComputeUtil.scaleTwo(ComputeUtil.safeSub(obj.getBigDecimal("sumShouldMny"), obj.getBigDecimal("sumReceiveMny"))));// 欠付金额

            // 下月计划(万元)
            if(productionMap.containsKey(projectId)){
                ProductionEntity production = productionMap.get(projectId).stream().filter(x->DateUtil.isSameMonth(x.getEndDate(), monthDate)).findAny().orElse(new ProductionEntity());
                ProductionPlanEntity plan = production.getPlanList().stream().filter(x->DateUtil.isSameMonth(x.getMonth(), nextMonth)).findAny().orElse(new ProductionPlanEntity());
                obj.put("planProductMny", ComputeUtil.scaleTwo(ComputeUtil.safeDiv(plan.getPlanTaxMny(), new BigDecimal("10000"))));// 计划产值
                obj.put("planProgress", plan.getPlanProgress());// 计划形象进度
            }
            array.add(obj);
        }
        page.put("records", array);
        return page;
    }

    /**
     * 给产值报量-计划产值赋值
     * @param list
     */
    private void setProductionPlanList(List<ProductionEntity> list) {
        if(CollectionUtils.isEmpty(list)) {
            return;
        }
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
        List<ProductionPlanEntity> planList = planService.queryList(param);
        if(CollectionUtils.isEmpty(planList)) {
            return;
        }
        Map<Long, List<ProductionPlanEntity>> planMap = planList.stream().collect(Collectors.groupingBy(x->x.getPid()));
        for(ProductionEntity entity : list){
            if(planMap.containsKey(entity.getId())){
                entity.setPlanList(planMap.get(entity.getId()));
            }
        }
    }

    /**
     * 根据日期汇总产值金额
     * @param list
     * @param startDate
     * @param endDate
     * @return
     */
    private BigDecimal getProductionTaxMnyByDate(List<ProductionEntity> list, Date startDate, Date endDate) {
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        List<ProductionEntity> filter = list.stream().filter(x->{
            if(null == startDate){
                return DateUtil.compareDate(x.getEndDate(), endDate) <= 0;
            }
            if(null == endDate){
                return DateUtil.compareDate(x.getEndDate(), startDate) >= 0;
            }
            return DateUtil.compareDate(x.getEndDate(), startDate) >= 0 && DateUtil.compareDate(x.getEndDate(), endDate) <= 0;
        }).collect(Collectors.toList());
        BigDecimal mny = filter.stream().map(x->x.getProductionTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        return mny;
    }

    /**
     * 根据日期汇总批复金额
     * @param list
     * @param startDate
     * @param endDate
     * @return
     */
    private BigDecimal getReplyTaxMnyByDate(List<QuoteEntity> list, Date startDate, Date endDate) {
        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        List<QuoteEntity> filter = list.stream().filter(x->{
            if(null == startDate){
                return DateUtil.compareDate(x.getReplyDate(), endDate) <= 0;
            }
            if(null == endDate){
                return DateUtil.compareDate(x.getReplyDate(), startDate) >= 0;
            }
            return DateUtil.compareDate(x.getReplyDate(), startDate) >= 0 && DateUtil.compareDate(x.getReplyDate(), endDate) <= 0;
        }).collect(Collectors.toList());
        BigDecimal mny = filter.stream().map(x->x.getReplyTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        return mny;
    }

}