package com.ejianc.business.pro.other.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.vo.OtherContractVO;

/**
 * 其他收入合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherContract")
public class OtherContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOtherContractService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(Long id) {
    	OtherContractEntity entity = service.selectById(id);
    	OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OtherContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OtherContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、合同甲方、合同乙方、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        IPage<OtherContractEntity> pageData = service.queryPage(param, false);
        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、合同甲方、合同乙方、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        //param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<OtherContractEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<OtherContractVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class);
            list.forEach(vo -> {
                if (null != vo.getContractStatus()) {
                    if ("1".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("未签订");
                    } else if ("2".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("履约中");
                    } else if ("3".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("已封账");
                    }else if ("4".equals(vo.getContractStatus())){
                        vo.setContractStatusName("已冻结");
                    }else if ("5".equals(vo.getContractStatus())){
                        vo.setContractStatusName("已解除");
                    }
                } else {
                    vo.setContractStatusName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("other-contract-export.xlsx", beans, response);
    }

    /**
     * 合同参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractEntity>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "searchText", required = false) String searchText,
                                                               @RequestParam(value = "condition", required = false) String condition) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //项目名称、合同编号、合同名称、合同甲方、合同乙方、经办人
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("employeeName");
        //竣工结算标志
        queryParam.getParams().put("is_finish", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));
        queryParam.getParams().put("is_relieve", new Parameter("eq", 0));
        queryParam.getParams().put("is_suspend", new Parameter("eq", 0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinishFlag")) {
                boolean flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString());
                // isFinishFlag 是否根据竣工过滤
                if(!flag){
                    queryParam.getParams().remove("is_finish");
                }
            }
            if (null != conditionMap.get("contractStatus")) {
                Long contractStatus = Long.valueOf(conditionMap.get("contractStatus").toString());
                queryParam.getParams().put("contractStatus", new Parameter(QueryParam.NE, contractStatus));
            }
        }
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success("查询列表数据成功！", service.queryPage(queryParam, false));
    }


    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/contractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> contractDetail(@RequestParam Long id) {
        OtherContractVO vo = service.contractDetail(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同状态修改
     *
     * @param OtherContractVO
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody OtherContractVO OtherContractVO) {
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherContractEntity::getId, OtherContractVO.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, OtherContractVO.getContractStatus());
        service.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 查询汇总金额
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/sumMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> sumMny(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、合同甲方、合同乙方、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OtherContractEntity> list = service.queryList(param, false);
        Map<String, BigDecimal> map = new HashMap<>();
        BigDecimal sumBaseMoney = BigDecimal.ZERO;
        BigDecimal sumContractMny = BigDecimal.ZERO;
        for (OtherContractEntity entity : list) {
            if (entity.getBaseTaxMoney() != null) {
                sumBaseMoney = sumBaseMoney.add(entity.getBaseTaxMoney());
            }
            if (entity.getContractTaxMny() != null) {
                sumContractMny = sumContractMny.add(entity.getContractTaxMny());
            }
        }
        map.put("sumBaseMoney", sumBaseMoney);
        map.put("sumContractMny", sumContractMny);
        return CommonResponse.success("查询汇总金额成功！", map);
    }

    /**
     * 查合同签约日期
     *
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/getSignDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> getSignDate(Long contractId) {
        Date date = service.getSignDate(contractId);
        return CommonResponse.success("查合同签约日期成功！", date);
    }

    /**
     * 同步合同池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushContract")
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value = "id") Long id) {
        OtherContractEntity entity = service.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        return CommonResponse.success("同步合同池成功！", service.pushContract(vo, false));
    }

}
