package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.bean.OtherContractSuspendEntity;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.service.IOtherContractSuspendService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Objects;

@Service("otherContractSuspend") 
public class OtherContractSuspendBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IOtherContractSuspendService service;

	@Autowired
	private IOtherContractService registerService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		OtherContractSuspendEntity entity = service.selectById(billId);

		if (Objects.equals(entity.getSuspendType(), "0")) {
			// 回写合同中止状态
			LambdaUpdateWrapper<OtherContractEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(OtherContractEntity::getContractStatus, "4");
			wrapper.set(OtherContractEntity::getIsSuspend, 1);
			wrapper.eq(OtherContractEntity::getId, entity.getContractId());
			registerService.update(wrapper);
		}else {
			// 回写合同中止状态
			LambdaUpdateWrapper<OtherContractEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(OtherContractEntity::getContractStatus, "2");
			wrapper.set(OtherContractEntity::getIsSuspend, 0);
			wrapper.eq(OtherContractEntity::getId, entity.getContractId());
			registerService.update(wrapper);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("合同冻结不支持回退功能!");
//		OtherContractSuspendEntity entity = service.selectById(billId);
//		LambdaQueryWrapper<OtherContractSuspendEntity> wrapper = new LambdaQueryWrapper<>();
//		wrapper.eq(OtherContractSuspendEntity::getContractId, entity.getContractId());
//		wrapper.orderByDesc(OtherContractSuspendEntity::getCreateTime);
//		List<OtherContractSuspendEntity> list = service.list(wrapper);
//		if (ListUtil.isNotEmpty(list)) {
//			long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
//			if (count > 0) {
//				throw new BusinessException("当前合同存在非审批通过态的合同冻结，无法撤回！");
//			}
//		}
//		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//
//		OtherContractSuspendEntity entity = service.selectById(billId);
//
//		LambdaUpdateWrapper<OtherContractEntity> wrapper = new LambdaUpdateWrapper<>();
//		if (Objects.equals(entity.getSuspendType(), "0")) {
//			wrapper.set(OtherContractEntity::getContractStatus, "2");
//			wrapper.set(OtherContractEntity::getIsSuspend, 0);
//		}else {
//			wrapper.set(OtherContractEntity::getContractStatus, "4");
//			wrapper.set(OtherContractEntity::getIsSuspend, 1);
//		}
//
//		wrapper.eq(OtherContractEntity::getId, entity.getContractId());
//		registerService.update(wrapper);

		return CommonResponse.success();
	}

}
