/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.enums.OtherContractStatusEnum;
import com.ejianc.business.pro.other.mapper.OtherContractMapper;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.vo.ImportOtherContractVO;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="otherContractService")
public class OtherContractServiceImpl
extends BaseServiceImpl<OtherContractMapper, OtherContractEntity>
implements IOtherContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @Override
    public OtherContractVO saveOrUpdate(OtherContractVO otherContractVO) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = (OtherContractEntity)((Object)BeanMapper.map((Object)otherContractVO, OtherContractEntity.class));
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_BILL_CODE, (Long)tenantId, (BaseVO)otherContractVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setIsFinish(0);
        }
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)otherContractVO.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setIsSuspend(0);
        entity.setIsRelieve(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        this.saveOrUpdate((Object)entity, false);
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OtherContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Date getSignDate(Long id) {
        return this.contractMapper.getSignDate(id);
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractMapper.selectById(id));
        OtherContractVO otherContractVO = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setSupplierId(otherContractVO.getSupplierId());
        vo.setSupplierName(otherContractVO.getSupplierName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }

    @Override
    public boolean pushContract(OtherContractVO vo, Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            if (updateLevel.booleanValue()) {
                this.delContractFromPool(vo.getId());
            }
            if ("1".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("1");
            }
            if ("2".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("2");
            }
            if ("3".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("3");
            }
            if ("4".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("5");
            }
            if ("5".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u5176\u4ed6\u6536\u5165\u5408\u540c.getTypeCode());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-proincome-frontend/#/otherContract/otherContractApprove?id=" + vo.getId() : "/ejc-proincome-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            data.setPcCardUrl(url);
            data.setCategoryId(Long.valueOf(1524002474627813378L));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public CommonResponse<JSONObject> excelImportProMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        HashMap orgVOMap = new HashMap();
        HashMap<Object, ProjectPoolSetVO> projectPoolVoMap = new HashMap<Object, ProjectPoolSetVO>();
        HashMap contractPoolVoNoCodeMap = new HashMap();
        HashMap<String, SupplierVO> supplierVOMap = new HashMap<String, SupplierVO>();
        HashMap<String, OrgVO> projectOrgVoMap = new HashMap<String, OrgVO>();
        HashMap contractReviewEntityMap = new HashMap();
        HashMap employeeVOMap = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportOtherContractVO> successList = new ArrayList<ImportOtherContractVO>();
        ArrayList<ImportOtherContractVO> errorList = new ArrayList<ImportOtherContractVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 12) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                Long orgIdP = 0L;
                List datas = (List)result.get(i);
                ImportOtherContractVO detailVO2 = new ImportOtherContractVO();
                String contractCodeEx = (String)datas.get(0);
                detailVO2.setBillCode(contractCodeEx);
                String contractNameEx = (String)datas.get(1);
                detailVO2.setContractName(contractNameEx);
                String projectNameEx = (String)datas.get(2);
                detailVO2.setProjectName(projectNameEx);
                String partyaNameEx = (String)datas.get(3);
                detailVO2.setCustomerName(partyaNameEx);
                String partybNameEx = (String)datas.get(4);
                detailVO2.setSupplierName(partybNameEx);
                String supplierEmployeeName = (String)datas.get(5);
                detailVO2.setSupplierEmployeeName(supplierEmployeeName);
                String supplierEmployeeMobile = (String)datas.get(6);
                detailVO2.setSupplierEmployeeMobile(supplierEmployeeMobile);
                String signDateStrEx = (String)datas.get(7);
                String taxRateEx = (String)datas.get(8);
                String contractStatus = (String)datas.get(9);
                detailVO2.setContractStatus(contractStatus);
                detailVO2.setContractStatusName(contractStatus);
                String employeeName = (String)datas.get(10);
                detailVO2.setEmployeeName(employeeName);
                String memoEx = (String)datas.get(11);
                detailVO2.setMemo(memoEx);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractCodeEx)) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OtherContractEntity::getBillCode, (Object)contractCodeEx);
                    queryWrapper.eq(BaseEntity::getDr, (Object)0);
                    queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
                    if (!this.list((Wrapper)queryWrapper).isEmpty()) {
                        detailVO2.setErrorMessage("\u5408\u540c\u7f16\u7801\u5df2\u5b58\u5728");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    detailVO2.setContractName(contractNameEx);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)projectNameEx)) {
                    detailVO2.setErrorMessage("\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    ProjectPoolSetVO projectPoolSetVOFlag = null;
                    if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                        CommonResponse projectVOListRes = this.projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                        if (projectVOListRes.isSuccess()) {
                            List projectVOList = (List)projectVOListRes.getData();
                            if (CollectionUtils.isEmpty((Collection)projectVOList)) {
                                detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                            } else if (projectVOList.size() == 1) {
                                ProjectPoolSetVO projectPoolSetVO;
                                projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectVOList.get(0);
                                Long orgId = projectPoolSetVO.getOrgId();
                                String orgCode = projectPoolSetVO.getOrgCode();
                                String orgName = projectPoolSetVO.getOrgName();
                                Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                detailVO2.setOrgId(projectDepartmentId1);
                                detailVO2.setOrgCode(projectDepartmentCode);
                                detailVO2.setOrgName(projectDepartmentName);
                                detailVO2.setParentOrgId(orgId);
                                detailVO2.setParentOrgCode(orgCode);
                                detailVO2.setParentOrgName(orgName);
                                detailVO2.setProjectId(projectPoolSetVO.getId());
                                detailVO2.setProjectName(projectPoolSetVO.getName());
                                projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                            } else {
                                detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u9879\u76ee\u4fe1\u606f");
                            }
                        } else {
                            detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                        }
                    } else {
                        ProjectPoolSetVO projectPoolSetVO;
                        projectPoolSetVOFlag = projectPoolSetVO = (ProjectPoolSetVO)projectPoolVoMap.get(projectNameEx);
                        Long orgId = projectPoolSetVO.getOrgId();
                        String orgCode = projectPoolSetVO.getOrgCode();
                        String orgName = projectPoolSetVO.getOrgName();
                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                        detailVO2.setOrgId(projectDepartmentId1);
                        detailVO2.setOrgCode(projectDepartmentCode);
                        detailVO2.setOrgName(projectDepartmentName);
                        detailVO2.setParentOrgId(orgId);
                        detailVO2.setParentOrgCode(orgCode);
                        detailVO2.setParentOrgName(orgName);
                        detailVO2.setProjectId(projectPoolSetVO.getId());
                        detailVO2.setProjectName(projectPoolSetVO.getName());
                    }
                    if (projectPoolSetVOFlag != null) {
                        OrgVO data;
                        CommonResponse orgVO;
                        Long orgId = projectPoolSetVOFlag.getOrgId();
                        Long projectDepartmentId1 = projectPoolSetVOFlag.getProjectDepartmentId();
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(orgId)) == null) {
                            orgVO = this.orgApi.detailById(orgId);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(orgId), data);
                                if (data == null) {
                                    detailVO2.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO2.setParentOrgCode(data.getCode());
                                }
                            } else {
                                detailVO2.setErrorMessage(orgVO.getMsg());
                            }
                        } else {
                            detailVO2.setParentOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(orgId))).getCode());
                        }
                        if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(projectDepartmentId1)) == null) {
                            orgVO = this.orgApi.detailById(projectDepartmentId1);
                            if (orgVO.isSuccess()) {
                                data = (OrgVO)orgVO.getData();
                                projectOrgVoMap.put(String.valueOf(projectDepartmentId1), data);
                                if (data == null) {
                                    detailVO2.setErrorMessage("\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
                                } else {
                                    detailVO2.setOrgCode(data.getCode());
                                }
                            }
                        } else {
                            detailVO2.setOrgCode(((OrgVO)projectOrgVoMap.get(String.valueOf(projectDepartmentId1))).getCode());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u4fe1\u606f");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)partyaNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u7532\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                    CommonResponse orgVORes = this.shareSupplierApi.findOneByName(partyaNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        SupplierVO orgVO = (SupplierVO)orgVORes.getData();
                        if (orgVO == null) {
                            detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partyaNameEx, orgVO);
                            detailVO2.setCustomerId(orgVO.getId());
                            detailVO2.setCustomerName(orgVO.getName());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO orgVO = (SupplierVO)supplierVOMap.get(partyaNameEx);
                    detailVO2.setCustomerId(orgVO.getId());
                    detailVO2.setCustomerName(orgVO.getName());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)partybNameEx)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u4e59\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                    CommonResponse supplierVORes = this.shareSupplierApi.findOneByName(partybNameEx, tenantid);
                    if (supplierVORes.isSuccess()) {
                        SupplierVO supplierVO = (SupplierVO)supplierVORes.getData();
                        if (supplierVO == null) {
                            detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            supplierVOMap.put(partybNameEx, supplierVO);
                            detailVO2.setSupplierId(supplierVO.getId());
                            detailVO2.setSupplierName(supplierVO.getName());
                        }
                    } else {
                        detailVO2.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    SupplierVO supplierVO = (SupplierVO)supplierVOMap.get(partybNameEx);
                    detailVO2.setSupplierId(supplierVO.getId());
                    detailVO2.setSupplierName(supplierVO.getName());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierEmployeeName)) {
                    detailVO2.setErrorMessage("\u4e59\u65b9\u7ecf\u529e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO2.setSupplierEmployeeName(supplierEmployeeName);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)supplierEmployeeMobile)) {
                    detailVO2.setErrorMessage("\u4e59\u65b9\u7ecf\u529e\u4eba\u7535\u8bdd\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    detailVO2.setSupplierEmployeeMobile(supplierEmployeeMobile);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)signDateStrEx)) {
                    detailVO2.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO2.setSignDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(signDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taxRateEx)) {
                    detailVO2.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal taxRate = new BigDecimal(taxRateEx);
                        if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO2.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO2.setTaxRate(taxRate);
                        }
                    }
                    catch (Exception e) {
                        detailVO2.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)employeeName)) {
                    detailVO2.setErrorMessage("\u7ecf\u529e\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(employeeName) == null) {
                    CommonResponse map = this.employeeApi.getEmployeeMapByNames(Collections.singletonList(employeeName));
                    if (map.isSuccess() && null != map.getData()) {
                        Map employee = (Map)map.getData();
                        if (MapUtils.isEmpty((Map)employee) || employee.get(employeeName) == null) {
                            detailVO2.setErrorMessage("\u7ecf\u529e\u4eba\u4e0d\u5b58\u5728");
                        } else {
                            EmployeeVO employeeVO = (EmployeeVO)employee.get(employeeName);
                            detailVO2.setEmployeeId(employeeVO.getId());
                            detailVO2.setEmployeeName(employeeVO.getName());
                            detailVO2.setDeptId(employeeVO.getDeptId());
                            detailVO2.setDeptName(employeeVO.getDeptName());
                        }
                    }
                } else {
                    EmployeeVO employeeVO = (EmployeeVO)employeeVOMap.get(employeeName);
                    detailVO2.setEmployeeId(employeeVO.getId());
                    detailVO2.setEmployeeName(employeeVO.getName());
                    detailVO2.setDeptId(employeeVO.getDeptId());
                    detailVO2.setDeptName(employeeVO.getDeptName());
                }
                if (StringUtils.isBlank((String)contractStatus)) {
                    detailVO2.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                    }
                    if (OtherContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                    } else if (OtherContractStatusEnum.\u5c65\u7ea6\u4e2d.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u5c65\u7ea6\u4e2d.getDescription());
                    } else if (OtherContractStatusEnum.\u5df2\u5c01\u8d26.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u5df2\u5c01\u8d26.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u5df2\u5c01\u8d26.getDescription());
                    } else if (OtherContractStatusEnum.\u5df2\u89e3\u9664.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u5df2\u89e3\u9664.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u5df2\u89e3\u9664.getDescription());
                    } else if (OtherContractStatusEnum.\u5df2\u51bb\u7ed3.getDescription().equals(contractStatus)) {
                        detailVO2.setContractStatus(OtherContractStatusEnum.\u5df2\u51bb\u7ed3.getCode());
                        detailVO2.setContractStatusName(OtherContractStatusEnum.\u5df2\u51bb\u7ed3.getDescription());
                    } else {
                        detailVO2.setErrorMessage("\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)memoEx) && memoEx.length() > 100) {
                    detailVO2.setErrorMessage("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u5927\u4e8e100");
                } else {
                    detailVO2.setMemo(memoEx);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)detailVO2.getErrorMessage())) {
                    successList.add(detailVO2);
                } else {
                    errorList.add(detailVO2);
                }
                detailVO2.setSupplementFlag(Integer.valueOf(0));
                detailVO2.setChangeStatus("1");
                detailVO2.setSupplementFlag(Integer.valueOf(0));
                detailVO2.setIsSuspend(Integer.valueOf(0));
                detailVO2.setIsRelieve(Integer.valueOf(0));
            }
        }
        errorList.forEach(detailVO -> detailVO.setId(Long.valueOf(IdWorker.getId())));
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        Date createTime = new Date();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = "";
        if (userContext != null) {
            userCode = userContext.getUserCode();
        }
        List sucVoList = BeanMapper.mapList(successList, OtherContractVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (CollectionUtils.isNotEmpty((Collection)sucVoList)) {
            for (OtherContractVO vo : sucVoList) {
                vo.setCreateTime(createTime);
                vo.setCreateUserCode(userCode);
                long contractId = IdWorker.getId();
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getBillCode())) continue;
                BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_BILL_CODE, (Long)tenantId, (BaseVO)vo);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    vo.setBillCode((String)billCode.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List sucEntityList = BeanMapper.mapList((Iterable)sucVoList, OtherContractEntity.class);
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }
}

