package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.GeneralDetailEntity;
import com.ejianc.business.pro.income.controller.api.ProincomeContrantApi;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IGeneralDetailService;
import com.ejianc.business.pro.income.vo.GeneralDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.income.bean.GeneralEntity;
import com.ejianc.business.pro.income.service.IGeneralService;
import com.ejianc.business.pro.income.vo.GeneralVO;

/**
 * 总包结算计划主表
 *
 * @author generator
 */
@Controller
@RequestMapping("general")
public class GeneralController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IFinalizedService finalizedService;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "GENERAL_XU_CODE_DATA";//此处需要根据实际修改

    @Autowired
    private IGeneralService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ProincomeContrantApi proincomeContrantApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GeneralVO> saveOrUpdate(@RequestBody GeneralVO saveOrUpdateVO) {
        GeneralEntity entity = BeanMapper.map(saveOrUpdateVO, GeneralEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        GeneralVO vo = BeanMapper.map(entity, GeneralVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GeneralVO> queryDetail(Long id) {
        GeneralEntity entity = service.selectById(id);
        GeneralVO vo = BeanMapper.map(entity, GeneralVO.class);
        List<GeneralDetailVO> detailList = vo.getDetailList();
        List<Long> projectIds = detailList.stream().map(GeneralDetailVO::getProjectId).collect(Collectors.toList());
        if(projectIds == null || projectIds.isEmpty()){
            return CommonResponse.success("查询成功！", vo);
        }
        List<Long> tenantId = detailList.stream().map(GeneralDetailVO::getTenantId).collect(Collectors.toList());
        List<Long> orgId = detailList.stream().map(GeneralDetailVO::getOrgId).collect(Collectors.toList());
        //查询 审批通过 竣工结算单
        QueryParam param = new QueryParam();
        //获取项目id对应的数据
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (tenantId != null && tenantId.isEmpty()) {
            param.getParams().put("tenantId", new Parameter(QueryParam.IN, tenantId));
        }
        if (orgId != null && orgId.isEmpty()) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgId));
        }
        List<FinalizedEntity> finalizedEntities = finalizedService.getProjectIds(param);
        if (finalizedEntities == null || finalizedEntities.isEmpty()) {
            return CommonResponse.success("查询详情数据成功！", vo);
        }
        HashMap<String, List<FinalizedEntity>> finalizedMap = new HashMap<>();
        //获取项目id对应的数据
        finalizedEntities.forEach(finalizedEntity -> {
            //数据已经存在
            if (finalizedMap.containsKey(finalizedEntity.getProjectId().toString())) {
                finalizedMap.get(finalizedEntity.getProjectId().toString()).add(finalizedEntity);
            } else {
                //数据不存在
                List<FinalizedEntity> list = new ArrayList<>();
                list.add(finalizedEntity);
                finalizedMap.put(finalizedEntity.getProjectId().toString(), list);
            }
        });
        //数据封装
        List<GeneralDetailVO> ans = new ArrayList<>();
        for (GeneralDetailVO detailVO : detailList) {
            if (!finalizedMap.containsKey(detailVO.getProjectId().toString())) {
                continue;
            }
            //1.先获取数据
            List<FinalizedEntity> check = finalizedMap.get(detailVO.getProjectId().toString());
            if (check.isEmpty()) {
                continue;
            }
            GeneralDetailVO an = new GeneralDetailVO();
            //数据拷贝
            BeanUtils.copyProperties(detailVO, an);
            //2.1报出金额：统计竣工结算单审批通过的
            BigDecimal mnys = new BigDecimal("0");
            //一审金额：统计审批通过的竣工结算单的【一审金额】如果存在多个，金额求和
            BigDecimal firstMny = new BigDecimal("0");
            //3.1 终审金额：统计审批通过的竣工结算单的【二审金额】如果存在多个，金额求和
            BigDecimal finalMny = new BigDecimal("0");
            //2.2 报出时间：统计竣工结算单的【一审完成日期】，如果存在多个，取最大日期
            Date time = null;
            Date firstTime = null;
            Date finalTime = null;
            for (FinalizedEntity finalized : check) {
                BigDecimal mny = finalized.getReportSettleTaxMny();
                try {
                    //报出金额
                    if (mny != null) {
                        mnys.add(mny);
                    }
                    //一审金额
                    if (finalized.getFirstInstanceMny() != null) {
                        firstMny.add(finalized.getFirstInstanceMny());
                    }
                    //终审金额
                    if (finalized.getFinalInstanceMny() != null) {
                        finalMny.add(finalized.getFinalInstanceMny());
                    }
                } catch (Exception e) {
                    logger.debug("金额数据处理异常{}", an.toString());
                }
                try {
                    if (time == null) {
                        time = finalized.getFirstInstanceDate();
                    } else {
                        //取最大日期
                        time = Collections.max(Arrays.asList(time, finalized.getFirstInstanceDate()));
                    }
                    //一审时间：统计审批通过的竣工结算单的【一审完成日期】，如果存在多个，取最大日期
                    if (firstTime == null) {
                        firstTime = finalized.getFirstInstanceDate();
                    } else {
                        firstTime = Collections.max(Arrays.asList(firstTime, finalized.getFirstInstanceDate()));
                    }
                    //终审时间：统计审批通过的竣工结算单的【二审完成日期】，如果存在多个，取最大日期
                    if (finalTime == null) {
                        finalTime = finalized.getFinalInstanceDate();
                    } else {
                        finalTime = Collections.max(Arrays.asList(finalTime, finalized.getFinalInstanceDate()));
                    }
                } catch (Exception e) {
                    logger.debug("日期数据校验异常{}", an.toString());
                }

            }
            an.setReportSettleTaxMny(mnys);
            an.setReportSettleTaxData(time);
            an.setFirstInstanceMny(firstMny);
            an.setFirstInstanceDate(firstTime);
            an.setFinalInstanceMny(finalMny);
            an.setFinalInstanceDate(finalTime);
            // 计算滞后天数
            if (time != null && time.after(new Date(0))) { // 确保 time 有效且不是初始值
                try {
                    LocalDate now = LocalDate.now();
                    LocalDate timeLocalDate = time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    LocalDate lastDayOfMonth = timeLocalDate.with(TemporalAdjusters.lastDayOfMonth());
                    //报送滞后时间
                    long delayDays = ChronoUnit.DAYS.between(lastDayOfMonth, now);
                    //一审滞后时间
                    LocalDate firstDate = firstTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    LocalDate firstDayOfMonth = firstDate.with(TemporalAdjusters.lastDayOfMonth());
                    long firstDelayDays = ChronoUnit.DAYS.between(firstDayOfMonth, now);
                    //终审滞后时间
                    LocalDate finalDate = finalTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    LocalDate finalDayOfMonth = finalDate.with(TemporalAdjusters.lastDayOfMonth());
                    long finalDelayDays = ChronoUnit.DAYS.between(finalDayOfMonth, now);
                    an.setFirstInstanceStopDate(finalDelayDays);
                    //一审滞后时间
                    an.setReportSettleTaxStopData(delayDays);
                    //报送滞后时间
                    an.setFirstInstanceStopDate(firstDelayDays);
                } catch (Exception e) {
                    logger.debug("滞后时间处理异常{}", an.toString());
                }
            }
            ans.add(an);
        }
        vo.setDetailList(ans);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GeneralVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GeneralVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(GeneralVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GeneralVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("unitId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /*if (CollectionUtils.isNotEmpty(commonOrgIds)) {
         *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }*/
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<GeneralEntity> page = service.queryPage(param, false);

        IPage<GeneralVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GeneralVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 查询项目对象名称
     *
     * @param id 项目ID
     * @return
     */
    @RequestMapping(value = "/queueObjectName", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> selectObject(Long id) {
        //TODO 获取金额ID
        return proincomeContrantApi.queryContranct(id);
    }


    // 导入模板下载
    @RequestMapping(value = "/downloadExcelModel")
    @ResponseBody
    public void downloadExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "General-import-export.xlsx", "总包结算计划");
    }

    // excel数据导入
    @ApiOperation("导入")
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response, 0);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<GeneralEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("General-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refGeneralData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GeneralVO>> refGeneralData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<GeneralEntity> page = service.queryPage(param, false);
        IPage<GeneralVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GeneralVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


}
