/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.home.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.home.service.IHomePortalService;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/homePortal"})
public class HomePortalController {
    @Autowired
    private IHomePortalService service;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinalizedService finalizedService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IProductionService productionService;

    @RequestMapping(value={"/productReplyReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReport(@RequestBody QueryParam param) {
        JSONObject result = this.service.productReplyReport(param);
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/productReplyReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> productReplyReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject result = this.service.productReplyReport(param);
        HashMap<String, JSONArray> beans = new HashMap<String, JSONArray>();
        beans.put("records", result.getJSONArray("records"));
        ExcelExport.getInstance().export("production-reply-export.xlsx", beans, response);
        return CommonResponse.success((Object)result);
    }

    @PostMapping(value={"getSecOprSituation"})
    public CommonResponse<JSONObject> getSecOprSituation(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        String year = "thisYear";
        if (params.containsKey((Object)"year")) {
            year = params.getString("year");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", Parameter.getInInstance(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if ("thisYear".equals(year)) {
            queryParam.getParams().put("happenDate", new Parameter("sql", (Object)(" DATE_FORMAT(happen_date, '%Y') = '" + DateUtil.getCurrentYear() + "'")));
        }
        List dbList = this.claimService.queryList(queryParam);
        BigDecimal totalApplyMny = BigDecimal.ZERO;
        BigDecimal totalApprMny = BigDecimal.ZERO;
        for (ClaimEntity c : dbList) {
            totalApplyMny = ComputeUtil.safeAdd((BigDecimal)totalApplyMny, (BigDecimal)c.getClaimTaxMny());
            if (!"1".equals(c.getReplyStatus())) continue;
            totalApprMny = ComputeUtil.safeAdd((BigDecimal)totalApprMny, (BigDecimal)c.getReplyTaxMny());
        }
        totalApplyMny = ComputeUtil.safeDiv((BigDecimal)totalApplyMny, (BigDecimal)new BigDecimal("10000"));
        totalApprMny = ComputeUtil.safeDiv((BigDecimal)totalApprMny, (BigDecimal)new BigDecimal("10000"));
        resp.put("totalApplyMny", (Object)totalApplyMny);
        resp.put("totalApprMny", (Object)totalApprMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/getFinalAccountsFinalized"})
    public CommonResponse<JSONObject> getFinalAccountsFinalized(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        String period = "1";
        if (params.containsKey((Object)"period")) {
            period = params.getString("period");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", Parameter.getInInstance(Arrays.stream(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}).collect(Collectors.toList())));
        queryParam.getParams().put("finalStage", Parameter.getInInstance(Arrays.stream(new String[]{"1", "2"}).collect(Collectors.toList())));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String todayStr = sdf.format(new Date());
        if ("1".equals(period)) {
            queryParam.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >=0 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 365")));
        } else if ("2".equals(period)) {
            queryParam.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') >365 AND DATEDIFF(DAY, report_date, '" + todayStr + "') <= 1095")));
        } else {
            queryParam.getParams().put("report_date", new Parameter("sql", (Object)(" DATEDIFF(DAY, report_date, '" + todayStr + "') > 1095")));
        }
        List dbList = this.finalizedService.queryList(queryParam);
        resp.put("nums", (Object)dbList.size());
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/getOperationInfo"})
    public CommonResponse<JSONObject> getOperationInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam conParam = new QueryParam();
        conParam.getParams().put("parentOrgId", Parameter.getInInstance(orgIds));
        conParam.getParams().put("billState", Parameter.getInInstance(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        conParam.getParams().put("signDate", new Parameter("sql", (Object)(" DATE_FORMAT(sign_date, '%Y') = '" + DateUtil.getCurrentYear() + "'")));
        List conList = this.contractRegisterService.queryList(conParam);
        BigDecimal conTotalTaxMny = conList.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        conParam.getParams().remove("signDate");
        conParam.getParams().put("startDate", new Parameter("sql", (Object)(" DATE_FORMAT(start_date, '%Y') = '" + DateUtil.getCurrentYear() + "'")));
        List pList = this.productionService.queryList(conParam);
        BigDecimal pTotalTaxMny = pList.stream().map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        resp.put("conTotalTaxMny", (Object)ComputeUtil.safeDiv((BigDecimal)conTotalTaxMny, (BigDecimal)new BigDecimal("10000")));
        resp.put("pTotalTaxMny", (Object)ComputeUtil.safeDiv((BigDecimal)pTotalTaxMny, (BigDecimal)new BigDecimal("10000")));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

