/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.income.bean.GeneralEntity;
import com.ejianc.business.pro.income.mapper.GeneralMapper;
import com.ejianc.business.pro.income.service.IGeneralService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.GeneralDetailVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="generalService")
public class GeneralServiceImpl
extends BaseServiceImpl<GeneralMapper, GeneralEntity>
implements IGeneralService {
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flg) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantId = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<GeneralDetailVO> successList = new ArrayList<GeneralDetailVO>();
        ArrayList<GeneralDetailVO> errorList = new ArrayList<GeneralDetailVO>();
        if (result == null || result.isEmpty()) {
            throw new BusinessException("\u6570\u636e\u8868\u683c\u9519\u8bef");
        }
        if (((List)result.get(0)).size() != 10) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
        }
        for (int i = 2; i < result.size(); ++i) {
            List datas;
            GeneralDetailVO vo;
            block23: {
                long id = IdWorker.getId();
                vo = new GeneralDetailVO();
                vo.setId(Long.valueOf(id));
                datas = (List)result.get(i);
                String contractNameEx = (String)datas.get(0);
                CommonResponse commonResponse = this.projectPoolApi.queryProjectListByNameAndTenantId(contractNameEx, tenantId);
                if (!commonResponse.isThisTimeDone()) {
                    GeneralServiceImpl.errorMessage(vo, contractNameEx, errorList, "\u672a\u627e\u5230\u9879\u76ee\u6c60\u9879\u76ee\u6570\u636e");
                    continue;
                }
                List projectPoolSetVOList = (List)commonResponse.getData();
                if (projectPoolSetVOList == null || projectPoolSetVOList.isEmpty()) {
                    GeneralServiceImpl.errorMessage(vo, contractNameEx, errorList, "\u672a\u627e\u5230\u9879\u76ee\u6c60\u9879\u76ee\u6570\u636e");
                    continue;
                }
                if (projectPoolSetVOList.size() > 1) {
                    GeneralServiceImpl.errorMessage(vo, contractNameEx, errorList, "\u9879\u76ee\u6c60\u9879\u76ee\u6570\u636e\u91cd\u590d");
                    continue;
                }
                List data = (List)commonResponse.getData();
                ProjectPoolSetVO setVO = (ProjectPoolSetVO)data.get(0);
                vo.setProjrctName(contractNameEx);
                vo.setProjectId(setVO.getProjectId());
                try {
                    String amount = setVO.getContractAmount();
                    if (amount == null) {
                        amount = (String)datas.get(1);
                    }
                    BigDecimal decimal = BigDecimal.valueOf(Double.parseDouble(amount));
                    vo.setContractTaxMny(decimal);
                }
                catch (Exception e) {
                    GeneralServiceImpl.errorMessage(vo, contractNameEx, errorList, "\u5408\u540c\u91d1\u989d\u67e5\u8be2\u9519\u8bef");
                    continue;
                }
                try {
                    Date date;
                    String actualEndDate = (String)datas.get(2);
                    if (setVO.getActualEndDate() == null) {
                        date = GeneralServiceImpl.convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                        vo.setConstructionTime(date);
                    } else {
                        vo.setConstructionTime(setVO.getActualEndDate());
                    }
                    if (datas.get(4) != null) {
                        actualEndDate = (String)datas.get(4);
                        date = GeneralServiceImpl.convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                        vo.setFirstTime(date);
                    }
                    if (datas.get(3) != null) {
                        actualEndDate = (String)datas.get(3);
                        date = GeneralServiceImpl.convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                        vo.setSettlementTime(date);
                    }
                    if (datas.get(5) == null) break block23;
                    actualEndDate = (String)datas.get(5);
                    date = GeneralServiceImpl.convertExcelDateToJavaDate(Integer.parseInt(actualEndDate));
                    vo.setFinalTime(date);
                }
                catch (Exception e) {
                    GeneralServiceImpl.errorMessage(vo, contractNameEx, errorList, "\u7ae3\u5de5\u65e5\u671f\u67e5\u8be2\u9519\u8bef");
                    continue;
                }
            }
            vo.setProjectUser((String)datas.get(6));
            vo.setBranchUser((String)datas.get(7));
            vo.setSupervisesUser((String)datas.get(8));
            vo.setMemo((String)datas.get(9));
            vo.setId(Long.valueOf(IdWorker.getId()));
            successList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        long settlementNums = 0L;
        long firstNums = 0L;
        long finalNums = 0L;
        BigDecimal contractTaxMny = new BigDecimal(0);
        for (GeneralDetailVO vo : successList) {
            if (vo.getContractTaxMny() != null) {
                contractTaxMny = MathUtil.safeAdd(contractTaxMny, vo.getContractTaxMny());
            }
            if (vo.getFirstTime() != null) {
                ++firstNums;
                continue;
            }
            if (vo.getFinalTime() != null) {
                ++finalNums;
                continue;
            }
            ++settlementNums;
        }
        json.put("settlementNums", (Object)settlementNums);
        json.put("firstNums", (Object)firstNums);
        json.put("finalNums", (Object)finalNums);
        json.put("contractTaxMny", (Object)contractTaxMny);
        return CommonResponse.success((Object)json);
    }

    private static void errorMessage(GeneralDetailVO vo, String contractNameEx, List<GeneralDetailVO> errorList, String errorMessage) {
        vo.setErrorMessage(errorMessage);
        vo.setProjrctName(contractNameEx);
        errorList.add(vo);
    }

    public static Date convertExcelDateToJavaDate(int excelDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        calendar.add(5, excelDate - 2);
        return calendar.getTime();
    }
}

