/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.utils.ValidateUtil;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.bean.OtherContractSuspendEntity;
import com.ejianc.business.pro.other.history.OtherContractSuspendHistoryVO;
import com.ejianc.business.pro.other.mapper.OtherContractSuspendMapper;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.service.IOtherContractSuspendService;
import com.ejianc.business.pro.other.vo.OtherContractSuspendVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractSuspendService")
public class OtherContractSuspendServiceImpl
extends BaseServiceImpl<OtherContractSuspendMapper, OtherContractSuspendEntity>
implements IOtherContractSuspendService {
    private static final String OTHER_SUSPEND_RELIEVE = "OTHER_SUSPEND_RELIEVE";
    private static final String OTHER_CODE = "EJCBT202205000014";
    @Autowired
    private IOtherContractService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ValidateUtil validateUtil;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OtherContractSuspendVO saveOrUpdate(OtherContractSuspendVO saveOrUpdateVO) {
        if (!Objects.equals(null, saveOrUpdateVO.getContractId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()), OTHER_CODE, saveOrUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        OtherContractSuspendEntity entity = (OtherContractSuspendEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OtherContractSuspendEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.validateContract(entity.getContractId(), entity.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)OTHER_SUSPEND_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            this.validateContract(entity.getContractId(), entity.getId());
        }
        this.saveOrUpdate((Object)entity, false);
        return (OtherContractSuspendVO)BeanMapper.map((Object)((Object)entity), OtherContractSuspendVO.class);
    }

    @Override
    public OtherContractSuspendVO queryLastSuspend(Long contractId) {
        List<OtherContractSuspendEntity> list = this.querySuspendByContractId(contractId);
        if (ListUtil.isEmpty(list)) {
            return new OtherContractSuspendVO();
        }
        return (OtherContractSuspendVO)BeanMapper.map((Object)((Object)list.get(0)), OtherContractSuspendVO.class);
    }

    @Override
    public OtherContractSuspendHistoryVO querySuspendRecord(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        OtherContractSuspendHistoryVO vo = new OtherContractSuspendHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OtherContractSuspendEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, OtherContractSuspendVO.class));
        return vo;
    }

    @Override
    public List<OtherContractSuspendEntity> querySuspendByContractId(Long contractId) {
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OtherContractSuspendEntity::getContractId, (Object)contractId);
        wrapper.in(OtherContractSuspendEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<OtherContractSuspendEntity>();
        }
        return list;
    }

    @Override
    public Boolean validateContract(Long contractId, Long id) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5408\u540c\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return true;
    }
}

