package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.BudgetNumEntity;
import com.ejianc.business.pro.income.mapper.BudgetNumMapper;
import com.ejianc.business.pro.income.service.IBudgetNumService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 工程量指标
 * 
 * @author generator
 * 
 */
@Service("budgetNumService")
public class BudgetNumServiceImpl extends BaseServiceImpl<BudgetNumMapper, BudgetNumEntity> implements IBudgetNumService{

    @Override
    public void delByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetNumEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetNumEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetNumEntity> queryByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetNumEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
