/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractRelieveEntity;
import com.ejianc.business.pro.income.mapper.ContractRelieveMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractRelieveService;
import com.ejianc.business.pro.income.vo.ContractRelieveVO;
import com.ejianc.business.pro.income.vo.RegisterRelieveHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    private static final String INCOME_CONTRACT_RELIEVE = "INCOME_CONTRACT_RELIEVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRegisterService registerService;

    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveorUpdateVO) {
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractRelieveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (ContractRelieveVO)BeanMapper.map((Object)this.selectById(entity.getId()), ContractRelieveVO.class);
    }

    @Override
    public ContractRelieveVO addRelieveByConId(Long registerId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(registerId));
        ContractRelieveVO vo = new ContractRelieveVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setRegisterId(registerId);
        vo.setContractName(entity.getContractName());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setTaxMny(entity.getTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setRelieveDate(new Date());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        return vo;
    }

    @Override
    public RegisterRelieveHistoryVO queryRelieveRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        RegisterRelieveHistoryVO vo = new RegisterRelieveHistoryVO();
        vo.setRegisterId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRelieveEntity::getRegisterId, (Object)id);
        wrapper.orderByDesc(ContractRelieveEntity::getRelieveDate);
        List list = super.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, ContractRelieveVO.class));
        return vo;
    }
}

