package com.ejianc.business.pro.income.controller;

import java.io.Serializable;

import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.OutPutEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.OutPutVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.income.bean.ProjectPaymentEntity;
import com.ejianc.business.pro.income.service.IProjectPaymentService;
import com.ejianc.business.pro.income.vo.ProjectPaymentVO;

/**
 * 内部配套项目工程款审批
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectPayment")
public class ProjectPaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_PAYMENT";//此处需要根据实际修改

    @Autowired
    private IProjectPaymentService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRegisterService iContractRegisterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectPaymentVO> saveOrUpdate(@RequestBody ProjectPaymentVO saveOrUpdateVO) {
    	ProjectPaymentEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectPaymentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getCivilMny().add(entity.getMechatronicMny()).add(entity.getOtherMny()).compareTo(entity.getContractSumMny())!=0){
            return CommonResponse.error("土建合同金额,机电合同金额,其他合同金额之和必须等于合同总金额！");
        }
        else {
            service.saveOrUpdate(entity, false);
            ProjectPaymentVO vo = BeanMapper.map(entity, ProjectPaymentVO.class);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPaymentVO> queryDetail(Long id) {
    	ProjectPaymentEntity entity = service.selectById(id);
    	ProjectPaymentVO vo = BeanMapper.map(entity, ProjectPaymentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPaymentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectPaymentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectPaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectPaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ProjectPaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectPaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPaymentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectPaymentEntity> list = service.queryList(param);
        List<ProjectPaymentVO> vos = BeanMapper.mapList(list, ProjectPaymentVO.class);
        vos.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("ProjectPayment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectPaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPaymentVO>> refProjectPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectPaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectPaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/selectByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPaymentVO> selectByProjectId(Long id) {
        List<ProjectPaymentEntity> list = service.lambdaQuery()
                .eq(ProjectPaymentEntity::getProjectId, id)
                .eq(ProjectPaymentEntity::getBillState, 0)
                .eq(ProjectPaymentEntity::getDr, 0)
                .list();
        List<ContractRegisterEntity> list1 = iContractRegisterService.lambdaQuery()
                .eq(ContractRegisterEntity::getProjectId, id)
                .eq(ContractRegisterEntity::getDr, 0)
                .in(ContractRegisterEntity::getBillState, 1, 3)
                .list();
        BigDecimal sumMny = list1.stream().map(e -> e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该项目存在未生效的单据，不可新增！");
        }
        else{
            ProjectPaymentVO projectPaymentVO = service.selectProject(id);
            if(projectPaymentVO != null){
                projectPaymentVO.setContractSumMny(sumMny);
                return CommonResponse.success("查询数据成功！",projectPaymentVO);
            }
            else {
                ProjectPaymentVO newProjectPaymentVO = new ProjectPaymentVO();
                newProjectPaymentVO.setContractSumMny(sumMny);
                return CommonResponse.success("查询数据成功！",newProjectPaymentVO);
            }
        }
    }
}
