/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.business.pro.income.vo.ClaimReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"claimRecords"})
public class ClaimRecordsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "INCOME_CLAIM_RECORDS";
    @Autowired
    private IClaimRecordsService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> saveOrUpdate(@RequestBody ClaimRecordsVO saveOrUpdateVO) {
        ClaimRecordsVO vo = this.service.insert(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> queryDetail(Long id) {
        ClaimRecordsEntity entity = (ClaimRecordsEntity)((Object)this.service.selectById(id));
        ClaimRecordsVO vo = (ClaimRecordsVO)BeanMapper.map((Object)((Object)entity), ClaimRecordsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimRecordsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ClaimRecordsVO claimRecordsVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ClaimRecordsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("claimTitle");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ClaimRecordsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("claimTitle");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List claimVOS = BeanMapper.mapList((Iterable)list, ClaimRecordsVO.class);
        claimVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            if (e.getSourceType().equals(1)) {
                e.setSourceTypeName("\u53d1\u5305\u65b9\u8981\u6c42");
            } else {
                e.setSourceTypeName("\u9879\u76ee\u90e8\u53d1\u8d77");
            }
            if (e.getClaimType().equals("2")) {
                e.setClaimTypeName("\u7b7e\u8bc1");
            } else {
                e.setClaimTypeName("\u7d22\u8d54");
            }
            if (e.getApprovalFlag() != null && e.getApprovalFlag() == 0) {
                e.setApprovalFlagName("\u5426");
            }
            if (e.getApprovalFlag() != null && e.getApprovalFlag() == 1) {
                e.setApprovalFlagName("\u662f");
            }
            if (e.getFinishState() != null && e.getFinishState() == 0) {
                e.setFinishStateName("\u672a\u5b8c\u5de5");
            }
            if (e.getFinishState() != null && e.getFinishState() == 1) {
                e.setFinishStateName("\u5df2\u5b8c\u5de5");
            }
            if (e.getHandleState() != null && e.getHandleState() == 1) {
                e.setHandleStateName("\u672a\u529e\u7406");
            }
            if (e.getHandleState() != null && e.getHandleState() == 2) {
                e.setHandleStateName("\u529e\u7406\u4e2d");
            }
            if (e.getHandleState() != null && e.getHandleState() == 3) {
                e.setHandleStateName("\u5df2\u529e\u7406");
            }
        });
        beans.put("records", claimVOS);
        ExcelExport.getInstance().export("ClaimRecords-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refClaimRecordsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ClaimRecordsVO>> refClaimRecordsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("claimType")) {
                String claimType = conditionMap.get("claimType").toString();
                param.getParams().put("claimType", new Parameter("eq", (Object)claimType));
            }
            if (null != conditionMap.get("claimId")) {
                Long claimId = Long.valueOf(conditionMap.get("claimId").toString());
                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("quoteStatus", new Parameter("eq", (Object)CommonConstants.WYY));
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("claimId", new Parameter("eq", (Object)claimId));
                c1.getComplexParams().add(c2);
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);
            } else {
                param.getParams().put("quoteStatus", new Parameter("eq", (Object)CommonConstants.WYY));
            }
        }
        param.getParams().put("quoteStatus", new Parameter("eq", (Object)CommonConstants.WYY));
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter("in", billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List claimVOS = BeanMapper.mapList((Iterable)page.getRecords(), ClaimRecordsVO.class);
        claimVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            if (e.getSourceType().equals(1)) {
                e.setSourceTypeName("\u53d1\u5305\u65b9\u8981\u6c42");
            } else {
                e.setSourceTypeName("\u9879\u76ee\u90e8\u53d1\u8d77");
            }
            if (e.getClaimType().equals("2")) {
                e.setClaimTypeName("\u7b7e\u8bc1");
            } else {
                e.setClaimTypeName("\u7d22\u8d54");
            }
        });
        pageData.setRecords(claimVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/updateCloseStatus"})
    @ResponseBody
    public CommonResponse<ClaimRecordsVO> updateCloseStatus(@RequestParam Long id, @RequestParam Integer isClose) {
        ClaimRecordsEntity entity = (ClaimRecordsEntity)((Object)this.service.selectById(id));
        if (!CommonConstants.WYY.equals(entity.getQuoteStatus())) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u5173\u95ed/\u5f00\u542f\uff01");
        }
        entity.setIsClose(isClose.equals(CommonConstants.OPEN) ? CommonConstants.CLOSE : CommonConstants.OPEN);
        this.service.save((Object)entity);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/claimReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> claimReport(@RequestBody QueryParam param) {
        JSONObject result = this.service.claimReport(param);
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/claimReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void claimReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject result = this.service.claimReport(param);
        Object records = result.get((Object)"records");
        ObjectMapper mapper = new ObjectMapper();
        List voList = (List)mapper.convertValue(records, (TypeReference)new TypeReference<List<ClaimReportVO>>(){});
        for (ClaimReportVO claimReportVO : voList) {
            if ("1".equals(claimReportVO.getProjectStatus())) {
                claimReportVO.setProjectStatusName("\u5728\u5efa");
            }
            if ("2".equals(claimReportVO.getProjectStatus())) {
                claimReportVO.setProjectStatusName("\u505c\u7f13\u5efa");
            }
            if ("3".equals(claimReportVO.getProjectStatus())) {
                claimReportVO.setProjectStatusName("\u7ae3\u5de5\u9a8c\u6536");
            }
            if ("4".equals(claimReportVO.getProjectStatus())) {
                claimReportVO.setProjectStatusName("\u5df2\u5b8c\u5de5");
            }
            if (!"5".equals(claimReportVO.getProjectStatus())) continue;
            claimReportVO.setProjectStatusName("\u5176\u4ed6");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        List claimVOS = BeanMapper.mapList((Iterable)voList, ClaimReportVO.class);
        beans.put("records", claimVOS);
        ExcelExport.getInstance().export("claimReportExport-export.xlsx", beans, response);
    }
}

