/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.OutPutEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IOutPutService;
import com.ejianc.business.pro.income.vo.OutPutVO;
import com.ejianc.business.prosub.api.IContractApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outPut"})
public class OutPutController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "OUTPUT_APPROVAL";
    @Autowired
    private IOutPutService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractApi iContractApi;
    @Autowired
    private IContractRegisterService iContractRegisterService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutPutVO> saveOrUpdate(@RequestBody OutPutVO saveOrUpdateVO) {
        OutPutEntity entity = (OutPutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutPutEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getCivilMny().add(entity.getMechatronicMny()).add(entity.getOtherMny()).compareTo(entity.getContractSumMny()) != 0) {
            return CommonResponse.error((String)"\u571f\u5efa\u5408\u540c\u91d1\u989d,\u673a\u7535\u5408\u540c\u91d1\u989d,\u5176\u4ed6\u5408\u540c\u91d1\u989d\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u5408\u540c\u603b\u91d1\u989d\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutPutVO vo = (OutPutVO)BeanMapper.map((Object)((Object)entity), OutPutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutPutVO> queryDetail(Long id) {
        OutPutEntity entity = (OutPutEntity)((Object)this.service.selectById(id));
        OutPutVO vo = (OutPutVO)BeanMapper.map((Object)((Object)entity), OutPutVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutPutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutPutVO outPutVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutPutVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutPutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List outPutVOS = BeanMapper.mapList((Iterable)list, OutPutVO.class);
        outPutVOS.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", outPutVOS);
        ExcelExport.getInstance().export("OutPut-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutPutData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutPutVO>> refOutPutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutPutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutPutVO> selectByProjectId(Long id) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.service.lambdaQuery().eq(OutPutEntity::getProjectId, (Object)id)).eq(OutPutEntity::getBillState, (Object)0)).eq(BaseEntity::getDr, (Object)0)).list();
        List list1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.iContractRegisterService.lambdaQuery().eq(ContractRegisterEntity::getProjectId, (Object)id)).eq(BaseEntity::getDr, (Object)0)).in(ContractRegisterEntity::getBillState, new Object[]{1, 3})).list();
        BigDecimal sumMny = list1.stream().map(e -> e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u65b0\u589e\uff01");
        }
        OutPutVO outPutVO = this.service.selectProject(id);
        if (outPutVO != null) {
            outPutVO.setContractSumMny(sumMny);
            Instant instant = outPutVO.getCurrentEndTime().toInstant();
            Date tomorrow = Date.from(instant.plus(1L, ChronoUnit.DAYS));
            outPutVO.setCurrentEndTime(tomorrow);
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)outPutVO);
        }
        OutPutVO newOutPutVO = new OutPutVO();
        newOutPutVO.setContractSumMny(sumMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)newOutPutVO);
    }
}

