package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.ProgressDetailEntity;
import com.ejianc.business.pro.income.bean.ProgressEntity;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IProgressService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.ProductionPlanVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("progress") 
public class ProgressBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProgressService service;

	@Autowired
	private IProductionService productionService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProgressEntity entity = service.selectById(billId);
		// 自动生成产值报量
		this.pushToProduction(entity);
		return CommonResponse.success();
	}

	/**
	 * 自动生成产值报量
	 * @param entity
	 */
	private void pushToProduction(ProgressEntity entity) {
		ProductionVO vo = new ProductionVO();
		vo.setProjectId(entity.getProjectId());
		vo.setProjectCode(entity.getProjectCode());
		vo.setProjectName(entity.getProjectName());
		vo.setOrgId(entity.getOrgId());
		vo.setOrgCode(entity.getOrgCode());
		vo.setOrgName(entity.getOrgName());
		vo.setParentOrgId(entity.getParentOrgId());
		vo.setParentOrgCode(entity.getParentOrgCode());
		vo.setParentOrgName(entity.getParentOrgName());
		vo.setCustomerId(entity.getOwnerId());
		vo.setCustomerName(entity.getOwnerName());
		vo.setScheduleDescription(entity.getMemo());

		vo.setStartDate(entity.getStartDate());
		vo.setEndDate(entity.getEndDate());
		vo.setProductionPeriod(DateUtil.formatDate(vo.getStartDate()) + "~" + DateUtil.formatDate(vo.getEndDate()));
		vo.setSourceId(String.valueOf(entity.getId()));

		List<ProductionPlanVO> planList = new ArrayList<>();
		for(ProgressDetailEntity detail : entity.getProgressDetailList()){
			ProductionPlanVO plan = new ProductionPlanVO();
			plan.setMonth(detail.getDetailDate());
			plan.setPlanProgress(detail.getPlanProgress());
			planList.add(plan);
		}
		vo.setPlanList(planList);
		productionService.saveOrUpdate(vo);
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryParam param = new QueryParam();
		param.getParams().put("sourceId", new Parameter(QueryParam.EQ, billId));
		List<ProductionEntity> list = productionService.queryList(param);
		if(CollectionUtils.isNotEmpty(list)){
			throw new BusinessException("该形象进度单有自动生成的产值进度单据，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
