package com.ejianc.business.pro.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.other.bean.OtherChangeEntity;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.business.pro.other.history.OtherSupplementHistoryVO;
import com.ejianc.business.pro.other.service.IOtherChangeService;
import com.ejianc.business.pro.other.service.IOtherContractService;
import com.ejianc.business.pro.other.vo.OtherSupplementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.other.mapper.OtherSupplementMapper;
import com.ejianc.business.pro.other.bean.OtherSupplementEntity;
import com.ejianc.business.pro.other.service.IOtherSupplementService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 其他收入合同补充协议
 * 
 * @author generator
 * 
 */
@Service("otherSupplementService")
public class OtherSupplementServiceImpl extends BaseServiceImpl<OtherSupplementMapper, OtherSupplementEntity> implements IOtherSupplementService{

    private static final String SUPPLEMENT_BILL_CODE = "OTHER_SUPPLEMENT";

    @Autowired
    private IOtherContractService contractService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOtherChangeService changeService;

    @Override
    public OtherSupplementVO saveOrUpdate(OtherSupplementVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OtherSupplementEntity> entities = null;
        OtherSupplementEntity entity = BeanMapper.map(saveOrUpdateVO, OtherSupplementEntity.class);

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<OtherSupplementEntity> lambdaQuery = Wrappers.<OtherSupplementEntity>lambdaQuery();
        lambdaQuery.eq(OtherSupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(OtherSupplementEntity::getMainContractId, entity.getMainContractId());
        if(entity.getId() != null && entity.getId() > 0) {
            lambdaQuery.ne(OtherSupplementEntity::getId, entity.getId());
        }
        lambdaQuery.ne(OtherSupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(OtherSupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }
        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<OtherChangeEntity> lambdachange = Wrappers.<OtherChangeEntity>lambdaQuery();
        lambdachange.eq(OtherChangeEntity::getTenantId, tenantId);
        lambdachange.eq(OtherChangeEntity::getContractId, entity.getMainContractId());
        lambdachange.ne(OtherChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(OtherChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = changeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(SUPPLEMENT_BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(entity.getId() != null && entity.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<OtherSupplementEntity> lambda = Wrappers.<OtherSupplementEntity>lambdaQuery();
            lambda.eq(OtherSupplementEntity::getBillCode, entity.getBillCode());
            lambda.eq(OtherSupplementEntity::getTenantId, tenantId);
            lambda.ne(OtherSupplementEntity::getId, entity.getId());
            entities = super.list(lambda);
        }else{
            LambdaQueryWrapper<OtherSupplementEntity> lambda = Wrappers.<OtherSupplementEntity>lambdaQuery();
            lambda.eq(OtherSupplementEntity::getBillCode, entity.getBillCode());
            lambda.eq(OtherSupplementEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }

        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        super.saveOrUpdate(entity, false);
        OtherSupplementVO vo = BeanMapper.map(entity, OtherSupplementVO.class);
        return vo;
    }


    @Override
    public OtherSupplementVO addConvertByConId(Long id) {
        OtherContractEntity contractVO = contractService.selectById(id);
        OtherSupplementVO otherSupplementVO = new OtherSupplementVO();
        otherSupplementVO.setProjectId(contractVO.getProjectId());
        otherSupplementVO.setProjectName(contractVO.getProjectName());
        otherSupplementVO.setOrgId(contractVO.getOrgId());
        otherSupplementVO.setOrgName(contractVO.getOrgName());
        otherSupplementVO.setSupplierId(contractVO.getSupplierId());
        otherSupplementVO.setSupplierName(contractVO.getSupplierName());
        otherSupplementVO.setCustomerId(contractVO.getCustomerId());
        otherSupplementVO.setCustomerName(contractVO.getCustomerName());
        otherSupplementVO.setTaxRate(contractVO.getTaxRate());
        otherSupplementVO.setSupplementFlag(1);
        otherSupplementVO.setContractStatus("2");
        otherSupplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        otherSupplementVO.setMainContractId(contractVO.getId());
        otherSupplementVO.setMainContractCode(contractVO.getBillCode());
        otherSupplementVO.setMainContractName(contractVO.getContractName());
        return otherSupplementVO;
    }

    @Override
    public OtherSupplementHistoryVO queryDetailRecord(Long id) {
        OtherContractEntity otherContractEntity = contractService.selectById(id);
        OtherSupplementHistoryVO recordVO = new OtherSupplementHistoryVO();
        BigDecimal contractTaxMny = otherContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : otherContractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = otherContractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : otherContractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setChangeStatus(otherContractEntity.getChangeStatus());
        recordVO.setIsFinish(otherContractEntity.getIsFinish());
        recordVO.setIsSuspend(otherContractEntity.getIsSuspend());
        recordVO.setIsRelieve(otherContractEntity.getIsRelieve());
        LambdaQueryWrapper<OtherSupplementEntity> lambda = Wrappers.<OtherSupplementEntity>lambdaQuery();
        lambda.eq(OtherSupplementEntity::getMainContractId, id);
        lambda.orderByDesc(OtherSupplementEntity::getSignDate);
        List<OtherSupplementEntity> entities = super.list(lambda);
        recordVO.setDetailList(BeanMapper.mapList(entities, OtherSupplementVO.class));
        return recordVO;
    }
}
