package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.pro.income.vo.SettlementFinalizationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.SettlementFinalizationMapper;
import com.ejianc.business.pro.income.bean.SettlementFinalizationEntity;
import com.ejianc.business.pro.income.service.ISettlementFinalizationService;

import java.util.List;

/**
 * 工程结算定案表返回确认单主实体
 * 
 * @author generator
 * 
 */
@Service("settlementFinalizationService")
public class SettlementFinalizationServiceImpl extends BaseServiceImpl<SettlementFinalizationMapper, SettlementFinalizationEntity> implements ISettlementFinalizationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "SETTLEMENT_FINALIZATION";//此处需要根据实际修改

    @Override
    public SettlementFinalizationVO saveOrUpdate(SettlementFinalizationVO saveOrUpdateVO) {
        //同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getContractId()));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(saveOrUpdateVO.getId() != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        }
        List<SettlementFinalizationEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的工程结算定案表返回确认单，不允许保存!");
        }

        SettlementFinalizationEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementFinalizationEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(super.selectById(entity.getId()), SettlementFinalizationVO.class);
    }
}
