package com.ejianc.business.pro.income.bean;

import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 总包结算计划主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_general")
public class GeneralEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="unit_name")
    private String unitName; // 单位名称
    @TableField(value="unit_id")
    private Long unitId; // 单位名称ID
    @TableField(value="report_nodes")
    private Long reportNodes; // 报出节点
    @TableField(value="first_nodes")
    private Long firstNodes; // 一审节点
    @TableField(value="lifetime_nodes")
    private Long lifetimeNodes; // 终身节点
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // parentOrgName
    @TableField(value="org_name")
    private String orgName; // orgName
    @TableField(value="editon")
    private Integer editon;

    public Integer getEditon() {
        return editon;
    }

    public void setEditon(Integer editon) {
        this.editon = editon;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="generalDetailService", pidName="generalId")
    private List<GeneralDetailEntity> detailList = new ArrayList<>(); // 总包结算计划子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public Long getReportNodes() {
        return reportNodes;
    }

    public void setReportNodes(Long reportNodes) {
        this.reportNodes = reportNodes;
    }
    public Long getFirstNodes() {
        return firstNodes;
    }

    public void setFirstNodes(Long firstNodes) {
        this.firstNodes = firstNodes;
    }
    public Long getLifetimeNodes() {
        return lifetimeNodes;
    }

    public void setLifetimeNodes(Long lifetimeNodes) {
        this.lifetimeNodes = lifetimeNodes;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    

    public List<GeneralDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<GeneralDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
