/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.ProgressDetailEntity;
import com.ejianc.business.pro.income.bean.ProgressEntity;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IProgressService;
import com.ejianc.business.pro.income.utils.DateUtil;
import com.ejianc.business.pro.income.vo.ProductionPlanVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="progress")
public class ProgressBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IProgressService service;
    @Autowired
    private IProductionService productionService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProgressEntity entity = (ProgressEntity)((Object)this.service.selectById(billId));
        this.pushToProduction(entity);
        return CommonResponse.success();
    }

    private void pushToProduction(ProgressEntity entity) {
        ProductionVO vo = new ProductionVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectCode(entity.getProjectCode());
        vo.setProjectName(entity.getProjectName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setCustomerId(entity.getOwnerId());
        vo.setCustomerName(entity.getOwnerName());
        vo.setScheduleDescription(entity.getMemo());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setProductionPeriod(DateUtil.formatDate(vo.getStartDate()) + "~" + DateUtil.formatDate(vo.getEndDate()));
        vo.setSourceId(String.valueOf(entity.getId()));
        ArrayList<ProductionPlanVO> planList = new ArrayList<ProductionPlanVO>();
        for (ProgressDetailEntity detail : entity.getProgressDetailList()) {
            ProductionPlanVO plan = new ProductionPlanVO();
            plan.setMonth(detail.getDetailDate());
            plan.setPlanProgress(detail.getPlanProgress());
            planList.add(plan);
        }
        vo.setPlanList(planList);
        this.productionService.saveOrUpdate(vo);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)billId));
        List list = this.productionService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u5f62\u8c61\u8fdb\u5ea6\u5355\u6709\u81ea\u52a8\u751f\u6210\u7684\u4ea7\u503c\u8fdb\u5ea6\u5355\u636e\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

